<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Data_Helper{
    protected $EE='';
    static $mdetect;
    
    function __construct(){
       $this->EE =& get_instance();
       
       if(self::$mdetect == null){
           require_once(PATH_THIRD . 'mdetect/ext.mdetect.php');
           self::$mdetect = new Mdetect_ext();
       }
    }
    
     public function getCountryFromIP($ipAddr, $all=''){
        require_once(APPPATH . 'application/helpers/geoip/Data.php');
     
        $geoip = new GeoIp();
        
        $country = $geoip->getAddressByIp($ipAddr);
        
        if($all === true){
            return $country;
        }
        
        if ($country == NULL){
            $country = "AU";
        }else{
            $country = $country->country_code;
        }
        return $country;
    }
    
    public function getRemoteCountry($all=''){
        
        return $this->getCountryFromIP($_SERVER['REMOTE_ADDR'], $all);
        //return $this->getCountryFromIP("180.150.157.20", $all);
    }
    
    public function getLimitText($text, $limit){
        if (strlen($text) > $limit){
            $text = substr($text, 0, $limit) . '...';
        }
        
        return $text;
    }
    
    public function getStrippedURL($url){
        $url = preg_replace('#^https?://#', '', $url);
        $url = trim($url, "/");
        return $url;
    }
    
    public function checkEmpty($value, $return='not_empty')
    {
       $result = $return; 
       if(is_array($value)){
           if(empty($value)){
               $result = '';
           }
       }else{
           if($value === null || $value === '' || $value === "" || $value === false){
              $result = '';    
           }
       }
       
       return $result;
    }
    
    /*public function render_results($swaps, $datas, $tagdata, $advanced = false){

        if ($this->EE->TMPL == null){
            $this->EE->load->library('template', NULL, 'TMPL');
        }
        foreach($swaps as $key => $value){
            $data = null;
            if (array_key_exists($swaps[$key], $datas)){
                $data = $datas[$swaps[$key]];
            }
            if ($data == null){
                $data = '';
            }
            if ($advanced == true){
                $tagdata = $this->process_condition($key, trim($data), $tagdata);
                $tagdata = $this->advanced_swap_var_single($key, trim($data), $tagdata);
            }else{
                $tagdata = $this->EE->TMPL->swap_var_single($key, trim($data), $tagdata);
            }
        }
        
        return $tagdata;
    }*/
    public function fetch_list($swaps, $datas, $tagdata){
        if ($this->EE->TMPL == null){
            $this->EE->load->library('template', NULL, 'TMPL');
        } 
        
        preg_match_all("/\[\#\#fetch_list(.+?)\#\#\](.+?)\[\#\#\/fetch_list\#\#\]/s", $tagdata, $matches);
        
        for($i=0, $s=count($matches['0']); $i < $s; ++$i){
             $target = $matches[1][$i];
             $sub_templ = $matches[2][$i];
             
             $key = trim($target);
             $keys = explode(".", $key);
             $key = $keys[0];
             
             $key = $swaps[$key];
             $all_datas = $datas[$key];
             if (count($keys) > 1){
                for($k = 1; $k < count($keys); $k++){
                    if(!is_array($all_datas)){
                        break;
                    }
                    $all_datas = $all_datas[$keys[$k]];
                }    
             }
             
             $html = '';
             $return = '';
             
             $is_first_row = false;
             $is_last_row = false;
             $len = count($all_datas);
             $j = 0;
             foreach($all_datas as $data){
                 if(!is_array($data)){
                     $len--;
                 }
             }
             foreach($all_datas as $all_datas_key => $data){
                 $html = $sub_templ;
                 if(!is_array($data)){
                     /*if(is_string($all_datas_key)){
                         continue;
                     } */
                     $key = "sys_val";
                     if(strpos($html, "{sys_val}") === false && strpos($html, "{#sys_val#}") === false){
                         continue;
                     }
                     
                     $html = $this->EE->TMPL->swap_var_single($key, ($data), $html); 
                     $empty = $this->checkEmpty($data, 'no');
                     
                     $html = $this->EE->TMPL->swap_var_single("#$key#", $empty, $html);
                     $return .= $html;
                     continue;
                 }
                 if ($j == 0){
                     $data['is_first_row'] = "yes";
                 }
                 if ($j == $len - 1){
                     $data['is_last_row'] = "yes";
                 }
                 $html = $this->EE->TMPL->swap_var_single("#sys_key#", $all_datas_key, $html);
                 foreach($data as $key => $item){
                    if (is_array($item)){
                        $html = $this->process_arrays($key, $item, $html, '');
                        continue;
                    } 
                    $html = $this->EE->TMPL->swap_var_single($key, ($item), $html); 
                    $empty = $this->checkEmpty($item, 'no');
                    $html = $this->EE->TMPL->swap_var_single("#$key#", $empty, $html);
                 }
                 $return .= $html;
                 
                 $j++;
             }
             $tagdata = str_replace($matches[0][$i], $return, $tagdata);
             
        }
        
        return $tagdata;
    }
    public function process_arrays($walks_key, $data, $tagdata, $type='advanced'){
       $is_empty = $this->checkEmpty($data);
       if($type == 'advanced'){
           $tagdata = str_replace("[###".$walks_key."###]", $is_empty, $tagdata);   
       }else{
           $tagdata = $this->EE->TMPL->swap_var_single("#$walks_key#", $is_empty, $tagdata);
       }
       foreach($data as $key => $value){
           if (!is_array($value)){ 
              $replace = "$walks_key.$key"; 
              if (is_numeric($key)){
                 $replace = $walks_key;
              }
              if($type == 'advanced'){
                $tagdata = $this->advanced_swap_var_single($replace, $value, $tagdata);
              }else{
                $is_empty = $this->checkEmpty($value);
                $tagdata = $this->EE->TMPL->swap_var_single("#$replace#", $is_empty, $tagdata);
                $tagdata = $this->EE->TMPL->swap_var_single($replace, $value, $tagdata);  
              }
           }else{
              $go_walks_key = $walks_key;
              if (!is_numeric($key)){
                  $go_walks_key = "$walks_key.$key";  
              }
              $is_empty = $this->checkEmpty($value);

              if($type == 'advanced'){
                  $tagdata = str_replace("[###".$go_walks_key."###]", $is_empty, $tagdata);   
              }else{
                  $tagdata = $this->EE->TMPL->swap_var_single("#$go_walks_key#", $is_empty, $tagdata);
              }

              $tagdata = $this->process_arrays($go_walks_key, $value, $tagdata, $type);
           }
       } 
       
       return $tagdata;
    }
    public function render_results($swaps, $datas, $tagdata, $advanced = false){
        
        $tagdata  = $this->fetch_list($swaps, $datas, $tagdata);     
        
        foreach($swaps as $key => $value){
            $data = null;
            if (array_key_exists($swaps[$key], $datas)){
                $data = $datas[$swaps[$key]];
            }
            if ($this->checkEmpty($data) === ''){
                $data = '';
            }
            if (!is_array($data)){
                $data = trim($data);
            }else{
                $tagdata = $this->process_arrays($key, $data, $tagdata);
                continue;
            }
            if ($advanced == true){
                $tagdata = $this->advanced_swap_var_single($key, $data, $tagdata);
            }else{
                $tagdata = $this->EE->TMPL->swap_var_single($key, trim($data), $tagdata);
            }
        }
        $regexp = "/\[\#\#[a-zA-Z0-9\.\-\_]+\#\#\]/i";
        $tagdata = preg_replace($regexp, "", $tagdata);
        $tagdata = str_replace("[##", "{", $tagdata);
        $tagdata = str_replace("##]", "}", $tagdata);
        
        $tagdata = $this->EE->TMPL->parse_simple_segment_conditionals($tagdata);
        $tagdata = $this->EE->TMPL->simple_conditionals($tagdata, '');
        $tagdata = $this->EE->TMPL->simple_conditionals($tagdata, '');
        
        if (strpos($tagdata, LD.'if') !== FALSE)
        {
            $tagdata = $this->EE->TMPL->advanced_conditionals($tagdata);
        }
        return $tagdata;
    }
    private function process_condition($key, $value, $tagdata){
        preg_match_all("/\[\#\#xif $key\#\#\](.+?)\[\#\#\/xif\#\#\]/si", $tagdata, $matches);
        for($i=0, $s=count($matches['0']); $i < $s; ++$i){            
             if (!empty($value)){
                $tagdata =str_replace($matches[0][$i], $matches['1'][$i], $tagdata);
             }else{
                $tagdata = str_replace($matches[0][$i], '', $tagdata);
             }
        }
        
        preg_match_all("/\[\#\#xifempty $key\#\#\](.+?)\[\#\#\/xif\#\#\]/si", $tagdata, $matches);
        for($i=0, $s=count($matches['0']); $i < $s; ++$i){            
             if (empty($value)){
                $tagdata =str_replace($matches[0][$i], $matches['1'][$i], $tagdata);
             }else{
                $tagdata = str_replace($matches[0][$i], '', $tagdata);
             }
        }
        return $tagdata;
    } 
    private function advanced_swap_var_single($search, $replace, $source){
        $is_empty = $this->checkEmpty($replace);
        $source = str_replace("[##".$search."##]", $replace, $source);  
        $source = str_replace("[###".$search."###]", $is_empty, $source);  
        return $source;  
    }
    
    public function render_results_clear($tagdata){
        /*while(preg_match("/\[\#\#if [a-zA-Z0-9_-]+\#\#\](.+?)\[\#\#\/if\#\#\]/s", $tagdata, $match)){
            $tagdata = preg_replace("/\[\#\#if [a-zA-Z0-9_-]+\#\#\](.+?)\[\#\#\/if\#\#\]/s", '', $tagdata);
        } */
        while(preg_match("/\[\#\#if(.+?)\#\#\](.+?)\[\#\#\/if\#\#\]/s", $tagdata, $match)){
            $tagdata = preg_replace("/\[\#\#if(.+?)\#\#\](.+?)\[\#\#\/if\#\#\]/s", '', $tagdata);
        }
        return $tagdata;
    }
    
    public function uniqHash($prefix = '')
    {
        return $prefix . md5(uniqid(microtime().mt_rand(), true));
    }
    public function get_xor_checksum($value){
        return $value ^ 0x42ae3567;
    }
    public function get_unpack($value){
        $value = unpack('H*', $value);
        return $value[1];
    }
    public function get_pack($value){
        return pack('H*', $value);
    }
    public function fetch_action_id($class,$method){
        $this->EE->db->select('action_id');
        $this->EE->db->where('class',  $class);
        $this->EE->db->where('method', $method);
        $query = $this->EE->db->get('actions');
        $raw_data = $query->row_array();
        
        return $raw_data['action_id'];
    }
    /* This converts from contact id to member_id */
    public function generate_member_id($id){
        $_items = explode('-', $id);

        $str = '0x';
        //$str .= reset(array_slice($_items, -2, 1));
        //$str .= reset(array_slice($_items, -1, 1));
        $str .= $_items[0];
        $val = intval($str, 16);
        return $val;
    }

    public function get_dropdowns_sugar($name, $params = '') {
        global $app_list_strings;
        $list = $app_list_strings[$name];
        //var_dump($app_list_strings);exit;
        $result = array();
        foreach($list as $key => $value){
            if ($key == '_empty_')
                continue;
            if(is_array($params) && $params['exclude_empty_key']){
                if($key == ''){
                    continue;
                }
            }    
            if(is_array($params) && $params['value_to_seo'] == "yes"){
                $key = str_replace(" ", "-", $key);
                $key = strtolower($key);
            }
            $result[$key] = $value;
        }
        
        return $result;
    }
    public function get_dropdowns_sugar_labels($name, $value, $multiple = true) {
        $list = $this->get_dropdowns_sugar($name);
        
        if($multiple){
            $value = trim($value, "^");
            $value = explode("^,^", $value);
        }else{
            return $list[$value]; 
        }
        
        $result = array();
        foreach($value as $item){    
           if(!empty($list[$item])){
            $result[] = $list[$item]; 
           }
        }
        
        return $result;
    }
    
    public function make_select_opts($options, $curr_vals, $params=''){    
        if(is_string($options)){
            $options = $this->get_dropdowns_sugar($options, $params);
        }
        if(!empty($params['excludes'])){
            $options = array_diff_assoc($options, $params['excludes']);
        }
        if($params['multiple_values'] == true && is_string($curr_vals)){
            $curr_vals = trim($curr_vals, "^");
            $curr_vals = explode("^,^", $curr_vals);
        }
        
        $html = '';  
        if (!is_array($curr_vals)){
            $curr_vals = array($curr_vals);
        }
        foreach($options as $key => $val){
           if(empty($key)){
               continue;
           } 
           $selected = (in_array($key, $curr_vals)) ? "selected='true'" : '';
           $html .= "<option $selected value=\"$key\" label=\"$val\">$val</option>"; 
        }
        
        return $html;
    }
    public function make_checkboxes($options, $curr_vals, $name, $params=''){
        if(is_string($options)){
            $options = $this->get_dropdowns_sugar($options, $params);
        }
        if(!empty($params['excludes'])){
            $options = array_diff_assoc($options, $params['excludes']);
        }
        
        $html = '';  
        if (!is_array($curr_vals)){
            $curr_vals = array($curr_vals);
        }
        
        $replace_labels = $params['replace_labels'];
        
        foreach($options as $key => $val){
           if(empty($key)){
               continue;
           } 
           $checked = (in_array($key, $curr_vals)) ? "checked='true'" : '';
           
           /// check replace label ///
           $replace_label = $replace_labels[$key];
           if(!empty($replace_label)){
               $val = $replace_label;
           }
           ///////////////////////////
           
           $html .= "<label><input type='checkbox' name='$name" . "[]" . "' $checked value=\"$key\" /><span>$val</span></label>"; 
        }
        
        return $html;
    }
    public function objectToArray($d) {
        if (is_object($d)) {
            // Gets the properties of the given object
            // with get_object_vars function
            $d = get_object_vars($d);
        }
 
        if (!is_array($d)) {
            /*
            * Return array converted to object
            * Using __FUNCTION__ (Magic constant)
            * for recursive call
            */
            return array_map(__FUNCTION__, $d);
        }
        else {
            // Return array
            return $d;
        }
    }
    public function sortArray($list, $key, $dir = SORT_ASC)
    {
        $values = array();
        foreach($list as $item){
            $values[] = $item[$key];
        }
        array_multisort($values, SORT_ASC, $list);
        return $list;
    }
   
    public function get_format_date($date, $format){
        $date = new DateTime($date);
        return $date->format($format);
    }
    
    public function setup_helptext($maps_helptexts){
        $this->EE->load->model('helptext');
        $helptext = $this->EE->helptext;
        
        foreach($maps_helptexts as $key => $item){
            $maps_helptexts[$key] = "\"$item\"";
        }
        $maps_helptexts = implode(",", $maps_helptexts);
        $selects = "{#m}.name,{#m}.description";
        $where = "{#m}.name IN($maps_helptexts)";
        $results = $helptext->get_main_data(array('selects' => $selects, 'where' => $where));
        
        $helptexts = array();
        foreach($results as $help){
            $key = $help['name'];
            $key = strtolower($key);
            $key = str_replace(' ', '_', $key);
            $value = $help['description'];
            $helptexts[$key] = $value;
        }
        
        return $helptexts;
        /*foreach($maps_helptexts as $map){
            $key = 'ht_' . $map;
            $key = strtolower($key);
            $key = str_replace(' ', '_', $key);
            $swaps[$key] = $key;
            $datas[$key] = $helptexts[$map];
        }
        
        return array('swaps' => $swaps, 'datas' => $datas);    */
    }
    public function get_app_img_url(){
        $app_img_url = $this->EE->config->item('site_url') . "themes/site_themes/dailyedition/images/app";
        
        return $app_img_url;
    }
    function formatEditionMonths($months)
    {
        $months = str_replace("JanFeb","Jan/Feb",$months);
        $months = str_replace("MarApr","Mar/Apr",$months);
        $months = str_replace("MayJun","May/Jun",$months);
        $months = str_replace("JulAug","Jul/Aug",$months);
        $months = str_replace("SepOct","Sep/Oct",$months);
        $months = str_replace("NovDec","Nov/Dec",$months);
        return $months;
    }
    
    public function google_finance($stock_symbol)
    {
        /*if (!$quote = file_get_contents("http://www.google.com/finance/info?q=".$stock_symbol))
        {    
            $this->EE->logger->developer('Google Finance: Failed to fetch quote');
            return false;
        } */
        if (!$quote = file_get_contents("http://www.google.com/finance/info?infotype=infoquoteall&q=".$stock_symbol))
        {    
            $this->EE->logger->developer('Google Finance: Failed to fetch quote');
            return false;
        }
        
        // Encode to UTF8 (json_decode only likes UTF8)
        $quote = utf8_encode($quote);
        
        // Fix the format to make it valid JSON
        $quote = substr(trim($quote),3);
        $quote = str_replace("\\x", "\\u00", $quote);
        if (!$quote = json_decode($quote,true))
        {
            $this->EE->logger->developer('Google Finance: Failed to decode JSON');
            return false;
        }
        
        // We only need the first quote
        $quote = $quote[0];
        
        $result = array(
            'id'            =>    $quote['id'],
            'symbol'        =>    $quote['t'],
            'exchange'         =>    $quote['e'],
            'l_price'        =>    $quote['l'],
            'l_trade_df'    =>    $quote['lt'],
            'l_trade'        =>    strtotime($quote['ltt']),
            'change'         =>    $quote['c'],
            'change_p'         =>    $quote['cp'],
            'e_price'        =>    isset($quote['el'])?$quote['el']:"",
            'e_trade_df'    =>    isset($quote['elt'])?$quote['elt']:"",
            'e_trade'        =>    isset($quote['elt'])?strtotime($quote['elt']):"",
            'e_change'        =>    isset($quote['ec'])?$quote['ec']:"",
            'e_change_p'    =>    isset($quote['ecp'])?$quote['ecp']:"",
            'name'          =>    addslashes(isset($quote['name'])?$quote['name']:""),
        );
        
        return $result;
    }
    public function get_nearest_timezone($cur_lat, $cur_long, $country_code = '') {
        $timezone_ids = ($country_code) ? DateTimeZone::listIdentifiers(DateTimeZone::PER_COUNTRY, $country_code)
                                        : DateTimeZone::listIdentifiers();

        if($timezone_ids && is_array($timezone_ids) && isset($timezone_ids[0])) {

            $time_zone = '';
            $tz_distance = 0;

            //only one identifier?
            if (count($timezone_ids) == 1) {
                $time_zone = $timezone_ids[0];
            } else {

                foreach($timezone_ids as $timezone_id) {
                    $timezone = new DateTimeZone($timezone_id);
                    $location = $timezone->getLocation();
                    $tz_lat   = $location['latitude'];
                    $tz_long  = $location['longitude'];

                    $theta    = $cur_long - $tz_long;
                    $distance = (sin(deg2rad($cur_lat)) * sin(deg2rad($tz_lat))) 
                    + (cos(deg2rad($cur_lat)) * cos(deg2rad($tz_lat)) * cos(deg2rad($theta)));
                    $distance = acos($distance);
                    $distance = abs(rad2deg($distance));
                    // echo '<br />'.$timezone_id.' '.$distance; 

                    if (!$time_zone || $tz_distance > $distance) {
                        $time_zone   = $timezone_id;
                        $tz_distance = $distance;
                    } 

                }
            }
            return  $time_zone;
        }
        return 'unknown';
    }
    public function get_env($key){
        $env = $this->EE->input->get_post("env");
        $env_decoded = json_decode($env, true);
        
        return $env_decoded[$key];
    }
    function get_countrycode($country){
        $countries = array( 'AF'=>'AFGHANISTAN', 'AL'=>'ALBANIA', 'DZ'=>'ALGERIA', 'AS'=>'AMERICAN SAMOA', 'AD'=>'ANDORRA', 'AO'=>'ANGOLA', 'AI'=>'ANGUILLA', 'AQ'=>'ANTARCTICA', 'AG'=>'ANTIGUA AND BARBUDA', 'AR'=>'ARGENTINA', 'AM'=>'ARMENIA', 'AW'=>'ARUBA', 'AU'=>'AUSTRALIA', 'AT'=>'AUSTRIA', 'AZ'=>'AZERBAIJAN', 'BS'=>'BAHAMAS', 'BH'=>'BAHRAIN', 'BD'=>'BANGLADESH', 'BB'=>'BARBADOS', 'BY'=>'BELARUS', 'BE'=>'BELGIUM', 'BZ'=>'BELIZE', 'BJ'=>'BENIN', 'BM'=>'BERMUDA', 'BT'=>'BHUTAN', 'BO'=>'BOLIVIA', 'BA'=>'BOSNIA AND HERZEGOVINA', 'BW'=>'BOTSWANA', 'BV'=>'BOUVET ISLAND', 'BR'=>'BRAZIL', 'IO'=>'BRITISH INDIAN OCEAN TERRITORY', 'BN'=>'BRUNEI DARUSSALAM', 'BG'=>'BULGARIA', 'BF'=>'BURKINA FASO', 'BI'=>'BURUNDI', 'KH'=>'CAMBODIA', 'CM'=>'CAMEROON', 'CA'=>'CANADA', 'CV'=>'CAPE VERDE', 'KY'=>'CAYMAN ISLANDS', 'CF'=>'CENTRAL AFRICAN REPUBLIC', 'TD'=>'CHAD', 'CL'=>'CHILE', 'CN'=>'CHINA', 'CX'=>'CHRISTMAS ISLAND', 'CC'=>'COCOS (KEELING) ISLANDS', 'CO'=>'COLOMBIA', 'KM'=>'COMOROS', 'CG'=>'CONGO', 'CD'=>'CONGO, THE DEMOCRATIC REPUBLIC OF THE', 'CK'=>'COOK ISLANDS', 'CR'=>'COSTA RICA', 'CI'=>'COTE D IVOIRE', 'HR'=>'CROATIA', 'CU'=>'CUBA', 'CY'=>'CYPRUS', 'CZ'=>'CZECH REPUBLIC', 'DK'=>'DENMARK', 'DJ'=>'DJIBOUTI', 'DM'=>'DOMINICA', 'DO'=>'DOMINICAN REPUBLIC', 'TP'=>'EAST TIMOR', 'EC'=>'ECUADOR', 'EG'=>'EGYPT', 'SV'=>'EL SALVADOR', 'GQ'=>'EQUATORIAL GUINEA', 'ER'=>'ERITREA', 'EE'=>'ESTONIA', 'ET'=>'ETHIOPIA', 'FK'=>'FALKLAND ISLANDS (MALVINAS)', 'FO'=>'FAROE ISLANDS', 'FJ'=>'FIJI', 'FI'=>'FINLAND', 'FR'=>'FRANCE', 'GF'=>'FRENCH GUIANA', 'PF'=>'FRENCH POLYNESIA', 'TF'=>'FRENCH SOUTHERN TERRITORIES', 'GA'=>'GABON', 'GM'=>'GAMBIA', 'GE'=>'GEORGIA', 'DE'=>'GERMANY', 'GH'=>'GHANA', 'GI'=>'GIBRALTAR', 'GR'=>'GREECE', 'GL'=>'GREENLAND', 'GD'=>'GRENADA', 'GP'=>'GUADELOUPE', 'GU'=>'GUAM', 'GT'=>'GUATEMALA', 'GN'=>'GUINEA', 'GW'=>'GUINEA-BISSAU', 'GY'=>'GUYANA', 'HT'=>'HAITI', 'HM'=>'HEARD ISLAND AND MCDONALD ISLANDS', 'VA'=>'HOLY SEE (VATICAN CITY STATE)', 'HN'=>'HONDURAS', 'HK'=>'HONG KONG', 'HU'=>'HUNGARY', 'IS'=>'ICELAND', 'IN'=>'INDIA', 'ID'=>'INDONESIA', 'IR'=>'IRAN, ISLAMIC REPUBLIC OF', 'IQ'=>'IRAQ', 'IE'=>'IRELAND', 'IL'=>'ISRAEL', 'IT'=>'ITALY', 'JM'=>'JAMAICA', 'JP'=>'JAPAN', 'JO'=>'JORDAN', 'KZ'=>'KAZAKSTAN', 'KE'=>'KENYA', 'KI'=>'KIRIBATI', 'KP'=>'KOREA DEMOCRATIC PEOPLES REPUBLIC OF', 'KR'=>'KOREA REPUBLIC OF', 'KW'=>'KUWAIT', 'KG'=>'KYRGYZSTAN', 'LA'=>'LAO PEOPLES DEMOCRATIC REPUBLIC', 'LV'=>'LATVIA', 'LB'=>'LEBANON', 'LS'=>'LESOTHO', 'LR'=>'LIBERIA', 'LY'=>'LIBYAN ARAB JAMAHIRIYA', 'LI'=>'LIECHTENSTEIN', 'LT'=>'LITHUANIA', 'LU'=>'LUXEMBOURG', 'MO'=>'MACAU', 'MK'=>'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF', 'MG'=>'MADAGASCAR', 'MW'=>'MALAWI', 'MY'=>'MALAYSIA', 'MV'=>'MALDIVES', 'ML'=>'MALI', 'MT'=>'MALTA', 'MH'=>'MARSHALL ISLANDS', 'MQ'=>'MARTINIQUE', 'MR'=>'MAURITANIA', 'MU'=>'MAURITIUS', 'YT'=>'MAYOTTE', 'MX'=>'MEXICO', 'FM'=>'MICRONESIA, FEDERATED STATES OF', 'MD'=>'MOLDOVA, REPUBLIC OF', 'MC'=>'MONACO', 'MN'=>'MONGOLIA', 'MS'=>'MONTSERRAT', 'MA'=>'MOROCCO', 'MZ'=>'MOZAMBIQUE', 'MM'=>'MYANMAR', 'NA'=>'NAMIBIA', 'NR'=>'NAURU', 'NP'=>'NEPAL', 'NL'=>'NETHERLANDS', 'AN'=>'NETHERLANDS ANTILLES', 'NC'=>'NEW CALEDONIA', 'NZ'=>'NEW ZEALAND', 'NI'=>'NICARAGUA', 'NE'=>'NIGER', 'NG'=>'NIGERIA', 'NU'=>'NIUE', 'NF'=>'NORFOLK ISLAND', 'MP'=>'NORTHERN MARIANA ISLANDS', 'NO'=>'NORWAY', 'OM'=>'OMAN', 'PK'=>'PAKISTAN', 'PW'=>'PALAU', 'PS'=>'PALESTINIAN TERRITORY, OCCUPIED', 'PA'=>'PANAMA', 'PG'=>'PAPUA NEW GUINEA', 'PY'=>'PARAGUAY', 'PE'=>'PERU', 'PH'=>'PHILIPPINES', 'PN'=>'PITCAIRN', 'PL'=>'POLAND', 'PT'=>'PORTUGAL', 'PR'=>'PUERTO RICO', 'QA'=>'QATAR', 'RE'=>'REUNION', 'RO'=>'ROMANIA', 'RU'=>'RUSSIAN FEDERATION', 'RW'=>'RWANDA', 'SH'=>'SAINT HELENA', 'KN'=>'SAINT KITTS AND NEVIS', 'LC'=>'SAINT LUCIA', 'PM'=>'SAINT PIERRE AND MIQUELON', 'VC'=>'SAINT VINCENT AND THE GRENADINES', 'WS'=>'SAMOA', 'SM'=>'SAN MARINO', 'ST'=>'SAO TOME AND PRINCIPE', 'SA'=>'SAUDI ARABIA', 'SN'=>'SENEGAL', 'SC'=>'SEYCHELLES', 'SL'=>'SIERRA LEONE', 'SG'=>'SINGAPORE', 'SK'=>'SLOVAKIA', 'SI'=>'SLOVENIA', 'SB'=>'SOLOMON ISLANDS', 'SO'=>'SOMALIA', 'ZA'=>'SOUTH AFRICA', 'GS'=>'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS', 'ES'=>'SPAIN', 'LK'=>'SRI LANKA', 'SD'=>'SUDAN', 'SR'=>'SURINAME', 'SJ'=>'SVALBARD AND JAN MAYEN', 'SZ'=>'SWAZILAND', 'SE'=>'SWEDEN', 'CH'=>'SWITZERLAND', 'SY'=>'SYRIAN ARAB REPUBLIC', 'TW'=>'TAIWAN, PROVINCE OF CHINA', 'TJ'=>'TAJIKISTAN', 'TZ'=>'TANZANIA, UNITED REPUBLIC OF', 'TH'=>'THAILAND', 'TG'=>'TOGO', 'TK'=>'TOKELAU', 'TO'=>'TONGA', 'TT'=>'TRINIDAD AND TOBAGO', 'TN'=>'TUNISIA', 'TR'=>'TURKEY', 'TM'=>'TURKMENISTAN', 'TC'=>'TURKS AND CAICOS ISLANDS', 'TV'=>'TUVALU', 'UG'=>'UGANDA', 'UA'=>'UKRAINE', 'AE'=>'UNITED ARAB EMIRATES', 'GB'=>'UNITED KINGDOM', 'US'=>'UNITED STATES', 'UM'=>'UNITED STATES MINOR OUTLYING ISLANDS', 'UY'=>'URUGUAY', 'UZ'=>'UZBEKISTAN', 'VU'=>'VANUATU', 'VE'=>'VENEZUELA', 'VN'=>'VIET NAM', 'VG'=>'VIRGIN ISLANDS, BRITISH', 'VI'=>'VIRGIN ISLANDS, U.S.', 'WF'=>'WALLIS AND FUTUNA', 'EH'=>'WESTERN SAHARA', 'YE'=>'YEMEN', 'YU'=>'YUGOSLAVIA', 'ZM'=>'ZAMBIA', 'ZW'=>'ZIMBABWE');
        foreach($countries as $key => $item){
            if(strtolower($country) == strtolower($item)){
                return $key;
            }
        }
        return "unknown";
    }
    
    function get_correct_time($time){
        $regexp = "/(\d{2}):(\d{2})\s*/si";
        preg_match_all($regexp, $time, $matches);
        
        if($matches[1][0] * 1 > 12){
            $time = $matches[1][0] . ":" . $matches[2][0];
        }
        return $time;
    }
    
    function is_mobile_device(){
        return self::$mdetect->is_mobile_device();
    }
    function is_iphone_device(){
        return self::$mdetect->is_iphone_device();
    }
    function escape($value){
        return $this->EE->crmdb->escape_str($value);
    }
    function clog($s='sss',$dump=false){
         if($_SERVER['REMOTE_ADDR'] == '180.150.148.229'){
             if($dump){
                 var_dump($s);exit;
             }
             echo $s;exit;
         }
    }
    
    function is_crawlers_bots(){
        // THE BOTS WE WANT TO IGNORE
        $bad_robots = array( 
                'crawler'
                , 'spider'
                , 'robot'
                , 'slurp'
                , 'Atomz'
                , 'googlebot'
                , 'VoilaBot'
                , 'msnbot'
                , 'Gaisbot'
                , 'Gigabot'
                , 'SBIder'
                , 'Zyborg'
                , 'FunWebProducts'
                , 'findlinks'
                , 'ia_archiver'
                , 'MJ12bot'
                , 'Ask Jeeves'
                , 'NG/2.0'
                , 'voyager'
                , 'Exabot'
                , 'Nutch'
                , 'Hercules'
                , 'psbot'
                , 'LocalcomBot'
            );

        // COMPARE THE BOT STRINGS TO THE USER AGENT STRING
        foreach ($bad_robots as $spider){
            $spider = '#' . $spider . '#i';
            if (preg_match($spider, $_SERVER["HTTP_USER_AGENT"])) 
                return TRUE;
        }
        return FALSE;
    }
    
    public function payment($params){
        require_once(PATH_THIRD . 'payments/models/processing.php');
        
        $cmd = "payments:bill";
        $processing = new PTSProcessing();
        $processing->initialize($cmd);
        return $processing->process($params);
    }
    function get_security_card_number($cc_number){
        $regexp = "/(\d{4})(\d{4})(\d{4})\s*/";
        return preg_replace($regexp, 'xxxx-xxxx-xxxx-', $cc_number);
    }
    function get_cc_type_name($cc_type){
        $types = array('VI' => 'visa', 'MC' => 'mastercard', 'DI' => 'Discover', 'AE' => 'amex', 'DC' => 'diners', 'JC' => 'JCB');
        return $types[$cc_type];
    }
    function toFixed($number, $decimals) {
        if($number === null || $number === ''){
            return '';
        }
        $number = round($number, $decimals); 
        return number_format($number, $decimals, ".", "");
    }
    
    function extract_multiselect($multiselect){
        $multiselect = trim($multiselect, "^");
        $multiselect = explode("^,^", $multiselect); 
        
        return $multiselect;   
    }

    function validate_cc_number($cc_number) {
        /* Validate; return value is card type if valid. */
        $false = false;
        $card_type = "";
        $card_regexes = array(
            "/^4\d{12}(\d\d\d){0,1}$/" => "visa",
            "/^5[12345]\d{14}$/"       => "mastercard",
            "/^3[47]\d{13}$/"          => "amex",
            "/^6011\d{12}$/"           => "Discover",
            "/^30[012345]\d{11}$/"     => "diners",
            "/^3[68]\d{12}$/"          => "diners",
        );

        foreach ($card_regexes as $regex => $type) {
            if (preg_match($regex, $cc_number)) {
                $card_type = $type;
                break;
            }
        }

        if (!$card_type) {
            return $false;
        }

        /*  mod 10 checksum algorithm  */
        $revcode = strrev($cc_number);
        $checksum = 0;

        for ($i = 0; $i < strlen($revcode); $i++) {
            $current_num = intval($revcode[$i]);
            if($i & 1) {  /* Odd  position */
                $current_num *= 2;
            }
            /* Split digits and add. */
            $checksum += $current_num % 10;
            if ($current_num >  9) {
                $checksum += 1;
            }
        }

        if ($checksum % 10 == 0) {
            return $card_type;
        } else {
            return $false;
        }
    }
}