<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Image_Helper{
    protected $EE='';
    protected $upload_path;
    
    function __construct(){
       $this->EE =& get_instance();
       $this->_crm_config = $this->EE->config->item('crm');
       
       $this->upload_path = $this->_crm_config['main']['upload_filepath'];
    }
    /************** Validation Image Type******************/
    public function validation_image($file_id, $params=array()){
    
        $file = $_FILES[$file_id];
        $mime = array('image/gif',
                  'image/jpeg',
                  'image/png',
                  'application/x-shockwave-flash',
                  'image/psd',
                  'image/bmp',
                  'image/tiff',
                  'image/tiff',
                  'image/jp2',
                  'image/iff',
                  'image/vnd.wap.wbmp',
                  'image/xbm',
                  'image/vnd.microsoft.icon');
        
        if (!in_array($file['type'], $mime)){
            return 'error_no_image';
        }
        
        $image =$file["name"];
        $uploadedfile = $file['tmp_name'];      
        
        /********Check the file size**********/
        $size=filesize($uploadedfile);
 
        /*if ($size > MAX_SIZE*1024){
           return "error_exceed_filesize";  
        }*/ 
        /******* Check the image size*********/
        list($width,$height)=getimagesize($uploadedfile);  
        
        $check_width = 200;
        if(!empty($params['width'])){
            $check_width = $params['width'] * 1; 
        }
        
        $check_height = 0;
        if(!empty($params['height'])){
            $check_height = $params['height'] * 1; 
        }
        
        if($params['square'] == true){
            if($width != $height){
                return "error_not_square"; 
            }
        }
        
        if ($width < $check_width){
            if(empty($params)){
                return 'error_small_width';
            }
            return array('code' => "error_small_width", 'size' => $check_width);
        }
        if ($height < $check_height){
            if(empty($params)){
                return 'error_small_height';
            }
            return array('code' => "error_small_height", 'size' => $check_height);
        }
        
        return 0;
    }
    /******************************************************/
    /************** GUID For CRM Uploading*****************/
    public function generate_guid(){
        $microTime = microtime();
        list($a_dec, $a_sec) = explode(" ", $microTime);

        $dec_hex = dechex($a_dec* 1000000);
        $sec_hex = dechex($a_sec);

        $this->_ensure_length($dec_hex, 5);
        $this->_ensure_length($sec_hex, 6);

        $guid = "";
        $guid .= $dec_hex;
        $guid .= $this->_create_guid_section(3);
        $guid .= '-';
        $guid .= $this->_create_guid_section(4);
        $guid .= '-';
        $guid .= $this->_create_guid_section(4);
        $guid .= '-';
        $guid .= $this->_create_guid_section(4);
        $guid .= '-';
        $guid .= $sec_hex;
        $guid .= $this->_create_guid_section(6);

        return $guid;
    }
    private function _create_guid_section($characters)
    {
        $return = "";
        for($i=0; $i<$characters; $i++)
        {
            $return .= dechex(mt_rand(0,15));
        }
        return $return;
    }

    private function _ensure_length(&$string, $length)
    {
        $strlen = strlen($string);
        if($strlen < $length)
        {
            $string = str_pad($string,$length,"0");
        }
        else if($strlen > $length)
        {
            $string = substr($string, 0, $length);
        }
    }
    public function remove_old_upload_crm($filename){
        $filepath = $this->upload_path . $filename;
        if (file_exists($filepath)){
            unlink($filepath);
        }
    }
    public function upload_to_crm($file_id, $filename, $params){
        $filepath = $this->upload_path . $filename;
        
        $file = $_FILES[$file_id];
        $image =$file["name"];
        $uploadedfile = $file['tmp_name'];
        $mime = $file['type'];
        
        list($width,$height)=getimagesize($uploadedfile);
        
        $newwidth = 200;
        if(!empty($params['width'])){
           $newwidth = $params['width'] * 1; 
        }
        
        if ($width == $newwidth){
            $result = move_uploaded_file($uploadedfile, $filepath);
        }
        if ($width > $newwidth){
            if(!empty($params['height'])){
                $newheight = $params['height'];
            }else{
                $newheight = $height * $newwidth/$width;
            }
            
            switch ($mime)
            {
                case 'image/gif':
                    $src = imagecreatefromgif($uploadedfile);
                break;
                
                case 'image/x-png':
                case 'image/png':
                    $src = imagecreatefrompng($uploadedfile);
                break;
                
                default:
                    $src = imagecreatefromjpeg($uploadedfile);
                break;
            }
            
            $tmp=imagecreatetruecolor($newwidth,$newheight);
            imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);

            imagejpeg($tmp,$filepath,100);
            imagedestroy($src);
            imagedestroy($tmp);
        }
        return file_exists($filepath);
    }
    /****************************************/
}