<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * ExpressionEngine - by EllisLab
 *
 * @package        ExpressionEngine
 * @author        EllisLab Dev Team
 * @copyright    Copyright (c) 2003 - 2012, EllisLab, Inc.
 * @license        http://ellislab.com/expressionengine/user-guide/license.html
 * @link        http://ellislab.com
 * @since        Version 2.0
 * @filesource
 */
 
// ------------------------------------------------------------------------

/**
 * ExpressionEngine Output Display Class
 *
 * @package        ExpressionEngine
 * @subpackage    Core
 * @category    Core
 * @author        EllisLab Dev Team
 * @link        http://ellislab.com
 */
class Output_Helper extends EE_Output {

    public function sendRedirectHeaders($url, $isPermanent = false)
    {
        if ($isPermanent) {
            header('HTTP/1.1 301 Moved Permanently');
        }

        header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
        header('Pragma: no-cache');
        header('Location: ' . $url);
        exit;
    }
    public function app_redirect($url_key, $params = array(), $is_encrypt = true){

        $EE =& get_instance();
        $return = $EE->functions->create_url($url_key);
        $_params = '';
        foreach($params as $key => $value){
            $encrypt = ($value);
            if($is_encrypt){
                $encrypt = md5($value);    
            }
            
            $_params .= "$key=$encrypt&&";
        }
        $_params = rtrim($_params, '&&');
        
        if ($_params != '')
            $return .= '/?' . $_params;
         echo "
                   <script type='text/javascript'>
                        window.location.href = '$return';
                   </script>
                ";
         exit;
    }
    
    public function app_output($swaps = null, $datas = null, $params = null){
        $EE =& get_instance();
        
        
        if(!empty($params['env']) && $params['env'] === true){
            $swaps['env'] = 'env';
            $env = $EE->input->get_post('env');
            $datas['env'] = $env;
        }
        
        
        $output = $this->get_output();
        
        $EE->load->helper('data');
        $_helper = new Data_Helper();
        
        if ($swaps != null){
            $output = $_helper->render_results($swaps, $datas, $output, true);
        }
        
        if($params['output'] === false){
            return $output;
        }
        
        $this->set_output($output);
        $this->_display();
        exit;
    }
    public function _display(){

        $EE =& get_instance();
        $output = $this->get_output();
        
        $EE->load->helper('data');
        $_helper = new Data_Helper();
        
    
        $output = $_helper->render_results_clear($output);

        $this->set_output($output);
        parent::_display();
    }
    

    // --------------------------------------------------------------------
}
// END CLASS

/* End of file EE_Output.php */
/* Location: ./system/expressionengine/libraries/EE_Output.php */