<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pdf_Helper{
    protected $EE='';
    protected $upload_path;
    
    function __construct(){
       $this->EE =& get_instance();
       $this->_crm_config = $this->EE->config->item('crm');
       
       $this->upload_path = $this->_crm_config['main']['upload_filepath'];
    }
    /************** Validation Image Type******************/
    public function check_multiple($file_id){
        $file = $_FILES[$file_id];
        if(is_array($file['name'])){
            return count($file['name']);
        }
        
        return false;
    }
    public function validate($file_id, $params=array()){
       /*
        $file = $_FILES[$file_id];
        $mime = array('image/gif',
                  'image/jpeg',
                  'image/png',
                  'application/x-shockwave-flash',
                  'image/psd',
                  'image/bmp',
                  'image/tiff',
                  'image/tiff',
                  'image/jp2',
                  'image/iff',
                  'image/vnd.wap.wbmp',
                  'image/xbm',
                  'image/vnd.microsoft.icon');

        $file_type = $file['type'];
        $file_name = $file["name"];
        $file_tmp_name = $file['tmp_name'];      
        if(isset($multiple_index)){
            $file_type = $file['type'][$multiple_index];
            $file_name = $file["name"][$multiple_index];
            $file_tmp_name = $file['tmp_name'][$multiple_index];
        }
        
        if (!in_array($file_type, $mime)){
            return 'error_no_image';
        }
         */
        return 0;
    }
    /******************************************************/
    /************** GUID For CRM Uploading*****************/
    public function generate_guid(){
        $microTime = microtime();
        list($a_dec, $a_sec) = explode(" ", $microTime);

        $dec_hex = dechex($a_dec* 1000000);
        $sec_hex = dechex($a_sec);

        $this->_ensure_length($dec_hex, 5);
        $this->_ensure_length($sec_hex, 6);

        $guid = "";
        $guid .= $dec_hex;
        $guid .= $this->_create_guid_section(3);
        $guid .= '-';
        $guid .= $this->_create_guid_section(4);
        $guid .= '-';
        $guid .= $this->_create_guid_section(4);
        $guid .= '-';
        $guid .= $this->_create_guid_section(4);
        $guid .= '-';
        $guid .= $sec_hex;
        $guid .= $this->_create_guid_section(6);

        return $guid;
    }
    private function _create_guid_section($characters)
    {
        $return = "";
        for($i=0; $i<$characters; $i++)
        {
            $return .= dechex(mt_rand(0,15));
        }
        return $return;
    }

    private function _ensure_length(&$string, $length)
    {
        $strlen = strlen($string);
        if($strlen < $length)
        {
            $string = str_pad($string,$length,"0");
        }
        else if($strlen > $length)
        {
            $string = substr($string, 0, $length);
        }
    }
    public function remove_old_upload_crm($filename){
        $filepath = $this->upload_path . $filename;
        if (file_exists($filepath)){
            unlink($filepath);
        }
    }
    public function upload_to_crm($file_id, $filename, $params){
        $filepath = $this->upload_path . $filename;
        
        $file = $_FILES[$file_id];

        $file_type = $file['type'];
        $file_name = $file["name"];
        $file_tmp_name = $file['tmp_name'];      

        $uploadedfile = $file_tmp_name;

        $result = move_uploaded_file($uploadedfile, $filepath);
        
        return $result;
    }
    
    public function convertPDP2JPG($id, $width, $height)
    {
        $jpg_id = $this->generate_guid();
        $pdf_file = $this->upload_path . $id . "[0]";    
        $jpg_file = $this->upload_path . $jpg_id;    
        
        try{
            $im = new Imagick();

            $im->readimage($pdf_file);      
            $im->setImageFormat('jpeg');  
            $im->writeImage($jpg_file); 
            $im->clear(); 
            $im->destroy();
            
            $im = new Imagick();

            $im->readimage($jpg_file);      
            $im->resizeImage($width, $height, imagick::FILTER_LANCZOS, 1); 
            $im->writeImage($jpg_file); 
            $im->clear(); 
            $im->destroy();
        }catch(Exception $e){
            return '';
        }
        
        return $jpg_id;
    }
}