<?php

/**
 * Generate DOCX internal structure of the main phpdocx base template
 * 
 * @category   Phpdocx
 * @package    utilities
 * @copyright  Copyright (c) Narcea Producciones Multimedia S.L.
 *             (http://www.2mdc.com)
 * @license    phpdocx LICENSE
 * @version    2016.08.25
 * @link       http://www.phpdocx.com
 */
class DOCXStructureTemplate
{
    /**
     * DOCX structure
     * @access private
     * @var array
     */
    private $docxStructureTemplate;

    /**
     * Constructor
     * 
     * @access public
     */
    public function __construct()
    {
        
    }

    /**
     * Getter docxStructure
     * @return DOCXStructure Template structure
     */
    public function getStructure() {
        // keep the template structure in memory instead of reading the ZIP file
        $zipDocx = new DOCXStructure();
        $zipDocx->addContent('[Content_Types].xml', 
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><Types xmlns="http://schemas.openxmlformats.org/package/2006/content-types"><Override PartName="/word/footnotes.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml"/><Override PartName="/word/comments.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml"/><Override PartName="/customXml/itemProps1.xml" ContentType="application/vnd.openxmlformats-officedocument.customXmlProperties+xml"/><Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml"/><Default Extension="xml" ContentType="application/xml"/><Override PartName="/word/document.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml"/><Override PartName="/word/numbering.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml"/><Override PartName="/word/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml"/><Override PartName="/word/endnotes.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml"/><Override PartName="/docProps/app.xml" ContentType="application/vnd.openxmlformats-officedocument.extended-properties+xml"/><Override PartName="/word/settings.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml"/><Override PartName="/word/theme/theme1.xml" ContentType="application/vnd.openxmlformats-officedocument.theme+xml"/><Override PartName="/word/fontTable.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml"/><Override PartName="/word/webSettings.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml"/><Override PartName="/docProps/core.xml" ContentType="application/vnd.openxmlformats-package.core-properties+xml"/></Types>'
        );
        $zipDocx->addContent('_rels/.rels', 
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships"><Relationship Id="rId3" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties" Target="docProps/app.xml"/><Relationship Id="rId2" Type="http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties" Target="docProps/core.xml"/><Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument" Target="word/document.xml"/></Relationships>'
        );
        $zipDocx->addContent('customXml/_rels/item1.xml.rels',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships"><Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXmlProps" Target="itemProps1.xml"/></Relationships>'
        );
        $zipDocx->addContent('customXml/itemProps1.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="no"?><ds:datastoreItem ds:itemID="{BB324958-CBFB-4DB0-B37D-BF649D31B7BE}" xmlns:ds="http://schemas.openxmlformats.org/officeDocument/2006/customXml"><ds:schemaRefs><ds:schemaRef ds:uri="http://schemas.openxmlformats.org/officeDocument/2006/bibliography"/></ds:schemaRefs></ds:datastoreItem>'
        );
        $zipDocx->addContent('customXml/item1.xml',
            '<b:Sources SelectedStyle="\APA.XSL" StyleName="APA" xmlns:b="http://schemas.openxmlformats.org/officeDocument/2006/bibliography" xmlns="http://schemas.openxmlformats.org/officeDocument/2006/bibliography"></b:Sources>'
        );
        $zipDocx->addContent('docProps/app.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><Properties xmlns="http://schemas.openxmlformats.org/officeDocument/2006/extended-properties" xmlns:vt="http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes"><Template>Normal.dotm</Template><TotalTime>43</TotalTime><Pages>12</Pages><Words>307</Words><Characters>1690</Characters><Application>Microsoft Office Word</Application><DocSecurity>0</DocSecurity><Lines>14</Lines><Paragraphs>3</Paragraphs><ScaleCrop>false</ScaleCrop><HeadingPairs><vt:vector size="2" baseType="variant"><vt:variant><vt:lpstr>Título</vt:lpstr></vt:variant><vt:variant><vt:i4>1</vt:i4></vt:variant></vt:vector></HeadingPairs><TitlesOfParts><vt:vector size="1" baseType="lpstr"><vt:lpstr></vt:lpstr></vt:vector></TitlesOfParts><Company></Company><LinksUpToDate>false</LinksUpToDate><CharactersWithSpaces>1994</CharactersWithSpaces><SharedDoc>false</SharedDoc><HyperlinksChanged>false</HyperlinksChanged><AppVersion>12.0000</AppVersion></Properties>'
        );
        $zipDocx->addContent('docProps/core.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><cp:coreProperties xmlns:cp="http://schemas.openxmlformats.org/package/2006/metadata/core-properties" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dcterms="http://purl.org/dc/terms/" xmlns:dcmitype="http://purl.org/dc/dcmitype/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><dc:title></dc:title><dc:subject></dc:subject><dc:creator>PHPDocX</dc:creator><cp:keywords></cp:keywords><dc:description></dc:description><cp:lastModifiedBy>PHPDocX</cp:lastModifiedBy><cp:revision>6</cp:revision><dcterms:created xsi:type="dcterms:W3CDTF">2012-01-10T09:29:00Z</dcterms:created><dcterms:modified xsi:type="dcterms:W3CDTF">2012-02-06T10:43:00Z</dcterms:modified></cp:coreProperties>'
        );
        $zipDocx->addContent('word/_rels/comments.xml.rels',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships"></Relationships>'
        );
        $zipDocx->addContent('word/_rels/document.xml.rels',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships"><Relationship Id="rId8" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable" Target="fontTable.xml"/><Relationship Id="rId3" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles" Target="styles.xml"/><Relationship Id="rId7" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes" Target="endnotes.xml"/><Relationship Id="rId2" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering" Target="numbering.xml"/><Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml" Target="../customXml/item1.xml"/><Relationship Id="rId6" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes" Target="footnotes.xml"/><Relationship Id="rId5" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/webSettings" Target="webSettings.xml"/><Relationship Id="rId4" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings" Target="settings.xml"/><Relationship Id="rId9" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme" Target="theme/theme1.xml"/><Relationship Id="rId10" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments" Target="comments.xml"/></Relationships>'
        );
        $zipDocx->addContent('word/_rels/endnotes.xml.rels',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships"></Relationships>'
        );
        $zipDocx->addContent('word/_rels/footnotes.xml.rels',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships"></Relationships>'
        );
        $zipDocx->addContent('word/theme/theme1.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><a:theme xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main" name="Tema de Office"><a:themeElements><a:clrScheme name="Office"><a:dk1><a:sysClr val="windowText" lastClr="000000"/></a:dk1><a:lt1><a:sysClr val="window" lastClr="FFFFFF"/></a:lt1><a:dk2><a:srgbClr val="1F497D"/></a:dk2><a:lt2><a:srgbClr val="EEECE1"/></a:lt2><a:accent1><a:srgbClr val="4F81BD"/></a:accent1><a:accent2><a:srgbClr val="C0504D"/></a:accent2><a:accent3><a:srgbClr val="9BBB59"/></a:accent3><a:accent4><a:srgbClr val="8064A2"/></a:accent4><a:accent5><a:srgbClr val="4BACC6"/></a:accent5><a:accent6><a:srgbClr val="F79646"/></a:accent6><a:hlink><a:srgbClr val="0000FF"/></a:hlink><a:folHlink><a:srgbClr val="800080"/></a:folHlink></a:clrScheme><a:fontScheme name="Office"><a:majorFont><a:latin typeface="Cambria"/><a:ea typeface=""/><a:cs typeface=""/><a:font script="Jpan" typeface="ＭＳ ゴシック"/><a:font script="Hang" typeface="맑은 고딕"/><a:font script="Hans" typeface="宋体"/><a:font script="Hant" typeface="新細明體"/><a:font script="Arab" typeface="Times New Roman"/><a:font script="Hebr" typeface="Times New Roman"/><a:font script="Thai" typeface="Angsana New"/><a:font script="Ethi" typeface="Nyala"/><a:font script="Beng" typeface="Vrinda"/><a:font script="Gujr" typeface="Shruti"/><a:font script="Khmr" typeface="MoolBoran"/><a:font script="Knda" typeface="Tunga"/><a:font script="Guru" typeface="Raavi"/><a:font script="Cans" typeface="Euphemia"/><a:font script="Cher" typeface="Plantagenet Cherokee"/><a:font script="Yiii" typeface="Microsoft Yi Baiti"/><a:font script="Tibt" typeface="Microsoft Himalaya"/><a:font script="Thaa" typeface="MV Boli"/><a:font script="Deva" typeface="Mangal"/><a:font script="Telu" typeface="Gautami"/><a:font script="Taml" typeface="Latha"/><a:font script="Syrc" typeface="Estrangelo Edessa"/><a:font script="Orya" typeface="Kalinga"/><a:font script="Mlym" typeface="Kartika"/><a:font script="Laoo" typeface="DokChampa"/><a:font script="Sinh" typeface="Iskoola Pota"/><a:font script="Mong" typeface="Mongolian Baiti"/><a:font script="Viet" typeface="Times New Roman"/><a:font script="Uigh" typeface="Microsoft Uighur"/></a:majorFont><a:minorFont><a:latin typeface="Calibri"/><a:ea typeface=""/><a:cs typeface=""/><a:font script="Jpan" typeface="ＭＳ 明朝"/><a:font script="Hang" typeface="맑은 고딕"/><a:font script="Hans" typeface="宋体"/><a:font script="Hant" typeface="新細明體"/><a:font script="Arab" typeface="Arial"/><a:font script="Hebr" typeface="Arial"/><a:font script="Thai" typeface="Cordia New"/><a:font script="Ethi" typeface="Nyala"/><a:font script="Beng" typeface="Vrinda"/><a:font script="Gujr" typeface="Shruti"/><a:font script="Khmr" typeface="DaunPenh"/><a:font script="Knda" typeface="Tunga"/><a:font script="Guru" typeface="Raavi"/><a:font script="Cans" typeface="Euphemia"/><a:font script="Cher" typeface="Plantagenet Cherokee"/><a:font script="Yiii" typeface="Microsoft Yi Baiti"/><a:font script="Tibt" typeface="Microsoft Himalaya"/><a:font script="Thaa" typeface="MV Boli"/><a:font script="Deva" typeface="Mangal"/><a:font script="Telu" typeface="Gautami"/><a:font script="Taml" typeface="Latha"/><a:font script="Syrc" typeface="Estrangelo Edessa"/><a:font script="Orya" typeface="Kalinga"/><a:font script="Mlym" typeface="Kartika"/><a:font script="Laoo" typeface="DokChampa"/><a:font script="Sinh" typeface="Iskoola Pota"/><a:font script="Mong" typeface="Mongolian Baiti"/><a:font script="Viet" typeface="Arial"/><a:font script="Uigh" typeface="Microsoft Uighur"/></a:minorFont></a:fontScheme><a:fmtScheme name="Office"><a:fillStyleLst><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="50000"/><a:satMod val="300000"/></a:schemeClr></a:gs><a:gs pos="35000"><a:schemeClr val="phClr"><a:tint val="37000"/><a:satMod val="300000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:tint val="15000"/><a:satMod val="350000"/></a:schemeClr></a:gs></a:gsLst><a:lin ang="16200000" scaled="1"/></a:gradFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:shade val="51000"/><a:satMod val="130000"/></a:schemeClr></a:gs><a:gs pos="80000"><a:schemeClr val="phClr"><a:shade val="93000"/><a:satMod val="130000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:shade val="94000"/><a:satMod val="135000"/></a:schemeClr></a:gs></a:gsLst><a:lin ang="16200000" scaled="0"/></a:gradFill></a:fillStyleLst><a:lnStyleLst><a:ln w="9525" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"><a:shade val="95000"/><a:satMod val="105000"/></a:schemeClr></a:solidFill><a:prstDash val="solid"/></a:ln><a:ln w="25400" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/></a:ln><a:ln w="38100" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/></a:ln></a:lnStyleLst><a:effectStyleLst><a:effectStyle><a:effectLst><a:outerShdw blurRad="40000" dist="20000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="38000"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="35000"/></a:srgbClr></a:outerShdw></a:effectLst></a:effectStyle><a:effectStyle><a:effectLst><a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="35000"/></a:srgbClr></a:outerShdw></a:effectLst><a:scene3d><a:camera prst="orthographicFront"><a:rot lat="0" lon="0" rev="0"/></a:camera><a:lightRig rig="threePt" dir="t"><a:rot lat="0" lon="0" rev="1200000"/></a:lightRig></a:scene3d><a:sp3d><a:bevelT w="63500" h="25400"/></a:sp3d></a:effectStyle></a:effectStyleLst><a:bgFillStyleLst><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="40000"/><a:satMod val="350000"/></a:schemeClr></a:gs><a:gs pos="40000"><a:schemeClr val="phClr"><a:tint val="45000"/><a:shade val="99000"/><a:satMod val="350000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:shade val="20000"/><a:satMod val="255000"/></a:schemeClr></a:gs></a:gsLst><a:path path="circle"><a:fillToRect l="50000" t="-80000" r="50000" b="180000"/></a:path></a:gradFill><a:gradFill rotWithShape="1"><a:gsLst><a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="80000"/><a:satMod val="300000"/></a:schemeClr></a:gs><a:gs pos="100000"><a:schemeClr val="phClr"><a:shade val="30000"/><a:satMod val="200000"/></a:schemeClr></a:gs></a:gsLst><a:path path="circle"><a:fillToRect l="50000" t="50000" r="50000" b="50000"/></a:path></a:gradFill></a:bgFillStyleLst></a:fmtScheme></a:themeElements><a:objectDefaults/><a:extraClrSchemeLst/></a:theme>'
        );
        $zipDocx->addContent('word/comments.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><w:comments xmlns:ve="http://schemas.openxmlformats.org/markup-compatibility/2006" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main" xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"></w:comments>'
        );
        $zipDocx->addContent('word/document.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><w:document xmlns:ve="http://schemas.openxmlformats.org/markup-compatibility/2006" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main" xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"><w:body><w:p w:rsidR="000F6147" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Titulo 1</w:t></w:r><w:r w:rsidR="004D6B48"><w:rPr><w:rStyle w:val="Refdenotaalpie"/></w:rPr><w:footnoteReference w:id="1"/></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Título 2</w:t></w:r><w:r w:rsidR="004D6B48"><w:rPr><w:rStyle w:val="Refdenotaalfinal"/></w:rPr><w:endnoteReference w:id="1"/></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Título 3</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Título 4</w:t></w:r><w:r w:rsidR="006E6663"><w:rPr><w:rStyle w:val="Refdenotaalpie"/></w:rPr><w:footnoteReference w:id="2"/></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Título 5</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Título 6</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Título 7</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Título grande</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Subtitulo</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Énfasis sutil</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Énfasis</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:proofErr w:type="spellStart"/><w:r><w:t>Enfasis</w:t></w:r><w:proofErr w:type="spellEnd"/><w:r><w:t xml:space="preserve"> intenso</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Texto en negrita</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Una cita</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Cita destacada</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Referencia sutil</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Referencia intensa</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Título de libro</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:proofErr w:type="spellStart"/><w:r><w:t>parrafo</w:t></w:r><w:proofErr w:type="spellEnd"/><w:r><w:t xml:space="preserve"> DE lista </w:t></w:r><w:proofErr w:type="spellStart"/><w:r><w:t>asdsad</w:t></w:r><w:proofErr w:type="spellEnd"/></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Normal</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Sin espaciado</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Muy junto</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:pPr><w:numPr><w:ilvl w:val="0"/><w:numId w:val="1"/></w:numPr></w:pPr><w:r><w:t xml:space="preserve">Lista con </w:t></w:r><w:proofErr w:type="spellStart"/><w:r><w:t>bullets</w:t></w:r><w:proofErr w:type="spellEnd"/></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:pPr><w:numPr><w:ilvl w:val="0"/><w:numId w:val="2"/></w:numPr></w:pPr><w:r><w:t>Lista numerada</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:pPr><w:numPr><w:ilvl w:val="0"/><w:numId w:val="3"/></w:numPr></w:pPr><w:r><w:t>Lista con paréntesis</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:pPr><w:numPr><w:ilvl w:val="0"/><w:numId w:val="4"/></w:numPr></w:pPr><w:r><w:t xml:space="preserve">Lista con </w:t></w:r><w:proofErr w:type="spellStart"/><w:r><w:t>sublistas</w:t></w:r><w:proofErr w:type="spellEnd"/></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:pPr><w:numPr><w:ilvl w:val="0"/><w:numId w:val="5"/></w:numPr></w:pPr><w:r><w:t xml:space="preserve">Listas con </w:t></w:r><w:proofErr w:type="spellStart"/><w:r><w:t>funky</w:t></w:r><w:proofErr w:type="spellEnd"/><w:r><w:t xml:space="preserve"> </w:t></w:r><w:proofErr w:type="spellStart"/><w:r><w:t>bullets</w:t></w:r><w:proofErr w:type="spellEnd"/></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"><w:r><w:t>Lista de títulos</w:t></w:r></w:p><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E"><w:r><w:br w:type="page"/></w:r></w:p><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRPr="00DF064E" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00DF064E" w:rsidRDefault="00DF064E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00493A0C"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00112029"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00493A0C" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00493A0C" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00493A0C" w:rsidRDefault="00493A0C" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00535F5A"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr><w:tr w:rsidR="00535F5A" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00535F5A"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00535F5A" w:rsidRDefault="00535F5A" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00361FF4"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00361FF4" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr><w:tr w:rsidR="00361FF4" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00361FF4"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00361FF4" w:rsidRDefault="00361FF4" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="00AC197E"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="002100BD"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="002100BD"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="002100BD"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:tbl><w:tblPr><w:tblStyle w:val="NormalTablePHPDOCX"/><w:tblW w:w="0" w:type="auto"/><w:tblLook w:val="04A0"/></w:tblPr><w:tblGrid><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/><w:gridCol w:w="2161"/></w:tblGrid><w:tr w:rsidR="00AC197E" w:rsidTr="002100BD"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="002100BD"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr><w:tr w:rsidR="00AC197E" w:rsidTr="002100BD"><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc><w:tc><w:tcPr><w:tcW w:w="2161" w:type="dxa"/></w:tcPr><w:p w:rsidR="00AC197E" w:rsidRDefault="00AC197E" w:rsidP="002100BD"/></w:tc></w:tr></w:tbl><w:p w:rsidR="00AC197E" w:rsidRPr="00DF064E" w:rsidRDefault="00AC197E" w:rsidP="00DF064E"/><w:sectPr w:rsidR="00AC197E" w:rsidRPr="00DF064E" w:rsidSect="000F6147"><w:pgSz w:w="11906" w:h="16838"/><w:pgMar w:top="1417" w:right="1701" w:bottom="1417" w:left="1701" w:header="708" w:footer="708" w:gutter="0"/><w:cols w:space="708"/><w:docGrid w:linePitch="360"/></w:sectPr></w:body></w:document>'
        );
        $zipDocx->addContent('word/endnotes.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><w:endnotes xmlns:ve="http://schemas.openxmlformats.org/markup-compatibility/2006" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main" xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"><w:endnote w:type="separator" w:id="-1"><w:p w:rsidR="006E0FDA" w:rsidRDefault="006E0FDA" w:rsidP="006E0FDA"><w:pPr><w:spacing w:after="0" w:line="240" w:lineRule="auto"/></w:pPr><w:r><w:separator/></w:r></w:p></w:endnote><w:endnote w:type="continuationSeparator" w:id="0"><w:p w:rsidR="006E0FDA" w:rsidRDefault="006E0FDA" w:rsidP="006E0FDA"><w:pPr><w:spacing w:after="0" w:line="240" w:lineRule="auto"/></w:pPr><w:r><w:continuationSeparator/></w:r></w:p></w:endnote></w:endnotes>'
        );
        $zipDocx->addContent('word/fontTable.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><w:fonts xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"><w:font w:name="Wingdings"><w:panose1 w:val="05000000000000000000"/><w:charset w:val="02"/><w:family w:val="auto"/><w:pitch w:val="variable"/><w:sig w:usb0="00000000" w:usb1="10000000" w:usb2="00000000" w:usb3="00000000" w:csb0="80000000" w:csb1="00000000"/></w:font><w:font w:name="Times New Roman"><w:panose1 w:val="02020603050405020304"/><w:charset w:val="00"/><w:family w:val="roman"/><w:pitch w:val="variable"/><w:sig w:usb0="20002A87" w:usb1="80000000" w:usb2="00000008" w:usb3="00000000" w:csb0="000001FF" w:csb1="00000000"/></w:font><w:font w:name="Symbol"><w:panose1 w:val="05050102010706020507"/><w:charset w:val="02"/><w:family w:val="roman"/><w:pitch w:val="variable"/><w:sig w:usb0="00000000" w:usb1="10000000" w:usb2="00000000" w:usb3="00000000" w:csb0="80000000" w:csb1="00000000"/></w:font><w:font w:name="Courier New"><w:panose1 w:val="02070309020205020404"/><w:charset w:val="00"/><w:family w:val="modern"/><w:pitch w:val="fixed"/><w:sig w:usb0="20002A87" w:usb1="80000000" w:usb2="00000008" w:usb3="00000000" w:csb0="000001FF" w:csb1="00000000"/></w:font><w:font w:name="Calibri"><w:panose1 w:val="020F0502020204030204"/><w:charset w:val="00"/><w:family w:val="swiss"/><w:pitch w:val="variable"/><w:sig w:usb0="A00002EF" w:usb1="4000207B" w:usb2="00000000" w:usb3="00000000" w:csb0="0000009F" w:csb1="00000000"/></w:font><w:font w:name="Cambria"><w:panose1 w:val="02040503050406030204"/><w:charset w:val="00"/><w:family w:val="roman"/><w:pitch w:val="variable"/><w:sig w:usb0="A00002EF" w:usb1="4000004B" w:usb2="00000000" w:usb3="00000000" w:csb0="0000009F" w:csb1="00000000"/></w:font></w:fonts>'
        );
        $zipDocx->addContent('word/footnotes.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><w:footnotes xmlns:ve="http://schemas.openxmlformats.org/markup-compatibility/2006" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main" xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"><w:footnote w:type="separator" w:id="-1"><w:p w:rsidR="006E0FDA" w:rsidRDefault="006E0FDA" w:rsidP="006E0FDA"><w:pPr><w:spacing w:after="0" w:line="240" w:lineRule="auto"/></w:pPr><w:r><w:separator/></w:r></w:p></w:footnote><w:footnote w:type="continuationSeparator" w:id="0"><w:p w:rsidR="006E0FDA" w:rsidRDefault="006E0FDA" w:rsidP="006E0FDA"><w:pPr><w:spacing w:after="0" w:line="240" w:lineRule="auto"/></w:pPr><w:r><w:continuationSeparator/></w:r></w:p></w:footnote></w:footnotes>'
        );
        $zipDocx->addContent('word/numbering.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><w:numbering xmlns:ve="http://schemas.openxmlformats.org/markup-compatibility/2006" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:wp="http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main" xmlns:wne="http://schemas.microsoft.com/office/word/2006/wordml"><w:abstractNum w:abstractNumId="0"><w:nsid w:val="262A5BB1"/><w:multiLevelType w:val="multilevel"/><w:tmpl w:val="FBB4C078"/><w:lvl w:ilvl="0"><w:start w:val="1"/><w:numFmt w:val="upperRoman"/><w:lvlText w:val="Article %1."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="0" w:firstLine="0"/></w:pPr></w:lvl><w:lvl w:ilvl="1"><w:start w:val="1"/><w:numFmt w:val="decimalZero"/><w:isLgl/><w:lvlText w:val="Section %1.%2"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="0" w:firstLine="0"/></w:pPr></w:lvl><w:lvl w:ilvl="2"><w:start w:val="1"/><w:numFmt w:val="lowerLetter"/><w:lvlText w:val="(%3)"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="720" w:hanging="432"/></w:pPr></w:lvl><w:lvl w:ilvl="3"><w:start w:val="1"/><w:numFmt w:val="lowerRoman"/><w:lvlText w:val="(%4)"/><w:lvlJc w:val="right"/><w:pPr><w:ind w:left="864" w:hanging="144"/></w:pPr></w:lvl><w:lvl w:ilvl="4"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%5)"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1008" w:hanging="432"/></w:pPr></w:lvl><w:lvl w:ilvl="5"><w:start w:val="1"/><w:numFmt w:val="lowerLetter"/><w:lvlText w:val="%6)"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1152" w:hanging="432"/></w:pPr></w:lvl><w:lvl w:ilvl="6"><w:start w:val="1"/><w:numFmt w:val="lowerRoman"/><w:lvlText w:val="%7)"/><w:lvlJc w:val="right"/><w:pPr><w:ind w:left="1296" w:hanging="288"/></w:pPr></w:lvl><w:lvl w:ilvl="7"><w:start w:val="1"/><w:numFmt w:val="lowerLetter"/><w:lvlText w:val="%8."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1440" w:hanging="432"/></w:pPr></w:lvl><w:lvl w:ilvl="8"><w:start w:val="1"/><w:numFmt w:val="lowerRoman"/><w:lvlText w:val="%9."/><w:lvlJc w:val="right"/><w:pPr><w:ind w:left="1584" w:hanging="144"/></w:pPr></w:lvl></w:abstractNum><w:abstractNum w:abstractNumId="1"><w:nsid w:val="2EE2481C"/><w:multiLevelType w:val="multilevel"/><w:tmpl w:val="0C0A0021"/><w:lvl w:ilvl="0"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="360" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Wingdings" w:hAnsi="Wingdings" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="1"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="720" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Wingdings" w:hAnsi="Wingdings" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="2"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1080" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Wingdings" w:hAnsi="Wingdings" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="3"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1440" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Symbol" w:hAnsi="Symbol" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="4"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1800" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Symbol" w:hAnsi="Symbol" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="5"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2160" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Wingdings" w:hAnsi="Wingdings" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="6"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2520" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Wingdings" w:hAnsi="Wingdings" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="7"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2880" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Symbol" w:hAnsi="Symbol" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="8"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="3240" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Symbol" w:hAnsi="Symbol" w:hint="default"/></w:rPr></w:lvl></w:abstractNum><w:abstractNum w:abstractNumId="2"><w:nsid w:val="4E030807"/><w:multiLevelType w:val="multilevel"/><w:tmpl w:val="0C0A0025"/><w:lvl w:ilvl="0"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:pStyle w:val="Heading1PHPDOCX"/><w:lvlText w:val="%1"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="432" w:hanging="432"/></w:pPr></w:lvl><w:lvl w:ilvl="1"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:pStyle w:val="Heading2PHPDOCX"/><w:lvlText w:val="%1.%2"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="576" w:hanging="576"/></w:pPr></w:lvl><w:lvl w:ilvl="2"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:pStyle w:val="Heading3PHPDOCX"/><w:lvlText w:val="%1.%2.%3"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="720" w:hanging="720"/></w:pPr></w:lvl><w:lvl w:ilvl="3"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:pStyle w:val="Heading4PHPDOCX"/><w:lvlText w:val="%1.%2.%3.%4"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="864" w:hanging="864"/></w:pPr></w:lvl><w:lvl w:ilvl="4"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:pStyle w:val="Heading5PHPDOCX"/><w:lvlText w:val="%1.%2.%3.%4.%5"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1008" w:hanging="1008"/></w:pPr></w:lvl><w:lvl w:ilvl="5"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:pStyle w:val="Heading6PHPDOCX"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1152" w:hanging="1152"/></w:pPr></w:lvl><w:lvl w:ilvl="6"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:pStyle w:val="Heading7PHPDOCX"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1296" w:hanging="1296"/></w:pPr></w:lvl><w:lvl w:ilvl="7"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:pStyle w:val="Heading8PHPDOCX"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7.%8"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1440" w:hanging="1440"/></w:pPr></w:lvl><w:lvl w:ilvl="8"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:pStyle w:val="Heading9PHPDOCX"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7.%8.%9"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1584" w:hanging="1584"/></w:pPr></w:lvl></w:abstractNum><w:abstractNum w:abstractNumId="3"><w:nsid w:val="516B4C7F"/><w:multiLevelType w:val="hybridMultilevel"/><w:tmpl w:val="D562937E"/><w:lvl w:ilvl="0" w:tplc="0C0A0001"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="720" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Symbol" w:hAnsi="Symbol" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="1" w:tplc="0C0A0003" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val="o"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1440" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Courier New" w:hAnsi="Courier New" w:cs="Courier New" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="2" w:tplc="0C0A0005" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2160" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Wingdings" w:hAnsi="Wingdings" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="3" w:tplc="0C0A0001" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2880" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Symbol" w:hAnsi="Symbol" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="4" w:tplc="0C0A0003" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val="o"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="3600" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Courier New" w:hAnsi="Courier New" w:cs="Courier New" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="5" w:tplc="0C0A0005" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="4320" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Wingdings" w:hAnsi="Wingdings" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="6" w:tplc="0C0A0001" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="5040" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Symbol" w:hAnsi="Symbol" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="7" w:tplc="0C0A0003" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val="o"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="5760" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Courier New" w:hAnsi="Courier New" w:cs="Courier New" w:hint="default"/></w:rPr></w:lvl><w:lvl w:ilvl="8" w:tplc="0C0A0005" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="bullet"/><w:lvlText w:val=""/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="6480" w:hanging="360"/></w:pPr><w:rPr><w:rFonts w:ascii="Wingdings" w:hAnsi="Wingdings" w:hint="default"/></w:rPr></w:lvl></w:abstractNum><w:abstractNum w:abstractNumId="4"><w:nsid w:val="5623468F"/><w:multiLevelType w:val="multilevel"/><w:tmpl w:val="0C0A001F"/><w:lvl w:ilvl="0"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="360" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="1"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1.%2."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="792" w:hanging="432"/></w:pPr></w:lvl><w:lvl w:ilvl="2"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1.%2.%3."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1224" w:hanging="504"/></w:pPr></w:lvl><w:lvl w:ilvl="3"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1.%2.%3.%4."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1728" w:hanging="648"/></w:pPr></w:lvl><w:lvl w:ilvl="4"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1.%2.%3.%4.%5."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2232" w:hanging="792"/></w:pPr></w:lvl><w:lvl w:ilvl="5"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2736" w:hanging="936"/></w:pPr></w:lvl><w:lvl w:ilvl="6"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="3240" w:hanging="1080"/></w:pPr></w:lvl><w:lvl w:ilvl="7"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7.%8."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="3744" w:hanging="1224"/></w:pPr></w:lvl><w:lvl w:ilvl="8"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1.%2.%3.%4.%5.%6.%7.%8.%9."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="4320" w:hanging="1440"/></w:pPr></w:lvl></w:abstractNum><w:abstractNum w:abstractNumId="5"><w:nsid w:val="56792213"/><w:multiLevelType w:val="hybridMultilevel"/><w:tmpl w:val="C502613C"/><w:lvl w:ilvl="0" w:tplc="0C0A000F"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="720" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="1" w:tplc="0C0A0019" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="lowerLetter"/><w:lvlText w:val="%2."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1440" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="2" w:tplc="0C0A001B" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="lowerRoman"/><w:lvlText w:val="%3."/><w:lvlJc w:val="right"/><w:pPr><w:ind w:left="2160" w:hanging="180"/></w:pPr></w:lvl><w:lvl w:ilvl="3" w:tplc="0C0A000F" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%4."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2880" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="4" w:tplc="0C0A0019" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="lowerLetter"/><w:lvlText w:val="%5."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="3600" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="5" w:tplc="0C0A001B" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="lowerRoman"/><w:lvlText w:val="%6."/><w:lvlJc w:val="right"/><w:pPr><w:ind w:left="4320" w:hanging="180"/></w:pPr></w:lvl><w:lvl w:ilvl="6" w:tplc="0C0A000F" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%7."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="5040" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="7" w:tplc="0C0A0019" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="lowerLetter"/><w:lvlText w:val="%8."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="5760" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="8" w:tplc="0C0A001B" w:tentative="1"><w:start w:val="1"/><w:numFmt w:val="lowerRoman"/><w:lvlText w:val="%9."/><w:lvlJc w:val="right"/><w:pPr><w:ind w:left="6480" w:hanging="180"/></w:pPr></w:lvl></w:abstractNum><w:abstractNum w:abstractNumId="6"><w:nsid w:val="6027097E"/><w:multiLevelType w:val="multilevel"/><w:tmpl w:val="0C0A001D"/><w:lvl w:ilvl="0"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%1)"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="360" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="1"><w:start w:val="1"/><w:numFmt w:val="lowerLetter"/><w:lvlText w:val="%2)"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="720" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="2"><w:start w:val="1"/><w:numFmt w:val="lowerRoman"/><w:lvlText w:val="%3)"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1080" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="3"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="(%4)"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1440" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="4"><w:start w:val="1"/><w:numFmt w:val="lowerLetter"/><w:lvlText w:val="(%5)"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="1800" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="5"><w:start w:val="1"/><w:numFmt w:val="lowerRoman"/><w:lvlText w:val="(%6)"/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2160" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="6"><w:start w:val="1"/><w:numFmt w:val="decimal"/><w:lvlText w:val="%7."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2520" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="7"><w:start w:val="1"/><w:numFmt w:val="lowerLetter"/><w:lvlText w:val="%8."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="2880" w:hanging="360"/></w:pPr></w:lvl><w:lvl w:ilvl="8"><w:start w:val="1"/><w:numFmt w:val="lowerRoman"/><w:lvlText w:val="%9."/><w:lvlJc w:val="left"/><w:pPr><w:ind w:left="3240" w:hanging="360"/></w:pPr></w:lvl></w:abstractNum><w:num w:numId="1"><w:abstractNumId w:val="3"/></w:num><w:num w:numId="2"><w:abstractNumId w:val="5"/></w:num><w:num w:numId="3"><w:abstractNumId w:val="6"/></w:num><w:num w:numId="4"><w:abstractNumId w:val="4"/></w:num><w:num w:numId="5"><w:abstractNumId w:val="1"/></w:num><w:num w:numId="6"><w:abstractNumId w:val="0"/></w:num><w:num w:numId="7"><w:abstractNumId w:val="2"/></w:num></w:numbering>'
        );
        $zipDocx->addContent('word/settings.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><w:settings xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:m="http://schemas.openxmlformats.org/officeDocument/2006/math" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w10="urn:schemas-microsoft-com:office:word" xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main" xmlns:sl="http://schemas.openxmlformats.org/schemaLibrary/2006/main"><w:zoom w:percent="100"/><w:proofState w:spelling="clean" w:grammar="clean"/><w:defaultTabStop w:val="708"/><w:hyphenationZone w:val="425"/><w:characterSpacingControl w:val="doNotCompress"/><w:footnotePr><w:footnote w:id="-1"/><w:footnote w:id="0"/></w:footnotePr><w:endnotePr><w:endnote w:id="-1"/><w:endnote w:id="0"/></w:endnotePr><w:compat/><w:rsids><w:rsidRoot w:val="00DF064E"/><w:rsid w:val="00065F9C"/><w:rsid w:val="000F6147"/><w:rsid w:val="00112029"/><w:rsid w:val="00135412"/><w:rsid w:val="00361FF4"/><w:rsid w:val="003B5299"/><w:rsid w:val="00493A0C"/><w:rsid w:val="004D6B48"/><w:rsid w:val="00531A4E"/><w:rsid w:val="00535F5A"/><w:rsid w:val="00555F58"/><w:rsid w:val="006E6663"/><w:rsid w:val="008B3AC2"/><w:rsid w:val="008F680D"/><w:rsid w:val="00AC197E"/><w:rsid w:val="00B21D59"/><w:rsid w:val="00BD419F"/><w:rsid w:val="00DF064E"/><w:rsid w:val="00FB45FF"/></w:rsids><m:mathPr><m:mathFont m:val="Cambria Math"/><m:brkBin m:val="before"/><m:brkBinSub m:val="--"/><m:smallFrac m:val="off"/><m:dispDef/><m:lMargin m:val="0"/><m:rMargin m:val="0"/><m:defJc m:val="centerGroup"/><m:wrapIndent m:val="1440"/><m:intLim m:val="subSup"/><m:naryLim m:val="undOvr"/></m:mathPr><w:themeFontLang w:val="en-US"/><w:clrSchemeMapping w:bg1="light1" w:t1="dark1" w:bg2="light2" w:t2="dark2" w:accent1="accent1" w:accent2="accent2" w:accent3="accent3" w:accent4="accent4" w:accent5="accent5" w:accent6="accent6" w:hyperlink="hyperlink" w:followedHyperlink="followedHyperlink"/><w:shapeDefaults><o:shapedefaults v:ext="edit" spidmax="1026"/><o:shapelayout v:ext="edit"><o:idmap v:ext="edit" data="1"/></o:shapelayout></w:shapeDefaults><w:decimalSymbol w:val="."/><w:listSeparator w:val=";"/></w:settings>'
        );
        $zipDocx->addContent('word/styles.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><w:styles xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"> <w:docDefaults> <w:rPrDefault> <w:rPr> <w:rFonts w:asciiTheme="minorHAnsi" w:eastAsiaTheme="minorHAnsi" w:hAnsiTheme="minorHAnsi" w:cstheme="minorBidi"/> <w:sz w:val="22"/> <w:szCs w:val="22"/> <w:lang w:val="en-US" w:eastAsia="en-US" w:bidi="ar-SA"/> </w:rPr> </w:rPrDefault> <w:pPrDefault> <w:pPr> <w:spacing w:after="200" w:line="276" w:lineRule="auto"/> </w:pPr> </w:pPrDefault> </w:docDefaults> <w:latentStyles w:defLockedState="0" w:defUIPriority="99" w:defSemiHidden="1" w:defUnhideWhenUsed="1" w:defQFormat="0" w:count="267"> <w:lsdException w:name="Normal PHPDOCX" w:semiHidden="0" w:uiPriority="0" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Heading 1 PHPDOCX" w:semiHidden="0" w:uiPriority="9" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Heading 2 PHPDOCX" w:uiPriority="9" w:qFormat="1"/> <w:lsdException w:name="Heading 3 PHPDOCX" w:uiPriority="9" w:qFormat="1"/> <w:lsdException w:name="Heading 4 PHPDOCX" w:uiPriority="9" w:qFormat="1"/> <w:lsdException w:name="Heading 5 PHPDOCX" w:uiPriority="9" w:qFormat="1"/> <w:lsdException w:name="Heading 6 PHPDOCX" w:uiPriority="9" w:qFormat="1"/> <w:lsdException w:name="Heading 7 PHPDOCX" w:uiPriority="9" w:qFormat="1"/> <w:lsdException w:name="Heading 8 PHPDOCX" w:uiPriority="9" w:qFormat="1"/> <w:lsdException w:name="Heading 9 PHPDOCX" w:uiPriority="9" w:qFormat="1"/> <w:lsdException w:name="toc 1 PHPDOCX" w:uiPriority="39"/> <w:lsdException w:name="toc 2 PHPDOCX" w:uiPriority="39"/> <w:lsdException w:name="toc 3 PHPDOCX" w:uiPriority="39"/> <w:lsdException w:name="toc 4 PHPDOCX" w:uiPriority="39"/> <w:lsdException w:name="toc 5 PHPDOCX" w:uiPriority="39"/> <w:lsdException w:name="toc 6 PHPDOCX" w:uiPriority="39"/> <w:lsdException w:name="toc 7 PHPDOCX" w:uiPriority="39"/> <w:lsdException w:name="toc 8 PHPDOCX" w:uiPriority="39"/> <w:lsdException w:name="toc 9 PHPDOCX" w:uiPriority="39"/> <w:lsdException w:name="caption PHPDOCX" w:uiPriority="35" w:qFormat="1"/> <w:lsdException w:name="Title PHPDOCX" w:semiHidden="0" w:uiPriority="10" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Default Paragraph Font PHPDOCX" w:uiPriority="1"/> <w:lsdException w:name="Subtitle PHPDOCX" w:semiHidden="0" w:uiPriority="11" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Strong PHPDOCX" w:semiHidden="0" w:uiPriority="22" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Emphasis PHPDOCX" w:semiHidden="0" w:uiPriority="20" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Normal Table PHPDOCX" w:semiHidden="0" w:uiPriority="58" w:unhideWhenUsed="0"/> <w:lsdException w:name="Table Grid PHPDOCX" w:semiHidden="0" w:uiPriority="59" w:unhideWhenUsed="0"/> <w:lsdException w:name="Placeholder Text PHPDOCX" w:unhideWhenUsed="0"/> <w:lsdException w:name="No Spacing PHPDOCX" w:semiHidden="0" w:uiPriority="1" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Light Shading PHPDOCX" w:semiHidden="0" w:uiPriority="60" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light List PHPDOCX" w:semiHidden="0" w:uiPriority="61" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Grid PHPDOCX" w:semiHidden="0" w:uiPriority="62" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 1 PHPDOCX" w:semiHidden="0" w:uiPriority="63" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 2 PHPDOCX" w:semiHidden="0" w:uiPriority="64" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 1 PHPDOCX" w:semiHidden="0" w:uiPriority="65" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 2 PHPDOCX" w:semiHidden="0" w:uiPriority="66" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 1 PHPDOCX" w:semiHidden="0" w:uiPriority="67" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 2 PHPDOCX" w:semiHidden="0" w:uiPriority="68" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 3 PHPDOCX" w:semiHidden="0" w:uiPriority="69" w:unhideWhenUsed="0"/> <w:lsdException w:name="Dark List PHPDOCX" w:semiHidden="0" w:uiPriority="70" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Shading PHPDOCX" w:semiHidden="0" w:uiPriority="71" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful List PHPDOCX" w:semiHidden="0" w:uiPriority="72" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Grid PHPDOCX" w:semiHidden="0" w:uiPriority="73" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Shading Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="60" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light List Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="61" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Grid Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="62" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 1 Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="63" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 2 Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="64" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 1 Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="65" w:unhideWhenUsed="0"/> <w:lsdException w:name="Revision PHPDOCX" w:unhideWhenUsed="0"/> <w:lsdException w:name="List Paragraph PHPDOCX" w:semiHidden="0" w:uiPriority="34" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Quote PHPDOCX" w:semiHidden="0" w:uiPriority="29" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Intense Quote PHPDOCX" w:semiHidden="0" w:uiPriority="30" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Medium List 2 Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="66" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 1 Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="67" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 2 Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="68" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 3 Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="69" w:unhideWhenUsed="0"/> <w:lsdException w:name="Dark List Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="70" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Shading Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="71" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful List Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="72" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Grid Accent 1 PHPDOCX" w:semiHidden="0" w:uiPriority="73" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Shading Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="60" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light List Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="61" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Grid Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="62" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 1 Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="63" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 2 Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="64" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 1 Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="65" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 2 Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="66" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 1 Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="67" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 2 Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="68" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 3 Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="69" w:unhideWhenUsed="0"/> <w:lsdException w:name="Dark List Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="70" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Shading Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="71" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful List Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="72" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Grid Accent 2 PHPDOCX" w:semiHidden="0" w:uiPriority="73" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Shading Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="60" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light List Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="61" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Grid Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="62" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 1 Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="63" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 2 Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="64" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 1 Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="65" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 2 Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="66" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 1 Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="67" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 2 Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="68" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 3 Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="69" w:unhideWhenUsed="0"/> <w:lsdException w:name="Dark List Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="70" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Shading Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="71" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful List Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="72" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Grid Accent 3 PHPDOCX" w:semiHidden="0" w:uiPriority="73" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Shading Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="60" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light List Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="61" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Grid Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="62" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 1 Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="63" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 2 Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="64" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 1 Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="65" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 2 Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="66" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 1 Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="67" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 2 Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="68" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 3 Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="69" w:unhideWhenUsed="0"/> <w:lsdException w:name="Dark List Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="70" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Shading Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="71" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful List Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="72" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Grid Accent 4 PHPDOCX" w:semiHidden="0" w:uiPriority="73" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Shading Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="60" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light List Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="61" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Grid Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="62" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 1 Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="63" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 2 Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="64" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 1 Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="65" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 2 Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="66" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 1 Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="67" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 2 Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="68" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 3 Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="69" w:unhideWhenUsed="0"/> <w:lsdException w:name="Dark List Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="70" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Shading Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="71" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful List Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="72" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Grid Accent 5 PHPDOCX" w:semiHidden="0" w:uiPriority="73" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Shading Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="60" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light List Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="61" w:unhideWhenUsed="0"/> <w:lsdException w:name="Light Grid Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="62" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 1 Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="63" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Shading 2 Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="64" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 1 Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="65" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium List 2 Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="66" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 1 Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="67" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 2 Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="68" w:unhideWhenUsed="0"/> <w:lsdException w:name="Medium Grid 3 Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="69" w:unhideWhenUsed="0"/> <w:lsdException w:name="Dark List Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="70" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Shading Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="71" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful List Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="72" w:unhideWhenUsed="0"/> <w:lsdException w:name="Colorful Grid Accent 6 PHPDOCX" w:semiHidden="0" w:uiPriority="73" w:unhideWhenUsed="0"/> <w:lsdException w:name="Subtle Emphasis PHPDOCX" w:semiHidden="0" w:uiPriority="19" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Intense Emphasis PHPDOCX" w:semiHidden="0" w:uiPriority="21" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Subtle Reference PHPDOCX" w:semiHidden="0" w:uiPriority="31" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Intense Reference PHPDOCX" w:semiHidden="0" w:uiPriority="32" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Book Title PHPDOCX" w:semiHidden="0" w:uiPriority="33" w:unhideWhenUsed="0" w:qFormat="1"/> <w:lsdException w:name="Bibliography PHPDOCX" w:uiPriority="37"/> <w:lsdException w:name="TOC Heading PHPDOCX" w:uiPriority="39" w:qFormat="1"/> </w:latentStyles> <w:style w:type="paragraph" w:default="1" w:styleId="Normal"> <w:name w:val="Normal"/> <w:qFormat/> <w:rsid w:val="000F6147"/> </w:style> <w:style w:type="paragraph" w:styleId="Heading1PHPDOCX"> <w:name w:val="Heading 1 PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="Heading1CarPHPDOCX"/> <w:uiPriority w:val="9"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:keepNext/> <w:keepLines/> <w:spacing w:before="480" w:after="0"/> <w:outlineLvl w:val="0"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> <w:color w:val="365F91" w:themeColor="accent1" w:themeShade="BF"/> <w:sz w:val="28"/> <w:szCs w:val="28"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="Heading2PHPDOCX"> <w:name w:val="Heading 2 PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="Heading2CarPHPDOCX"/> <w:uiPriority w:val="9"/> <w:unhideWhenUsed/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:keepNext/> <w:keepLines/> <w:spacing w:before="200" w:after="0"/> <w:outlineLvl w:val="1"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> <w:sz w:val="26"/> <w:szCs w:val="26"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="Heading3PHPDOCX"> <w:name w:val="Heading 3 PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="Heading3CarPHPDOCX"/> <w:uiPriority w:val="9"/> <w:unhideWhenUsed/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:keepNext/> <w:keepLines/> <w:spacing w:before="200" w:after="0"/> <w:outlineLvl w:val="2"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="Heading4PHPDOCX"> <w:name w:val="Heading 4 PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="Heading4CarPHPDOCX"/> <w:uiPriority w:val="9"/> <w:unhideWhenUsed/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:keepNext/> <w:keepLines/> <w:spacing w:before="200" w:after="0"/> <w:outlineLvl w:val="3"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> <w:i/> <w:iCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="Heading5PHPDOCX"> <w:name w:val="Heading 5 PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="Heading5CarPHPDOCX"/> <w:uiPriority w:val="9"/> <w:unhideWhenUsed/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:keepNext/> <w:keepLines/> <w:spacing w:before="200" w:after="0"/> <w:outlineLvl w:val="4"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="243F60" w:themeColor="accent1" w:themeShade="7F"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="Heading6PHPDOCX"> <w:name w:val="Heading 6 PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="Heading6CarPHPDOCX"/> <w:uiPriority w:val="9"/> <w:unhideWhenUsed/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:keepNext/> <w:keepLines/> <w:spacing w:before="200" w:after="0"/> <w:outlineLvl w:val="5"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:i/> <w:iCs/> <w:color w:val="243F60" w:themeColor="accent1" w:themeShade="7F"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="Heading7PHPDOCX"> <w:name w:val="Heading 7 PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="Heading7CarPHPDOCX"/> <w:uiPriority w:val="9"/> <w:unhideWhenUsed/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:keepNext/> <w:keepLines/> <w:spacing w:before="200" w:after="0"/> <w:outlineLvl w:val="6"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:i/> <w:iCs/> <w:color w:val="404040" w:themeColor="text1" w:themeTint="BF"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="Heading8PHPDOCX"> <w:name w:val="Heading 8 PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="Heading8CarPHPDOCX"/> <w:uiPriority w:val="9"/> <w:semiHidden/> <w:unhideWhenUsed/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:keepNext/> <w:keepLines/> <w:spacing w:before="200" w:after="0"/> <w:outlineLvl w:val="7"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="404040" w:themeColor="text1" w:themeTint="BF"/> <w:sz w:val="20"/> <w:szCs w:val="20"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="Heading9PHPDOCX"> <w:name w:val="Heading 9 PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="Heading9CarPHPDOCX"/> <w:uiPriority w:val="9"/> <w:semiHidden/> <w:unhideWhenUsed/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:keepNext/> <w:keepLines/> <w:spacing w:before="200" w:after="0"/> <w:outlineLvl w:val="8"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:i/> <w:iCs/> <w:color w:val="404040" w:themeColor="text1" w:themeTint="BF"/> <w:sz w:val="20"/> <w:szCs w:val="20"/> </w:rPr> </w:style><w:style w:type="character" w:styleId="CommentReferencePHPDOCX"><w:name w:val="annotation reference PHPDOCX"/><w:basedOn w:val="DefaultParagraphFontPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:unhideWhenUsed/><w:rsid w:val="00E139EA"/><w:rPr><w:sz w:val="16"/><w:szCs w:val="16"/></w:rPr></w:style><w:style w:type="paragraph" w:styleId="CommentTextPHPDOCX"><w:name w:val="annotation text PHPDOCX"/><w:basedOn w:val="Normal"/><w:link w:val="CommentTextCharPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:unhideWhenUsed/><w:rsid w:val="00E139EA"/><w:pPr><w:spacing w:line="240" w:lineRule="auto"/></w:pPr><w:rPr><w:sz w:val="20"/><w:szCs w:val="20"/></w:rPr></w:style><w:style w:type="character" w:customStyle="1" w:styleId="CommentTextCharPHPDOCX"><w:name w:val="Comment Text Char PHPDOCX"/><w:basedOn w:val="DefaultParagraphFontPHPDOCX"/><w:link w:val="CommentTextPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:rsid w:val="00E139EA"/><w:rPr><w:sz w:val="20"/><w:szCs w:val="20"/></w:rPr></w:style><w:style w:type="paragraph" w:styleId="CommentSubjectPHPDOCX"><w:name w:val="annotation subject PHPDOCX"/><w:basedOn w:val="CommentTextPHPDOCX"/><w:next w:val="CommentTextPHPDOCX"/><w:link w:val="CommentSubjectCharPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:unhideWhenUsed/><w:rsid w:val="00E139EA"/><w:rPr><w:b/><w:bCs/></w:rPr></w:style><w:style w:type="character" w:customStyle="1" w:styleId="CommentSubjectCharPHPDOCX"><w:name w:val="Comment Subject Char PHPDOCX"/><w:basedOn w:val="CommentTextCharPHPDOCX"/><w:link w:val="CommentSubjectPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:rsid w:val="00E139EA"/><w:rPr><w:b/><w:bCs/><w:sz w:val="20"/><w:szCs w:val="20"/></w:rPr></w:style><w:style w:type="paragraph" w:styleId="BalloonTextPHPDOCX"><w:name w:val="Balloon Text PHPDOCX"/><w:basedOn w:val="Normal"/><w:link w:val="BalloonTextCharPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:unhideWhenUsed/><w:rsid w:val="00E139EA"/><w:pPr><w:spacing w:after="0" w:line="240" w:lineRule="auto"/></w:pPr><w:rPr><w:rFonts w:ascii="Tahoma" w:hAnsi="Tahoma" w:cs="Tahoma"/><w:sz w:val="16"/><w:szCs w:val="16"/></w:rPr></w:style><w:style w:type="character" w:customStyle="1" w:styleId="BalloonTextCharPHPDOCX"><w:name w:val="Balloon Text Char PHPDOCX"/><w:basedOn w:val="DefaultParagraphFontPHPDOCX"/><w:link w:val="BalloonTextPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:rsid w:val="00E139EA"/><w:rPr><w:rFonts w:ascii="Tahoma" w:hAnsi="Tahoma" w:cs="Tahoma"/><w:sz w:val="16"/><w:szCs w:val="16"/></w:rPr></w:style> <w:style w:type="paragraph" w:styleId="footnoteTextPHPDOCX"><w:name w:val="footnote Text PHPDOCX"/><w:basedOn w:val="Normal"/><w:link w:val="footnoteTextCarPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:unhideWhenUsed/><w:rsid w:val="006E0FDA"/><w:pPr><w:spacing w:after="0" w:line="240" w:lineRule="auto"/></w:pPr><w:rPr><w:sz w:val="20"/><w:szCs w:val="20"/></w:rPr></w:style><w:style w:type="character" w:customStyle="1" w:styleId="footnoteTextCarPHPDOCX"><w:name w:val="footnote text Car PHPDOCX"/><w:basedOn w:val="DefaultParagraphFontPHPDOCX"/><w:link w:val="footnoteTextPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:rsid w:val="006E0FDA"/><w:rPr><w:sz w:val="20"/><w:szCs w:val="20"/></w:rPr></w:style><w:style w:type="character" w:styleId="footnoteReferencePHPDOCX"><w:name w:val="footnote Reference PHPDOCX"/><w:basedOn w:val="DefaultParagraphFontPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:unhideWhenUsed/><w:rsid w:val="006E0FDA"/><w:rPr><w:vertAlign w:val="superscript"/></w:rPr></w:style><w:style w:type="paragraph" w:styleId="endnoteTextPHPDOCX"><w:name w:val="endnote Text PHPDOCX"/><w:basedOn w:val="Normal"/><w:link w:val="endnoteTextCarPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:unhideWhenUsed/><w:rsid w:val="006E0FDA"/><w:pPr><w:spacing w:after="0" w:line="240" w:lineRule="auto"/></w:pPr><w:rPr><w:sz w:val="20"/><w:szCs w:val="20"/></w:rPr></w:style><w:style w:type="character" w:customStyle="1" w:styleId="endnoteTextCarPHPDOCX"><w:name w:val="endnote text Car PHPDOCX"/><w:basedOn w:val="DefaultParagraphFontPHPDOCX"/><w:link w:val="endnoteTextPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:rsid w:val="006E0FDA"/><w:rPr><w:sz w:val="20"/><w:szCs w:val="20"/></w:rPr></w:style><w:style w:type="character" w:styleId="endnoteReferencePHPDOCX"><w:name w:val="endnote Reference PHPDOCX"/><w:basedOn w:val="DefaultParagraphFontPHPDOCX"/><w:uiPriority w:val="99"/><w:semiHidden/><w:unhideWhenUsed/><w:rsid w:val="006E0FDA"/><w:rPr><w:vertAlign w:val="superscript"/></w:rPr></w:style> <w:style w:type="character" w:default="1" w:styleId="DefaultParagraphFontPHPDOCX"> <w:name w:val="Default Paragraph Font PHPDOCX"/> <w:uiPriority w:val="1"/> <w:semiHidden/> <w:unhideWhenUsed/> </w:style> <w:style w:type="numbering" w:default="1" w:styleId="NoListPHPDOCX"> <w:name w:val="No List PHPDOCX"/> <w:uiPriority w:val="99"/> <w:semiHidden/> <w:unhideWhenUsed/> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="Heading1CarPHPDOCX"> <w:name w:val="Heading 1 Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="Heading1PHPDOCX"/> <w:uiPriority w:val="9"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> <w:color w:val="365F91" w:themeColor="accent1" w:themeShade="BF"/> <w:sz w:val="28"/> <w:szCs w:val="28"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="Heading2CarPHPDOCX"> <w:name w:val="Heading 2 Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="Heading2PHPDOCX"/> <w:uiPriority w:val="9"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> <w:sz w:val="26"/> <w:szCs w:val="26"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="Heading3CarPHPDOCX"> <w:name w:val="Heading 3 Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="Heading3PHPDOCX"/> <w:uiPriority w:val="9"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="Heading4CarPHPDOCX"> <w:name w:val="Heading 4 Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="Heading4PHPDOCX"/> <w:uiPriority w:val="9"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> <w:i/> <w:iCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="Heading5CarPHPDOCX"> <w:name w:val="Heading 5 Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="Heading5PHPDOCX"/> <w:uiPriority w:val="9"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="243F60" w:themeColor="accent1" w:themeShade="7F"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="Heading6CarPHPDOCX"> <w:name w:val="Heading 6 Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="Heading6PHPDOCX"/> <w:uiPriority w:val="9"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:i/> <w:iCs/> <w:color w:val="243F60" w:themeColor="accent1" w:themeShade="7F"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="Heading7CarPHPDOCX"> <w:name w:val="Heading 7 Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="Heading7PHPDOCX"/> <w:uiPriority w:val="9"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:i/> <w:iCs/> <w:color w:val="404040" w:themeColor="text1" w:themeTint="BF"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="TitlePHPDOCX"> <w:name w:val="Title PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="TitleCarPHPDOCX"/> <w:uiPriority w:val="10"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:pBdr> <w:bottom w:val="single" w:sz="8" w:space="4" w:color="4F81BD" w:themeColor="accent1"/> </w:pBdr> <w:spacing w:after="300" w:line="240" w:lineRule="auto"/> <w:contextualSpacing/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="17365D" w:themeColor="text2" w:themeShade="BF"/> <w:spacing w:val="5"/> <w:kern w:val="28"/> <w:sz w:val="52"/> <w:szCs w:val="52"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="TitleCarPHPDOCX"> <w:name w:val="Title Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="TitlePHPDOCX"/> <w:uiPriority w:val="10"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="17365D" w:themeColor="text2" w:themeShade="BF"/> <w:spacing w:val="5"/> <w:kern w:val="28"/> <w:sz w:val="52"/> <w:szCs w:val="52"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="SubtitlePHPDOCX"> <w:name w:val="Subtitle PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="SubtitleCarPHPDOCX"/> <w:uiPriority w:val="11"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:numPr> <w:ilvl w:val="1"/> </w:numPr> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:i/> <w:iCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> <w:spacing w:val="15"/> <w:sz w:val="24"/> <w:szCs w:val="24"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="SubtitleCarPHPDOCX"> <w:name w:val="Subtitle Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="SubtitlePHPDOCX"/> <w:uiPriority w:val="11"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:i/> <w:iCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> <w:spacing w:val="15"/> <w:sz w:val="24"/> <w:szCs w:val="24"/> </w:rPr> </w:style> <w:style w:type="character" w:styleId="SubtleEmphasisPHPDOCX"> <w:name w:val="Subtle Emphasis PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:uiPriority w:val="19"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:i/> <w:iCs/> <w:color w:val="808080" w:themeColor="text1" w:themeTint="7F"/> </w:rPr> </w:style> <w:style w:type="character" w:styleId="EmphasisPHPDOCX"> <w:name w:val="Emphasis PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:uiPriority w:val="20"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:i/> <w:iCs/> </w:rPr> </w:style> <w:style w:type="character" w:styleId="IntenseEmphasisPHPDOCX"> <w:name w:val="Intense Emphasis PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:uiPriority w:val="21"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:b/> <w:bCs/> <w:i/> <w:iCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> </w:rPr> </w:style> <w:style w:type="character" w:styleId="Strong PHPDOCX"> <w:name w:val="Strong PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:uiPriority w:val="22"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="QuotePHPDOCX"> <w:name w:val="Quote PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="QuoteCarPHPDOCX"/> <w:uiPriority w:val="29"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:i/> <w:iCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="QuoteCarPHPDOCX"> <w:name w:val="Quote Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="QuotePHPDOCX"/> <w:uiPriority w:val="29"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:i/> <w:iCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="IntenseQuotePHPDOCX"> <w:name w:val="Intense Quote PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:next w:val="Normal"/> <w:link w:val="IntenseQuoteCarPHPDOCX"/> <w:uiPriority w:val="30"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:pBdr> <w:bottom w:val="single" w:sz="4" w:space="4" w:color="4F81BD" w:themeColor="accent1"/> </w:pBdr> <w:spacing w:before="200" w:after="280"/> <w:ind w:left="936" w:right="936"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:i/> <w:iCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="IntenseQuoteCarPHPDOCX"> <w:name w:val="Intense Quote Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="IntenseQuotePHPDOCX"/> <w:uiPriority w:val="30"/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:b/> <w:bCs/> <w:i/> <w:iCs/> <w:color w:val="4F81BD" w:themeColor="accent1"/> </w:rPr> </w:style> <w:style w:type="character" w:styleId="SubtleReferencePHPDOCX"> <w:name w:val="Subtle Reference PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:uiPriority w:val="31"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:smallCaps/> <w:color w:val="C0504D" w:themeColor="accent2"/> <w:u w:val="single"/> </w:rPr> </w:style> <w:style w:type="character" w:styleId="IntenseReferencePHPDOCX"> <w:name w:val="Intense Reference PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:uiPriority w:val="32"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:b/> <w:bCs/> <w:smallCaps/> <w:color w:val="C0504D" w:themeColor="accent2"/> <w:spacing w:val="5"/> <w:u w:val="single"/> </w:rPr> </w:style> <w:style w:type="character" w:styleId="BookTitlePHPDOCX"> <w:name w:val="Book Title PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:uiPriority w:val="33"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:b/> <w:bCs/> <w:smallCaps/> <w:spacing w:val="5"/> </w:rPr> </w:style> <w:style w:type="paragraph" w:styleId="ListParagraphPHPDOCX"> <w:name w:val="List Paragraph PHPDOCX"/> <w:basedOn w:val="Normal"/> <w:uiPriority w:val="34"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:ind w:left="720"/> <w:contextualSpacing/> </w:pPr> </w:style> <w:style w:type="paragraph" w:styleId="NoSpacingPHPDOCX"> <w:name w:val="No Spacing PHPDOCX"/> <w:uiPriority w:val="1"/> <w:qFormat/> <w:rsid w:val="00DF064E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="Heading8CarPHPDOCX"> <w:name w:val="Heading 8 Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="Heading8PHPDOCX"/> <w:uiPriority w:val="9"/> <w:semiHidden/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="404040" w:themeColor="text1" w:themeTint="BF"/> <w:sz w:val="20"/> <w:szCs w:val="20"/> </w:rPr> </w:style> <w:style w:type="character" w:customStyle="1" w:styleId="Heading9CarPHPDOCX"> <w:name w:val="Heading 9 Car PHPDOCX"/> <w:basedOn w:val="DefaultParagraphFontPHPDOCX"/> <w:link w:val="Heading9PHPDOCX"/> <w:uiPriority w:val="9"/> <w:semiHidden/> <w:rsid w:val="00DF064E"/> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:i/> <w:iCs/> <w:color w:val="404040" w:themeColor="text1" w:themeTint="BF"/> <w:sz w:val="20"/> <w:szCs w:val="20"/> </w:rPr> </w:style> <w:style w:type="table" w:default="1" w:styleId="NormalTablePHPDOCX"> <w:name w:val="Normal Table PHPDOCX"/> <w:uiPriority w:val="99"/> <w:semiHidden/> <w:unhideWhenUsed/> <w:qFormat/> <w:tblPr> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> </w:style> <w:style w:type="table" w:styleId="PlainTablePHPDOCX"> <w:name w:val="Plain Table PHPDOCX"/> <w:uiPriority w:val="58"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> </w:style> <w:style w:type="table" w:styleId="TableGridPHPDOCX"> <w:name w:val="Table Grid PHPDOCX"/> <w:uiPriority w:val="59"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="4" w:space="0" w:color="auto"/> <w:left w:val="single" w:sz="4" w:space="0" w:color="auto"/> <w:bottom w:val="single" w:sz="4" w:space="0" w:color="auto"/> <w:right w:val="single" w:sz="4" w:space="0" w:color="auto"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="auto"/> <w:insideV w:val="single" w:sz="4" w:space="0" w:color="auto"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> </w:style> <w:style w:type="table" w:customStyle="1" w:styleId="LightShadingPHPDOCX"> <w:name w:val="Light Shading PHPDOCX"/> <w:uiPriority w:val="60"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1" w:themeShade="BF"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:customStyle="1" w:styleId="LightShadingAccent1PHPDOCX"> <w:name w:val="Light Shading Accent 1 PHPDOCX"/> <w:uiPriority w:val="60"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="365F91" w:themeColor="accent1" w:themeShade="BF"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightShadingAccent2PHPDOCX"> <w:name w:val="Light Shading Accent 2 PHPDOCX"/> <w:uiPriority w:val="60"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="943634" w:themeColor="accent2" w:themeShade="BF"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightShadingAccent3PHPDOCX"> <w:name w:val="Light Shading Accent 3 PHPDOCX"/> <w:uiPriority w:val="60"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="76923C" w:themeColor="accent3" w:themeShade="BF"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightShadingAccent4PHPDOCX"> <w:name w:val="Light Shading Accent 4 PHPDOCX"/> <w:uiPriority w:val="60"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="5F497A" w:themeColor="accent4" w:themeShade="BF"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightShadingAccent5PHPDOCX"> <w:name w:val="Light Shading Accent 5 PHPDOCX"/> <w:uiPriority w:val="60"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="31849B" w:themeColor="accent5" w:themeShade="BF"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:customStyle="1" w:styleId="LightListPHPDOCX"> <w:name w:val="Light List PHPDOCX"/> <w:uiPriority w:val="61"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:customStyle="1" w:styleId="LightListAccent1PHPDOCX"> <w:name w:val="Light List Accent 1 PHPDOCX"/> <w:uiPriority w:val="61"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="4F81BD" w:themeFill="accent1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightListAccent2PHPDOCX"> <w:name w:val="Light List Accent 2 PHPDOCX"/> <w:uiPriority w:val="61"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="C0504D" w:themeFill="accent2"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightListAccent3PHPDOCX"> <w:name w:val="Light List Accent 3 PHPDOCX"/> <w:uiPriority w:val="61"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="9BBB59" w:themeFill="accent3"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightListAccent4PHPDOCX"> <w:name w:val="Light List Accent 4 PHPDOCX"/> <w:uiPriority w:val="61"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="8064A2" w:themeFill="accent4"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightListAccent5PHPDOCX"> <w:name w:val="Light List Accent 5 PHPDOCX"/> <w:uiPriority w:val="61"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="4BACC6" w:themeFill="accent5"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightListAccent6PHPDOCX"> <w:name w:val="Light List Accent 6 PHPDOCX"/> <w:uiPriority w:val="61"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F79646" w:themeFill="accent6"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightGridPHPDOCX"> <w:name w:val="Light Grid PHPDOCX"/> <w:uiPriority w:val="62"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightGrid1PHPDOCX"> <w:name w:val="Light Grid 1 PHPDOCX"/> <w:uiPriority w:val="62"/> <w:rsid w:val="00493A0C"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightGrid2PHPDOCX"> <w:name w:val="Light Grid 2 PHPDOCX"/> <w:uiPriority w:val="62"/> <w:rsid w:val="00112029"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightGrid3PHPDOCX"> <w:name w:val="Light Grid 3 PHPDOCX"/> <w:uiPriority w:val="62"/> <w:rsid w:val="00112029"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightGrid4PHPDOCX"> <w:name w:val="Light Grid 4 PHPDOCX"/> <w:uiPriority w:val="62"/> <w:rsid w:val="00112029"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightGrid5PHPDOCX"> <w:name w:val="Light Grid 5 PHPDOCX"/> <w:uiPriority w:val="62"/> <w:rsid w:val="00112029"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="LightGrid6PHPDOCX"> <w:name w:val="Light Grid 6 PHPDOCX"/> <w:uiPriority w:val="62"/> <w:rsid w:val="00112029"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading1PHPDOCX"> <w:name w:val="Medium Shading 1 PHPDOCX"/> <w:uiPriority w:val="63"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading1-accent1PHPDOCX"> <w:name w:val="Medium Shading 1 Accent 1 PHPDOCX"/> <w:uiPriority w:val="63"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4F81BD" w:themeFill="accent1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading1-accent2PHPDOCX"> <w:name w:val="Medium Shading 1 Accent 2 PHPDOCX"/> <w:uiPriority w:val="63"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0504D" w:themeFill="accent2"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading1-accent3PHPDOCX"> <w:name w:val="Medium Shading 1 Accent 3 PHPDOCX"/> <w:uiPriority w:val="63"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9BBB59" w:themeFill="accent3"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading1-accent4PHPDOCX"> <w:name w:val="Medium Shading 1 Accent 4 PHPDOCX"/> <w:uiPriority w:val="63"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="8064A2" w:themeFill="accent4"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading1-accent5PHPDOCX"> <w:name w:val="Medium Shading 1 Accent 5 PHPDOCX"/> <w:uiPriority w:val="63"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4BACC6" w:themeFill="accent5"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading1-accent6PHPDOCX"> <w:name w:val="Medium Shading 1 Accent 6 PHPDOCX"/> <w:uiPriority w:val="63"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="F79646" w:themeFill="accent6"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band2Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading2PHPDOCX"> <w:name w:val="Medium Shading 2 PHPDOCX"/> <w:uiPriority w:val="64"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="auto"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading2-accent1PHPDOCX"> <w:name w:val="Medium Shading 2 Accent 1 PHPDOCX"/> <w:uiPriority w:val="64"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4F81BD" w:themeFill="accent1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="auto"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4F81BD" w:themeFill="accent1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4F81BD" w:themeFill="accent1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading2-accent2PHPDOCX"> <w:name w:val="Medium Shading 2 Accent 2 PHPDOCX"/> <w:uiPriority w:val="64"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0504D" w:themeFill="accent2"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="auto"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0504D" w:themeFill="accent2"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0504D" w:themeFill="accent2"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading2-accent3PHPDOCX"> <w:name w:val="Medium Shading 2 Accent 3 PHPDOCX"/> <w:uiPriority w:val="64"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9BBB59" w:themeFill="accent3"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="auto"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9BBB59" w:themeFill="accent3"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9BBB59" w:themeFill="accent3"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading2-accent4PHPDOCX"> <w:name w:val="Medium Shading 2 Accent 4 PHPDOCX"/> <w:uiPriority w:val="64"/> <w:rsid w:val="00535F5A"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="8064A2" w:themeFill="accent4"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="auto"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="8064A2" w:themeFill="accent4"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="8064A2" w:themeFill="accent4"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading2-accent5PHPDOCX"> <w:name w:val="Medium Shading 2 Accent 5 PHPDOCX"/> <w:uiPriority w:val="64"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4BACC6" w:themeFill="accent5"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="auto"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4BACC6" w:themeFill="accent5"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4BACC6" w:themeFill="accent5"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumShading2-accent6PHPDOCX"> <w:name w:val="Medium Shading 2 Accent 6 PHPDOCX"/> <w:uiPriority w:val="64"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="F79646" w:themeFill="accent6"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:pPr> <w:spacing w:before="0" w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="auto"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="double" w:sz="6" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="F79646" w:themeFill="accent6"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="F79646" w:themeFill="accent6"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D8D8D8" w:themeFill="background1" w:themeFillShade="D8"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="auto"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList1PHPDOCX"> <w:name w:val="Medium List 1 PHPDOCX"/> <w:uiPriority w:val="65"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="1F497D" w:themeColor="text2"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList1-accent1PHPDOCX"> <w:name w:val="Medium List 1 Accent 1 PHPDOCX"/> <w:uiPriority w:val="65"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="1F497D" w:themeColor="text2"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList1-accent2PHPDOCX"> <w:name w:val="Medium List 1 Accent 2 PHPDOCX"/> <w:uiPriority w:val="65"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="1F497D" w:themeColor="text2"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList1-accent3PHPDOCX"> <w:name w:val="Medium List 1 Accent 3 PHPDOCX"/> <w:uiPriority w:val="65"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="1F497D" w:themeColor="text2"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList1-accent4PHPDOCX"> <w:name w:val="Medium List 1 Accent 4 PHPDOCX"/> <w:uiPriority w:val="65"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="1F497D" w:themeColor="text2"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList1-accent5PHPDOCX"> <w:name w:val="Medium List 1 Accent 5 PHPDOCX"/> <w:uiPriority w:val="65"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="1F497D" w:themeColor="text2"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList1-accent6PHPDOCX"> <w:name w:val="Medium List 1 Accent 6 PHPDOCX"/> <w:uiPriority w:val="65"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="1F497D" w:themeColor="text2"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList2PHPDOCX"> <w:name w:val="Medium List 2 PHPDOCX"/> <w:uiPriority w:val="66"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:sz w:val="24"/> <w:szCs w:val="24"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="swCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList2-accent1PHPDOCX"> <w:name w:val="Medium List 2 Accent 1 PHPDOCX"/> <w:uiPriority w:val="66"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:sz w:val="24"/> <w:szCs w:val="24"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="swCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList2-accent2PHPDOCX"> <w:name w:val="Medium List 2 Accent 2 PHPDOCX"/> <w:uiPriority w:val="66"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:sz w:val="24"/> <w:szCs w:val="24"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="swCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList2-accent3PHPDOCX"> <w:name w:val="Medium List 2 Accent 3 PHPDOCX"/> <w:uiPriority w:val="66"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:sz w:val="24"/> <w:szCs w:val="24"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="swCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList2-accent4PHPDOCX"> <w:name w:val="Medium List 2 Accent 4 PHPDOCX"/> <w:uiPriority w:val="66"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:sz w:val="24"/> <w:szCs w:val="24"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="swCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList2-accent5PHPDOCX"> <w:name w:val="Medium List 2 Accent 5 PHPDOCX"/> <w:uiPriority w:val="66"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:sz w:val="24"/> <w:szCs w:val="24"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="swCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumList2-accent6PHPDOCX"> <w:name w:val="Medium List 2 Accent 6 PHPDOCX"/> <w:uiPriority w:val="66"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:sz w:val="24"/> <w:szCs w:val="24"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:bottom w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="swCell"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid1PHPDOCX"> <w:name w:val="Medium Grid 1 PHPDOCX"/> <w:uiPriority w:val="67"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="404040" w:themeColor="text1" w:themeTint="BF"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="808080" w:themeFill="text1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="808080" w:themeFill="text1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid1-accent1PHPDOCX"> <w:name w:val="Medium Grid 1 Accent 1 PHPDOCX"/> <w:uiPriority w:val="67"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="7BA0CD" w:themeColor="accent1" w:themeTint="BF"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A7BFDE" w:themeFill="accent1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A7BFDE" w:themeFill="accent1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid1-accent2PHPDOCX"> <w:name w:val="Medium Grid 1 Accent 2 PHPDOCX"/> <w:uiPriority w:val="67"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="CF7B79" w:themeColor="accent2" w:themeTint="BF"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFA7A6" w:themeFill="accent2" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFA7A6" w:themeFill="accent2" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid1-accent3PHPDOCX"> <w:name w:val="Medium Grid 1 Accent 3 PHPDOCX"/> <w:uiPriority w:val="67"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="B3CC82" w:themeColor="accent3" w:themeTint="BF"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CDDDAC" w:themeFill="accent3" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CDDDAC" w:themeFill="accent3" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid1-accent4PHPDOCX"> <w:name w:val="Medium Grid 1 Accent 4 PHPDOCX"/> <w:uiPriority w:val="67"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="9F8AB9" w:themeColor="accent4" w:themeTint="BF"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="BFB1D0" w:themeFill="accent4" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="BFB1D0" w:themeFill="accent4" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid1-accent5PHPDOCX"> <w:name w:val="Medium Grid 1 Accent 5 PHPDOCX"/> <w:uiPriority w:val="67"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="78C0D4" w:themeColor="accent5" w:themeTint="BF"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A5D5E2" w:themeFill="accent5" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A5D5E2" w:themeFill="accent5" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid1-accent6PHPDOCX"> <w:name w:val="Medium Grid 1 Accent 6 PHPDOCX"/> <w:uiPriority w:val="67"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="F9B074" w:themeColor="accent6" w:themeTint="BF"/> </w:tcBorders> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FBCAA2" w:themeFill="accent6" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FBCAA2" w:themeFill="accent6" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid2PHPDOCX"> <w:name w:val="Medium Grid 2 PHPDOCX"/> <w:uiPriority w:val="68"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E6E6E6" w:themeFill="text1" w:themeFillTint="19"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b w:val="0"/> <w:bCs w:val="0"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="CCCCCC" w:themeFill="text1" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="808080" w:themeFill="text1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="808080" w:themeFill="text1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid2-accent1PHPDOCX"> <w:name w:val="Medium Grid 2 Accent 1 PHPDOCX"/> <w:uiPriority w:val="68"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EDF2F8" w:themeFill="accent1" w:themeFillTint="19"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b w:val="0"/> <w:bCs w:val="0"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DBE5F1" w:themeFill="accent1" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A7BFDE" w:themeFill="accent1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="A7BFDE" w:themeFill="accent1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid2-accent2PHPDOCX"> <w:name w:val="Medium Grid 2 Accent 2 PHPDOCX"/> <w:uiPriority w:val="68"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F8EDED" w:themeFill="accent2" w:themeFillTint="19"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b w:val="0"/> <w:bCs w:val="0"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="F2DBDB" w:themeFill="accent2" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFA7A6" w:themeFill="accent2" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="C0504D" w:themeColor="accent2"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFA7A6" w:themeFill="accent2" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid2-accent3PHPDOCX"> <w:name w:val="Medium Grid 2 Accent 3 PHPDOCX"/> <w:uiPriority w:val="68"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F5F8EE" w:themeFill="accent3" w:themeFillTint="19"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b w:val="0"/> <w:bCs w:val="0"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="EAF1DD" w:themeFill="accent3" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CDDDAC" w:themeFill="accent3" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="CDDDAC" w:themeFill="accent3" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid2-accent4PHPDOCX"> <w:name w:val="Medium Grid 2 Accent 4 PHPDOCX"/> <w:uiPriority w:val="68"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F2EFF6" w:themeFill="accent4" w:themeFillTint="19"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b w:val="0"/> <w:bCs w:val="0"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E5DFEC" w:themeFill="accent4" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="BFB1D0" w:themeFill="accent4" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="8064A2" w:themeColor="accent4"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="BFB1D0" w:themeFill="accent4" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid2-accent5PHPDOCX"> <w:name w:val="Medium Grid 2 Accent 5 PHPDOCX"/> <w:uiPriority w:val="68"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EDF6F9" w:themeFill="accent5" w:themeFillTint="19"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b w:val="0"/> <w:bCs w:val="0"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DAEEF3" w:themeFill="accent5" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A5D5E2" w:themeFill="accent5" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="A5D5E2" w:themeFill="accent5" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid2-accent6PHPDOCX"> <w:name w:val="Medium Grid 2 Accent 6 PHPDOCX"/> <w:uiPriority w:val="68"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:rFonts w:asciiTheme="majorHAnsi" w:eastAsiaTheme="majorEastAsia" w:hAnsiTheme="majorHAnsi" w:cstheme="majorBidi"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FEF4EC" w:themeFill="accent6" w:themeFillTint="19"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b w:val="0"/> <w:bCs w:val="0"/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FDE9D9" w:themeFill="accent6" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FBCAA2" w:themeFill="accent6" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="F79646" w:themeColor="accent6"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FBCAA2" w:themeFill="accent6" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid3PHPDOCX"> <w:name w:val="Medium Grid 3 PHPDOCX"/> <w:uiPriority w:val="69"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="808080" w:themeFill="text1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="808080" w:themeFill="text1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid3-accent1PHPDOCX"> <w:name w:val="Medium Grid 3 Accent 1 PHPDOCX"/> <w:uiPriority w:val="69"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4F81BD" w:themeFill="accent1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4F81BD" w:themeFill="accent1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4F81BD" w:themeFill="accent1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4F81BD" w:themeFill="accent1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="A7BFDE" w:themeFill="accent1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="A7BFDE" w:themeFill="accent1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid3-accent2PHPDOCX"> <w:name w:val="Medium Grid 3 Accent 2 PHPDOCX"/> <w:uiPriority w:val="69"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0504D" w:themeFill="accent2"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0504D" w:themeFill="accent2"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0504D" w:themeFill="accent2"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0504D" w:themeFill="accent2"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFA7A6" w:themeFill="accent2" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFA7A6" w:themeFill="accent2" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid3-accent3PHPDOCX"> <w:name w:val="Medium Grid 3 Accent 3 PHPDOCX"/> <w:uiPriority w:val="69"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9BBB59" w:themeFill="accent3"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9BBB59" w:themeFill="accent3"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9BBB59" w:themeFill="accent3"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9BBB59" w:themeFill="accent3"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="CDDDAC" w:themeFill="accent3" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="CDDDAC" w:themeFill="accent3" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid3-accent5PHPDOCX"> <w:name w:val="Medium Grid 3 Accent 5 PHPDOCX"/> <w:uiPriority w:val="69"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4BACC6" w:themeFill="accent5"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4BACC6" w:themeFill="accent5"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4BACC6" w:themeFill="accent5"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4BACC6" w:themeFill="accent5"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="A5D5E2" w:themeFill="accent5" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="A5D5E2" w:themeFill="accent5" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid3-accent4PHPDOCX"> <w:name w:val="Medium Grid 3 Accent 4 PHPDOCX"/> <w:uiPriority w:val="69"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="8064A2" w:themeFill="accent4"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="8064A2" w:themeFill="accent4"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="8064A2" w:themeFill="accent4"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="8064A2" w:themeFill="accent4"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="BFB1D0" w:themeFill="accent4" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="BFB1D0" w:themeFill="accent4" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="MediumGrid3-accent6PHPDOCX"> <w:name w:val="Medium Grid 3 Accent 6 PHPDOCX"/> <w:uiPriority w:val="69"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="F79646" w:themeFill="accent6"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="F79646" w:themeFill="accent6"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="F79646" w:themeFill="accent6"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> <w:i w:val="0"/> <w:iCs w:val="0"/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="24" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="F79646" w:themeFill="accent6"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FBCAA2" w:themeFill="accent6" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="8" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FBCAA2" w:themeFill="accent6" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="DarkListPHPDOCX"> <w:name w:val="Dark List PHPDOCX"/> <w:uiPriority w:val="70"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1" w:themeFillShade="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="DarkList-accent1PHPDOCX"> <w:name w:val="Dark List Accent 1 PHPDOCX"/> <w:uiPriority w:val="70"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="4F81BD" w:themeFill="accent1"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="243F60" w:themeFill="accent1" w:themeFillShade="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="365F91" w:themeFill="accent1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="365F91" w:themeFill="accent1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="365F91" w:themeFill="accent1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="365F91" w:themeFill="accent1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="DarkList-accent2PHPDOCX"> <w:name w:val="Dark List Accent 2 PHPDOCX"/> <w:uiPriority w:val="70"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="C0504D" w:themeFill="accent2"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="622423" w:themeFill="accent2" w:themeFillShade="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="943634" w:themeFill="accent2" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="943634" w:themeFill="accent2" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="943634" w:themeFill="accent2" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="943634" w:themeFill="accent2" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="DarkList-accent3PHPDOCX"> <w:name w:val="Dark List Accent 3 PHPDOCX"/> <w:uiPriority w:val="70"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="9BBB59" w:themeFill="accent3"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4E6128" w:themeFill="accent3" w:themeFillShade="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="76923C" w:themeFill="accent3" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="76923C" w:themeFill="accent3" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="76923C" w:themeFill="accent3" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="76923C" w:themeFill="accent3" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="DarkList-accent4PHPDOCX"> <w:name w:val="Dark List Accent 4 PHPDOCX"/> <w:uiPriority w:val="70"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="8064A2" w:themeFill="accent4"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="3F3151" w:themeFill="accent4" w:themeFillShade="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="5F497A" w:themeFill="accent4" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="5F497A" w:themeFill="accent4" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="5F497A" w:themeFill="accent4" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="5F497A" w:themeFill="accent4" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="DarkList-accent5PHPDOCX"> <w:name w:val="Dark List Accent 5 PHPDOCX"/> <w:uiPriority w:val="70"/> <w:rsid w:val="00361FF4"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="4BACC6" w:themeFill="accent5"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="205867" w:themeFill="accent5" w:themeFillShade="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="31849B" w:themeFill="accent5" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="31849B" w:themeFill="accent5" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="31849B" w:themeFill="accent5" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="31849B" w:themeFill="accent5" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="DarkList-accent6PHPDOCX"> <w:name w:val="Dark List Accent 6 PHPDOCX"/> <w:uiPriority w:val="70"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F79646" w:themeFill="accent6"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="974706" w:themeFill="accent6" w:themeFillShade="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E36C0A" w:themeFill="accent6" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="single" w:sz="18" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E36C0A" w:themeFill="accent6" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E36C0A" w:themeFill="accent6" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E36C0A" w:themeFill="accent6" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulShadingPHPDOCX"> <w:name w:val="Colorful Shading PHPDOCX"/> <w:uiPriority w:val="71"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="4" w:space="0" w:color="000000" w:themeColor="text1"/> <w:bottom w:val="single" w:sz="4" w:space="0" w:color="000000" w:themeColor="text1"/> <w:right w:val="single" w:sz="4" w:space="0" w:color="000000" w:themeColor="text1"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E6E6E6" w:themeFill="text1" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="000000" w:themeColor="text1" w:themeShade="99"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="999999" w:themeFill="text1" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="808080" w:themeFill="text1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulShading-accent1PHPDOCX"> <w:name w:val="Colorful Shading Accent 1 PHPDOCX"/> <w:uiPriority w:val="71"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="4" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:bottom w:val="single" w:sz="4" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:right w:val="single" w:sz="4" w:space="0" w:color="4F81BD" w:themeColor="accent1"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EDF2F8" w:themeFill="accent1" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="2C4C74" w:themeFill="accent1" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="2C4C74" w:themeColor="accent1" w:themeShade="99"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="2C4C74" w:themeFill="accent1" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="2C4C74" w:themeFill="accent1" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="B8CCE4" w:themeFill="accent1" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A7BFDE" w:themeFill="accent1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulShading-accent2PHPDOCX"> <w:name w:val="Colorful Shading Accent 2 PHPDOCX"/> <w:uiPriority w:val="71"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:left w:val="single" w:sz="4" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:bottom w:val="single" w:sz="4" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="single" w:sz="4" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F8EDED" w:themeFill="accent2" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="C0504D" w:themeColor="accent2"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="772C2A" w:themeFill="accent2" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="772C2A" w:themeColor="accent2" w:themeShade="99"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="772C2A" w:themeFill="accent2" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="772C2A" w:themeFill="accent2" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E5B8B7" w:themeFill="accent2" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFA7A6" w:themeFill="accent2" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulShading-accent3PHPDOCX"> <w:name w:val="Colorful Shading Accent 3 PHPDOCX"/> <w:uiPriority w:val="71"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:left w:val="single" w:sz="4" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:bottom w:val="single" w:sz="4" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="single" w:sz="4" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F5F8EE" w:themeFill="accent3" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="5E7530" w:themeFill="accent3" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="5E7530" w:themeColor="accent3" w:themeShade="99"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="5E7530" w:themeFill="accent3" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="5E7530" w:themeFill="accent3" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D6E3BC" w:themeFill="accent3" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CDDDAC" w:themeFill="accent3" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulShading-accent4PHPDOCX"> <w:name w:val="Colorful Shading Accent 4 PHPDOCX"/> <w:uiPriority w:val="71"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:left w:val="single" w:sz="4" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:bottom w:val="single" w:sz="4" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:right w:val="single" w:sz="4" w:space="0" w:color="8064A2" w:themeColor="accent4"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F2EFF6" w:themeFill="accent4" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="9BBB59" w:themeColor="accent3"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4C3B62" w:themeFill="accent4" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="4C3B62" w:themeColor="accent4" w:themeShade="99"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4C3B62" w:themeFill="accent4" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="4C3B62" w:themeFill="accent4" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CCC0D9" w:themeFill="accent4" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="BFB1D0" w:themeFill="accent4" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulShading-accent5PHPDOCX"> <w:name w:val="Colorful Shading Accent 5 PHPDOCX"/> <w:uiPriority w:val="71"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:left w:val="single" w:sz="4" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:bottom w:val="single" w:sz="4" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="single" w:sz="4" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EDF6F9" w:themeFill="accent5" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="276A7C" w:themeFill="accent5" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="276A7C" w:themeColor="accent5" w:themeShade="99"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="276A7C" w:themeFill="accent5" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="276A7C" w:themeFill="accent5" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="B6DDE8" w:themeFill="accent5" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A5D5E2" w:themeFill="accent5" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulShading-accent6PHPDOCX"> <w:name w:val="Colorful Shading Accent 6 PHPDOCX"/> <w:uiPriority w:val="71"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:top w:val="single" w:sz="24" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:left w:val="single" w:sz="4" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:bottom w:val="single" w:sz="4" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:right w:val="single" w:sz="4" w:space="0" w:color="F79646" w:themeColor="accent6"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> <w:insideV w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FEF4EC" w:themeFill="accent6" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="single" w:sz="24" w:space="0" w:color="4BACC6" w:themeColor="accent5"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="6" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="B65608" w:themeFill="accent6" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="B65608" w:themeColor="accent6" w:themeShade="99"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="B65608" w:themeFill="accent6" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="B65608" w:themeFill="accent6" w:themeFillShade="99"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FBD4B4" w:themeFill="accent6" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FBCAA2" w:themeFill="accent6" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="neCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="nwCell"> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulListPHPDOCX"> <w:name w:val="Colorful List PHPDOCX"/> <w:uiPriority w:val="72"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E6E6E6" w:themeFill="text1" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:bottom w:val="single" w:sz="12" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9E3A38" w:themeFill="accent2" w:themeFillShade="CC"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="9E3A38" w:themeColor="accent2" w:themeShade="CC"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="C0C0C0" w:themeFill="text1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CCCCCC" w:themeFill="text1" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulList-accent1PHPDOCX"> <w:name w:val="Colorful List Accent 1 PHPDOCX"/> <w:uiPriority w:val="72"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EDF2F8" w:themeFill="accent1" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:bottom w:val="single" w:sz="12" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9E3A38" w:themeFill="accent2" w:themeFillShade="CC"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="9E3A38" w:themeColor="accent2" w:themeShade="CC"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D3DFEE" w:themeFill="accent1" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DBE5F1" w:themeFill="accent1" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulList-accent2PHPDOCX"> <w:name w:val="Colorful List Accent 2 PHPDOCX"/> <w:uiPriority w:val="72"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F8EDED" w:themeFill="accent2" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:bottom w:val="single" w:sz="12" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="9E3A38" w:themeFill="accent2" w:themeFillShade="CC"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="9E3A38" w:themeColor="accent2" w:themeShade="CC"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="EFD3D2" w:themeFill="accent2" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F2DBDB" w:themeFill="accent2" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulList-accent3PHPDOCX"> <w:name w:val="Colorful List Accent 3 PHPDOCX"/> <w:uiPriority w:val="72"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F5F8EE" w:themeFill="accent3" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:bottom w:val="single" w:sz="12" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="664E82" w:themeFill="accent4" w:themeFillShade="CC"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="664E82" w:themeColor="accent4" w:themeShade="CC"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="E6EED5" w:themeFill="accent3" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EAF1DD" w:themeFill="accent3" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulList-accent4PHPDOCX"> <w:name w:val="Colorful List Accent 4 PHPDOCX"/> <w:uiPriority w:val="72"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F2EFF6" w:themeFill="accent4" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:bottom w:val="single" w:sz="12" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="7E9C40" w:themeFill="accent3" w:themeFillShade="CC"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="7E9C40" w:themeColor="accent3" w:themeShade="CC"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="DFD8E8" w:themeFill="accent4" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E5DFEC" w:themeFill="accent4" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulList-accent5PHPDOCX"> <w:name w:val="Colorful List Accent 5 PHPDOCX"/> <w:uiPriority w:val="72"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EDF6F9" w:themeFill="accent5" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:bottom w:val="single" w:sz="12" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="F2730A" w:themeFill="accent6" w:themeFillShade="CC"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="F2730A" w:themeColor="accent6" w:themeShade="CC"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="D2EAF1" w:themeFill="accent5" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DAEEF3" w:themeFill="accent5" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulList-accent6PHPDOCX"> <w:name w:val="Colorful List Accent 6 PHPDOCX"/> <w:uiPriority w:val="72"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FEF4EC" w:themeFill="accent6" w:themeFillTint="19"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:bottom w:val="single" w:sz="12" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="348DA5" w:themeFill="accent5" w:themeFillShade="CC"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="348DA5" w:themeColor="accent5" w:themeShade="CC"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="single" w:sz="12" w:space="0" w:color="000000" w:themeColor="text1"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FFFFFF" w:themeFill="background1"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:tcBorders> <w:top w:val="nil"/> <w:left w:val="nil"/> <w:bottom w:val="nil"/> <w:right w:val="nil"/> <w:insideH w:val="nil"/> <w:insideV w:val="nil"/> </w:tcBorders> <w:shd w:val="clear" w:color="auto" w:fill="FDE4D0" w:themeFill="accent6" w:themeFillTint="3F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FDE9D9" w:themeFill="accent6" w:themeFillTint="33"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulGridPHPDOCX"> <w:name w:val="Colorful Grid PHPDOCX"/> <w:uiPriority w:val="73"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CCCCCC" w:themeFill="text1" w:themeFillTint="33"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="999999" w:themeFill="text1" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="999999" w:themeFill="text1" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="000000" w:themeFill="text1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="808080" w:themeFill="text1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="808080" w:themeFill="text1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulGrid-accent1PHPDOCX"> <w:name w:val="Colorful Grid Accent 1 PHPDOCX"/> <w:uiPriority w:val="73"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DBE5F1" w:themeFill="accent1" w:themeFillTint="33"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="B8CCE4" w:themeFill="accent1" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="B8CCE4" w:themeFill="accent1" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="365F91" w:themeFill="accent1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="365F91" w:themeFill="accent1" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A7BFDE" w:themeFill="accent1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A7BFDE" w:themeFill="accent1" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulGrid-accent2PHPDOCX"> <w:name w:val="Colorful Grid Accent 2 PHPDOCX"/> <w:uiPriority w:val="73"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="F2DBDB" w:themeFill="accent2" w:themeFillTint="33"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E5B8B7" w:themeFill="accent2" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E5B8B7" w:themeFill="accent2" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="943634" w:themeFill="accent2" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="943634" w:themeFill="accent2" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFA7A6" w:themeFill="accent2" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DFA7A6" w:themeFill="accent2" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulGrid-accent3PHPDOCX"> <w:name w:val="Colorful Grid Accent 3 PHPDOCX"/> <w:uiPriority w:val="73"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="EAF1DD" w:themeFill="accent3" w:themeFillTint="33"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D6E3BC" w:themeFill="accent3" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="D6E3BC" w:themeFill="accent3" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="76923C" w:themeFill="accent3" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="76923C" w:themeFill="accent3" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CDDDAC" w:themeFill="accent3" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CDDDAC" w:themeFill="accent3" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulGrid-accent4PHPDOCX"> <w:name w:val="Colorful Grid Accent 4 PHPDOCX"/> <w:uiPriority w:val="73"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E5DFEC" w:themeFill="accent4" w:themeFillTint="33"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CCC0D9" w:themeFill="accent4" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="CCC0D9" w:themeFill="accent4" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="5F497A" w:themeFill="accent4" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="5F497A" w:themeFill="accent4" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="BFB1D0" w:themeFill="accent4" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="BFB1D0" w:themeFill="accent4" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulGrid-accent5PHPDOCX"> <w:name w:val="Colorful Grid Accent 5 PHPDOCX"/> <w:uiPriority w:val="73"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="DAEEF3" w:themeFill="accent5" w:themeFillTint="33"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="B6DDE8" w:themeFill="accent5" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="B6DDE8" w:themeFill="accent5" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="31849B" w:themeFill="accent5" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="31849B" w:themeFill="accent5" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A5D5E2" w:themeFill="accent5" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="A5D5E2" w:themeFill="accent5" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style> <w:style w:type="table" w:styleId="ColorfulGrid-accent6PHPDOCX"> <w:name w:val="Colorful Grid Accent 6 PHPDOCX"/> <w:uiPriority w:val="73"/> <w:rsid w:val="00AC197E"/> <w:pPr> <w:spacing w:after="0" w:line="240" w:lineRule="auto"/> </w:pPr> <w:rPr> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr> <w:tblStyleRowBandSize w:val="1"/> <w:tblStyleColBandSize w:val="1"/> <w:tblInd w:w="0" w:type="dxa"/> <w:tblBorders> <w:insideH w:val="single" w:sz="4" w:space="0" w:color="FFFFFF" w:themeColor="background1"/> </w:tblBorders> <w:tblCellMar> <w:top w:w="0" w:type="dxa"/> <w:left w:w="108" w:type="dxa"/> <w:bottom w:w="0" w:type="dxa"/> <w:right w:w="108" w:type="dxa"/> </w:tblCellMar> </w:tblPr> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FDE9D9" w:themeFill="accent6" w:themeFillTint="33"/> </w:tcPr> <w:tblStylePr w:type="firstRow"> <w:rPr> <w:b/> <w:bCs/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FBD4B4" w:themeFill="accent6" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastRow"> <w:rPr> <w:b/> <w:bCs/> <w:color w:val="000000" w:themeColor="text1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FBD4B4" w:themeFill="accent6" w:themeFillTint="66"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="firstCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E36C0A" w:themeFill="accent6" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="lastCol"> <w:rPr> <w:color w:val="FFFFFF" w:themeColor="background1"/> </w:rPr> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="E36C0A" w:themeFill="accent6" w:themeFillShade="BF"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Vert"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FBCAA2" w:themeFill="accent6" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> <w:tblStylePr w:type="band1Horz"> <w:tblPr/> <w:tcPr> <w:shd w:val="clear" w:color="auto" w:fill="FBCAA2" w:themeFill="accent6" w:themeFillTint="7F"/> </w:tcPr> </w:tblStylePr> </w:style></w:styles>'
        );
        $zipDocx->addContent('word/webSettings.xml',
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?><w:webSettings xmlns:r="http://schemas.openxmlformats.org/officeDocument/2006/relationships" xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"><w:optimizeForBrowser/></w:webSettings>'
        );

        return $zipDocx;
    }
    
}