<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Redirects_Helper{
    protected $EE='';
    protected $helper = '';
    protected $output_helper = '';
    
    function __construct(){
       $this->EE =& get_instance();
       
       $this->EE->load->helper("data");
       $this->helper = new Data_Helper();
       
       $this->EE->load->helper("output");
       $this->output_helper = new Output_Helper();
    }
    
    public function check_accounts(){
        $this->EE->load->model("accounts");
        
        $params = array();
        $params['selects'] = "{#m}.id,{#c}.sef_url_c";
                
        $accounts = $this->EE->accounts->get_main_data($params);
        $base_url = $this->EE->config->item("site_url");
        foreach($accounts as $item){
            $item_id = $item['id'];
            $sef_url = $item['sef_url_c'];
            
            /// redirects for something like this /dentists/primary-dental-brookvale-a12011025 ///
            $regexp = "/http:\/\/www.dentist.com.au\/dentists\/(.*?)-a(\d{8})/i";
            preg_match_all($regexp, $sef_url, $matches);

            if(isset($matches[1][0]) && isset($matches[2][0])){
                $name = $matches[1][0];
                $id = "a" . $matches[2][0];  
                $update_url = $base_url . "dentist-detail/{$name}/{$id}";
                
                $query = $this->EE->crmdb->update_string("accounts_cstm", array('sef_url_c' => $update_url), "id_c='{$item_id}'");
                $result = $this->EE->crmdb->query($query);;
            }
            //////////////////////////////////////////////////////////////////////////////////////
        }
    }
    public function check_contacts(){
        $this->EE->load->model("contacts");
        
        $params = array();
        $params['selects'] = "{#m}.id,{#c}.sef_url_c";
                
        $contacts = $this->EE->contacts->get_main_data($params);
        $base_url = $this->EE->config->item("site_url");
        foreach($contacts as $item){
            $item_id = $item['id'];
            $sef_url = $item['sef_url_c'];
            
            /// redirects for something like this /dentists/primary-dental-brookvale-a12011025 ///
            $regexp = "/http:\/\/www.dentist.com.au\/dentists\/(.*?)-c(\d{8})/i";
            preg_match_all($regexp, $sef_url, $matches);

            if(isset($matches[1][0]) && isset($matches[2][0])){
                $name = $matches[1][0];
                $id = "c" . $matches[2][0];  
                $update_url = $base_url . "general-dentist/{$name}/{$id}";
                
                $query = $this->EE->crmdb->update_string("contacts_cstm", array('sef_url_c' => $update_url), "id_c='{$item_id}'");
                $result = $this->EE->crmdb->query($query);;
            }
            //////////////////////////////////////////////////////////////////////////////////////
        }
    }
    
    public function check_redirects(){
        $uri = $this->EE->uri->uri_string;
        
        /// redirects for something like this /dentists/nsw-sydney.html ///
        $regexp = "/dentists\/(\w+)-(.*?).html/i";
        preg_match_all($regexp, $uri, $matches);

        if(isset($matches[1][0]) && isset($matches[2][0])){
            $state = $matches[1][0];
            $city = $matches[2][0];  
            $this->output_helper->sendRedirectHeaders("/dentist/{$state}/{$city}", true);  
        }
        ///////////////////////////////////////////////////////////////////
        
        /// redirects for something like this /dentists/primary-dental-brookvale-a12011025 ///
        $regexp = "/dentists\/(.*?)-a(\d{8})/i";
        preg_match_all($regexp, $uri, $matches);

        if(isset($matches[1][0]) && isset($matches[2][0])){
            $name = $matches[1][0];
            $id = "a" . $matches[2][0];  
            $this->output_helper->sendRedirectHeaders("/dentist-detail/{$name}/{$id}", true);  
        }
        //////////////////////////////////////////////////////////////////////////////////////
        
        /// redirects for something like this /dentists/mr-nasser-shademan-c11017458 ///
        $regexp = "/dentists\/(.*?)-c(\d{8})/i";
        preg_match_all($regexp, $uri, $matches);

        if(isset($matches[1][0]) && isset($matches[2][0])){
            $name = $matches[1][0];
            $id = "c" . $matches[2][0];  
            $this->output_helper->sendRedirectHeaders("/general-dentist/{$name}/{$id}", true);  
        }
        ////////////////////////////////////////////////////////////////////////////////
        
        /// redirects for something like this /practice/capsite-dental-a11006938 ///
        $regexp = "/practice\/(.*?)-a(\d{8})/i";
        preg_match_all($regexp, $uri, $matches);

        if(isset($matches[1][0]) && isset($matches[2][0])){
            $name = $matches[1][0];
            $id = "a" . $matches[2][0];  
            $this->output_helper->sendRedirectHeaders("/dentist-detail/{$name}/{$id}", true);  
        }
        ////////////////////////////////////////////////////////////////////////////////
    }
}
