<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Seo_Helper{
    protected $EE='';
    protected $router = '';
    protected $actions = '';
    protected $helper = '';
    protected $output_helper = '';
    protected $blog_uri_segs = '';
    protected $system_uri_segs = '';
    
    const HOME = 1;
    const SPEAKER_PROFILE = 2;
    const SPEAKER_PROFILE_EMAIL = 3;
    const DETAILS = 4;
    const EVENT_DETAILS_EMAIL = 5;
    const ACCOUNT_VENUE_DETAIL = 6;
    const ACCOUNT_ORG_DETAIL = 7; 
    const ACCOUNT_EXHIBITOR_DETAIL = 8; 
    const ACCOUNT_DETAIL_EMAIL = 9;
    const ARTICLE_DETAIL = 10;
    const EVENT_REGISTRATION_RECEIPT = 11;
    const EVENT_ADD_NEW_OPTION = 12;
    const EXPRESS_EDIT_OPTION = 13;

    const BLOGS = 19;
    const SYSTEM = 20;

    const SITEMAP_EVENTS = 'SITEMAP_EVENTS';
    
    const PAGES_ORAL_B_PROMOTION = 50;
    
    function __construct(){
       $this->EE =& get_instance();
       
       $this->EE->load->helper("data");
       $this->helper = new Data_Helper();
       
       $this->EE->load->helper("output");
       $this->output_helper = new Output_Helper();
       
       $this->actions = array();
       $this->actions['dentevents'] = $this->helper->fetch_action_id("Mdentevents", "process");
       
       $this->blog_uri_segs = array('about-us', 'useful-links', 'contact-us', 'information-for-dentists', 'sitemap', 'advertise');
       $this->system_uri_segs = array('system/not_found_page','ajax/processing_module');
    }
    
    function get_seo_text($text){
        $text = str_replace(" ", "-", $text);
        $text = strtolower($text);
        $regexp = "#(;|\?|\.|\,|\/|\'|\"|{|}|<|>|http:\/\/|https:\/\/|\w+:/*[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3})#i";
        $text = preg_replace($regexp, "", $text);
        
        $text = preg_replace("/[^A-Za-z0-9\-]/", '-', $text);
        return $text;
    }
    
    function get_address($city, $state){
        $this->EE->load->model("postcodes");
        
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.shipping_address_city,{#m}.shipping_address_state,{#m}.name";
        $params['where'] = "
                             {#m}.country='AUSTRALIA' and {#m}.pcode_type IN('Delivery Area')
                             and {#m}.shipping_address_state='{$this->helper->escape($state)}' and REPLACE({#m}.shipping_address_city, ' ', '-')='{$this->helper->escape($city)}'
                           ";
        $params['single'] = true;
        $_postcode = $this->EE->postcodes->get_main_data($params);
        
        $city = $_postcode['shipping_address_city']; $city = strtolower($city); $city = ucwords($city);
        $state = $_postcode['shipping_address_state'];
        $postalcode = $_postcode['name'];
        $address = "{$city}, {$state}, {$postalcode}";
        
        return $address;
    }

    function get_seo_url($router, $params){
        $site_url = $this->EE->config->item("site_url");
        
        $url = '';
        $id = $params['id'];
        switch($router){
            case Seo_Helper::SPEAKER_PROFILE:
                $name = $this->get_seo_text($params['name']);
                $id = $this->get_seo_text($id);
                $url = $site_url . "speaker-profile/{$name}/{$id}";
                /*$url = $site_url . "?ACT=24&cmd=dentevents:speaker_profile:show&id={$id}";
                $event_id = $params['event'];
                if(!empty($event_id)){
                    $url = $url . "&event={$event_id}";
                }*/  
            break;
            case Seo_Helper::SPEAKER_PROFILE_EMAIL:
                $url = $site_url . "?ACT=24&cmd=dentevents:speaker_profile:email:show&id={$id}";
            break;
            case Seo_Helper::DETAILS:
                $country = $this->get_seo_text($params['country']);
                $name = $this->get_seo_text($params['name']);
                $id = $this->get_seo_text($id);
                $url = $site_url . "{$country}/{$name}/{$id}";
                //$url = $site_url . "?ACT=24&cmd=dentevents:details:show&id={$id}";
            break;
            case Seo_Helper::EVENT_DETAILS_EMAIL:
                $url = $site_url . "?ACT=24&cmd=dentevents:details:email:show&id={$id}";
            break;
            case Seo_Helper::EVENT_REGISTRATION_RECEIPT:
                $url = $site_url . "event-registration-receipt/{$id}";
            break;
            case Seo_Helper::ACCOUNT_ORG_DETAIL:
                $country = $this->get_seo_text($params['country']);
                $name = $this->get_seo_text($params['name']);
                $url = $site_url . "org/{$country}/{$name}/{$id}";
            break;
            case Seo_Helper::ACCOUNT_EXHIBITOR_DETAIL:
                $country = $this->get_seo_text($params['country']);
                $name = $this->get_seo_text($params['name']);
                $url = $site_url . "exhibitor/{$country}/{$name}/{$id}";
            break;
            case Seo_Helper::ACCOUNT_VENUE_DETAIL:
                $country = $this->get_seo_text($params['country']);
                $name = $this->get_seo_text($params['name']);
                $url = $site_url . "event-venue/{$country}/{$name}/{$id}";
            break;
            case Seo_Helper::ACCOUNT_DETAIL_EMAIL:
                $url = $site_url . "?ACT=24&cmd=dentevents:account:email:show&id={$id}";
            break;
            case Seo_Helper::EXPRESS_EDIT_OPTION:

                $url = $site_url . "express/{$id}/{$name}/{$id}";
            break;
            case Seo_Helper::ARTICLE_DETAIL:
                $_article = $params['article'];
                $id = $_article['id'];
                $name = $_article['document_name'];
                $name = $this->get_seo_text($name);
                $name = $this->EE->uri->_filter_uri($name);
                
                $type = $_article['article_type'];
                $site_url = "https://www.dentalcommunity.com.au/";
                
                if($type == 'News'){
                    $url = $site_url . "news/{$name}/{$id}";
                }else{
                    $url = $site_url . "articles/{$name}/{$id}";
                }
            break;
        }
        
        return $url;
    }
   
    function trigger_router(){
        switch($this->router){
            case Seo_Helper::SYSTEM:
            break;
            case Seo_Helper::HOME:
                $this->trigger_router_HOME();
            break;
            case Seo_Helper::DETAILS:
                $this->trigger_router_DETAILS();
            break;
            case Seo_Helper::ACCOUNT_VENUE_DETAIL:
                $this->trigger_router_ACCOUNT_VENUE_DETAIL();
            break;
            case Seo_Helper::ACCOUNT_ORG_DETAIL:
                $this->trigger_router_ACCOUNT_ORG_DETAIL();
            break;
            case Seo_Helper::ACCOUNT_EXHIBITOR_DETAIL:
                $this->trigger_router_ACCOUNT_EXHIBITOR_DETAIL();
            break;
            case Seo_Helper::SPEAKER_PROFILE:
                $this->trigger_router_SPEAKER_PROFILE();
            break;
            case Seo_Helper::EVENT_REGISTRATION_RECEIPT:
                $this->trigger_router_EVENT_REGISTRATION_RECEIPT();
            break;
            case Seo_Helper::BLOGS:
                $this->trigger_router_BLOGS();
            break;
            case Seo_Helper::EVENT_ADD_NEW_OPTION:
                $this->trigger_router_EVENT_ADD_NEW_OPTION();
            break;
            case Seo_Helper::EXPRESS_EDIT_OPTION:
                $this->trigger_router_EXPRESS_EDIT_OPTION();
            break;
            default:
                $this->trigger_router_NOTFOUND();
            break;
        }
    } 
    function matches() {
        if(isset($_GET['URL']) || isset($_GET['url'])) {
            return '';
        }

        if(isset($_SERVER['QUERY_STRING']) && !isset($_GET['test'])) {
            $queryString = $_SERVER['QUERY_STRING'];
            $queryString = urldecode($queryString);
            $regex = '/(?:https?:\/\/)?(?:www\.)?([a-zA-Z0-9-]+\.[a-zA-Z]{2,})(?:\/\S*)?/i';
            if (preg_match($regex, $queryString)) {
                return '';
            }
        }

        $uri = $this->EE->uri->uri_string;
        
        $segs = explode("/", $uri);

        if($_SERVER['REMOTE_ADDR'] == '103.6.219.60'){
            // var_dump(count($segs));var_dump($segs);
        }
        
        /// detect HOME ///
        if($uri == "" && REQ != 'ACTION' && REQ != "CP"){
             $this->router = Seo_Helper::HOME;
             return;
        }
        ///////////////////
        
        /// detect BLOGS ///
        if(count($segs) == 1 && in_array($segs[0], $this->blog_uri_segs)){
             $this->router = Seo_Helper::BLOGS;
             return;
        }
        ////////////////////  
        
        /// detect event detail ///
        if(count($segs) == 3){
             $regexp = "/e(\d{8})/i";
             $seg_num = explode("&", $segs[2]);
             $segs[2] = $seg_num[0];
             preg_match_all($regexp, $segs[2], $matches);
             
             if(isset($matches[1][0])){
                 $this->router = Seo_Helper::DETAILS;
                 return;
             }
        }
        ///////////////////////////
        
        /// detect event venue ///
        if(count($segs) == 4 && $segs[0] == 'event-venue'){
             $regexp = "/a(\d{8})/i";
             preg_match_all($regexp, $segs[3], $matches);
             
             if(isset($matches[1][0])){
                 $this->router = Seo_Helper::ACCOUNT_VENUE_DETAIL;
                 return;
             }
        }
        //////////////////////////

        /// detect event venue ///
        if(count($segs) == 3 && $segs[0] == 'express'){

             $regexp = "/a(\d{8})/i";
             preg_match_all($regexp, $segs[3], $matches);
            //  if($_SERVER['REMOTE_ADDR'] == '103.6.219.60'){
            //     // var_dump($matches);var_dump(Seo_Helper::EXPRESS_EDIT_OPTION);
            //     $this->router = Seo_Helper::EXPRESS_EDIT_OPTION;
            //     return;
                
            // }
            $this->router = Seo_Helper::EXPRESS_EDIT_OPTION;
                return;
             // if(isset($matches[1][0])){
             //     $this->router = Seo_Helper::EXPRESS_EDIT_OPTION;
             //     var_dump($this->router);
             //     return;
             // }
        }
        //////////////////////////
        
        /// detect organiser ///
        if(count($segs) == 4 && $segs[0] == 'org'){
             $regexp = "/a(\d{8})/i";
             preg_match_all($regexp, $segs[3], $matches);
             
             if(isset($matches[1][0])){
                 $this->router = Seo_Helper::ACCOUNT_ORG_DETAIL;
                 return;
             }
        }
        /////////////////////////
        
        /// detect exhibitor ///
        if(count($segs) == 4 && $segs[0] == 'exhibitor'){
             $regexp = "/a(\d{8})/i";
             preg_match_all($regexp, $segs[3], $matches);
             
             if(isset($matches[1][0])){
                 $this->router = Seo_Helper::ACCOUNT_EXHIBITOR_DETAIL;
                 return;
             }
        }
        /////////////////////////
        
        /// detect speaker profile ///
        if(count($segs) == 3 && $segs[0] == 'speaker-profile'){
             $regexp = "/c(\d{8})/i";
             preg_match_all($regexp, $segs[2], $matches);
             
             if(isset($matches[1][0])){
                 $this->router = Seo_Helper::SPEAKER_PROFILE;
                 return;
             }
        }
        ///////////////////////////////
        
        /// detect event registration receipt ///
        if(count($segs) == 2 && $segs[0] == 'event-registration-receipt'){
             $this->router = Seo_Helper::EVENT_REGISTRATION_RECEIPT;
             return;
        }
        ////////////////////////////////////////
        
        ///// detect new add option ///////
        if(strpos($segs[0], 'addoptions') !== false){
            $_segs = explode("=", $segs[0]);
            $this->router = Seo_Helper::EVENT_ADD_NEW_OPTION;
            return;
        }
        ///////////////////////////////////

        /// detect system ///
        $is_system = false;
        foreach($this->system_uri_segs as $item){
            if($item == $uri){
               $is_system = true;
               break; 
            }
        }
        $act = $this->EE->input->get_post("ACT");
        if(!empty($act)){
            $is_system = true;
        }
        if(REQ == 'CP'){
            $is_system = true;
        }
        if($is_system){
            $this->router = Seo_Helper::SYSTEM;
            return;
        }
        ////////////////////
    }
    
    function get_router(){
        return $this->router;
    }
    
    /// triggers for routers ///
    function trigger_router_HOME(){
        if ( ! class_exists('Mdentevents')){
            require PATH_THIRD.'mdentevents/mod.mdentevents.php';
        }
        $_POST['cmd'] = "dentevents:home:show";
        $DS = new Mdentevents();
        $DS->process();
    }
    
    function trigger_router_DETAILS(){
        $uri = $this->EE->uri->uri_string;
        $segs = explode("/", $uri);

        /// ID ///
        $regexp = "/e(\d{8})/i";
        preg_match_all($regexp, $segs[2], $matches);
        $id = "e" . $matches[1][0];
        //////////
        
        $_POST['ACT'] = $this->actions['dentevents'];
        $_POST['cmd'] = "dentevents:details:show";
        $_POST['id'] = $id;
        
        $this->EE->core->generate_action(true);
    }

    function trigger_router_EVENT_ADD_NEW_OPTION(){
        $uri = $this->EE->uri->uri_string;
        $segs = explode("/", $uri);
        $_segs = explode("&", $segs[0]);
        $seg_act = explode("=", $_segs[0]);
        $seg_event = explode("=", $_segs[1]);
        /// id //
        $id = $seg_act[1];
        $event_id = $seg_event[1];
        ////
        $_POST['ACT'] = $this->actions['dentevents'];
        $_POST['cmd'] = "dentevents:details:premium:registration:options:registered_show";
        $_POST['act_id'] = $id;
        $_POST['event_id'] = $event_id;
        
        $this->EE->core->generate_action(true);
    }
    function trigger_router_EXPRESS_EDIT_OPTION(){

        $uri = $this->EE->uri->uri_string;
        $segs = explode("/", $uri);
        $_segs = explode("&", $segs[0]);
        $seg_act = explode("=", $_segs[0]);
        $seg_event = explode("=", $segs[1]);
        /// id //

        $id = $seg_act[1];
        $event_id = $seg_event[1];
        ////
        $_POST['ACT'] = $this->actions['dentevents'];
        $_POST['cmd'] = "dentevents:events:edit_express";
        $_POST['act_id'] = $id;
        $_POST['event_id'] = $event_id;
        
        
        $this->EE->core->generate_action(true);
    }

    function trigger_router_ACCOUNT_ORG_DETAIL(){
        $uri = $this->EE->uri->uri_string;
        $segs = explode("/", $uri);

        /// ID ///
        $regexp = "/a(\d{8})/i";
        preg_match_all($regexp, $segs[3], $matches);
        $id = "a" . $matches[1][0];
        //////////
        
        $_POST['ACT'] = $this->actions['dentevents'];
        $_POST['cmd'] = "dentevents:account:show";
        $_POST['id'] = $id;
        $_POST['type'] = "org";
        
        $this->EE->core->generate_action(true);
    }
    function trigger_router_ACCOUNT_EXHIBITOR_DETAIL(){
        $uri = $this->EE->uri->uri_string;
        $segs = explode("/", $uri);

        /// ID ///
        $regexp = "/a(\d{8})/i";
        preg_match_all($regexp, $segs[3], $matches);
        $id = "a" . $matches[1][0];
        //////////
        
        $_POST['ACT'] = $this->actions['dentevents'];
        $_POST['cmd'] = "dentevents:account:show";
        $_POST['id'] = $id;
        $_POST['type'] = "exhibitor";
        
        $this->EE->core->generate_action(true);
    }
    function trigger_router_ACCOUNT_VENUE_DETAIL(){
        $uri = $this->EE->uri->uri_string;
        $segs = explode("/", $uri);

        /// ID ///
        $regexp = "/a(\d{8})/i";
        preg_match_all($regexp, $segs[3], $matches);
        $id = "a" . $matches[1][0];
        //////////
        
        $_POST['ACT'] = $this->actions['dentevents'];
        $_POST['cmd'] = "dentevents:account:show";
        $_POST['id'] = $id;
        $_POST['type'] = "venue";
        
        $this->EE->core->generate_action(true);
    }
    
    function trigger_router_SPEAKER_PROFILE(){
        $uri = $this->EE->uri->uri_string;
        $segs = explode("/", $uri);

        /// ID ///
        $regexp = "/c(\d{8})/i";
        preg_match_all($regexp, $segs[2], $matches);
        $id = "c" . $matches[1][0];
        //////////
                                             
        $_POST['ACT'] = $this->actions['dentevents'];
        $_POST['cmd'] = "dentevents:speaker_profile:show";
        $_POST['id'] = $id;
        
        $this->EE->core->generate_action(true);
    }
    function trigger_router_EVENT_REGISTRATION_RECEIPT(){
        $uri = $this->EE->uri->uri_string;
        $segs = explode("/", $uri);

        /// ID ///
        $id = $segs[1];
        //////////
                                             
        $_POST['ACT'] = $this->actions['dentevents'];
        $_POST['cmd'] = "dentevents:details:premium:registration:receipt:download";
        $_POST['act_id'] = $id;
        
        $this->EE->core->generate_action(true);
    }
    
    function trigger_router_BLOGS(){
        $uri = $this->EE->uri->uri_string;
        $this->EE->uri->segments[1] = "blogs";
        $this->EE->uri->segments[2] = $uri;
        
        //$uri = "blogs/" . $uri;
        
        //$this->EE->uri->_set_uri_string($uri);        
    }
  
    function trigger_router_NOTFOUND(){
        show_404();
        exit;
        /*$this->EE->uri->segments[1] = "system";
        $this->EE->uri->segments[2] = "not_found_page";
        
        $uri = "system/not_found_page";
        
        $this->EE->uri->_set_uri_string($uri);*/
        $uri = "/system/not_found_page";
        $this->output_helper->sendRedirectHeaders($uri, true);
    }
    ////////////////////////////
}