<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once(APPPATH . 'application/models/base/core.php');

class Base extends Core{
    protected $table = '';
    protected $table_cstm = '';
    protected $relationship = '';
    protected $seo_helper = '';
    
    function __construct(){
        parent::__construct();
        
        $config = $this->EE->config->item($this->module, 'tables');
        
        $defaults = array(
                'main_table' => '',
                'main_table_cstm' => '',
                'relationship' => ''
                );
        $diffs = array_diff_key($defaults,$config);
        $config = array_merge($config,$diffs);
        
        $this->table = $config['main_table'];
        $this->table_cstm = $config['main_table_cstm'];
        $this->relationship = $config['relationship'];
        
        $this->EE->load->helper('seo');
        $this->seo_helper = new Seo_Helper();
    }
    private function _check_cstm($check, $target){
        if ($target == '' || strpos($target, $check) === false){
            return false;        
        }
        return true;
    }
    private function _swap_tables($tables = array(), $target){
        foreach($tables as $key => $value){
            $target = str_replace($key, $value, $target);
        }
        
        return $target;
    }
    function get_cstm_data($params = array(), $execute = true){
        $args = array(
                    'selects' => '',
                    'orders' => '',
                    'joins' => array(),
                    'where' => '',
                    'limit' => '',
                    'groups' => '',
                    'single' => false
                );
        $diffs = array_diff_key($args, $params);
        $params = array_merge($params,$diffs);
        
        $selects = $params['selects'];
        $joins = $params['joins'];
        $orders = $params['orders'];
        $where = $params['where'];
        $limit = $params['limit'];
        $groups = $params['groups'];
        
        $main_table = $this->table;
        $main_table_cstm = $this->table_cstm;
        $tables = array('{#m}.' => $main_table . '.', '{#c}.' => $main_table_cstm . '.');
        
        $sql_join = '';
        foreach($joins as $key => $_join){
            
            $sql = $_join['sql'];
            $table = $_join['table'];
            $type = $_join['type'];
            
            $tables["$key."] = "$table.";
            
            $sql_join = $sql_join . " $type join ($sql) as $table on $table.id=$main_table.id";
        }
        
        $selects = $this->_swap_tables($tables, $selects);
        $orders = $this->_swap_tables($tables, $orders);
        $where = $this->_swap_tables($tables, $where);
        $groups = $this->_swap_tables($tables, $groups);
        
        if ($orders != '')
            $orders = 'order by ' .  $orders;
        if ($where != '')
            $where = 'where ' .  $where;
        if ($limit != '')
            $limit = 'limit ' .  $limit;
        if ($groups != '')
            $groups = 'group by ' .  $groups;
            
        $query = "select $selects
                   from $main_table_cstm
                   $sql_join
                   $where
                   $groups
                   $orders 
                   $limit
                  ";    
       
        
        if (!$execute){
            return array('table' => $main_table_cstm, 'sql' => $query);
        }
        $rows = $this->executeQuery($query, $params['single']);
        
        return $rows;
    }
    function get_main_data($params = array(), $execute = true){
        $args = array(
                    'selects' => '',
                    'orders' => '',
                    'joins' => array(),
                    'where' => '',
                    'limit' => '',
                    'groups' => '',
                    'single' => false,
                    'execute' => true,
                    'custom_main' => array()
                );
        $diffs = array_diff_key($args, $params);
        $params = array_merge($params,$diffs);
        
        $selects = $params['selects'];
        $joins = $params['joins'];
        $orders = $params['orders'];
        $where = $params['where'];
        $limit = $params['limit'];
        $groups = $params['groups'];
        $custom_main = $params['custom_main'];
        $param_execute = $params['execute'];
        
        $main_table = $this->table;
        $main_table_cstm = $this->table_cstm;
        $tables = array('{#m}.' => $main_table . '.', '{#c}.' => $main_table_cstm . '.');
        
        $sql_join = '';
        foreach($joins as $key => $_join){
            
            $sql = $_join['sql'];
            $table = $_join['table'];
            $type = $_join['type'];
            $cond = $_join['cond'];
            
            $sql_join_cond = "$table.id=$main_table.id";
            if (!empty($cond)){
                $sql_join_cond = $cond;
            }
            $tables["$key."] = "$table.";
            
            $sql_join = $sql_join . " $type join ($sql) as $table on $sql_join_cond";
        }
        
        
        if ($where != ''){
            $where = "($where) and " . "{#m}.deleted=0";
        }else{
            $where = "{#m}.deleted=0";
        }
        $enable_cstm = $this->_check_cstm('{#c}.', $selects . $orders . $where. $sql_join);
       
        $selects = $this->_swap_tables($tables, $selects);
        $orders = $this->_swap_tables($tables, $orders);
        $where = $this->_swap_tables($tables, $where);
        $groups = $this->_swap_tables($tables, $groups);
        $sql_join = $this->_swap_tables($tables, $sql_join);
        
        if ($orders != '')
            $orders = 'order by ' .  $orders;
        if ($where != '')
            $where = 'where ' .  $where;
        if ($limit != '')
            $limit = 'limit ' .  $limit;
        if ($groups != '')
            $groups = 'group by ' .  $groups;
            
        $sql_from = "from $main_table";
        if (!empty($custom_main)){
            $sql = $custom_main['sql'];
            $sql_from = "from ($sql) as $main_table";
        }
        
        if ($enable_cstm){
            
            $cstm_join = "left join $main_table_cstm ON  $main_table.id=$main_table_cstm.id_c";
            if(array_key_exists("{#c}", $joins)){
                $cstm_join = '';
            }
            $query = "select $selects
                   $sql_from
                   $cstm_join
                   $sql_join
                   $where
                   $groups
                   $orders 
                   $limit
                  ";    
        }else{
            $query = "select $selects
                   $sql_from
                   $sql_join
                   $where
                   $groups
                   $orders 
                   $limit
                  ";
        }
        
        if (!$execute || !$param_execute){
            return $query;
        }
        $rows = $this->executeQuery($query, $params['single']);
        
        return $rows;
        
    }
   
    function get_multi_relationship($params){
        $params['rel_module_name'] = 'images'; 
        
         $rows = $this->get_relationship($params);
    }
    function get_relationship($params, $execute = true){
        $args = array(
                       'id' => '' ,
                       'rel_module_name' => '',
                       'selects' => '',
                       'orders' => '',
                       'where' => '',
                       'limit' => '',
                       'groups' => '',
                       'multiple' => array(),
                       'rel_join_type' => 'inner',
                       'execute' => true,
                       'single' => false
                ); 
                
        $diffs = array_diff_key($args, $params);
        $params = array_merge($params,$diffs);
        
        $id = $params['id'];
        $rel_module_name = $params['rel_module_name'];
        $selects = $params['selects'];
        $orders = $params['orders'];
        
        $where = $params['where'];
        if(empty($where)){
            $where = "{#m}.deleted=0";
        }else{
            $where = "{#m}.deleted=0 AND ($where)";
        }
        
        $limit = $params['limit'];
        $groups = $params['groups'];
        $multiple = $params['multiple'];
        $param_execute = $params['execute'];
        $rel_join_type = $params['rel_join_type'];
           
        $relationship = $this->relationship; 
        $relationship = $relationship[$rel_module_name]; 
        $main_table = $relationship['main_table'];
        $main_table_cstm = $relationship['main_table_cstm'];
        $rel_table = $relationship['rel_table'];
        $rel_id = $relationship['rel_id'];
        $main_id = $relationship['main_id'];

        $tables = array('{#m}.' => $main_table . '.', '{#c}.' => $main_table_cstm . '.', '{#r}.' => $rel_table . '.');
        
        $enable_cstm = $this->_check_cstm('{#c}.', $selects . $orders . $where);
       
        $selects = $this->_swap_tables($tables, $selects);
        $selects = str_replace('{#join_col}', "$rel_table.$main_id", $selects);
        
        $orders = $this->_swap_tables($tables, $orders);
        $where = $this->_swap_tables($tables, $where);
        $groups = $this->_swap_tables($tables, $groups);
        
        if ($orders != '')
            $orders = 'order by ' .  $orders;
        if ($where != '')
            $where = 'where ' .  $where;
        if ($limit != '')
            $limit = 'limit ' .  $limit;
        if ($groups != '')
            $groups = 'group by ' .  $groups;
        
        if ($id != ''){
            $join_cond = "and $rel_table.$main_id='$id'";
        }else{
            $join_cond = '';
        }    
        
        
        $main_table_id = 'id';
        $from_sql = "from $main_table";
        if (!empty($multiple) && empty($multiple['sql'])){
            $multi_module = $multiple['module'];    
            $multi_module_relation = $multiple['relation'];    
            
            $config = $this->EE->config->item($multi_module, 'tables');
            $relationship = $config['relationship'];
            $relationship = $relationship[$multi_module_relation];
            $multi_rel_table = $relationship['rel_table'];
            $main_table_id = $relationship['main_id'];
            $multi_rel_id = $relationship['rel_id'];
            $from_sql = "from (select $main_table.*,$multi_rel_table.$main_table_id,$multi_rel_table.$multi_rel_id from $main_table inner join $multi_rel_table ON $main_table.id = $multi_rel_table.$main_table_id and $multi_rel_table.deleted=0) as $main_table";
        }   
        if (empty($main_table_id)){
            $main_table_id = 'id';
        } 
        
        $rel_table_sql = "$rel_table";
        if (!empty($multiple) && !empty($multiple['sql'])){
            $multiple_sql = $multiple['sql'];
            $rel_table_sql = "($multiple_sql) as $rel_table";
        }
        if ($enable_cstm){
             $query = "
                  select $selects
                  $from_sql
                  left join $main_table_cstm ON $main_table.id=$main_table_cstm.id_c
                  $rel_join_type join $rel_table_sql ON $main_table.$main_table_id=$rel_table.$rel_id $join_cond and $rel_table.deleted=0
                  $where
                  $groups
                  $orders
                  $limit
                 ";
        }else{
             $query = "
                  select $selects
                  $from_sql
                  $rel_join_type join $rel_table_sql ON $main_table.$main_table_id=$rel_table.$rel_id $join_cond and $rel_table.deleted=0
                  $where
                  $groups
                  $orders
                  $limit
                 ";
        }
        
        
        if (!$execute || !$param_execute){
            return $query;
        }         
        
        $results = $this->executeQuery($query, $params['single']);
        
        if(!empty($params['to_values'])){
            $temp = array();
            $key = $params['to_values'];
            foreach($results as $item){
                $temp[] = $item[$key];
            }
            
            return $temp;
        }
        
        return $results;
    }
    
    function add_relationship($params){
        
        $params['delete'] = '0';
        $result = $this->rest->set_relationship($params);
        
        return $result;
    }
    function remove_relationship($params){
        
        $params['delete'] = '1';
        $result = $this->rest->set_relationship($params);
        
        return $result;
    }
    
        /***********add / remove app relationships *********/
    function add_relationship_app($main_id, $ids, $target){
        if (!is_array($ids)){
            $ids = array($ids);
        }
        $params = array();
        $params['module_name'] = $this->legal_module;
        $params['module_id'] = $main_id;
        $params['link_field_name'] = $this->relationship[$target]['link_name'];
        $params['related_ids'] = $ids;
        $params['name_value_list'] = '';
        
        $response = $this->add_relationship($params);
        
        if ($response->created)
            return true;
        
        return false;
    }
    function add_relationships_app($main_ids, $ids, $target){
        if (!is_array($ids)){
            $ids = array($ids);
        }
        $params = array();
        $params['module_names'] = array();
        foreach($main_ids as $item){
            $params['module_names'][] = $this->legal_module;
        }
        $params['module_ids'] = $main_ids;
        
        $params['link_field_names'] = array();
        foreach($main_ids as $item){
            $params['link_field_names'][] = $this->relationship[$target]['link_name'];
        }
        
        $params['related_ids'] = array();
        foreach($main_ids as $key => $item){
            $params['related_ids'][] = array($ids[$key]);
        }
        
        $params['name_value_lists'] = '';
        
        $params['delete_array'] = array();
        foreach($main_ids as $item){
            $params['delete_array'][] = 0;
        }
        
        $response = $this->rest->set_relationships($params);
        
        if ($response->created)
            return true;
        
        return false;
    }
    function remove_relationship_app($main_id, $ids, $target){
        if (!is_array($ids)){
            $ids = array($ids);
        }
        $params = array();
        $params['module_name'] = $this->legal_module;
        $params['module_id'] = $main_id;
        $params['link_field_name'] = $this->relationship[$target]['link_name'];
        $params['related_ids'] = $ids;
        $params['name_value_list'] = '';
        
        $response = $this->remove_relationship($params);
        
        if ($response->deleted)
            return true;
        
        return false;
    }
    
    public function set_record($datas){
        //return true;
        $params = array();
        $params['module_name'] = $this->legal_module;
        
        foreach($datas as $key => $value){
            $params['name_value_list'][] = array('name' => $key, 'value' => $value);    
        } 

        $response = $this->rest->set_entry($params);
         
        if ($response == null)
            return false;
        
        $results = $response->id;
        if ($results == null)
            return false;
        
        /*foreach($datas as $key => $value){
            if ($results->$key == null)
                return false;
            if ($results->$key->value != $value){
                return false;
            }
        }*/
        
        return $response->id;
    }
    
    public function set_records($datas){
        //return true;
        $params = array();
        $params['module_name'] = $this->legal_module;
        
        foreach($datas as $data){
            $item = array();
            foreach($data as $key => $value){
                $item[] = array('name' => $key, 'value' => $value);    
            } 
            $params['name_value_list'][] = $item;
        }

        $response = $this->rest->set_entries($params);
         
        if ($response == null)
            return false;
        
        $results = $response->ids;
        if ($results == null)
            return false;
        
        return $response->ids;
    }
    
    public function get_module_fields($fields){
        $params = array();
        $params['module_name'] = $this->legal_module;
        $params['fields'] = $fields;  
        
        $response = $this->rest->get_module_fields($params);
         
        if ($response == null)
            return false;
        return $response;     
    }   
    
    public function render_field_dropdown($field, $curr_val = '', $multiline=false, $excludes = array(), $params=''){
        $results = array();
        if (empty($this->buffers['dropdown'][$field])){
            $response = $this->get_module_fields(array($field));
            if (!$response)
                return false;
            if ($response->module_fields->$field == null) 
                return false;
            $options = $response->module_fields->$field->options;
            
            $this->EE->load->helper('data');
            $helper = new Data_Helper();
            
            $options = $helper->objectToArray($options);
            
            foreach($options as $key => $option){
               if ($key == '_empty_')
                  continue;  
               $key = $option->name; 
               
               if($params['value_to_seo'] == "yes"){
                   $key = $this->seo_helper->get_seo_text($key);
               }
               $results[$key] = $option->value; 
            } 
            $this->buffers['dropdown'][$field] = $results;
        }else{
            $results = $this->buffers['dropdown'][$field];
        }

        $vals = array();
        if ($multiline){
            $curr_val = trim($curr_val, "^");
            if($curr_val != ''){
                $vals = explode('^,^', $curr_val);
            }else{
                $vals = array();
            }
        }else{
            $vals = array($curr_val);
        }
        
        $results = array_diff_assoc($results, $excludes);
        
        if($params['dropdown_datas'] == "yes"){
            if($params['dropdown_datas_selected'] == "yes"){
                $selected_datas = array();
                foreach($vals as $_val){
                    $selected_datas[] = $results[$_val];
                }
                return $selected_datas;
            }
            return $results;
        }
        
        $html = '';
        switch($params['render_type']){
            case 'checkboxes':
                $name = $params['name'];
                $html = $helper->make_checkboxes($results, $vals, $name);
            break;
            default:
                $html = $helper->make_select_opts($results, $vals);    
            break;
        }

        return $html;
    }
    
    ///// UPDATE field on rel_table  /////
    function update_field_on_reltable($params){
        $args = array(
                       'id' => '' ,
                       'rel_module_name' => '',
                       'rel_id_value' => '',
                       'datas' => ''
                ); 
                
        $diffs = array_diff_key($args, $params);
        $params = array_merge($params,$diffs);
        
        $id = $params['id'];
        $rel_id_value = $params['rel_id_value'];
        $rel_module_name = $params['rel_module_name'];
        $datas = $params['datas'];
           
        $relationship = $this->relationship; 
        $relationship = $relationship[$rel_module_name]; 

        $rel_table = $relationship['rel_table'];
        $rel_id = $relationship['rel_id'];
        $main_id = $relationship['main_id'];
        
        $where = "$main_id='$id' and $rel_id='$rel_id_value' and deleted=0";
        
        $query = $this->EE->crmdb->update_string($rel_table, $datas, $where);
        
        $result = $this->executeQuery($query);
        
        return $result;
    }
}