<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Core extends CI_Model{
    protected $EE;
    protected $rest;
    protected $crmdb;
    protected $db;
    protected $logger;
    static $buffers;
    
    function __construct(){
        $this->EE =& get_instance();
        $this->rest = $this->EE->rest;
        $this->crmdb = $this->EE->crmdb;
        $this->db =  $this->EE->db;
        
        $this->EE->load->library('logger');
        $this->logger = $this->EE->logger;
        
        $this->buffers = array();
    }
    
    protected function executeQuery($query, $single = false){
        $q_results = $this->EE->crmdb->query($query);
        
        if (is_bool($q_results)){
            return $q_results;
        }
        $results = $q_results->result_array();
        
        $q_results->free_result();
        
        foreach($results as $record){
            if (array_key_exists('id', $record)){
                $this->buffers[$record['id']] = $record;
                if ($single)
                    break;
            }
        }
        if ($single && count($results) > 0){
          return $results[0];
        }
        
        return $results;
    }
    public function get_buffer_data($id){
        return $this->buffers[$id];
    }
    
}