<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once(APPPATH . 'application/models/base/base.php');

class Contacts extends Base{
    
    protected $module = 'contacts';
    protected $legal_module = 'Contacts';
    
    function __construct(){
        parent::__construct();
    }
    
    function get_contacts($params){
        
        $rows = $this->get_main_data($params);
        
        return $rows;
    }
    function get_totals($params){
        $rows = $this->get_main_data($params);
        
        if ($rows != null){
            return $rows[0]['count'];
        }
        return 0;
    }
    
    function get_relationship_accounts($params){
        
        $params['rel_module_name'] = 'accounts';
        $results = $this->get_relationship($params);

        return $results;
    }
    
    function get_relationship_news($params){
        
        $params['rel_module_name'] = 'news';
        $results = $this->get_relationship($params);

        return $results;
    }
    
    function get_relationship_event_topics($params){
        
        $params['rel_module_name'] = 'event_topics';
        $results = $this->get_relationship($params);

        return $results;
    }
    function get_relationship_memberships($params){
        
        $params['rel_module_name'] = 'memberships';
        $results = $this->get_relationship($params);

        return $results;
    }
    function get_relationship_cpdactivity($params){
        
        $params['rel_module_name'] = 'cpdactivity';
        $results = $this->get_relationship($params);

        return $results;
    }
    function get_relationship_subscriptions($params){
        
        $params['rel_module_name'] = 'subscriptions';
        $results = $this->get_relationship($params);

        return $results;
    }
    
    function get_relationship_contacthits($params){
        
        $params['rel_module_name'] = 'contact_hits';
        $results = $this->get_relationship($params);

        return $results;
    }
    
    function get_relationship_cpd_events_speakers($params){
        
        $params['rel_module_name'] = 'cpd_events_speakers';
        $results = $this->get_relationship($params);

        return $results;
    }
    
    function get_relationship_cpd_events_interest($params){
        
        $params['rel_module_name'] = 'cpd_events_interest';
        $results = $this->get_relationship($params);

        return $results;
    }
    
    function get_relationship_article_images($params){
        
        $params['rel_module_name'] = 'article_images';
        $results = $this->get_relationship($params);

        return $results;
    }
    
    /*function get_relationship_images($params){
        
         $params['rel_module_name'] = 'images'; 
         $rows = $this->get_relationship($params);
         
         return $rows;
    } */
    
    
    function get_email_address($contact_id){
        
        $query = "SELECT ea.email_address FROM email_addresses ea
                LEFT JOIN email_addr_bean_rel ear ON ea.id = ear.email_address_id
                WHERE ear.bean_module = 'Contacts'
                AND ear.bean_id = '$contact_id'
                AND ear.deleted = 0
                AND ea.invalid_email = 0
                ORDER BY ear.primary_address DESC LIMIT 0,1";
        $result = $this->executeQuery($query, true);
        
        if (array_key_exists('email_address', $result)){
            return $result['email_address'];
        }
        return '';
    }
    
    /********************relationships funcs****************/
    function add_article_to_list($article_id, $contact_id){
        
        $params = array();
        $params['module_name'] = $this->legal_module;
        $params['module_id'] = $contact_id;
        $params['link_field_name'] = $this->relationship['articles']['link_name'];
        $params['related_ids'] = array($article_id);
        $params['name_value_list'] = array($article_id);
        
        $response = $this->add_relationship($params);
        
        if ($response->created)
            return true;
        
        return false;
    }
    
    function add_tasks($task_id, $contact_id){
        
        $params = array();
        $params['module_name'] = $this->legal_module;
        $params['module_id'] = $contact_id;
        $params['link_field_name'] = $this->relationship['tasks']['link_name'];
        $params['related_ids'] = array($task_id);
        $params['name_value_list'] = array($task_id);
        
    
        $response = $this->add_relationship($params);
        
        if ($response->created)
            return true;
        
        return false;
    }
    function get_relationship_grp_group_members($params){
        
        $params['rel_module_name'] = 'grp_group_members';
        $results = $this->get_relationship($params);

        return $results;
    }

}