<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once(APPPATH . 'application/models/base/base.php');

class Reserve_Tickets extends Base{
    protected $table;
    
    function __construct(){
        parent::__construct();
        $this->table = 'exp_reserve_tickets';
    }
    
    function load($event_id)
    {   
        $now = date('Y-m-d H:i:s');         
        $this->EE->load->dbforge();
        $this->EE->db->select('*');
        $where = "event_id = '{$event_id}' and created_at <= '{$now}' and expired_at >= '{$now}'";
        $query = $this->EE->db->get_where($this->table, $where);
        $results = $query->result_array();
        
        return $results;
    }
    
    function loadById($reserve_id)
    {
        $this->EE->load->dbforge();
        $this->EE->db->select('*');
        $where = array('id' => $reserve_id);
        $query = $this->EE->db->get_where($this->table, $where);
        $result = $query->row_array();    
        
        return $result;
    }
    
    function remove($reserve_id)
    {
        $this->EE->load->dbforge();
        $this->EE->db->where('id', $reserve_id);
        $this->EE->db->delete($this->table);    
    }
    
    function clean_expired()
    {
        $now = date('Y-m-d H:i:s');         
        $this->EE->load->dbforge();
        $this->EE->db->where("expired_at < '{$now}'");  
        $this->EE->db->delete($this->table);     
    }
    
    function add($event_id, $rego_id, $mins, $sparams = '')
    {   
        if($mins == ''){
            $mins = 10;
        }
        $created_at = date('Y-m-d H:i:s');
        $expired_at = time() + 60 * $mins;
        $expired_at = date('Y-m-d H:i:s', $expired_at);
        
        $data = array(
                    'event_id' => $event_id,
                    'rego_id' => $rego_id,
                    'created_at' => $created_at,
                    'expired_at' => $expired_at,
                );
        if(!empty($sparams['data'])){
            $data = array_merge($data, $sparams['data']);
        }
                 
        $this->EE->load->dbforge();
        $id = $this->EE->db->insert($this->table, $data);
        $data['id'] = $this->EE->db->insert_id();
        
        return $data;
    }
}