<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * ExpressionEngine - by EllisLab
 *
 * @package        ExpressionEngine
 * @author        EllisLab Dev Team
 * @copyright    Copyright (c) 2003 - 2012, EllisLab, Inc.
 * @license        http://ellislab.com/expressionengine/user-guide/license.html
 * @link        http://ellislab.com
 * @since        Version 2.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * This class doesn't do much work.  Most of the heavy lifting is done via
 * libraries/Core.php, which runs automatically behind the scenes.  
 */
class Ajax extends CI_Controller {
    /**
     * Index
     */
    protected $module_class_maps = array(
                             'mdentevents' => 'DEProcessing',
                             'madverts' => 'AVTProcessing'   
                          ); 
    function articles()
    {
        $this->core->generate_page();

        $html = $this->output->get_output();
  
        $results = array();
        $results['update_section'] = array(
                                        'name' => 'list-content',
                                        'html' => $html
                                    );
        $this->output->send_ajax_response($results);
    }
    
    function add_article_to_list(){
        
         require_once(PATH_THIRD . 'app/homepage/ajax_add_article_to_list.php');
         $doClass = new Ajax_Add_Article_To_List();
         $return_data =$doClass->do_action();
         
         $results = array();
         $results['update_section'] = array(
                                        'name' => 'result',
                                        'html' => $return_data
                                    );
        $this->output->send_ajax_response($results);
    }
    function upload_to_crm(){
       $EE =& get_instance(); 
       $file_id = $EE->input->get_post('file_id');
       $crm_field = $EE->input->get_post('crm_field');
           
       require_once(PATH_THIRD . 'person/models/processing.php');
       $processing = new MProcessing();
       $result = $processing->ajax_upload_to_crm(); 
       
       $output = array();
       if (is_array($result) ){
           $output['success'] = 1;
           $output['filename'] = $result['filename'];
       }else{
           $output['success'] = 0;
           
           $app_config = $EE->config->item('app');
           $output['error'] = $app_config['error_code'][$result];
       }
       $EE->load->library('javascript');
       $output = $EE->javascript->generate_json($output, TRUE);
       echo $output;
       exit;
       //$this->output->send_ajax_response($output);
    }
    function remove_photo(){
       $EE =& get_instance(); 
       $crm_field = $EE->input->get_post('crm_field'); 
       
       require_once(PATH_THIRD . 'person/models/processing.php');
       $processing = new MProcessing();
       $result = $processing->ajax_remove_photo();
       
       $output = array();
       if (is_array($result) ){
           $output['success'] = 1;
       }else{
           $output['success'] = 0;
           
           $app_config = $EE->config->item('app');
           $output['error'] = $app_config['error_code'][$result];
       }
       $EE->load->library('javascript');
       $output = $EE->javascript->generate_json($output, TRUE);
       echo $output;
       exit;
    }

    function processing_module(){
       $EE =& get_instance();
       $module = $EE->input->get_post("module");
       
       $classname = $this->module_class_maps[$module];
       require_once(PATH_THIRD . $module . '/models/processing.php');
       $processing = new $classname();
       $processing->initialize();
       $result = $processing->process(); 
       
       echo $result;
    }
}

/* End of file ee.php */
/* Location: ./system/expressionengine/controllers/ee.php */