<?php
/*
    author : Adeel
    date   : 2013/4/18
*/
class Init{
    
    function __construct(){
        $this->EE =& get_instance();    
    }
    public function initialize(){
        date_default_timezone_set("UTC");
        $this->load_application_config();
        $this->load_rest();
        $this->load_crm_db();
        
        $this->EE->load->helper("seo");
        $this->EE->load->helper("redirects");
    }
    protected function load_rest(){
        $this->EE->load->library('rest/rest', NULL, 'rest');
        $this->EE->load->library('io/file', NULL, 'file');
    }
    protected function load_crm_db(){

        // Do we even need to load the database class?
        if (isset($this->EE->crmdb) AND is_object($this->EE->crmdb))
        {
            return FALSE;
        }

        require_once(BASEPATH.'database/DB.php');

        $params = $this->EE->config->item('crm');
        $params = $params['db'];
        // Initialize the db variable.  Needed to prevent
        // reference errors with some configurations
        $this->EE->crmdb = '';
        $active_record = TRUE;
        // Load the DB class
        $this->EE->crmdb =& DB($params, $active_record);
        
        /// load crm app config ///
        define('sugarEntry', true);
        $params = $this->EE->config->item('crm');
        $base = $params['main']['site_basepath'];
        $lang = "en_us";

        if(file_exists($base . "custom/application/Ext/Language/$lang.lang.ext.php")) {
            include($base . "custom/application/Ext/Language/$lang.lang.ext.php");
        }
        if(file_exists($base . "custom/include/language/$lang.lang.php")) {
            include($base . "custom/include/language/$lang.lang.php");
        }
        include("readURL.php");
        ///////////////////////////
    }
    protected function load_application_config(){
        $this->EE->config->load('app', TRUE);
        $this->EE->config->load('crm', TRUE);
        $this->EE->config->load('tables', TRUE);
        
        $this->EE->load->helper('output');
        $output = new Output_Helper();
        
        $this->EE->output = $output;
    }
    
    public function check_trigger_routers()
    {
        if ($this->EE->session->userdata('admin_sess')) {
            return;
        }
        $app_config = $this->EE->config->item('app');
        /// build site maps ///
        if($this->EE->uri->uri_string == "build_sitemap" && $app_config['sitemap_build_enable'] == true){
            $targets = array(Seo_Helper::SITEMAP_EVENTS);
            require_once(PATH_THIRD . 'sitemap' . '/mod.sitemap.php');
            $sitemap = new Sitemap();
            $sitemap->generate_sitemap($targets);
            
            /////////////////
            /*$redirects = new Redirects_Helper();
            $redirects->check_contacts();
            echo 'Success!';*/
            /////////////////
            
            exit;
        }
        ///////////////////////
        
        /// check redirets ///
        //$redirects = new Redirects_Helper();
        //$redirects->check_redirects();
        //////////////////////

        $seo = new Seo_Helper();
        $seo->matches();
        $seo->trigger_router();
          
    }
}
