<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * ExpressionEngine REST Class
 *
 * @package       ExpressionEngine
 * @subpackage    REST
 * @category      REST
 * @author        Adeel
 * @link        
 */

require_once(APPPATH.'libraries/rest/Core.php');
 
class Rest extends REST_Core {
    
    protected $EE;
    protected $_config = '';
    protected $_user = '';
    protected $_password = '';
    protected $_url = '';
    protected $_session_name = 'crm_rest_session';
    
    function __construct(){
        $this->EE =& get_instance();     
        
        $this->config = $this->EE->config->item('crm');
        $this->config = $this->config['rest'];
        
        $this->_url = $this->config['url'];
        $this->_user = $this->config['user'];
        $this->_password = $this->config['password'];
    }
    
    private function call($method, $params, $url){
     

        session_start();
        $rest_session = $_SESSION[$this->_session_name];
        
        if (!$rest_session){
            $rest_session = $this->login();
    
            $_SESSION[$this->_session_name] = $rest_session;
        }
        


        $params['session'] = $rest_session;

        
        return $this->api_call($method, $params, $url);
    }
    
    public function login(){
        
        $login_parameters = array(
             "user_auth"=>array(
                  "user_name"=>$this->_user,
                  "password"=>md5($this->_password),
                  "version"=>"1"
             ),
             "application_name"=>"RestTest",
             "name_value_list"=>array(),
        );
        //$login_parameters = json_encode($login_parameters);
        $login_result = $this->api_call("login", $login_parameters, $this->_url);
        //get session id
        $session_id = $login_result->id;
        
        return $session_id;
    }
    //function to make cURL request
    
    public function set_entry($params){     
        /*
            *params*
            * session id
            * module_name
            * name_value_list : array(   array('name' => 'name', 'value' => 'val'), ... ,)
         */
        $defaults = array(
                        'session' => '',
                        'module_name' => '',
                        'name_value_list' => array()
                    );
        foreach($defaults as $key => $value){
            if (array_key_exists($key, $params)){
                $defaults[$key] = $params[$key];
            }
        }
        
        $set_entry_result = $this->call("set_entry", $defaults, $this->_url);
        
        return  $set_entry_result;
    }
    
    public function set_entries($params){     
        /*
            *params*
            * session id
            * module_name
            * name_value_list : array(   array('name' => 'name', 'value' => 'val'), ... ,)
         */
        $defaults = array(
                        'session' => '',
                        'module_name' => '',
                        'name_value_list' => array()
                    );
        foreach($defaults as $key => $value){
            if (array_key_exists($key, $params)){
                $defaults[$key] = $params[$key];
            }
        }
        
        $set_entry_result = $this->call("set_entries", $defaults, $this->_url);

        return  $set_entry_result;
    }
    
    public function set_relationship($params){
        /*
            *params*
            * session
            * module_name
            * module_id
            * link_field_name 
            * related_ids : array
            * name_value_list : array
            * delete
        */
        
        $defaults = array(
                        'session' => '',
                        'module_name' => '',
                        'module_id' => '',
                        'link_field_name' => '',
                        'related_ids' => array(),
                        'name_value_list' => array(),
                        'delete' => ''
                    );
        foreach($defaults as $key => $value){
            if (array_key_exists($key, $params)){
                $defaults[$key] = $params[$key];
            }
        }
        $set_relationship_result = $this->call("set_relationship", $defaults, $this->_url);
        
        return $set_relationship_result;
    }
    
    public function set_relationships($params){
        /*
            *params*
            * session
            * module_names
            * module_id s
            * link_field_names 
            * related_ids : array
            * name_value_lists : array
            * delete_array
        */
        
        $defaults = array(
                        'session' => '',
                        'module_names' => array(),
                        'module_ids' => array(),
                        'link_field_names' => array(),
                        'related_ids' => array(),
                        'name_value_lists' => array(),
                        'delete_array' => array()
                    );
        foreach($defaults as $key => $value){
            if (array_key_exists($key, $params)){
                $defaults[$key] = $params[$key];
            }
        }
        $set_relationships_result = $this->call("set_relationships", $defaults, $this->_url);
        
        return $set_relationships_result;
    }
    
    public function get_module_fields($params){
        /*
            *params*
            * session
            * module_name
            * fields
            * return
              Retrieves variable definitions (vardefs) for fields of the specified SugarBean.
        */
        
        $defaults = array(
                        'session' => '',
                        'module_name' => '',
                        'fields' => ''
                    );
        foreach($defaults as $key => $value){
            if (array_key_exists($key, $params)){
                $defaults[$key] = $params[$key];
            }
        }
        $set_relationship_result = $this->call("get_module_fields", $defaults, $this->_url);
        
        return $set_relationship_result;
    }    

	public function save_invoice_acc_sales($params){

        $username = $this->_user;  
        $password = $this->_password;  
        $auth_url = 'http://dev.crm.com/rest/v11_8/oauth2/token';

        $oauth2_token_arguments = array(
            "grant_type" => "password",
            "client_id" => "sugar",
            "client_secret" => "",
            "username" => $username,
            "password" => $password,
            "platform" => "base"
        );

        $curl_request = curl_init($auth_url);
        curl_setopt($curl_request, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
        curl_setopt($curl_request, CURLOPT_HEADER, false);
        curl_setopt($curl_request, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl_request, CURLOPT_FOLLOWLOCATION, 0);
        curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json"
        ));
        $json_arguments = json_encode($oauth2_token_arguments);
        curl_setopt($curl_request, CURLOPT_POSTFIELDS, $json_arguments);
        $curl_response = curl_exec($curl_request);
        
        $oauth2_token_response_obj = json_decode($curl_response);
        $oauth_token = $oauth2_token_response_obj->access_token;
        curl_close($curl_request); //fixed // customized

        $url = 'http://dev.crm.com/rest/v11_8/accounting/saveinvoice';
        $curl_request = curl_init($url);

        curl_setopt($curl_request, CURLOPT_POST, 1);
        curl_setopt($curl_request, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
        curl_setopt($curl_request, CURLOPT_HEADER, false);
        curl_setopt($curl_request, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl_request, CURLOPT_FOLLOWLOCATION, 0);
        curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
            "Content-Type: application/json",
            "oauth-token: {$oauth_token}"
        ));

        $json_arguments = json_encode($params);
     
        curl_setopt($curl_request, CURLOPT_POSTFIELDS, $json_arguments);
        $curl_response = curl_exec($curl_request);
        
        $createdRecord = json_decode($curl_response);
        
        



        

        curl_close($curl_request);


        return $createdRecord;
	}
} 