<?php
/**
 * ©[2016] SugarCRM Inc.  Licensed by SugarCRM under the Apache 2.0 license.
 */

namespace SugarAPI\SDK\Request\Interfaces;

interface RequestInterface
{
    /**
     * Set the HTTP Method the Request object will use
     * @param string $type
     * @return self
     */
    public function setType($type);

    /**
     * Get the HTTP Method of the Request object
     * @return string
     */
    public function getType();

    /**
     * Set the Body to Request
     * @param mixed
     * @return self
     */
    public function setBody($array);

    /**
     * Get the Body on the request
     * @return array
     */
    public function getBody();

    /**
     * Add a Header to the Request Headers property, doesn't Set the CURL Option until Sending
     * @param string - Header Name
     * @param string - Header Value
     * @return self
     */
    public function addHeader($name, $value);

    /**
     * Sets the Headers on the Curl Request object, called during Sending. Appends to Request Headers property
     * @param array $array
     * @return \SugarAPI\SDK\Request\Interfaces\RequestInterface
     */
    public function setHeaders(array $array);

    /**
     * Get the Headers configured on the Request Object
     * @return array - Headers Property
     */
    public function getHeaders();

    /**
     * Get the CURL Resource
     * @return Curl Resource
     */
    public function getCurlObject();

    /**
     * Set an Option on the Curl Resource
     * @param mixed $option - Curl Option
     * @param mixed $value - Curl Option Value
     * @return self
     */
    public function setOption($option, $value);

    /**
     * Get the list of Options set on the Curl Resource
     * @return array
     */
    public function getOptions();

    /**
     * Set the URL on the Request Object
     * @param string $url
     * @return self
     */
    public function setURL($url);

    /**
     * Get the URL configured on the Request Object
     * @return string
     */
    public function getURL();

    /**
     * Execute the Curl Request. Before sending, Headers are added to the Curl Object
     * @return self
     */
    public function send();

    /**
     * Get the Curl Response Object generated by the Curl Request
     * @return Curl Response Resource
     */
    public function getCurlResponse();

    /**
     * Initialize Curl Resource
     * @return self
     */
    public function start();

    /**
     * Close the Curl Resource
     * @return self
     */
    public function close();

    /**
     * Close and Restart the Curl Resource
     * @return self
     */
    public function reset();

    /**
     * Get the Status of the Curl Object
     * @return string - Initialized, Sent or Closed
     */
    public function getCurlStatus();
}
