<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once(PATH_MOD . 'member/models/adaptor_db_result.php');

class Portal_Auth extends Auth{
    
    protected $EE = '';
    function __construct(){
        
        parent::__construct();
        
        $this->EE =& get_instance();
        $this->EE->load->model('contacts');
    }
    private function _portal_authenticate(Adaptor_Db_Result $member, $password){
        
        $always_disallowed = array(4);

        if ($member->num_rows() !== 1)
        {
            return FALSE;
        }

        if (in_array($member->row('group_id'), $always_disallowed))
        {
            return $this->EE->output->show_user_error('general', lang('mbr_account_not_active'));
        }

        $m_pass = $member->row('password');
        

        if ($m_pass !== $password)
        {
            return FALSE;
        }
        

        
        $authed = new Auth_result($member->row());
        $member->free_result();
        
        return $authed;
    }
    
    public function authenticate_username($username, $password)  
    {

        $contacts = $this->EE->contacts;
        $_contact = array();
        
        if (!empty($username)){
            $selects = "{#c}.id_c as id,{#c}.username_c,{#c}.password_c,{#c}.invalid_username_c,{#c}.failed_logins_c,{#c}.email_c,{#c}.locked_c,{#c}.hostile_c,{#c}.first_time_c,{#c}.initial_c,{#c}.gender_c,{#c}.photo_thumb_c,{#c}.prof_photo_c";
            $where = "{#c}.username_c='$username'";
            $params = array();
            $params['selects'] = $selects;
            $params['where'] = $where;
            $cstm = $contacts->get_cstm_data($params, false);
            
            $selects = "{#m}.id,{#m}.first_name,{#m}.last_name,{#m}.salutation,{#c}.*";
            $params = array();
            $params['joins'] = array(
                                    "{#c}" => array(
                                        'sql' => $cstm['sql'],
                                        'table' => $cstm['table'],
                                        'type' => 'inner'
                                    )
                                 );
            $params['selects'] = $selects;
            $params['single'] = true;
            $_contact = $contacts->get_contacts($params);
        }
        
        $member = new Adaptor_Db_Result($_contact);

        $member_data = $member->row_array();

        // if($_SERVER['REMOTE_ADDR'] == '103.6.219.60'){
        //     var_dump("</br>");
        //     var_dump("portal");
        //     var_dump($member_data);
        //     var_dump($_contact);
        // }
        
        $ee_member = $this->EE->db->get_where('members', array('username' => $username)); 
        if ($ee_member->num_rows() == 0){
            // $insert = $this->EE->db->insert_string('members', $member_data);
            // $this->EE->db->query($insert);
            
            // $ee_member = $this->EE->db->get_where('members', array('username' => $username));
            // $temp = $ee_member->row_array();
            // $member_id = $temp['member_id'];
            
            // $insert = $this->EE->db->insert_string('member_data', array('member_id' => $member_id));
            // $this->EE->db->query($insert);

            $member_data["salt"]= "xxxx";
            $insert = $this->EE->db->insert_string('members', $member_data);
            // var_dump($this->EE->db->query($insert));
            $this->EE->db->query($insert);

            
            $ee_member = $this->EE->db->get_where('members', array('username' => $username));
            $temp = $ee_member->row_array();
            $member_id = $temp['member_id'];
            
            $insert = $this->EE->db->insert_string('member_data', array('member_id' => $member_id));
            $this->EE->db->query($insert);
        }
            
        $member->updateMember($ee_member, $_contact); 
        $member_data = $member->row_array();
        
        $ee_member->free_result();
        
        $auth = $this->_portal_authenticate($member, $password);


        
        if (!$auth){
           
           require_once(PATH_MOD . 'member/app/sequences/processing.php');
           $processing = new Processing();
           
           if ($member_data['member_id'] == 0){    
               $this->EE->load->library('template', NULL, 'TMPL');
               $swaps = array(
                 'message' => 'message'
               );
               $datas = array(
                   'message' => "Username and Password combination is invalid. Please try again.",
                   'user_id' =>  $_contact['username_c'],
                    'user_email' => $_contact['email_c']
                   );
               // $this->EE->TMPL->run_template_engine('login', 'invalid_login');
               // $this->EE->output->app_output($swaps, $datas);
               
                // require_once(PATH_THIRD . 'person/models/processing.php');
                // $processing = new MProcessing();
                // $processing->go_welcome_page($datas);
                require_once(PATH_THIRD . 'mdentevents/models/processing.php');

                $processing = new DEProcessing();
                $processing->initialize('dentevents:home:show');
                $processing->process($datas);
           }else{
               $processing->process_invalid_password($_contact['id']);
           } 
        }else{
           require_once(PATH_MOD . 'member/app/sequences/processing.php');
           $processing = new Processing(); 
           $processing->process_valid_password($_contact['id']);
        }
        
        return $auth;
    }
    
    public function get_user_access($contact_id){
        $contacts = $this->EE->contacts;
        $_contact = array();
        
        if (!empty($contact_id)){
            $selects = "{#c}.id_c as id,{#c}.username_c,{#c}.password_c";
            $where = "{#c}.id_c='$contact_id'";
            $params = array();
            $params['selects'] = $selects;
            $params['where'] = $where;
            $cstm = $contacts->get_cstm_data($params, false);
            
            $selects = "{#m}.id,{#m}.first_name,{#m}.last_name,{#m}.salutation,{#c}.*";
            $params = array();
            $params['joins'] = array(
                                    "{#c}" => array(
                                        'sql' => $cstm['sql'],
                                        'table' => $cstm['table'],
                                        'type' => 'inner'
                                    )
                                 );
            $params['selects'] = $selects;
            $params['single'] = true;
            $_contact = $contacts->get_contacts($params);
        }
        $username = $_contact['username_c'];
        $password = $_contact['password_c'];
        
        return array('username' => $username, 'password' => $password);
    }
    
    public function authenticate_contact($username, $password){
        $contacts = $this->EE->contacts;
        $_contact = array();
        
        if (!empty($username)){
            $selects = "{#c}.id_c as id,{#c}.username_c,{#c}.password_c,{#c}.failed_logins_c,{#c}.email_c,{#c}.locked_c,{#c}.hostile_c,{#c}.first_time_c,{#c}.initial_c,{#c}.gender_c,{#c}.photo_thumb_c,{#c}.prof_photo_c";
            $where = "{#c}.username_c='$username'";
            $params = array();
            $params['selects'] = $selects;
            $params['where'] = $where;
            $cstm = $contacts->get_cstm_data($params, false);
            
            $selects = "{#m}.id,{#m}.first_name,{#m}.last_name,{#m}.salutation,{#c}.*";
            $params = array();
            $params['joins'] = array(
                                    "{#c}" => array(
                                        'sql' => $cstm['sql'],
                                        'table' => $cstm['table'],
                                        'type' => 'inner'
                                    )
                                 );
            $params['selects'] = $selects;
            $params['single'] = true;
            $_contact = $contacts->get_contacts($params);
        }
        
        $member = new Adaptor_Db_Result($_contact);
        $member_data = $member->row_array();
        
        $ee_member = $this->EE->db->get_where('members', array('username' => $username));
        if ($ee_member->num_rows() == 0 && $member_data['member_id'] != 0){
            $insert = $this->EE->db->insert_string('members', $member_data);
            $this->EE->db->query($insert);
            
            $ee_member = $this->EE->db->get_where('members', array('username' => $username));
            $temp = $ee_member->row_array();
            $member_id = $temp['member_id'];
            
            $insert = $this->EE->db->insert_string('member_data', array('member_id' => $member_id));
            $this->EE->db->query($insert);
        }else{
            $member->updateMember($ee_member, $_contact); 
        }

        $ee_member->free_result();
        
        $auth = $this->_portal_authenticate($member, $password);
       
        return $auth;
    }
    
    
}