<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_FTS_Confirm_Contacts extends Processing_First_Time_Sequence{

    function __construct(){
        parent::__construct(); 
    }
    public function process_back(){
        $contact_id = $this->EE->input->get_post('CID');
        
        $this->go_preferred_name($contact_id, 'confirm_contacts');
    }
    
    public function process_confirm(){
        $contact_id = $this->EE->input->get_post('CID');
        $phone_mobile = $this->EE->input->get_post('phone_mobile');
        $email = $this->EE->input->get_post('personal_email');
        
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id,{#c}.email_c,{#c}.rego_no_c,{#c}.rego_no_nz_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.phone_mobile,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);
        
        $email1 = $contacts->get_email_address($contact_id);
        $crm_email_c = $_contact['email_c'];
        $crm_phone_mobile = $_contact['phone_mobile'];
        $rego_no_c = $_contact['rego_no_c'];
        $rego_no_nz_c = $_contact['rego_no_nz_c'];
        
        $datas = array('id' => $contact_id);
        if ($phone_mobile != ''){
            $datas['phone_mobile'] = $phone_mobile;
        }
        if ($email != ''){
            $datas['email_c'] = $email;
        }
        if ($email1 == ''){
            $datas['email1'] = $email;
        }
        $success = $this->contacts->set_record($datas);
        if (!$success){
            $this->logger->developer("Failed to update emails and phone on Confirm Contacts.");
            return false;
        }
        
        if ($crm_email_c != $email){
            $datas = array(
                    'name' => 'Personal Email updated in the first time',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => "Personal Email changed from $crm_email_c to $email during the First Time Sequence.",
                    'contact_id' => $contact_id,
				    'message_no_c' => 'MSL1028'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for FTS-confirm contacts.");
                return false;
            }              
        }
        if ($crm_phone_mobile != $phone_mobile){
            $datas = array(
                    'name' => 'Mobile phone updated in first time',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => "Mobile Phone changed from $crm_phone_mobile to $phone_mobile during the First Time Sequence.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1029'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for FTS-confirm contacts.");
                return false;
            }              
        }
  
        require_once(PATH_MOD . 'member/app/sequences/FTS/confirm_registration.php');
        $processing = new Processing_FTS_Confirm_Registration();
        
        if ( empty($rego_no_c) && empty($rego_no_nz_c) ){
            $processing->go_fts_nine($contact_id);
        }else{
            $processing->go_fts_ten($contact_id);
        }
        /*
                
        UPDATE email_addresses SET email_address='jjj@coj.cn', invalid_email=0, opt_out=0, date_modified='2013-06-06 10:06:46' WHERE id='848b2ae4-e1e0-5f62-9df0-51b05dcf0162'  
        
        select *  from email_addr_bean_rel eabr WHERE eabr.bean_id = '1000ed48-1ef1-853b-5f28-4e456ed4ced7' AND eabr.bean_module = 'Contacts' and eabr.deleted=0
        /* email_address_id
        */
    }
}