<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_FTS_Confirm_Name extends Processing_First_Time_Sequence{

    function __construct(){
        parent::__construct(); 
    }
    
    function process_confirm(){
        $action_id =  $this->EE->input->get_post('ACT');
        $contact_id = $this->EE->input->get_post('CID');
        $fts_id = $this->EE->input->get_post('FTS_ID');
        $in_salutation = $this->EE->input->get_post('salutation');
        $in_firstname = $this->EE->input->get_post('firstname');
        $in_initial = $this->EE->input->get_post('initial');
        $in_gender = $this->EE->input->get_post('gender');
        
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id,{#c}.gender_c,{#c}.initial_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);
        
        $salutation = $_contact['salutation'];
        $gender_c = $_contact['gender_c'];
        $firstname = $_contact['first_name']; 
        $lastname = $_contact['last_name'];
        $initial_c = $_contact['initial_c'];       
       
        $updates = array();
        if ($in_firstname != null && $in_firstname != ''){
            $datas = array(
                'name' => 'First Name changed in the first time sequence',
                'status' => 'Completed',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'Low',
                'message_type_c' => 'System',
                'description' => "First Name changed from $firstname to $in_firstname during the First Time Sequence.",
                'contact_id' => $_contact['id'],
				'message_no_c' => 'MSL1022'
            );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for First Time Sequence Commenced.");
                return false;
            }     
            $updates['first_name'] = $in_firstname;       
        }         
        if ($in_salutation != null && $in_salutation != $salutation){
            $datas = array(
                'name' => 'Salutation updated in first time sequence',
                'status' => 'Completed',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'Low',
                'message_type_c' => 'System',
                'description' => "Salutation changed from $salutation to $in_salutation during the First Time Sequence.",
                'contact_id' => $_contact['id'],
				'message_no_c' => 'MSL1021'
            );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for First Time Sequence Commenced.");
                return false;
            }  
            
            $updates['salutation'] = $in_salutation;
        }
        if ($in_gender != null && $in_gender != $gender_c){
            $datas = array(
                'name' => 'Gender changed in the first time sequence',
                'status' => 'Completed',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'Low',
                'message_type_c' => 'System',
                'description' => "Gender changed from $gender_c to $in_gender during the First Time Sequence.",
                'contact_id' => $_contact['id'],
				'message_no_c' => 'MSL1024'
            );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for First Time Sequence Commenced.");
                return false;
            }      
            
            $updates['gender_c'] = $in_gender;        
        }
        
        if ($in_initial != null && $in_initial != ''){
            $datas = array(
                'name' => 'Middle Initial added in first time sequence',
                'status' => 'Completed',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'Low',
                'message_type_c' => 'System',
                'description' => "Middle Initial -$in_initial- added during the First Time Sequence.",
                'contact_id' => $_contact['id'],
				'message_no_c' => 'MSL1023'
            );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for First Time Sequence Commenced.");
                return false;
            }             
            
            $updates['initial_c'] = $in_initial;
        }
        
        if (count($updates) > 0){
            $updates['id'] = $_contact['id'];
            $success = $this->contacts->set_record($updates);
            if (!$success){
                $this->logger->developer("Failed to update contact on $fts_id");
            }
        }

        $this->go_preferred_name($contact_id, 'fts_normal');
    }
    
    function process_not_me(){
        $contact_id = $this->EE->input->get_post('CID');
        
        $success = $this->contacts->set_record(array('id' => $contact_id, 'locked_c' => 'yes', 'invalid_username_c' => 1));
        if (!$success){
            $this->logger->developer("Failed to set the locked_c to 0 on this is not me");
            return false;
        }
        
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);
        
        $salutation = $_contact['salutation'];
        $firstname = $_contact['first_name']; 
        $lastname = $_contact['last_name'];

        $datas = array(
                'name' => 'Account has been locked',
                'status' => 'In Progress',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'High',
                'message_type_c' => 'System',
                'description' => "$salutation $firstname $lastname 's account was locked during the First Time Sequence as the This Is Not Me link was clicked.",
                'contact_id' => $contact_id,
			    'message_no_c' => 'MSL1026'
            );
        $success = $this->tasks->set_record($datas);
        if (!$success){
            $this->logger->developer("Failed to create the task for First Time Sequence Commenced.");
            return false;
        }  
        
		$action_id = $this->helper->fetch_action_id('Member', 'contacting_support');
            
        $swaps = array(
                        'AID' => 'AID',
			            'CID' => 'CID'
                    );
        $datas = array(
                        'AID' => $action_id,
			            'CID' => $contact_id
                    );
        $this->EE->TMPL->run_template_engine('login', 'account_disabled');
        $this->EE->output->app_output($swaps, $datas);       
    }
    
    function process_incorrect_name(){
        $contact_id = $this->EE->input->get_post('CID');
        $this->go_incorrect_name($contact_id);
    }
    
    public function process_request(){
        $contact_id = $this->EE->input->get_post('CID');
        
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id,{#c}.initial_c,{#c}.username_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);
         
        $crm_firstname = $_contact['first_name'];
        $crm_lastname = $_contact['last_name'];
        $crm_initial_c = $_contact['initial_c'];
        $crm_salutation = $_contact['salutation'];     
        $username = $_contact['username_c'];   
        
        $firstname = $this->EE->input->get_post('firstname');
        $lastname = $this->EE->input->get_post('lastname');
        $initial_c = $this->EE->input->get_post('initial');
        $salutation = $this->EE->input->get_post('salutation');

        
        if ($firstname != $crm_firstname ||
            $lastname != $crm_lastname ||
            $initial_c != $crm_initial_c ||
            $salutation != $crm_salutation ){
             
			 $datas = array();
             $datas[] = array(
                'name' => 'Minor name change requested',
                'status' => 'In Progress',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'Medium',
                'message_type_c' => 'System',
                'description' => "$username has requested a minor name change as follows:
                                  Salutation : $salutation
                                  First Name : $firstname
                                  Initial : $initial_c
                                  Last Name : $lastname 
                                 ",
                'contact_id' => $contact_id,
				'message_no_c' => 'MSL1025'
            );
			$datas[] = array(
                'name' => 'Minor name change request being reviewed',
                'status' => 'In Progress',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'Medium',
                'message_type_c' => 'Alert',
                'description' => "Your request for a minor change to your name is currently being reviewed. If you are a registered practitioner, your name must match the name you are registered under. You can select a Preferred Name to replace your first name and middle initial at any time by selecting Personal Details from the Update Menu.",
                'contact_id' => $contact_id,
				'message_no_c' => 'MAL1025'
            );

            $success = $this->tasks->set_records($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Request of Incorrect name.");
                return false;
            }     
                
        }

        $this->go_preferred_name($contact_id, 'fts_incorrect');
    }
    public function process_cancel(){
        $contact_id = $this->EE->input->get_post('CID');
        
        $this->go_fts_page($contact_id);
    }
    public function process_preferred_name(){
        $contact_id = $this->EE->input->get_post('CID');
                
        $this->go_preferred_name($contact_id, 'fts_incorrect');
    }
}