<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_FTS_Confirm_Registration_Confirmation extends Processing_FTS_Confirm_Registration{

    function __construct(){
        parent::__construct(); 
    }
    
    function go_page($contact_id){    
        $contacts = $this->EE->contacts;

		$selects = "{#c}.id_c as id,{#c}.account_id_c,{#c}.email_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);
        $principal_ac = $_contact['account_id_c'];
        $salutation = $_contact['salutation'];
        $firstname = $_contact['first_name']; 
        $lastname = $_contact['last_name'];
        $email_c = $_contact['email_c'];
         
        if (empty($principal_ac)){
            $selects = '{#m}.id,{#m}.name';
           
            $params = array(
                        'id' => $contact_id,
                        'selects' => $selects,
                        'single' => true
                     );
            $account = $contacts->get_relationship_accounts($params);
           
            if (!empty($account)){
                $updates['id'] = $contact_id;
                $updates['account_id_c'] = $account['id'];
                $account_name = $account['name'];
                
                $contacts->set_record($updates);   
                

                $datas = array(
                    'name' => 'Principal Practice automatically set',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Medium',
                    'message_type_c' => 'Alert',
                    'description' => "$account_name has automatically been set as your Principal Practice for correspondence, such as the delivery of magazine subscriptions. <a href='#' class='alert-links MAL1010'>Click here</a> to choose a different Principal Practice.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MAL1010'
                );
                $success = $this->tasks->set_record($datas);
                if (!$success){
                    $this->logger->developer("Failed to create the task for Confirm_Registration FTS_confirmation.");
                    return false;
                }   
            }else{
                $datas = array(
                    'name' => 'Principal Practice missing',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Medium',
                    'message_type_c' => 'Alert',
                    'description' => "You are currently not linked to any Practices or Organizations. Please <a href='#' class='alert-links MAL1040'>click here</a> to select where you work.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MAL1040'
                );
                $success = $this->tasks->set_record($datas);
                if (!$success){
                    $this->logger->developer("Failed to create the task for Confirm_Registration FTS_confirmation.");
                    return false;
                }
            }
        }
        
        /// create tasks ///
        $datas = array();
        $datas[] = array(
                        'name' => 'Account Locked pending email verification',
                        'status' => 'In Progress',
                        'date_entered' => date("F j, Y, g:i a"),
                        'priority' => 'High',
                        'message_type_c' => 'System',
                        'description' => "The Account has been locked pending verification of personal email address.",
                        'contact_id' => $contact_id,
                        'message_no_c' => 'MSL1042'
                    );
        $datas[] = array(
                        'name' => 'Your Account has been Locked',
                        'status' => 'In Progress',
                        'date_entered' => date("F j, Y, g:i a"),
                        'priority' => 'High',
                        'message_type_c' => 'Alert',
                        'description' => "Your Account has been locked pending verification of your personal email address. Please check your email account for the verification email.",
                        'contact_id' => $contact_id,
                        'message_no_c' => 'MAL1042'
                    );
        $success = $this->tasks->set_records($datas);
        if (!$success){
            $this->logger->developer("Failed to create the task for Confirm_Registration FTS_confirmation.");
            return false;
        }
        ////////////////////
        
        $contacts->set_record(array('id' => $contact_id, 'first_time_c' => 'no'));  
        
        $datas = array(
                    'name' => 'First Time Sequence completed',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => "$salutation $firstname $lastname has completed the First Time Sequence",
                    'contact_id' => $contact_id,
                    'message_no_c' => 'MSL1043'
        );
        $success = $this->tasks->set_record($datas);
        if (!$success){
            $this->logger->developer("Failed to create the task for Confirm_Registration FTS_confirmation.");
            return false;
        }
        
        $datas = array(
                    'name' => 'You have been sent an email to verify your account',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'High',
                    'message_type_c' => 'Alert',
                    'description' => "A verification email has been sent to $email_c. Please click the link contained in this email to unlock your account.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MAL1041'
        );
        $success = $this->tasks->set_record($datas);
        if (!$success){
            $this->logger->developer("Failed to create the task for Confirm_Registration FTS_confirmation.");
            return false;
        }

        require_once(PATH_MOD . 'member/app/sequences/processing.php');
        $processing = new Processing(); 
        $processing->goto_terms($contact_id);
       
        /*********session build************************/ 
        if ( ! class_exists('Member_auth'))
        {
            require PATH_MOD.'member/mod.member_auth.php';
        }

        $MA = new Member_auth();
        $MA->do_contact_auth($contact_id);
        /*****************************************/
        
        $swaps = array(
                    'email' => 'email'
                );
        $datas = array(
                    'email' => $email_c
                );
        $this->EE->TMPL->run_template_engine('login', 'fts_confirm_welcome');
        $this->EE->output->app_output($swaps, $datas);        
        
    }
   
}