<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_FTS_Confirm_Registration_Eleven extends Processing_FTS_Confirm_Registration{

    function __construct(){
        parent::__construct(); 
    }
    private function _check_duplicate_DBA($number, $contact_id){
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id";
        $where = "{#c}.rego_no_c='$number' and {#c}.id_c != '$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);
        if (!empty($_contact)){
            return true;
        }
        
        return false;
    }
    function go_page($contact_id){
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id,{#c}.employ_type_c,{#c}.year_grad_c,{#c}.quals_c,{#c}.rego_no_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);  
        
        $employ_type_c = $_contact['employ_type_c'];
        $year_grad_c= $_contact['year_grad_c'];
        $quals_c = $_contact['quals_c'];
        $rego_no_c = $_contact['rego_no_c'];
        $rego_no_c = ltrim($rego_no_c, 'DEN');
        
        $employ_type_html = $contacts->render_field_dropdown('employ_type_c', $employ_type_c);  
        
        $years = array();
        $now_year = date("Y") * 1;
        for($i = 1930; $i <= $now_year; $i++){
            $years[$i] = $i;
        }
        $year_grad_html = $this->helper->make_select_opts($years, array($year_grad_c));

        $action_id = $this->helper->fetch_action_id('Member', 'fts_confirm_registration_eleven');
        
        $swaps = array(
                    'AID' => 'AID',
                    'CID' => 'CID',
                    'employ_type_html' => 'employ_type_html',
                    'year_grad_html' => 'year_grad_html',
                    'quals' => 'quals',
                    'rego_no' => 'rego_no'
                );
        $datas = array(
                    'AID' => $action_id,
                    'CID' => $contact_id,
                    'employ_type_html' => $employ_type_html,
                    'year_grad_html' => $year_grad_html,
                    'quals' => $quals_c,
                    'rego_no' => $rego_no_c                    
                 );    

        $this->EE->TMPL->run_template_engine('login', 'fts_confirm_registration_eleven');
        $this->EE->output->app_output($swaps, $datas);        
    }
    
    public function process_back(){
        $contact_id = $this->EE->input->get_post('CID');
        
        require_once(PATH_MOD . 'member/app/sequences/FTS/preferred_name.php');
        $processing = new Processing_FTS_Preferred_Name();
        $processing->go_confirm_contacts($contact_id);
    }
    
    public function process_confirm(){
        $contact_id = $this->EE->input->get_post('CID');
        $employ_type = $this->EE->input->get_post('employ_type');
        $year_grad = $this->EE->input->get_post('year_grad');
        $quals = $this->EE->input->get_post('quals');
        $rego_no = 'DEN' . $this->EE->input->get_post('rego_no');
        
        if($this->_check_duplicate_DBA($rego_no, $contact_id)){
            $datas = array(
                    'name' => 'Duplicate DBA Rego Number Entered',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'High',
                    'message_type_c' => 'System',
                    'description' => "Duplicate DBA Registration Number $rego_no entered. Please investigate.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1038'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Confirm_Registration FTS11.");
                return false;
            } 
        }
        
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id,{#c}.employ_type_c,{#c}.year_grad_c,{#c}.quals_c,{#c}.rego_no_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);  
        
        $crm_employ_type_c = $_contact['employ_type_c'];
        $crm_year_grad_c = $_contact['year_grad_c'];
        $crm_rego_no_c = $_contact['rego_no_c'];
        $crm_quals_c = $_contact['quals_c'];
        
        $updates = array('id' => $contact_id);
        
        if($rego_no != $crm_rego_no_c){
            $datas = array(
                    'name' => 'DBA Rego No added in first time sequence',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'High',
                    'message_type_c' => 'System',
                    'description' => "DBA Rego number added during the First Time Sequence. PLEASE CONFIRM!",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1036'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Confirm_Registration FTS11.");
                return false;
            }
            $updates['rego_no_c'] = $rego_no;
        }
        
        if($employ_type != $crm_employ_type_c){
            $datas = array(
                    'name' => 'Employment Status updated in first time',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => "Employment Status changed from $crm_employ_type_c to $employ_type during the First Time Sequence.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1030'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Confirm_Registration FTS11.");
                return false;
            }
            $updates['employ_type_c'] = $employ_type;
        }
        if($year_grad != $crm_year_grad_c){
            $datas = array(
                    'name' => 'Year of Graduation updated in first time',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => "Year of Graduation changed from $crm_year_grad_c to $year_grad during the First Time Sequence.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1031'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Confirm_Registration FTS11.");
                return false;
            }
            $updates['year_grad_c'] = $year_grad;
        }
        if($quals != $crm_quals_c){
            $datas = array(
                    'name' => 'Qualifications updated in first time',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => "Qualifications changed from $crm_quals_c to $quals during the First Time Sequence.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1032'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Confirm_Registration FTS11.");
                return false;
            }
            $updates['quals_c'] = $quals;
        }
        
        if (count($updates) > 1){
            $contacts->set_record($updates);
        }
        $this->go_confirmation($contact_id);
    }
}