<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_FTS_Confirm_Registration_Nine extends Processing_FTS_Confirm_Registration{

    function __construct(){
        parent::__construct(); 
    }

    function go_page($contact_id){
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id,{#c}.rego_domain_c,{#c}.pract_type_c,{#c}.pract_type_nz_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);  
        
        $rego_domain_c = $_contact['rego_domain_c'];
        $pract_type_c = $_contact['pract_type_c'];
        $pract_type_nz_c = $_contact['pract_type_nz_c'];
        
        $rego_domain_html = $contacts->render_field_dropdown('rego_domain_c', $rego_domain_c);      
        $pract_type_html = $contacts->render_field_dropdown('pract_type_c', $pract_type_c, true);      
        $pract_type_nz_html = $contacts->render_field_dropdown('pract_type_nz_c', $pract_type_nz_c, true); 


        $action_id = $this->helper->fetch_action_id('Member', 'fts_confirm_registration_nine');
        
        $swaps = array(
                    'AID' => 'AID',
                    'CID' => 'CID',
                    'rego_domain_html' => 'rego_domain_html',
                    'pract_type_html' => 'pract_type_html',
                    'pract_type_nz_html' => 'pract_type_nz_html'
                );
        $datas = array(
                    'AID' => $action_id,
                    'CID' => $contact_id,
                    'rego_domain_html' => $rego_domain_html,
                    'pract_type_html' => $pract_type_html,
                    'pract_type_nz_html' => $pract_type_nz_html                    
                 ); 

        $this->EE->TMPL->run_template_engine('login', 'fts_confirm_registration_nine');
        $this->EE->output->app_output($swaps, $datas);        
    }
    
    public function process_back(){
        $contact_id = $this->EE->input->get_post('CID');
        
        require_once(PATH_MOD . 'member/app/sequences/FTS/preferred_name.php');
        $processing = new Processing_FTS_Preferred_Name();
        $processing->go_confirm_contacts($contact_id);
    }
    
    public function process_confirm(){
        $contact_id = $this->EE->input->get_post('CID');
        $rego_domain = $this->EE->input->get_post('rego_domain');
        $pract_type = $this->EE->input->get_post('pract_type');
        $pract_type_nz = $this->EE->input->get_post('pract_type_nz');
        
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id,{#c}.rego_domain_c,{#c}.pract_type_c,{#c}.pract_type_nz_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);  
        
        $crm_rego_domain_c = $_contact['rego_domain_c'];
        $crm_pract_type_c = $_contact['pract_type_c'];
        $crm_pract_type_nz_c = $_contact['pract_type_nz_c'];
        
        $crm_pract_type_c = str_replace('^', '', $crm_pract_type_c);
        $crm_pract_type_c = explode(',', $crm_pract_type_c);
        
        $crm_pract_type_nz_c = str_replace('^', '', $crm_pract_type_nz_c);
        $crm_pract_type_nz_c = explode(',', $crm_pract_type_nz_c);
        
        $updates = array('id' => $contact_id);
        
        if($rego_domain != $crm_rego_domain_c){
            $datas = array(
                    'name' => 'Country of Residence changed in first time',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => "Country of Residence changed from $crm_rego_domain_c to $rego_domain during the First Time Sequence.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1033'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Confirm_Registration FTS9.");
                return false;
            }
            $updates['rego_domain_c'] = $rego_domain;
        }
        if(strtolower($rego_domain)  == 'new zealand'){
            if(count(array_diff($pract_type_nz, $crm_pract_type_nz_c)) > 0){
                $pract_type_str = implode(',', $pract_type_nz);
                $crm_pract_type_str = implode(',', $crm_pract_type_nz_c);
                
                $datas = array(
                    'name' => 'Practitioner Type NZ updated in first time',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'High',
                    'message_type_c' => 'System',
                    'description' => "Practitioner Type NZ changed from $crm_pract_type_str to $pract_type_str.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1035'
                );
                $success = $this->tasks->set_record($datas);
                if (!$success){
                    $this->logger->developer("Failed to create the task for Confirm_Registration FTS9.");
                    return false;
                }
                
                $temp = array();
                foreach($pract_type_nz as $type){
                    $temp[] = "^$type^";
                }
                $updates['pract_type_nz_c'] = implode(',', $temp);
            }
        }else{
            if(count(array_diff($pract_type, $crm_pract_type_c)) > 0){
                $pract_type_str = implode(',', $pract_type);
                $crm_pract_type_str = implode(',', $crm_pract_type_c);
                
                $datas = array(
                    'name' => 'Practitioner Type updated in first time',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'High',
                    'message_type_c' => 'System',
                    'description' => "Practitioner Type changed from $crm_pract_type_str to $pract_type_str.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1034'
                );
                $success = $this->tasks->set_record($datas);
                if (!$success){
                    $this->logger->developer("Failed to create the task for Confirm_Registration FTS9.");
                    return false;
                }
                $temp = array();
                foreach($pract_type as $type){
                    $temp[] = "^$type^";
                }
                $updates['pract_type_c'] = implode(',', $temp);
                
            }
        }
        if (count($updates) > 1){
            $contacts->set_record($updates);
        }
        
        if(strtolower($rego_domain) == 'new zealand'){
            $practs = array('Dental Assistant', 'Dental Industry Personnel', 'Practice Manager', 'Other', 'Student');
            if(count(array_intersect($pract_type_nz, $practs)) > 0){
                $this->go_confirmation($contact_id);
            }else{
                $this->go_fts_twelve($contact_id);
            }
        }else{
            $practs = array('Dental Assistant', 'Dental Industry Personnel', 'Dental Technician', 'Practice Manager', 'Other', 'Student');
            if(count(array_intersect($pract_type, $practs)) > 0){
                $this->go_confirmation($contact_id);
            }else{
                if(strtolower($rego_domain) == 'australia'){
                    $this->go_fts_eleven($contact_id);
                }else{
                    $this->go_fts_ten($contact_id);
                }
            }
        }
    }
}