<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_FTS_Confirm_Registration_Ten extends Processing_FTS_Confirm_Registration{

    function __construct(){
        parent::__construct(); 
    }

    function go_page($contact_id){
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id,{#c}.employ_type_c,{#c}.year_grad_c,{#c}.quals_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);  
        
        $employ_type_c = $_contact['employ_type_c'];
        $year_grad_c= $_contact['year_grad_c'];
        $quals_c = $_contact['quals_c'];
        
        $employ_type_html = $contacts->render_field_dropdown('employ_type_c', $employ_type_c);  
        
        $years = array();
        $now_year = date("Y") * 1;
        for($i = 1930; $i <= $now_year; $i++){
            $years[$i] = $i;
        }
        $year_grad_html = $this->helper->make_select_opts($years, array($year_grad_c));

        $action_id = $this->helper->fetch_action_id('Member', 'fts_confirm_registration_ten');
        
        $swaps = array(
                    'AID' => 'AID',
                    'CID' => 'CID',
                    'employ_type_html' => 'employ_type_html',
                    'year_grad_html' => 'year_grad_html',
                    'quals' => 'quals'
                );
        $datas = array(
                    'AID' => $action_id,
                    'CID' => $contact_id,
                    'employ_type_html' => $employ_type_html,
                    'year_grad_html' => $year_grad_html,
                    'quals' => $quals_c                    
                 );    

        $this->EE->TMPL->run_template_engine('login', 'fts_confirm_registration_ten');
        $this->EE->output->app_output($swaps, $datas);        
    }
    
    public function process_back(){
        $contact_id = $this->EE->input->get_post('CID');
        
        require_once(PATH_MOD . 'member/app/sequences/FTS/preferred_name.php');
        $processing = new Processing_FTS_Preferred_Name();
        $processing->go_confirm_contacts($contact_id);
    }
    
    public function process_confirm(){
        $contact_id = $this->EE->input->get_post('CID');
        $employ_type = $this->EE->input->get_post('employ_type');
        $year_grad = $this->EE->input->get_post('year_grad');
        $quals = $this->EE->input->get_post('quals');
        
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id,{#c}.employ_type_c,{#c}.year_grad_c,{#c}.quals_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);  
        
        $crm_employ_type_c = $_contact['employ_type_c'];
        $crm_year_grad_c = $_contact['year_grad_c'];
        $crm_quals_c = $_contact['quals_c'];

        $updates = array('id' => $contact_id);
        
        if ($employ_type != "Practising"){
            $updates['display_on_internet_c'] = '0';
        }
        if($employ_type != $crm_employ_type_c){
            $datas = array(
                    'name' => 'Employment Status updated in first time',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => "Employment Status changed from $crm_employ_type_c to $employ_type during the First Time Sequence.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1030'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Confirm_Registration FTS10.");
                return false;
            }
            $updates['employ_type_c'] = $employ_type;
        }
        if($year_grad != $crm_year_grad_c){
            $datas = array(
                    'name' => 'Year of Graduation updated in first time',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => "Year of Graduation changed from $crm_year_grad_c to $year_grad during the First Time Sequence.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1031'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Confirm_Registration FTS10.");
                return false;
            }
            $updates['year_grad_c'] = $year_grad;
        }
        if($quals != $crm_quals_c){
            $datas = array(
                    'name' => 'Qualifications updated in first time',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => "Qualifications changed from $crm_quals_c to $quals during the First Time Sequence.",
                    'contact_id' => $contact_id,
					'message_no_c' => 'MSL1032'
                );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Confirm_Registration FTS10.");
                return false;
            }
            $updates['quals_c'] = $quals;
        }
        
        if (count($updates) > 1){
            $contacts->set_record($updates);
        }
        $this->go_confirmation($contact_id);
    }
}