<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_FTS_Preferred_Name extends Processing_First_Time_Sequence{

    function __construct(){
        parent::__construct(); 
    }
    public function process_back(){
        $contact_id = $this->EE->input->get_post('CID');
        $referral = $this->EE->input->get_post('REF');
        
        switch($referral){
            case 'fts_normal':
                $this->go_fts_page($contact_id);
            break;
            case 'fts_incorrect':
                $this->go_incorrect_name($contact_id);
            break;
            default:
                $this->go_fts_page($contact_id);
            break;
        }
    }
    public function process_empty(){
        $contact_id = $this->EE->input->get_post('CID');
        
        $success = $this->contacts->set_record(array('id' => $contact_id, 'prefname_c' => ''));
        if (!$success){
            $this->logger->developer("Failed to save the prefname on FTS-preferred name.");
            return false;
        }
                
        $this->go_confirm_contacts($contact_id);
    }
    public function process_equal(){
        $contact_id = $this->EE->input->get_post('CID');
        
        $success = $this->contacts->set_record(array('id' => $contact_id, 'prefname_c' => ''));
        if (!$success){
            $this->logger->developer("Failed to save the prefname on FTS-preferred name.");
            return false;
        }
        
        $this->go_confirm_contacts($contact_id);
    }
    public function process_save(){
        $contact_id = $this->EE->input->get_post('CID');
        $prefname = $this->EE->input->get_post('prefname');
        
        $success = $this->contacts->set_record(array('id' => $contact_id, 'prefname_c' => $prefname));
        if (!$success){
            $this->logger->developer("Failed to save the prefname on FTS-preferred name.");
            return false;
        }
        
        $datas = array(
                'name' => 'Preferred Name added in the first time',
                'status' => 'Completed',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'Low',
                'message_type_c' => 'System',
                'description' => "A Preferred Name of $prefname added during the First Time Sequence.",
                'contact_id' => $contact_id,
				'message_no_c' => 'MSL1027'
            );
        $success = $this->tasks->set_record($datas);
        if (!$success){
            $this->logger->developer("Failed to create the task for FTS-Preferred Name.");
            return false;
        }         
        
        $this->go_confirm_contacts($contact_id);
    }
}