<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing{
    
    protected $EE = '';
    protected $contacts;
    protected $helper;
    protected $tasks;
    protected $logger;
    
    function __construct(){
        
        $this->EE =& get_instance();
        $this->EE->load->model('contacts');
        $this->contacts = $this->EE->contacts;
        
        $this->EE->load->library('logger');
        $this->logger = $this->EE->logger;
        
        $this->EE->load->helper('data');
        $this->helper = new Data_Helper();
        
        $this->EE->load->model('tasks');
        $this->tasks = $this->EE->tasks;
        $this->EE->load->library('template', NULL, 'TMPL');
    }


    function get_adverts(){

        $this->EE->load->model("adverts");
        $country = "Australia";

        $website = "DenteventsTV";

        $size = "Leaderboard";
        

        $limit = 2;
                
        $now_date = new DateTime();
        $now_date = $now_date->format("Y-m-d");
        $country = strtolower($country);
        
        $img_base_url = 'https://crm.dentist.com.au/upload/';
  
        /// search adverts ///  
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.document_name,{#c}.webad_c,{#c}.webad_url_c,{#c}.webad2_c,{#c}.webad2_url_c,{#c}.link_target_c,{#c}.target_url_c,{#c}.charge_basis_c,{#c}.impressions_c,{#c}.impression_target_c,{#c}.clicks_c,{#c}.click_target_c";
        //$params['where'] = "{#c}.target_website_c='DentistComAU' and {#c}.website_ad_status_c='Active' and {#c}.start_date_c <= '{$now_date}' and {#c}.end_date_c >= '{$now_date}' and {#c}.ad_position_c='YDsidebar' and LOWER({#c}.target_country_c) like '%^{$country}^%'";
        $params['where'] = "{#c}.target_websites_c like '%^{$website}^%' and {#c}.website_ad_status_c='Active' and {#c}.start_date_c <= '{$now_date}' and {#c}.end_date_c >= '{$now_date}' and {#m}.size='{$size}' and LOWER({#c}.target_country_c) like '%^{$country}^%'";
        $params['orders'] = "rand()";
        $params['limit'] = $limit;
        $_adverts = $this->EE->adverts->get_main_data($params);


        //////////////////////
        if(empty($_adverts)){
            return '';
        }
        // /// logger for impressions ///
        // self::$router = "logger:impressions";
        // $success = AVTProcessing_Adverts::process(array('adverts' => $_adverts));
        // //////////////////////////////
        
        foreach($_adverts as $key => $_advert){
            if(!empty($_advert['webad_url_c'])){
                $_advert['web_ad'] = $_advert['webad_url_c'];
            }else{
                $_advert['web_ad'] = $img_base_url . $_advert['webad_c'];
            }

            if(!empty($_advert['webad2_url_c'])){
                $_advert['web_ad2'] = $_advert['webad2_url_c'];
            }else{
                $_advert['web_ad2'] = $img_base_url . $_advert['webad2_c'];
            }

            /// fetch target_url ///
            $target_url = '';
            if($_advert['link_target_c'] == 'URL'){
                $target_url = $_advert['target_url_c'];
            }
            if($_advert['link_target_c'] == 'Article'){
                $params = array();
                $params['selects'] = "{#m}.id";
                $params['id'] = $_advert['id'];
                $params['single'] = true;
                $_article = $this->EE->adverts->get_relationship_articles($params);  
                if(!empty($_article)){
                    $target_url = $_article['id'];
                }
            }
            if($_advert['link_target_c'] == 'Product'){
                $params = array();
                $params['selects'] = "{#m}.id";
                $params['id'] = $_advert['id'];
                $params['single'] = true;
                $_product = $this->EE->adverts->get_relationship_products($params);  
                if(!empty($_product)){
                    $target_url = $_product['id'];
                }
            }
            if($_advert['link_target_c'] == 'Event'){
                $params = array();
                $params['selects'] = "{#m}.id,{#c}.sef_url_c";
                $params['id'] = $_advert['id'];
                $params['single'] = true;
                $_cpd_event = $this->EE->adverts->get_relationship_cpd_events($params);  
                if(!empty($_cpd_event)){
                    $target_url = $_cpd_event['sef_url_c'];
                }
            }
            $_advert['target_action'] = $target_url;
            ////////////////////////
            
            $_adverts[$key] = $_advert;
        }
        return $_adverts;
    }
    
    function process_valid_password($contact_id){
        require_once(PATH_MOD . 'member/app/sequences/processing_valid_password.php');
        $processing = new Processing_Valid_Password();
        $processing->process($contact_id);
    }
    
    function process_invalid_password($contact_id){
        require_once(PATH_MOD . 'member/app/sequences/processing_invalid_password.php');
        $processing = new Processing_Invalid_Password();
        $processing->process($contact_id);
    }
    
    public function process_reset_password(){   
        require_once(PATH_MOD . 'member/app/sequences/processing_reset_password.php');
        $processing = new Processing_Reset_Password();
        $processing->process();
    }
    
    public function trigger_invoke_reset_password(){
        require_once(PATH_MOD . 'member/app/sequences/processing_invoke_reset_password.php');
        $processing = new Processing_Invoke_Reset_Password();
        $processing->trigger();    
    }
    public function invoke_reset_password($contact_id, $password){
        require_once(PATH_MOD . 'member/app/sequences/processing_invoke_reset_password.php');
        $processing = new Processing_Invoke_Reset_Password();
        $processing->process($contact_id,  $password);    
    }
    
    public function unlock_account_email($contact_id){
        require_once(PATH_MOD . 'member/app/sequences/processing_unlock_account.php');
        $processing = new Processing_Unlock_Account();
        $processing->process_email($contact_id);
    }
    
    public function fts_confirm_name(){
        require_once(PATH_MOD . 'member/app/sequences/processing_first_time_sequence.php');
        $processing = new Processing_First_Time_Sequence(); 
        $processing->process_confirm_name();
    }
    public function fts_incorrect_name(){
        require_once(PATH_MOD . 'member/app/sequences/processing_first_time_sequence.php');
        $processing = new Processing_First_Time_Sequence(); 
        $processing->process_incorrect_name();
    }
    public function fts_preferred_name(){
        require_once(PATH_MOD . 'member/app/sequences/processing_first_time_sequence.php');
        $processing = new Processing_First_Time_Sequence(); 
        $processing->process_preferred_name();
    }
    public function fts_confirm_contacts(){
        require_once(PATH_MOD . 'member/app/sequences/processing_first_time_sequence.php');
        $processing = new Processing_First_Time_Sequence(); 
        $processing->process_confirm_contacts();
    }
    public function fts_confirm_registration_nine(){
        require_once(PATH_MOD . 'member/app/sequences/processing_first_time_sequence.php');
        $processing = new Processing_First_Time_Sequence(); 
        $processing->process_confirm_registration_nine();
    }
    public function fts_confirm_registration_ten(){
        require_once(PATH_MOD . 'member/app/sequences/processing_first_time_sequence.php');
        $processing = new Processing_First_Time_Sequence(); 
        $processing->process_confirm_registration_ten();
    }
    public function fts_confirm_registration_eleven(){
        require_once(PATH_MOD . 'member/app/sequences/processing_first_time_sequence.php');
        $processing = new Processing_First_Time_Sequence(); 
        $processing->process_confirm_registration_eleven();
    }
    public function fts_confirm_registration_twelve(){
        require_once(PATH_MOD . 'member/app/sequences/processing_first_time_sequence.php');
        $processing = new Processing_First_Time_Sequence(); 
        $processing->process_confirm_registration_twelve();
    }
    public function process_contacting_support(){
        require_once(PATH_MOD . 'member/app/sequences/processing_contacting_support.php');
        $processing = new Processing_Contacting_Support(); 
        
        $cmd = $this->EE->input->get_post('cmd');
        $contact_id = $this->EE->input->get_post('CID');
        
        switch($cmd){
            case 'go_page':
                $processing->go_page($contact_id);
            break;
            case 'process':
                $processing->process($contact_id);
            break;
            default:
        }
    }
    public function process_confirm_email(){
        require_once(PATH_MOD . 'member/app/sequences/processing_confirm_email.php');
        $processing = new Processing_Confirm_Email(); 
        
        $cmd = $this->EE->input->get_post('cmd');
        $contact_id = $this->EE->input->get_post('CID');
        
        switch($cmd){
            case 'go_page':
                $processing->go_page($contact_id);
            break;
            case 'process':
                $processing->process($contact_id);
            break;
            default:
        }
    }
    
    public function goto_terms($contact_id = ''){
        require_once(PATH_MOD . 'member/app/sequences/processing_terms.php');
        $processing = new Processing_Terms();
        $processing->go_page($contact_id);
    }
    public function process_terms(){
        require_once(PATH_MOD . 'member/app/sequences/processing_terms.php');
        $processing = new Processing_Terms();
        
        $cmd = $this->EE->input->get_post('cmd');

        
                
        switch($cmd){
            case 'logout':
                $processing->process_logout();
            break;
            case 'show_latest_terms':
                $processing->show_latest_terms();
            break;
            default:
                $processing->process();
            break;
        }
    }

}
