<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_Confirm_Email extends Processing{

    function __construct(){
        parent::__construct(); 
    }
    
    function go_page($contact_id, $params=array()){
              
        $action_id = $this->helper->fetch_action_id('Member', 'confirm_email');
        $swaps = array(
             'AID' => 'AID',
             'CID' => 'CID'
            );
        $datas = array(
            'AID' => $action_id,
            'CID' => $contact_id
            );
            
        foreach($params as $key => $value){
            $swaps[$key] = $key;
            $datas[$key] = $value;
        }
        $this->EE->TMPL->run_template_engine('login', 'confirm_email');
        $this->EE->output->app_output($swaps, $datas);
    }
    function process($contact_id){
        $userpwd = $this->EE->input->get_post('userpwd');
        $newpwd = $this->EE->input->get_post('newpwd');
        $retypepwd = $this->EE->input->get_post('retypepwd');
        
        $contacts = $this->EE->contacts;
        $selects = "{#c}.id_c as id,{#c}.password_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params); 
        
        $password_c = $_contact['password_c'];
        
        if ($password_c != $userpwd){
            $message = 'Error: Incorrect User Password';
            $this->go_page($contact_id, array('message' => $message));
            return false;
        }
        if ($newpwd != $retypepwd){
            $message = 'Error: The new password should be same as the retype password.';
            $this->go_page($contact_id, array('message' => $message));
            return false;
        }
        if (empty($newpwd)){
            $message = 'Error: The new password should not be blank.';
            $this->go_page($contact_id, array('message' => $message));
            return false;
        }
        
        $contacts->set_record(array('id' => $contact_id, 'password_c' => $newpwd, 'first_time_c' => 'no', 'password_changed_c' => date("F j, Y, g:i a")));
        
        $url    = $this->EE->config->item('site_url');
        $name    = stripslashes($this->EE->config->item('site_name'));
        $data = array(  'title'     => 'Confirm Email',
                        'heading'    => $this->EE->lang->line('thank_you'),
                        'content'    => 'Your password was reset successfully.',
                        'redirect'    => $url,
                        'link'        => array($url, $name)
                     );

        $this->EE->output->show_message($data);
        
    }
}