<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_First_Time_Sequence extends Processing{

    function __construct(){
        parent::__construct(); 
    }
    function go_fts_page($contact_id){  
        $contacts = $this->EE->contacts;
        $_contact = $contacts->get_buffer_data($contact_id);
        
        if (empty($_contact)){
            $selects = "{#c}.id_c as id,{#c}.gender_c,{#c}.initial_c";
            $where = "{#c}.id_c='$contact_id'";
            $params = array();
            $params['selects'] = $selects;
            $params['where'] = $where;
            $cstm = $contacts->get_cstm_data($params, false);
            
            $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
            $params = array();
            $params['joins'] = array(
                                    "{#c}" => array(
                                        'sql' => $cstm['sql'],
                                        'table' => $cstm['table'],
                                        'type' => 'inner'
                                    )
                                 );
            $params['selects'] = $selects;
            $params['single'] = true;
            $_contact = $contacts->get_contacts($params); 
        }
        $salutation = $_contact['salutation'];
        $gender_c = $_contact['gender_c'];
        $firstname = $_contact['first_name']; 
        $lastname = $_contact['last_name'];
        $initial_c = $_contact['initial_c'];
        
        $fts_id = '';
        
        if (strlen($firstname) > 1 && $initial_c == null){
             $fts_id = 'FTS-1';
        }else if(strlen($firstname) <= 1 && $initial_c != null){
             $fts_id = 'FTS-2';
        }else if(strlen($firstname) <= 1 && $initial_c == null){
            $fts_id = 'FTS-3';
        }else if(strlen($firstname) > 1 && $initial_c != null){
             $fts_id = 'FTS-4';
        }
        
        $action_id = $this->helper->fetch_action_id('Member', 'fts_confirm_name');
        
        $opts_salutation = $this->contacts->render_field_dropdown('salutation', $salutation);
        $opts_gender = $this->contacts->render_field_dropdown('gender_c', $gender_c);
        
        $swaps = array(
                    'FTS_ID' => 'FTS_ID',
                    'AID' => 'AID',
                    'CID' => 'CID',
                    'firstname' => 'firstname',
                    'lastname' => 'lastname',
                    'initial' => 'initial',
                    'salutation' => 'salutation',
                    'gender' => 'gender'
                );
        $datas = array(
                    'FTS_ID' => $fts_id,
                    'AID' => $action_id,
                    'CID' => $_contact['id'],
                    'firstname' => $firstname,
                    'lastname' => $lastname,
                    'initial' => $initial_c,
                    'salutation' => $opts_salutation,
                    'gender' => $opts_gender
                 ); 
        $this->EE->TMPL->run_template_engine('login', 'fts_confirm_name');
        $this->EE->output->app_output($swaps, $datas);
    }
    function go_incorrect_name($contact_id){
        $contacts = $this->EE->contacts;
        
        $selects = "{#c}.id_c as id,{#c}.initial_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);
         
        $firstname = $_contact['first_name'];
        $lastname = $_contact['last_name'];
        $initial_c = $_contact['initial_c'];
        $salutation = $_contact['salutation'];
        
        $opts_salutation = $contacts->render_field_dropdown('salutation', $salutation);
        
        $action_id = $this->helper->fetch_action_id('Member', 'fts_incorrect_name');
        
        $swaps = array(
                    'AID' => 'AID',
                    'CID' => 'CID',
                    'firstname' => 'firstname',
                    'lastname' => 'lastname',
                    'initial' => 'initial',
                    'salutation' => 'salutation'
                );
        $datas = array(
                    'AID' => $action_id,
                    'CID' => $_contact['id'],
                    'firstname' => $firstname,
                    'lastname' => $lastname,
                    'initial' => $initial_c,
                    'salutation' => $opts_salutation
                 ); 
        $this->EE->TMPL->run_template_engine('login', 'fts_incorrect_name');
        $this->EE->output->app_output($swaps, $datas);
        
    }
    public function go_preferred_name($contact_id, $referral){
        $contacts = $this->EE->contacts;
        
        $selects = "{#c}.id_c as id,{#c}.gender_c,{#c}.initial_c,{#c}.prefname_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params); 
        

        $firstname = $_contact['first_name'];
        $lastname = $_contact['last_name'];
        $initial_c = $_contact['initial_c'];
        $salutation = $_contact['salutation'];
        $prefname_c = $_contact['prefname_c'];
        
        if (empty($prefname_c)){
            $prefname_c = '';
        }
        
        $action_id = $this->helper->fetch_action_id('Member', 'fts_preferred_name');
        
        $swaps = array(
                    'AID' => 'AID',
                    'CID' => 'CID',
                    'REF' => 'REF',
                    'firstname' => 'firstname',
                    'lastname' => 'lastname',
                    'initial' => 'initial',
                    'salutation' => 'salutation',
                    'prefname' => 'prefname'
                );
        $datas = array(
                    'AID' => $action_id,
                    'CID' => $contact_id,
                    'REF' => $referral,
                    'firstname' => $firstname,
                    'lastname' => $lastname,
                    'initial' => $initial_c,
                    'salutation' => $salutation,
                    'prefname' => $prefname_c
                 ); 
        $this->EE->TMPL->run_template_engine('login', 'fts_preferred_name');
        $this->EE->output->app_output($swaps, $datas);
    }
    public function go_confirm_contacts($contact_id){
        $contacts = $this->EE->contacts;
        
        $selects = "{#c}.id_c as id,{#c}.email_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.phone_mobile,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params);
        
        $email_c = $_contact['email_c'];
        $phone_mobile = $_contact['phone_mobile'];
        
        $action_id = $this->helper->fetch_action_id('Member', 'fts_confirm_contacts');
        
        $swaps = array(
                    'AID' => 'AID',
                    'CID' => 'CID',
                    'email' => 'email',
                    'phone_mobile' => 'phone_mobile'
                );
        $datas = array(
                    'AID' => $action_id,
                    'CID' => $contact_id,
                    'email' => $email_c,
                    'phone_mobile' => $phone_mobile
                 ); 

        $this->EE->TMPL->run_template_engine('login', 'fts_confirm_contacts');
        $this->EE->output->app_output($swaps, $datas);        
    }
    function process($contact){
        $_contact = $contact;

        $salutation = $_contact['salutation'];
        $firstname = $_contact['first_name'];
        $lastname = $_contact['last_name'];
        $first_time_c = $_contact['first_time_c'];
        $initial_c = $_contact['initial_c'];
        $gender_c = $_contact['gender_c'];
        
        $datas = array(
                'name' => 'First Time Sequence commenced',
                'status' => 'Completed',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'Low',
                'message_type_c' => 'System',
                'description' => "$salutation $firstname $lastname has commenced the First Time Sequence.",
                'contact_id' => $_contact['id'],
                'message_no_c' => 'MSL1020'
            );
        $success = $this->tasks->set_record($datas);
        if (!$success){
            $this->logger->developer("Failed to create the task for First Time Sequence Commenced.");
            return false;
        } 
        
        $this->go_fts_page($_contact['id']);
    }
    
    function process_confirm_name(){
        $cmd = $this->EE->input->get_post('cmd');
        if ($cmd == null or $cmd == '')
            $cmd = 'confirm';
       
        require_once(PATH_MOD . 'member/app/sequences/FTS/confirm_name.php');
        $processing = new Processing_FTS_Confirm_Name(); 
         
        switch($cmd){
            case 'not_me':
                  $processing->process_not_me();
            break;
            case 'incorrect_name':
                  $processing->process_incorrect_name();
            break;
            case 'confirm':
                  $processing->process_confirm();
            break;
            default:
            break;
        }
    }
    function process_incorrect_name(){
        $cmd = $this->EE->input->get_post('cmd');
        if ($cmd == null or $cmd == '')
            $cmd = 'request';
       
        require_once(PATH_MOD . 'member/app/sequences/FTS/confirm_name.php');
        $processing = new Processing_FTS_Confirm_Name(); 
         
        switch($cmd){
            case 'not_me':
                  $processing->process_not_me();
            break;
            case 'preferred_name':
                  $processing->process_preferred_name();
            break;
            case 'request':
                  $processing->process_request();
            break;
            case 'cancel':
                  $processing->process_cancel();
            break;
            default:
            break;
        }
    }  
    public function process_preferred_name(){
        $cmd = $this->EE->input->get_post('cmd');
        if ($cmd == null or $cmd == '')
            $cmd = 'skip';
       
        require_once(PATH_MOD . 'member/app/sequences/FTS/preferred_name.php');
        $processing = new Processing_FTS_Preferred_Name(); 
         
        switch($cmd){
            case 'prefname-back':
                  $processing->process_back();
            break;
            case 'prefname-empty':
                  $processing->process_empty();
            break;
            case 'prefname-equal':
                  $processing->process_equal();
            break;
            case 'prefname-save':
                  $processing->process_save();
            break;
            default:
            break;
        }
    }  
    public function process_confirm_contacts(){
        $cmd = $this->EE->input->get_post('cmd');
        if ($cmd == null or $cmd == '')
            $cmd = 'confirm';
        require_once(PATH_MOD . 'member/app/sequences/FTS/confirm_contacts.php');
        $processing = new Processing_FTS_Confirm_Contacts(); 
         
        switch($cmd){
            case 'back':
                  $processing->process_back();
            break;
            case 'confirm':
                  $processing->process_confirm();
            break;
            default:
            break;
        }                    
    }
    public function process_confirm_registration_nine(){
        require_once(PATH_MOD . 'member/app/sequences/FTS/confirm_registration.php');
        $processing = new Processing_FTS_Confirm_Registration();        
        $processing->process_confirm_registration_nine();
    }
    public function process_confirm_registration_ten(){
        require_once(PATH_MOD . 'member/app/sequences/FTS/confirm_registration.php');
        $processing = new Processing_FTS_Confirm_Registration();        
        $processing->process_confirm_registration_ten();
    }
    public function process_confirm_registration_eleven(){
        require_once(PATH_MOD . 'member/app/sequences/FTS/confirm_registration.php');
        $processing = new Processing_FTS_Confirm_Registration();        
        $processing->process_confirm_registration_eleven();
    }
    public function process_confirm_registration_twelve(){
        require_once(PATH_MOD . 'member/app/sequences/FTS/confirm_registration.php');
        $processing = new Processing_FTS_Confirm_Registration();        
        $processing->process_confirm_registration_twelve();
    }
}