<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_Invalid_Password extends Processing{

    function __construct(){
        parent::__construct(); 
    }
    
    function process($contact_id){



        $_contact = $this->contacts->get_buffer_data($contact_id);
        
        $failed_logins = $_contact['failed_logins_c'];
        if ($failed_logins == null)
           $failed_logins = 0; 
        
        $failed_logins++;
        
        $success = $this->contacts->set_record(array('id' => $_contact['id'], 'failed_logins_c' => $failed_logins));
        if (!$success){
            $this->logger->developer("Failed to increase 'failed_logins_c' on 'process_invalid_password'");
            return false;
        }
        
        $datas = array(
                    'name' => 'Invalid Login Attempt',
                    'status' => 'Completed',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Low',
                    'message_type_c' => 'System',
                    'description' => 'Login attempted with invalid password.',
                    'contact_id' => $_contact['id'],
					'message_no_c' => 'DVT1001'
                );
                
        $success = $this->tasks->set_record($datas);
        if (!$success){
            $this->logger->developer("Failed to create the task");
            return false;
        }
        
        if ($failed_logins >= 5){
            $datas = array(
                'name' => 'Invalid Login quota exceeded',
                'status' => 'In Progress',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'High',
                'message_type_c' => 'System',
                'description' => "Account locked due to $failed_logins invalid login attempts.",
                'contact_id' => $_contact['id'],
				'message_no_c' => 'DVT1002'
            );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for quota exceed.");
                return false;
            }
            $success = $this->contacts->set_record(array('id' => $_contact['id'], 'locked_c' => 'yes'));
            if (!$success){
                $this->logger->developer("Failed to set the locked to Contact");
                return false;
            }
            
            
            $address = $_contact['email_c'];
            $email_tit = 'Security Violation';
            $email_msg = 'Account Locked due to Security Violation';
            
            $this->EE->load->library('email');
            $this->EE->email->wordwrap = true;
            $this->EE->email->from($this->EE->config->item('webmaster_email'), $this->EE->config->item('webmaster_name'));
            $this->EE->email->to($address);
            $this->EE->email->subject($email_tit);
            $this->EE->email->message($email_msg);
            $this->EE->email->send();
            
			// $action_id = $this->helper->fetch_action_id('Member', 'contacting_support');
   //          $swaps = array(
			// 	 'AID' => 'AID',
			// 	 'CID' => 'CID'
   //              );
   //          $datas = array(
			// 	'AID' => $action_id,
			// 	'CID' => $contact_id
   //              );
            // $this->EE->TMPL->run_template_engine('login', 'security_violation');
            // $this->EE->output->app_output($swaps, $datas);
            $datas = array(
                    'message' => "security_violation"
                    );
            // require_once(PATH_THIRD . 'person/models/processing.php');
            // $processing = new MProcessing();
            // $processing->go_welcome_page($datas);
            require_once(PATH_THIRD . 'mdentevents/models/processing.php');

             $processing = new DEProcessing();
             $processing->initialize('dentevents:home:show');
             $processing->process($datas);

        }else{

            $type = $this->EE->input->get_post("login_type");
            $datas = array();
            

            $swaps = array(
                 'message' => 'message'
                );
            if($type && $type == 'old-user'){
                $datas = array(
                    'message' => "Error:old-user",
                    'user_id' =>  $_contact['username_c'],
                    'user_email' => $_contact['email_c']
                    
                    );
            }else{
                $datas = array(
                    'message' => "Username and Password combination is invalid. Please try again.",
                    'user_id' =>  $_contact['username_c'],
                    'user_email' => $_contact['email_c']
                    );
            }

            // require_once(PATH_THIRD . 'person/models/processing.php');
            // $processing = new MProcessing();
            // $processing->go_welcome_page($datas);
             require_once(PATH_THIRD . 'mdentevents/models/processing.php');

             $processing = new DEProcessing();
             $processing->initialize('dentevents:home:show');
             $processing->process($datas);

        }
    }
}