<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Processing_Valid_Password extends Processing{

    function __construct(){
        parent::__construct(); 
    }
    
    function process($contact_id){
        $_contact = $this->contacts->get_buffer_data($contact_id);
        
        $failed_logins_c = $_contact['failed_logins_c'];
        $locked_c = $_contact['locked_c'];
        $hostile_c = $_contact['hostile_c'];
        $salutation = $_contact['salutation'];
        $firstname = $_contact['first_name'];
        $lastname = $_contact['last_name'];
        $first_time_c = $_contact['first_time_c'];
        $invalid_username_c = $_contact['invalid_username_c'];


        $_adverts = array();
        $_adverts = $this->get_adverts();

        if($invalid_username_c == 1){
            $datas = array(
                    'name' => 'Login attempted to Invalid Account',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Medium',
                    'message_type_c' => 'System',
                    'description' => 'The user attempted to login to an account that was set to Invalid during the First Time Sequence.',
                    'contact_id' => $_contact['id'],
                    'message_no_c' => 'MSL1006'
                );
                
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for username no longer valid.");
                return false;
            } 
            
            $action_id = $this->helper->fetch_action_id('Member', 'contacting_support');
            $swaps = array(
                    'id' => 'id',
                    'web_ad' => 'web_ad',
                    'web_ad2' => 'web_ad2',
                    'target_action' => 'target_action',
                    'document_name' => 'document_name',
                    'AID' => 'AID',
                    'CID' => 'CID'
                );
            $datas = array(
                    'id' => $_adverts[0]['id'],
                    'web_ad' =>$_adverts[0]['web_ad'],
                    'web_ad2' =>$_adverts[0]['web_ad2'],
                    'target_action' =>$_adverts[0]['target_action'],
                    'document_name' =>$_adverts[0]['document_name'],
                    'AID' => $action_id,
                    'CID' => $contact_id
                );
            $this->EE->TMPL->run_template_engine('login', 'username_nolonger_valid');
            $this->EE->output->app_output($swaps, $datas);
        }
        if ($locked_c == 1 && $failed_logins_c <= 5){
            $datas = array(
                    'name' => 'Login attempted to Locked Account',
                    'status' => 'In Progress',
                    'date_entered' => date("F j, Y, g:i a"),
                    'priority' => 'Medium',
                    'message_type_c' => 'System',
                    'description' => 'User attempted to access their account while it is locked.',
                    'contact_id' => $_contact['id'],
					'message_no_c' => 'DVT1003'
                );
                
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Login attempted to locked account");
                return false;
            } 
            
   //          $action_id = $this->helper->fetch_action_id('Member', 'unlock_account_email');
			// $con_action_id = $this->helper->fetch_action_id('Member', 'contacting_support');
            
   //          $swaps = array(
   //                      'id' => 'id',
   //                      'web_ad' => 'web_ad',
   //                      'web_ad2' => 'web_ad2',
   //                      'target_action' => 'target_action',
   //                      'document_name' => 'document_name',
   //                      'email' => 'email',
   //                      'AID' => 'AID',
   //                      'CID' => 'CID',
			// 	        'CON_AID' => 'CON_AID'
   //                  );
   //          $datas = array(
   //                      'id' => $_adverts[0]['id'],
   //                      'web_ad' =>$_adverts[0]['web_ad'],
   //                      'web_ad2' =>$_adverts[0]['web_ad2'],
   //                      'target_action' =>$_adverts[0]['target_action'],
   //                      'document_name' =>$_adverts[0]['document_name'],
   //                      'email' => $_contact['email_c'],
   //                      'AID' => $action_id,
   //                      'CID' => $contact_id,
			// 	        'CON_AID' => $con_action_id
   //                  );
   //          $this->EE->TMPL->run_template_engine('login', 'account_locked');
   //          $this->EE->output->app_output($swaps, $datas);
            $datas = array(
                    'message' => "account_locked",
                    'user_email' =>  $_contact['email_c']
                    );
            // require_once(PATH_THIRD . 'person/models/processing.php');
            // $processing = new MProcessing();
            // $processing->go_welcome_page($datas);
            require_once(PATH_THIRD . 'mdentevents/models/mdentevents/events/home.php');
            $processing = new DEProcessing_Dentevents_Events_Home();
            $processing->initialize($params);
            $processing->show($datas);
        }
        
        if ($locked_c == 1 && $failed_logins_c > 5){
            $datas = array(
                'name' => 'Login attempted to Locked Account',
                'status' => 'In Progress',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'Medium',
                'message_type_c' => 'System',
                'description' => 'User attempted to access their account while it is locked.',
                'contact_id' => $_contact['id'],
				'message_no_c' => 'DVT1003'
            );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Login attempted to locked account");
                return false;
            } 
            
			// $action_id = $this->helper->fetch_action_id('Member', 'contacting_support');
   //          $swaps = array(
   //                  'id' => 'id',
   //                  'web_ad' => 'web_ad',
   //                  'web_ad2' => 'web_ad2',
   //                  'target_action' => 'target_action',
   //                  'document_name' => 'document_name',
   //  				'AID' => 'AID',
   //  				'CID' => 'CID'
   //              );
   //          $datas = array(
   //                  'id' => $_adverts[0]['id'],
   //                  'web_ad' =>$_adverts[0]['web_ad'],
   //                  'web_ad2' =>$_adverts[0]['web_ad2'],
   //                  'target_action' =>$_adverts[0]['target_action'],
   //                  'document_name' =>$_adverts[0]['document_name'],
   //  				'AID' => $action_id,
   //  				'CID' => $contact_id
   //              );

            // $this->EE->TMPL->run_template_engine('login', 'security_violation');
            // $this->EE->output->app_output($swaps, $datas);
            $datas = array(
                    'message' => "security_violation",
                    'user_email' =>  $_contact['email_c']
                    );
            // require_once(PATH_THIRD . 'person/models/processing.php');
            // $processing = new MProcessing();
            // $processing->go_welcome_page($datas);
            require_once(PATH_THIRD . 'mdentevents/models/mdentevents/events/home.php');
            $processing = new DEProcessing_Dentevents_Events_Home();
            $processing->initialize($params);
            $processing->show($datas);

        }
        if ($hostile_c == 1){
            $datas = array(
                'name' => 'Hostile login attempt',
                'status' => 'In Progress',
                'date_entered' => date("F j, Y, g:i a"),
                'priority' => 'Medium',
                'message_type_c' => 'System',
                'description' => "Hostile login attempt. User $firstname $lastname denied access.",
                'contact_id' => $_contact['id']
            );
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Hostile login attempt");
                return false;
            } 
            // $swaps = array(
            //         'id' => 'id',
            //         'web_ad' => 'web_ad',
            //         'web_ad2' => 'web_ad2',
            //         'target_action' => 'target_action',
            //         'document_name' => 'document_name'
                  
            //     );
            // $datas = array(
            //         'id' => $_adverts[0]['id'],
            //         'web_ad' =>$_adverts[0]['web_ad'],
            //         'web_ad2' =>$_adverts[0]['web_ad2'],
            //         'target_action' =>$_adverts[0]['target_action'],
            //         'document_name' =>$_adverts[0]['document_name']
            //     );
            
            // $this->EE->TMPL->run_template_engine('login', 'offline_maintenance');
            // $this->EE->output->app_output($swaps, $datas);
            $datas = array(
                    'message' => "maintenance"
                    );
            // require_once(PATH_THIRD . 'person/models/processing.php');
            // $processing = new MProcessing();
            // $processing->go_welcome_page($datas);
            require_once(PATH_THIRD . 'mdentevents/models/mdentevents/events/home.php');
            $processing = new DEProcessing_Dentevents_Events_Home();
            $processing->initialize($params);
            $processing->show($datas);
        }
        
        if ($failed_logins_c > 0){
            $success = $this->contacts->set_record(array('id' => $_contact['id'], 'failed_logins_c' => 0));
            if (!$success){
                $this->logger->developer("Failed to set 'failed_logins_c' to 0 on 'process_valid_password'");
                return false;
            }
            
            $datas = array(
                        'name' => 'Failed Login count reset',
                        'status' => 'Completed',
                        'date_entered' => date("F j, Y, g:i a"),
                        'priority' => 'Low',
                        'message_type_c' => 'System',
                        'description' => 'A successful login has reset the Failed Login count to 0.',
                        'contact_id' => $_contact['id'],
						'message_no_c' => 'DVT1007'
                    );
                    
            $success = $this->tasks->set_record($datas);
            if (!$success){
                $this->logger->developer("Failed to create the task for Falied Login count reset");
                return false;
            }    
        }
        
        if ($first_time_c == 1){

            // if($_contact['username_c'] != $_contact['email_c']){
            //     $result = $this->set_contact_data($_contact['id'],$_contact['email_c']);
            //     if($result)
            //         $this->go_to_login($_contact['id']);

            // }else{   
            //        // require_once(PATH_MOD . 'member/app/sequences/processing_first_time_sequence.php');
            //        // $processing = new Processing_First_Time_Sequence(); 
            //        // $processing->process($_contact);
            //    }
            $result = $this->set_contact_data($_contact['id'],$_contact['email_c']);
                if($result)
                    $this->go_to_login($_contact['id']);
        }else{

            if($_contact['username_c'] != $_contact['email_c']){

                $MA = new Member_auth();

                $MA->do_contact_auth($contact_id);
                
                require_once(PATH_THIRD . 'person/models/processing.php');
                $processing = new MProcessing();
                $send_datas = array(
                        'message' => "change username",
                        'user_id' =>  $_contact['email_c'],
                        'password' =>  $_contact['password_c'], 
                );

                $processing->go_welcome_page($send_datas);
                // $this->go_to_login($_contact['id']);
            }else{
                require_once(PATH_MOD . 'member/app/sequences/processing.php');
                $processing = new Processing(); 
                $processing->goto_terms($_contact['id']);
                
                require_once(PATH_MOD . 'member/app/sequences/processing_portal_entry_sequence.php');
                $processing = new Processing_Portal_Entry_Sequence(); 
                $processing->process($contact_id); 
            }
           
           
        }
    }

    function set_contact_data($contact_id,$email_id){

        $param = array();
        $param['id'] = $contact_id;
        $param['username_c'] = $email_id;
        $param['first_time_c'] = 0;

        $result = $this->contacts->set_record($param);

        $sparam = array();
        $sparam['id'] = $contact_id;
        $sparam['locked_c'] = 0;
        $result = $this->contacts->set_record($sparam);        

        return $result;
    }

    function go_to_login($contact_id){
        $MA = new Member_auth();

        /*foreach(get_object_vars($this) as $key => $value)
        {
            $MA->{$key} = $value;
        }*/

        $MA->do_contact_auth($contact_id);
        /*****************************************/

        
        
        require_once(PATH_THIRD . 'person/models/processing.php');
        $processing = new MProcessing();
        // $send_datas = array(
        //         'message' => "You accepted the terms.",
        //         'user_id' =>  $_contact['username_c'],
        //         'password' =>  $_contact['password_c'],
        // );

        $processing->go_welcome_page();
    }
}