<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class App_Member {
   protected $EE;
   protected $member; 
   
   function __construct(){
       
       $this->EE =& get_instance();
       
       $this->EE->load->model('member_model');
       $this->member = $this->EE->member_model;
   }
   public function update_custom_fields($member_id, $data){
       $query = $this->member->get_custom_member_fields();
       $fields = array();
       if ($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
                $fields[$row['m_field_name']] = $row['m_field_id'];
            }
        }
        $update_data = array();
        foreach($data as $field_name => $value){
            $field_key = "m_field_id_" . $fields[$field_name];
            $update_data[$field_key] = $value;
        }
        $this->member->update_member_data($member_id, $update_data);
   } 
   public function get_custom_fields($member_id, $field_names){
        $query = $this->member->get_custom_member_fields();
        $fields = array();
        if ($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
                $fields[$row['m_field_name']] = $row['m_field_id'];
            }
        }
        
        $this->EE->db->select();
        $this->EE->db->where('member_id', (int) $member_id);
        $query = $this->EE->db->get('member_data');
        $raw_data = $query->row_array();
        
        $data = array();
        foreach($field_names as $field_name){
           $field_key = "m_field_id_" . $fields[$field_name]; 
           $data[$field_name] = $raw_data[$field_key];
        }
        
        return $data;
   }
   public function generate_reset_password_token($username, $contact){
       $token = '';       
       require_once(PATH_MOD . 'member/models/adaptor_db_result.php');
       $member = new Adaptor_Db_Result($contact);
        
       $member_data = $member->row_array();
       
       $member_id = '';
       $ee_member = $this->EE->db->get_where('members', array('username' => $username));
       
       if ($ee_member->num_rows() == 0){
           $member_data["salt"]= "xxxx";
           $insert = $this->EE->db->insert_string('members', $member_data);
           $this->EE->db->query($insert);
           
           $ee_member = $this->EE->db->get_where('members', array('username' => $username));
           $temp = $ee_member->row_array();
           $member_id = $temp['member_id'];
            
           $insert = $this->EE->db->insert_string('member_data', array('member_id' => $member_id));
           $this->EE->db->query($insert);
       }else{
           $ee_member = $this->EE->db->get_where('members', array('username' => $username));
           $temp = $ee_member->row_array();
           $member_id = $temp['member_id'];
       }
       $ee_member->free_result();
       
       
       $this->EE->load->helper('data');
       $_helper = new Data_Helper();
       $token = $_helper->uniqHash();
       $token_created_at = date('Y-m-d');

       $this->update_custom_fields(
                $member_id,
                array('reset_password_token' => $token, 'rpt_created_at' => $token_created_at)
                ); 

       // $this->get_custom_fields($member_data['member_id'], array('reset_password_token', 'rpt_created_at'));
       return $token;
   } 
   public function get_reset_password_link($username, $contact){
       $this->EE->load->helper('data');
       $_helper = new Data_Helper();
       $action_id = $_helper->fetch_action_id('Member', 'trigger_invoke_reset_password');
       
       $site_url = $this->EE->functions->fetch_site_index();
       $contact_id = $contact['id'];
       
       $token = $this->generate_reset_password_token($username, $contact);
       $url = $site_url . "?ACT=$action_id&id=$contact_id&token=$token";
       
       return $url; 
   }
   
   /**
     * Check if current reset password link token is expired
     *
     * @return boolean
     */
    public function isResetPasswordTokenExpired($token, $token_created_at)
    {
       
        if (empty($token) || empty($token_created_at)) {
            return true;
        }

        $tokenExpirationPeriod = 1;

        $currentDate = date('Y-m-d');
        $currentTimestamp = strtotime($currentDate);
        $tokenTimestamp = strtotime($token_created_at);
        if ($tokenTimestamp > $currentTimestamp) {
            return true;
        }

        $dayDifference = floor(($currentTimestamp - $tokenTimestamp) / (24 * 60 * 60));
        if ($dayDifference >= $tokenExpirationPeriod) {
            return true;
        }

        return false;
    }
    
   /**
     * Check if password reset token is valid
     *
     * @param int $customerId
     * @param string $resetPasswordLinkToken
     * @throws 
     */
    public function validateResetPasswordToken($member_id, $reset_password_token)
    {
        if (!is_string($reset_password_token)
            || empty($reset_password_token)
            || empty($member_id)
        ) {
            return false;
        }

        $member_data = $this->get_custom_fields($member_id, array('reset_password_token', 'rpt_created_at'));

        if($_SERVER['REMOTE_ADDR'] == '103.6.219.60'){
          var_dump($member_id);
          var_dump($member_data);
        }
    

        $token = $member_data['reset_password_token'];
        $rpt_created_at = $member_data['rpt_created_at'];
        if (strcmp($token, $reset_password_token) != 0 || $this->isResetPasswordTokenExpired($token, $rpt_created_at)) {
          // if($_SERVER['REMOTE_ADDR'] == '103.6.219.60'){
          //   var_dump("expression");
          // }
            return false;
        }
        
        return true;
    }
}