<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MProcessing_Admin extends MProcessing{
    function initialize($params = array()){
        $this->EE->load->model("publication");
        $this->EE->load->model("subscriptions");
        $this->EE->load->model("contacts");
        $this->EE->load->model("accounts");
    }

    function process(){
        $cmd = self::$utility->fetch_router();

        switch($cmd){
            case "home":
                $this->go_home();
            break;
            case "generate":
                $this->generate_show();
            break;
            case "generate_download":
                $this->generate_download();
            break;
            case "save_template":
                $this->save_template();
            break;
            case "issue_login":
                $this->issue_login_show();
            break;
            case "send_credentials":
                $this->send_credentials();
            break;
        }

    }

    public function go_home(){
        /// fetch actions ///
        $actions = array();
        $actions['person_admin'] = $this->helper->fetch_action_id('Person', 'administration_func');
        /////////////////////
        $swaps = array('actions' => 'actions');
        $datas = array('actions' => $actions);
        $this->EE->TMPL->run_template_engine('person', 'admin_dashboard');
        $this->EE->output->app_output($swaps, $datas);
    }

    public function generate_show(){
        /// fetch actions ///
        $actions = array();
        $actions['person_admin'] = $this->helper->fetch_action_id('Person', 'administration_func');
        /////////////////////
        $data = array();
        $data['current_template'] = "SUB-Renewal.docx";

        //////// publications /////
        $publications = $this->EE->publication->get_publications(array(
            'selects'=> "{#m}.id,{#m}.name",
        ));
        $publications = $this->helper->put_id_to_key($publications);
        $publications_opts = $this->helper->make_select_opts($publications, '');
        $data['publications_opts'] = $publications_opts;
        //////////////////////////

        $swaps = array('actions' => 'actions', 'dt' => 'dt');
        $datas = array('actions' => $actions, 'dt' => $data);
        $this->EE->TMPL->run_template_engine('person', 'admin_generate_sub_renewal');
        $this->EE->output->app_output($swaps, $datas);
    }

    public function issue_login_show(){
        $actions = array();
        $actions['person_admin'] = $this->helper->fetch_action_id('Person', 'administration_func');
        /////////////////////
        $data = array();

        $swaps = array('actions' => 'actions', 'dt' => 'dt');
        $datas = array('actions' => $actions, 'dt' => $data);
        $this->EE->TMPL->run_template_engine('person', 'admin_generate_login_credentials');
        $this->EE->output->app_output($swaps, $datas);
    }

    public function send_credentials(){
        $usernames = $this->EE->input->get_post('usernames');
        $usernames = str_replace(" ", "", $usernames);
        $usernames = explode(",", $usernames);
        $log_msgs = array();

        foreach ($usernames as $key => $username) {
            $log_msg = '';
            $_contact = $this->EE->contacts->get_main_data(array(
                        'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.email_c,{#c}.username_c,{#c}.password_c,{#c}.contact_id_nr_c",
                        'where' => "{#c}.contact_id_nr_c='{$username}'",
                        'single' => true
                    ));

            if(empty($_contact)){
                $log_msg = "<p style='color:#eb212e;'>Send to {$username} Failed - Contact not found</p>";
                $log_msgs[] = $log_msg;
                continue;
            }
            if(empty($_contact['email_c'])){
                $log_msg = "<p style='color:#eb212e;'>Send to {$username} Failed - Email Address missing</p>";
                $log_msgs[] = $log_msg;
                continue;    
            }
            if(empty($_contact['username_c'])){
                $log_msg = "<p style='color:#eb212e;'>Send to {$username} Failed - Contact username missing</p>";
                $log_msgs[] = $log_msg;
                continue;    
            }
            if(empty($_contact['password_c'])){
                $log_msg = "<p style='color:#eb212e;'>Send to {$username} Failed - Contact password missing</p>";
                $log_msgs[] = $log_msg;
                continue;    
            }

            ////// send email /////

            $address = $_contact['email_c'];
            $subject = "Dental Community Login";

            $password = $_contact['password_c'];
            $bcc = "";
            $username_c = $_contact['username_c'];
            ////get content for email ////
            $data = array();
            $data['salutation'] = $_contact['salutation'];
            $data['last_name'] = $_contact['last_name'];
            $data['username_c'] = $_contact['username_c'];
            $data['password_c'] = $_contact['password_c'];

            $email_template = $this->EE->TMPL->fetch_template('email', 'admin_send_login_credentials', false);
            
            $swaps = array(
                'dt' => 'dt'
                );
            $datas = array(
                'dt' => $data
                );  
            
            $message = $this->helper->render_results($swaps, $datas, $email_template, true);
            ////////

            $this->EE->load->library('email');
            $this->EE->email->wordwrap = true;
            $this->EE->email->set_mailtype('html');
            $this->EE->email->from('do_not_reply@dentist.com.au', 'Dental Community Support');
            $this->EE->email->to($address);
            $this->EE->email->bcc($bcc);
            $this->EE->email->reply_to('do_not_reply@dentist.com.au');
            $this->EE->email->subject($subject);
            $this->EE->email->message($message);

            $status = '';
            if($this->EE->email->send()){
                $status = "success";
            }else{
                $status = "fail";
            }
            $log_msg = "<p style='color:#00a453;'>Login Credentials successfully sent to {$username}</p>";
            $log_msgs[] = $log_msg;
            ///////////////////////
        }
        
        $logs_str = implode("", $log_msgs);
        
        echo $logs_str;
        exit;
    }

    public function create_subscription_renewals($subscriptions = array()){
        require_once (APPPATH . 'application/helpers/phpdocx/classes/CreateDocx.inc');

        putenv("HOME=/home/dentalcommun/");

        $to_date = $this->EE->input->get_post("date_to_print");
        $from_date = $this->EE->input->get_post("from_date");
        $publication_id = $this->EE->input->get_post("publication");
        $template_name = $this->EE->input->get_post("loaded_template");

        if(empty($template_name)){
            $template_name = "SUB-Renewal.docx";
        }
        $publication_data = $this->EE->publication->get_main_data(array(
            'selects' => "{#m}.name",
            'where' => "{#m}.id='$publication_id'",
            'single' => true
        ));
        
        //// template setting /////
        $template_url = $this->_crm_config['main']['temp_path'] . $template_name;
        $template_crm_url = $this->_crm_config['main']['upload_url'] . $template_name;
        copy($template_crm_url, $template_url);
        ////////////////////////
        $renewals = array();
        foreach ($subscriptions as $key => $item) {
            // if($key > 1){
            //     break;
            // }
            $docx = new CreateDocxFromTemplate($template_url);
            $docx->setTemplateSymbol('%');
            $contact_name = $item['contact']['salutation'] . " " . $item['contact']['first_name'] . " " . $item['contact']['last_name'];
            $date_1 = $from_date;

            $date_2 = strtotime('+1 year', strtotime($date_1));
            $date_3 = strtotime('+2 year', strtotime($date_1));
            $date_2 = date("d/m/Y", $date_2);
            $date_3 = date('d/m/Y', $date_3);

            $variables = array("name" => $contact_name,
                "Mailing_Company_Name" => $item['account']['mailing_name_c'],
                "MAILING_SUBURB" => $item['account']['shipping_address_city'],
                "MAILING_STATE" =>$item['account']['shipping_address_state'],
                "Mailing_Street" =>$item['account']['shipping_address_street'],
                "MAILING_POSTCODE" =>$item['account']['shipping_address_postalcode'],
                "MAILING_COUNTRY" =>$item['account']['shipping_address_country'],
                "contact_id" =>$item['contact']['contact_id_nr_c'],
                "date" => $to_date,
                "date_1" => $from_date,
                "date_2" => $date_2,
                "date_3" => $date_3,
                "magazine" => $publication_data['name']
            );
            $options = array('parseLineBreaks' => true);
            $docx->replaceVariableByText($variables, $options);

            $docx->createDocx($this->_crm_config['main']['temp_path'] . 'subscription_renewal');

            $docx_file = $this->_crm_config['main']['temp_path'] . 'subscription_renewal.docx';
            $renewal_name = "Subscription_Renewal_" . $item['contact']['contact_id_nr_c'];
            $pdf_destination_file = $this->_crm_config['main']['temp_path'] . $renewal_name . ".pdf";

            $_docx = new TransformDocAdvLibreOffice();
            $_docx->transformDocument($docx_file, $pdf_destination_file, NULL);
            $renewals[] = $renewal_name . ".pdf";
        }

        return $renewals;
    }

    function remove_pdf($pdf){
        $filepath = $this->_crm_config['main']['temp_path'] . $pdf;
        if(file_exists($filepath)){
            unlink($filepath);
        }
    }

    public function generate_download(){
        $publication_id = $this->EE->input->get_post("publication");
        $expiry_date = $this->EE->input->get_post("expiry_date");
        $expiry_date_min = $this->EE->input->get_post("expiry_date_min");

        $expiry_date = date_create($expiry_date);
        $expiry_date = date_format($expiry_date, "Y-m-d");
        
        if(!empty($expiry_date_min)){
            $expiry_date_min = date_create($expiry_date_min);
            $expiry_date_min = date_format($expiry_date_min, "Y-m-d");            
            $where = "{#m}.validto<='{$expiry_date}' and {#m}.validto>='{$expiry_date_min}' and {#m}.status='Paid Subscriber' and {#m}.validity='Current'";
        }else{
            $where = "{#m}.validto<='{$expiry_date}' and {#m}.status='Paid Subscriber' and {#m}.validity='Current'";
        }

        ///// get subscriptions using ext_publications_id_c //////
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.contact_id_c,{#m}.validto";
        $where .= " and {#m}.ext_publications_id_c ='{$publication_id}'";
        $params['where'] = $where;
        $params['orders'] = "{#m}.validto desc";
        $subscriptions = $this->EE->subscriptions->get_main_data($params);
        ////////////////////////////////////
        
        ///// get subscriptions /////
        /*$params = array();
        $params['id'] = $publication_id;
        $params['selects'] = "{#m}.id,{#m}.contact_id_c,{#m}.validto";
        $params['where'] = $where;
        $params['orders'] = "{#m}.validto desc";
        $subscriptions = $this->EE->publication->get_relationship_subscriptions($params);*/
        ////////////////////////////
        
        foreach ($subscriptions as $key => $item) {
            // if($key > 1){
            //     break;
            // }
            $contact_id = $item['contact_id_c'];
            $item_contact = $this->EE->contacts->get_main_data(array(
                'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.account_id_c,{#m}.primary_address_street,{#m}.primary_address_city,{#m}.primary_address_state,{#m}.primary_address_postalcode,{#m}.primary_address_country,{#c}.contact_id_nr_c,{#c}.prefname_c,{#c}.initial_c",
                'where' => "{#m}.id='$contact_id'",
                'single' => true
            ));
            $account_id = $item_contact['account_id_c'];
            $item_account = $this->EE->accounts->get_main_data(array(
                'selects' => "{#m}.id,{#m}.shipping_address_street,{#m}.shipping_address_country,{#m}.shipping_address_city,{#m}.shipping_address_state,{#m}.shipping_address_postalcode,{#m}.billing_address_street,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_country,{#m}.billing_address_postalcode,{#c}.mailing_name_c,{#c}.billing_address_region_nz_c,{#c}.shipping_address_region_nz_c,{#c}.billing_name_c",
                'where' => "{#m}.id='$account_id'",
                'single' => true
            ));
            $subscriptions[$key]['contact'] = $item_contact;
            $subscriptions[$key]['account'] = $item_account;
        }

        $downloaded_files = $this->create_subscription_renewals($subscriptions);

        $zip_name = "Subscription_Renewals.zip";
        $zip_file = $this->_crm_config['main']['temp_path'] . $zip_name;

        $zip = new ZipArchive;
        $zip->open($zip_file, ZipArchive::CREATE);
        foreach($downloaded_files as $key => $file){
            $file_location = $this->_crm_config['main']['temp_path'] . $file;
            $zip->addFile($file_location, $file);
            //$this->remove_pdf($file);
        }
        $zip->close();

        //// removing ////
        foreach($downloaded_files as $key => $file){
            $this->remove_pdf($file);
        }
        ///
        if(file_exists($zip_file)){
            header('Content-Description: File Transfer');
            header('Content-Type: application/pdf');
            header('Content-Disposition: attachment; filename=' . $zip_name);
            header('Expires: 0');
            header('Content-Length: ' . filesize($zip_file));
            readfile($zip_file);
            $this->remove_pdf($zip_name);
            exit;
        }

    }

    public function save_template(){
        $this->EE->load->helper('docx');
        $docx = new Docx_Helper();
        $file_id = "load_template";
        $file_name = $_FILES[$file_id]['name'];
        $success = $docx->upload_template_to_crm($file_id, $_FILES[$file_id]['name'], '');

        if($success){
            echo $file_name;    
        }else{
            echo "fail";
        }
        exit;
    }
}