<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class AVTProcessing_Adverts_Event extends AVTProcessing_Adverts{

    function initialize($params = array()){
        $this->EE->load->model("cpd_events");
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;

        }
    }
    
    function show($params = array()){
        $website = $this->EE->TMPL->fetch_param("website");
        $size = $this->EE->TMPL->fetch_param("size");
        $limit = $this->EE->TMPL->fetch_param("limit");
        $device = $this->EE->TMPL->fetch_param("device");
        
        if($this->helper->is_mobile_device()){
           if($device == 'no_iphone'){
               return '';
           } 
        }else {
           if($device == 'iphone'){
               return '';
           }  
        }
        
        if(empty($limit)){
            $limit = 1;
        }
        $now_date = new DateTime();
        $now_date = $now_date->format("Y-m-d");
        $country = strtolower(self::$country);
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        /// search adverts ///
        $params = array();
        $params['id'] = $GLOBALS['adverts_event_id'];
        $params['selects'] = "{#m}.id,{#m}.document_name,{#c}.webad_c,{#c}.webad2_c,{#c}.link_target_c,{#c}.target_url_c,{#c}.charge_basis_c,{#c}.impressions_c,{#c}.impression_target_c,{#c}.clicks_c,{#c}.click_target_c";
        //$params['where'] = "{#c}.target_website_c='DentistComAU' and {#c}.website_ad_status_c='Active' and {#c}.start_date_c <= '{$now_date}' and {#c}.end_date_c >= '{$now_date}' and {#c}.ad_position_c='YDsidebar' and LOWER({#c}.target_country_c) like '%^{$country}^%'";
        $params['where'] = "{#c}.target_websites_c like '%^{$website}^%' and {#c}.website_ad_status_c='Active' and {#c}.start_date_c <= '{$now_date}' and {#c}.end_date_c >= '{$now_date}' and {#m}.size='{$size}' and LOWER({#c}.target_country_c) like '%^{$country}^%'";
        //$params['where'] = "{#c}.target_websites_c like '%^{$website}^%' and {#c}.website_ad_status_c='Active' and {#c}.start_date_c <= '{$now_date}' and {#c}.end_date_c >= '{$now_date}' and {#m}.size='{$size}'";
        $params['orders'] = "rand()";
        $params['limit'] = $limit;
        $_adverts = $this->EE->cpd_events->get_relationship_adverts($params);
        //////////////////////
        if(empty($_adverts)){
            return '';
        }
        
        
        
        /// logger for impressions ///
        self::$router = "logger:impressions";
        $success = AVTProcessing_Adverts::process(array('adverts' => $_adverts));
        //////////////////////////////
        
        foreach($_adverts as $key => $_advert){
            $_advert['web_ad'] = $img_base_url . $_advert['webad_c'];
            $_advert['web_ad2'] = $img_base_url . $_advert['webad2_c'];
            /// fetch target_url ///
            $target_url = '';
            if($_advert['link_target_c'] == 'URL'){
                $target_url = $_advert['target_url_c'];
            }
            if($_advert['link_target_c'] == 'Article'){
                $params = array();
                $params['selects'] = "{#m}.id";
                $params['id'] = $_advert['id'];
                $params['single'] = true;
                $_article = $this->EE->adverts->get_relationship_articles($params);  
                if(!empty($_article)){
                    $target_url = $_article['id'];
                }
            }
            if($_advert['link_target_c'] == 'Product'){
                $params = array();
                $params['selects'] = "{#m}.id";
                $params['id'] = $_advert['id'];
                $params['single'] = true;
                $_product = $this->EE->adverts->get_relationship_products($params);  
                if(!empty($_product)){
                    $target_url = $_product['id'];
                }
            }
            if($_advert['link_target_c'] == 'Event'){
                $params = array();
                $params['selects'] = "{#m}.id,{#m}.name,{#m}.event_country,{#c}.event_id_c";
                $params['id'] = $_advert['id'];
                $params['single'] = true;
                $_cpd_event = $this->EE->adverts->get_relationship_cpd_events($params);  
                if(!empty($_cpd_event)){
                    $target_url = $this->seo_helper->get_seo_url(Seo_Helper::DETAILS, array('id' => $_cpd_event['event_id_c'], 'name' => $_cpd_event['name'], 'country' => $_cpd_event['event_country']));
                }
            }
            $_advert['target_action'] = $target_url;
            ////////////////////////
            
            $_adverts[$key] = $_advert;
        }
        
        
        /////// get html for script ////
        $html = '';
        if($GLOBALS['web_ad_script'] != "included"){
            $swaps = array(
                        'dt' => 'dt'
                     );
            $datas = array(
                        'dt' => $_advert
                     );
            
            $TMPL = new EE_Template();         
            $TMPL->run_template_engine('adverts', 'show');
            $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));
            $GLOBALS['web_ad_script'] = "included";
        }
        ////////////////////////////////
        
        ////////////////////////////////
        $swaps = array(
                    'id' => 'id',
                    'web_ad' => 'web_ad',
                    'web_ad2' => 'web_ad2',
                    'target_action' => 'target_action',
                    'document_name' => 'document_name'
                );
        $tagdata = $this->EE->TMPL->tagdata;
        
        $return = '';
        foreach($_adverts as $_advert){
            $return .= $this->helper->render_results($swaps, $_advert, $tagdata);
        }
        /////////////////////////////////
        
        $html = $return . " " . $html;
        return $html;
    }
    
}