<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class AVTProcessing_Logger extends AVTProcessing{
    public static $country;
    
    function initialize($params = array()){
        $this->EE->load->model("general_hits");
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "impressions":
                return $this->record_impressions($params);
            break;
            case "clicks":
                return $this->record_clicks($params);
            break;
            case "impressions_p":
                return $this->record_impressions_plus($params);
            break;
            case "imp_plus":
                return $this->imp_plus($params);
            break;
        }

    }
    function imp_plus($params = ''){     
        $adverts_ids =  $this->EE->input->get_post("adverts");
        $now_year = date("Y");
        $now_month = date("m");
        $now_day = date("d");
        $datas = array();
        $link_datas = array();
        $link_ids = array();
        $advert_datas = array();
        if(count($adverts_ids) > 0){
            foreach ($adverts_ids as $key => $adverts_id) {
                $params = array();
                $params['selects'] = "{#m}.id,{#c}.charge_basis_c,{#c}.impressions_c,{#c}.impression_target_c,{#c}.clicks_c,{#c}.click_target_c,{#c}.imp_dentevents_com_c";
                $params['where'] = "{#m}.id = '{$adverts_id}'";
                $params['single'] = true;
                $_advert = $this->EE->adverts->get_main_data($params);
                $params = array();
                $params['selects'] = "{#m}.id,{#m}.schresult";
                $params['where'] = "{#m}.month='{$now_month}' and {#m}.year='{$now_year}' and {#m}.keyvalue='{$now_day}'";
                $params['single'] = true;
                $params['id'] = $_advert['id'];
                $_hit = $this->EE->adverts->get_relationship_general_hits($params);
                if(empty($_hit)){
                     $link_datas[] = array(
                            'name' => $_advert['document_name'],
                            'month' => $now_month,
                            'year' => $now_year,
                            'keytype' => 'webAd',
                            'keyvalue' => $now_day,
                            'schresult' => 1
                        );
                     $link_ids[] = $_advert['id'];
                }else{
                     $schresult = $_hit['schresult'] * 1 + 1;
                     $_hit['schresult'] = $schresult;
                     $datas[] = $_hit;
                }
                
                /// test for budget ///
                if($_advert['charge_basis_c'] == 'Impressions'){
                        
                    
                    if($_advert['impressions_c'] >= $_advert['impression_target_c']){
                        $advert_datas[] = array('id' => $_advert['id'], 'website_ad_status_c' => 'BudgetReached');
                    }
                    continue;
                }
                ///////////////////////
                if(empty($_advert['impressions_c'])){
                        $_advert['impressions_c'] = 0;
                    }
                $_advert['impressions_c'] = $_advert['impressions_c'] * 1 + 1;
                if(empty($_advert['imp_dentevents_com_c'])){
                        $_advert['imp_dentevents_com_c'] = 0;
                    }
                $_advert['imp_dentevents_com_c'] = $_advert['imp_dentevents_com_c'] * 1 + 1;
                $advert_datas[] = array('id' => $_advert['id'], 'impressions_c' => $_advert['impressions_c'], 'imp_dentevents_com_c' => $_advert['imp_dentevents_com_c']);
            }
        }
        
        /// UPDATE general_hits ///
        if(!empty($datas)){
            $success = $this->EE->general_hits->set_records($datas);
            if(!$success){
                $this->logger->developer("Failed to update the general hits.");
                return false;
            }    
        } 
        ///////////////////////////
        
        /// UPDATE adverts ///
        if(!empty($advert_datas)){
            $success = $this->EE->adverts->set_records($advert_datas);
            if(!$success){
                $this->logger->developer("Failed to update the adverts.");
                return false;
            }    
        } 
        ///////////////////////////
        
        /// CREATE general_hits and linke those ///
        if(!empty($link_datas)){
            $success = $this->EE->general_hits->set_records($link_datas);
            if(!$success){
                $this->logger->developer("Failed to create the general hits.");
                return false;
            }
            $ids = $success;
            
            $success = $this->EE->adverts->add_relationships_app($link_ids, $ids, 'general_hits'); 
            if(!$success){
                $this->logger->developer("Failed to link the general_hits to the adverts.");
                return false;
            }     
        }

        return true;
        ///////////////////////////
    }
    function record_impressions_plus($params = ''){   

        $website =  $this->EE->input->get_post("website");
        $size = $this->EE->input->get_post("size");
        $id = $this->EE->input->get_post("id");
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.document_name,{#c}.webad_c,{#c}.webad_url_c,{#c}.webad2_c,{#c}.webad2_url_c,{#c}.link_target_c,{#c}.target_url_c,{#c}.charge_basis_c,{#c}.impressions_c,{#c}.impression_target_c,{#c}.clicks_c,{#c}.click_target_c";
        $params['where'] = "{#m}.id='{$id}'";
        $params['single'] = true;
        $_advert = $this->EE->adverts->get_main_data($params);
        
        
        $now_year = date("Y");
        $now_month = date("m");
        $now_day = date("d");
        

        $params = array();
        $params['id'] = $_advert['id'];
        $params['selects'] = "{#m}.id,{#m}.schresult";
        $params['where'] = "{#m}.month='{$now_month}' and {#m}.year='{$now_year}' and {#m}.keyvalue='{$now_day}'";
        $params['single'] = true;
        $_hit = $this->EE->adverts->get_relationship_general_hits($params);
        $success;
        if(!empty($_hit)){

            $schresult = $_hit['schresult'] * 1 + 1;
            $success = $this->EE->general_hits->set_record(array('id' => $_hit['id'], 'schresult' => $schresult));
            if(!$success){
                $this->logger->developer("Failed to increase the schresult on impressions for advertise.");
                return false;
            }    
        }else{
            $data = array(
                        'name' => $_advert['document_name'],
                        'month' => $now_month,
                        'year' => $now_year,
                        'keytype' => 'webAd',
                        'keyvalue' => $now_day,
                        'schresult' => 1
                    );
            $success = $this->EE->general_hits->set_record($data);
            if(!$success){
                $this->logger->developer("Failed to create the general hits record for impressions of advertise.");
                return false;
            }
            
            $link_id = $success;
            $success = $this->EE->adverts->add_relationship_app($_advert['id'], $link_id, 'general_hits');
            if(!$success){
                $this->logger->developer("Failed to link the general hits to adverts.");
                return false;
            }
        }
        
        /// test for budget ///
        if($_advert['charge_basis_c'] == 'Impressions'){
            if(empty($_advert['impressions_c'])){
                $_advert['impressions_c'] = 0;
            }
            $_advert['impressions_c'] = $_advert['impressions_c'] * 1 + 1;    
            
            if($_advert['impressions_c'] >= $_advert['impression_target_c']){
                $data = array('id' => $_advert['id'], 'website_ad_status_c' => 'BudgetReached');
                if(!empty($_advert['id']))
                    $success = $this->EE->adverts->set_record($data);
                
                if(!$success){
                    $this->logger->developer("Failed to update website_ad_status_c.");
                    return false;
                }else{
                    $output = array();
                    $output["adverts"] = $_advert;
                    $output["data"] = $success;
                    if($sucess){
                        $output["result"] = 'success';
                        $output["data"] = $success;
                    }else{
                        $output["result"] = ['failed'];
                    }
                    
                    $this->EE->load->library('javascript');
                    $output = $this->EE->javascript->generate_json($output, TRUE);
                    return $output;
                }
            }
        }
        $_advert['impressions_c'] = $_advert['impressions_c'] * 1 + 1;
        ///////////////////////
        if(!empty($_advert)){
            $_adverts = array();
            $_adverts[0] = $_advert;
            // $success = $this->EE->adverts->set_records($_adverts);
            $data = array('id' => $_advert['id'], 'impressions_c' => $_advert['impressions_c']);
            if(!empty($_advert['id']))
                $success = $this->EE->adverts->set_record($data);
            if(!$success){
                $this->logger->developer("Failed to update the adverts.");
                return false;
            }    
        }
        // ////////////////////////////
        $output = array();
        $output["adverts"] = $_advert;
        $output["data"] = $success;
        if($success){
            $output["result"] = 'success';
            $output["data"] = $success;
        }else{
            $output["result"] = ['failed'];
        }
        
        $this->EE->load->library('javascript');
        $output = $this->EE->javascript->generate_json($output, TRUE);
        return $output;
        
    }
    function record_impressions($params = ''){     
        $_adverts = $params['adverts'];   
        $now_year = date("Y");
        $now_month = date("m");
        $now_day = date("d");
        
        $datas = array();
        $link_datas = array();
        $link_ids = array();
        $advert_datas = array();
        
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.schresult";
        $params['where'] = "{#m}.month='{$now_month}' and {#m}.year='{$now_year}' and {#m}.keyvalue='{$now_day}'";
        $params['single'] = true;
        
        foreach($_adverts as $_advert){
            if(empty($_advert['id']))
                continue;
            $params['id'] = $_advert['id'];
            $_hit = $this->EE->adverts->get_relationship_general_hits($params);
            
            if(empty($_hit)){
                 $link_datas[] = array(
                        'name' => $_advert['document_name'],
                        'month' => $now_month,
                        'year' => $now_year,
                        'keytype' => 'webAd',
                        'keyvalue' => $now_day,
                        'schresult' => 1
                    );
                 $link_ids[] = $_advert['id'];
            }else{
                 $schresult = $_hit['schresult'] * 1 + 1;
                 $_hit['schresult'] = $schresult;
                 $datas[] = $_hit;
            }
            
            /// test for budget ///
            if($_advert['charge_basis_c'] == 'Impressions'){
                    
                
                if($_advert['impressions_c'] >= $_advert['impression_target_c']){
                    $advert_datas[] = array('id' => $_advert['id'], 'website_ad_status_c' => 'BudgetReached');
                }
                continue;
            }
            ///////////////////////
            if(empty($_advert['impressions_c'])){
                    $_advert['impressions_c'] = 0;
                }
            $_advert['impressions_c'] = $_advert['impressions_c'] * 1 + 1;
            if(empty($_advert['imp_dentevents_com_c'])){
                    $_advert['imp_dentevents_com_c'] = 0;
                }
            $_advert['imp_dentevents_com_c'] = $_advert['imp_dentevents_com_c'] * 1 + 1;
            $advert_datas[] = array('id' => $_advert['id'], 'impressions_c' => $_advert['impressions_c'], 'imp_dentevents_com_c' => $_advert['imp_dentevents_com_c']);
        }


        /// UPDATE general_hits ///
        if(!empty($datas)){
            $success = $this->EE->general_hits->set_records($datas);
            if(!$success){
                $this->logger->developer("Failed to update the general hits.");
                return false;
            }    
        } 
        ///////////////////////////
        
        /// UPDATE adverts ///
        if(!empty($advert_datas)){
            $success = $this->EE->adverts->set_records($advert_datas);
            if(!$success){
                $this->logger->developer("Failed to update the adverts.");
                return false;
            }    
        } 
        ///////////////////////////
        
        /// CREATE general_hits and linke those ///
        if(!empty($link_datas)){
            $success = $this->EE->general_hits->set_records($link_datas);
            if(!$success){
                $this->logger->developer("Failed to create the general hits.");
                return false;
            }
            $ids = $success;
            
            $success = $this->EE->adverts->add_relationships_app($link_ids, $ids, 'general_hits'); 
            if(!$success){
                $this->logger->developer("Failed to link the general_hits to the adverts.");
                return false;
            }     
        }

        return true;
        ///////////////////////////
    }
    
    function record_clicks($params = ''){     
        $_advert = $params['advert'];  
        if(empty($_advert)){
            $id = $this->EE->input->get_post("id");
            /// search adverts ///
            $params = array();
            $params['selects'] = "{#m}.id,{#m}.document_name,{#c}.webad_c,{#c}.link_target_c,{#c}.target_url_c,{#c}.charge_basis_c,{#c}.impressions_c,{#c}.impression_target_c,{#c}.clicks_c,{#c}.click_target_c,{#c}.clicks_dentevents_com_c";
            $params['where'] = "{#m}.id='{$id}'";
            $params['single'] = true;
            $_advert = $this->EE->adverts->get_main_data($params);
        }
        
         
        $now_year = date("Y");
        $now_month = date("m");
        $now_day = date("d");
        
        $params = array();
        $params['id'] = $_advert['id'];
        $params['selects'] = "{#m}.id,{#m}.schclick";
        $params['where'] = "{#m}.month='{$now_month}' and {#m}.year='{$now_year}' and {#m}.keyvalue='{$now_day}'";
        $params['single'] = true;
        $_hit = $this->EE->adverts->get_relationship_general_hits($params);
        
        if(!empty($_hit)){
            $schclick = $_hit['schclick'] * 1 + 1;
            $success = $this->EE->general_hits->set_record(array('id' => $_hit['id'], 'schclick' => $schclick));
            if(!$success){
                $this->logger->developer("Failed to increase the schclick on impressions for advertise.");
                return false;
            }    
        }else{
            $data = array(
                        'name' => $_advert['document_name'],
                        'month' => $now_month,
                        'year' => $now_year,
                        'keytype' => 'webAd',
                        'keyvalue' => $now_day,
                        'schclick' => 1
                    );
            $success = $this->EE->general_hits->set_record($data);
            if(!$success){
                $this->logger->developer("Failed to create the general hits record for schclicks of advertise.");
                return false;
            }
            
            
            $link_id = $success;
            $success = $this->EE->adverts->add_relationship_app($_advert['id'], $link_id, 'general_hits');
            if(!$success){
                $this->logger->developer("Failed to link the general hits to adverts.");
                return false;
            }
        }
        
        /// test for budget ///
        if($_advert['charge_basis_c'] == 'Clicks'){
                
            
            if($_advert['clicks_c'] >= $_advert['click_target_c']){
                $data = array('id' => $_advert['id'], 'website_ad_status_c' => 'BudgetReached');
                $success = $this->EE->adverts->set_record($data);
                
                if(!$success){
                    $this->logger->developer("Failed to update website_ad_status_c.");
                    return false;
                }
            }
        }
        ///////////////////////
        if(empty($_advert['clicks_c'])){
            $_advert['clicks_c'] = 0;
        }
        $_advert['clicks_c'] = $_advert['clicks_c'] * 1 + 1;
        if(empty($_advert['clicks_dentevents_com_c'])){
            $_advert['clicks_dentevents_com_c'] = 0;
        }
        $click_tv = $_advert['clicks_dentevents_com_c'] * 1 + 1;
        $data = array('id' => $_advert['id'], 'clicks_c' => $_advert['clicks_c'], 'clicks_dentevents_com_c' => $click_tv);
        
        $success = $this->EE->adverts->set_record($data);
        
       $output = array("result" => 'success');
        
       $this->EE->load->library('javascript');
       $output = $this->EE->javascript->generate_json($output, TRUE);
       return $output;
    }
}