<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class AVTProcessing_Adverts extends AVTProcessing{
    public static $country;
    
    function initialize($params = array()){
        $this->EE->load->model("adverts");
        $this->EE->load->model("articles");
        $this->EE->load->model("products");
        $this->EE->load->model('cpd_events');
        $this->EE->load->model('general_hits');
        
        self::$country = $this->helper->getRemoteCountry(true);
        if(self::$country == null){
            self::$country = "Australia";
        }else{
            self::$country = self::$country->country_name;
        }
        
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "record":
                return $this->record($params);
            break;
            case "show_video":
                return $this->show_video($params);
            break;
            case "event":
                require_once(PATH_THIRD . 'madverts/models/adverts/event.php');
                $processing = new AVTProcessing_Adverts_Event();
                $processing->initialize($params);
                return $processing->process($params);
            break;    
            case "logger":
                require_once(PATH_THIRD . 'madverts/models/adverts/logger.php');
                $processing = new AVTProcessing_Logger();
                $processing->initialize($params);
                return $processing->process($params);
            break;    
     
        }

    }

    function show_video($params = array()){
        $website = $this->EE->TMPL->fetch_param("website");
        $size = $this->EE->TMPL->fetch_param("size");
        $limit = $this->EE->TMPL->fetch_param("limit");
        $device = $this->EE->TMPL->fetch_param("device");
        
        if($this->helper->is_mobile_device()){
           if($device == 'no_iphone'){
               return '';
           } 
        }else {
           if($device == 'iphone'){
               return '';
           }  
        }
        
        if(empty($limit)){
            $limit = 1;
        }
        $now_date = new DateTime();
        $now_date = $now_date->format("Y-m-d");
        $country = strtolower(self::$country);
        /*if($_SERVER['REMOTE_ADDR'] == '209.58.131.5'){
            var_dump($country);exit;    
        }*/
        if($country == "united states"){
            $country = "usa";
        }
        $this->EE->load->model('cpd_events');

        $cur_date = date("Y-m-d");
        
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.start_date,{#m}.end_date,{#m}.name,{#c}.dentevents_tv_thumbnail_c,{#c}.dentevents_tv_source_c,{#c}.dentevents_tv_source_id_c,{#c}.dentevents_tv_thumnail_img_c,{#c}.dentevents_tv_channel_c,{#c}.dentevents_tv_thumb_sm_img_c,{#c}.dentevents_tv_duration_c";
        $params['where'] = "{#m}.event_status = 'Approved_Online' AND {#m}.event_format in('Webinar' , 'OnlineLearning') AND {#c}.dentevents_tv_c = 1 AND {#c}.dentevents_tv_channel_c LIKE '%^Featured^%' AND {#c}.dentevents_tv_content_status_c = 'Library' AND {#m}.end_date >= '{$cur_date}' AND {#m}.start_date < '{$cur_date}'";

        // $limit = 10;
        $params['limit'] = 1;
        $params['orders'] = "rand()";
        $selected_events = $this->EE->cpd_events->get_main_data($params);

        $img_base_url = $this->_crm_config['main']['upload_url'];
        $datas = array();
        foreach ($selected_events as $key => $value) {
            if($value['dentevents_tv_source_id_c']){

                $datas[$key]['sub_id'] = $value['id'];
                $event_id = $value['id'];
                $datas[$key]['name'] = $value['name'];
                
                
                $url = $value['dentevents_tv_source_id_c'];
                $datas[$key]['source_id'] = $url;
                $content = '';
                if($value['dentevents_tv_source_c'] == "YouTube"){
                    if($value['dentevents_tv_thumnail_img_c'])
                        $datas[$key]['thumb_url'] = $img_base_url.$value['dentevents_tv_thumnail_img_c'];
                    $content = "YouTube";
                }elseif ($value['dentevents_tv_source_c'] == "Vimeo") {
                    if($value['dentevents_tv_thumnail_img_c'])
                        $datas[$key]['thumb_url'] = $img_base_url.$value['dentevents_tv_thumnail_img_c'];
                    $content = "Vimeo";
                }
                $datas[$key]['url'] ="https://www.dentevents.tv/?ACT=60&cmd=events:video_detail&video_id=".$url."&content_type=".$content."&sub_id=".$event_id."&pre=no";
            }
        }
    
        ////////////////////////////////
        
        ////////////////////////////////
        $swaps = array(
                    'sub_id' => 'sub_id',
                    'name' => 'name',
                    'source_id' => 'source_id',
                    'thumb_url' => 'thumb_url',
                    'url' => 'url'
                );
        $tagdata = $this->EE->TMPL->tagdata;
        
        $return = '';
        foreach($datas as $_advert){
            $return .= $this->helper->render_results($swaps, $_advert, $tagdata);
        }
        /////////////////////////////////
        
        $html = $return;
        return $html;
    } 
    function record($params = array()){
        $website =  $this->EE->input->get_post("website");
        $size = $this->EE->input->get_post("size");
        $limit = 1;
        $device = $this->EE->input->get_post("device");
        if($this->helper->is_mobile_device()){
           if($device == 'no_iphone'){
               return '';
           } 
        }else {
           if($device == 'iphone'){
               return '';
           }  
        }
        $now_date = new DateTime();
        $now_date = $now_date->format("Y-m-d");
        $country = strtolower(self::$country);
        /*if($_SERVER['REMOTE_ADDR'] == '209.58.131.5'){
            var_dump($country);exit;    
        }*/
        if($country == "united states"){
            $country = "usa";
        }
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        /// search adverts ///
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.document_name,{#c}.webad_c,{#c}.webad_url_c,{#c}.webad2_c,{#c}.webad2_url_c,{#c}.link_target_c,{#c}.target_url_c,{#c}.charge_basis_c,{#c}.impressions_c,{#c}.impression_target_c,{#c}.clicks_c,{#c}.click_target_c";
        //$params['where'] = "{#c}.target_website_c='DentistComAU' and {#c}.website_ad_status_c='Active' and {#c}.start_date_c <= '{$now_date}' and {#c}.end_date_c >= '{$now_date}' and {#c}.ad_position_c='YDsidebar' and LOWER({#c}.target_country_c) like '%^{$country}^%'";
        $params['where'] = "{#c}.target_websites_c like '%^{$website}^%' and {#c}.website_ad_status_c='Active' and {#c}.start_date_c <= '{$now_date}' and {#c}.end_date_c >= '{$now_date}' and {#m}.size='{$size}' and LOWER({#c}.target_country_c) like '%^{$country}^%'";
        $params['orders'] = "rand()";
        $params['limit'] = $limit;
        $_adverts = $this->EE->adverts->get_main_data($params);

        //////////////////////
        if(empty($_adverts)){
            
            return '';
        }
        // / logger for impressions ///
        self::$router = "logger:impressions";
        $success = AVTProcessing_Adverts::process(array('adverts' => $_adverts));
        ////////////////////////////
        $output = array();
        $output["adverts"] = $_adverts;
        $output["data"] = $success;
        if($sucess){
            $output["result"] = 'success';
            $output["data"] = $success;
        }else{
            $output["result"] = ['failed'];
        }
        
        $this->EE->load->library('javascript');
        $output = $this->EE->javascript->generate_json($output, TRUE);
        return $output;


    }
    function show($params = array()){
        $website = $this->EE->TMPL->fetch_param("website");
        $size = $this->EE->TMPL->fetch_param("size");
        $limit = $this->EE->TMPL->fetch_param("limit");
        $device_1 = $this->EE->TMPL->fetch_param("device");
        $device = $this->EE->TMPL->fetch_param("dev");
        $phone_list = $this->EE->TMPL->fetch_param("phone_list");
        require_once(PATH_THIRD . 'mdentevents/models/mdentevents/details/premium/registration/registrants/lib/detect.php');
        $detect = new Detect;
        if($this->helper->is_mobile_device()){
           if($device == 'no_iphone'){
               return '';
           } 
        }else {
           if($device == 'iphone'){
               return '';
           }  
        }
        
        if(empty($limit)){
            $limit = 1;
        }
        $now_date = new DateTime();
        $now_date = $now_date->format("Y-m-d");
        $country = strtolower(self::$country);
        /*if($_SERVER['REMOTE_ADDR'] == '209.58.131.5'){
            var_dump($country);exit;    
        }*/
        if($country == "united states"){
            $country = "usa";
        }
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        $is_mobile;
        if($detect->isMobile())
          $is_mobile = "Yes";
        else
          $is_mobile = "No";

        if(($is_mobile == "No" && $device =="desktop") || ($is_mobile == "Yes" && $device =="mobile") || $device == "all"){
            /// search adverts ///
            $params = array();
            $params['selects'] = "{#m}.id,{#m}.document_name,{#c}.webad_c,{#c}.webad_url_c,{#c}.webad2_c,{#c}.webad2_url_c,{#c}.link_target_c,{#c}.target_url_c,{#c}.charge_basis_c,{#c}.impressions_c,{#c}.impression_target_c,{#c}.clicks_c,{#c}.click_target_c,{#c}.imp_dentevents_com_c";
            //$params['where'] = "{#c}.target_website_c='DentistComAU' and {#c}.website_ad_status_c='Active' and {#c}.start_date_c <= '{$now_date}' and {#c}.end_date_c >= '{$now_date}' and {#c}.ad_position_c='YDsidebar' and LOWER({#c}.target_country_c) like '%^{$country}^%'";
            $params['where'] = "{#c}.target_websites_c like '%^{$website}^%' and {#c}.website_ad_status_c='Active' and {#c}.start_date_c <= '{$now_date}' and {#c}.end_date_c >= '{$now_date}' and {#m}.size='{$size}' and LOWER({#c}.target_country_c) like '%^{$country}^%'";
            $params['orders'] = "rand()";
            $params['limit'] = $limit;
            $_adverts = $this->EE->adverts->get_main_data($params);
            if($_SERVER['REMOTE_ADDR'] == "103.6.219.60"){
                //         var_dump($size);
                // var_dump($_adverts);
            }
            //////////////////////
            if(empty($_adverts)){
                if($size == 'Leaderboard'){
                    $params['selects'] = "{#m}.id,{#m}.document_name,{#c}.webad_c,{#c}.webad_url_c,{#c}.webad2_c,{#c}.webad2_url_c,{#c}.link_target_c,{#c}.target_url_c,{#c}.charge_basis_c,{#c}.impressions_c,{#c}.impression_target_c,{#c}.clicks_c,{#c}.click_target_c,{#c}.imp_dentevents_com_c";
                    $params['where'] = "{#m}.id='c315e71c-bf80-11eb-82a5-799be91ff9f5'";
                    $_adverts = $this->EE->adverts->get_main_data($params);
                    $_adverts[0]['web_ad'] = $_adverts[0]['webad2_url_c'];

                    $_adverts[0]['target_action'] = $_adverts[0]['target_url_c'];
                }else
                    return '';
            }else{
                foreach($_adverts as $key => $_advert){
                    if(!empty($_advert['webad_url_c'])){
                        $_advert['web_ad'] = $_advert['webad_url_c'];
                    }else{
                        $_advert['web_ad'] = $img_base_url . $_advert['webad_c'];
                    }

                    if(!empty($_advert['webad2_url_c'])){
                        $_advert['web_ad2'] = $_advert['webad2_url_c'];
                    }else{
                        $_advert['web_ad2'] = $img_base_url . $_advert['webad2_c'];
                    }
                    
                    /// fetch target_url ///
                    $target_url = '';
                    if($_advert['link_target_c'] == 'URL'){
                        $target_url = $_advert['target_url_c'];
                    }
                    if($_advert['link_target_c'] == 'Article'){
                        $params = array();
                        $params['selects'] = "{#m}.id";
                        $params['id'] = $_advert['id'];
                        $params['single'] = true;
                        $_article = $this->EE->adverts->get_relationship_articles($params);  
                        if(!empty($_article)){
                            $target_url = $_article['id'];
                        }
                    }
                    if($_advert['link_target_c'] == 'Product'){
                        $params = array();
                        $params['selects'] = "{#m}.id";
                        $params['id'] = $_advert['id'];
                        $params['single'] = true;
                        $_product = $this->EE->adverts->get_relationship_products($params);  
                        if(!empty($_product)){
                            $target_url = $_product['id'];
                        }
                    }
                    if($_advert['link_target_c'] == 'Event'){
                        $params = array();
                        $params['selects'] = "{#m}.id,{#m}.name,{#m}.event_country,{#c}.event_id_c";
                        $params['id'] = $_advert['id'];
                        $params['single'] = true;
                        $_cpd_event = $this->EE->adverts->get_relationship_cpd_events($params);  
                        if(!empty($_cpd_event)){
                            $target_url = $this->seo_helper->get_seo_url(Seo_Helper::DETAILS, array('id' => $_cpd_event['event_id_c'], 'name' => $_cpd_event['name'], 'country' => $_cpd_event['event_country']));
                        }
                    }
                    $_advert['target_action'] = $target_url;
                    ////////////////////////
                    
                    $_adverts[$key] = $_advert;
                }
            }
            
            
            
            // logger for impressions ///

            // if($size != "Slider"){
            //     self::$router = "logger:impressions";
            //     $success = AVTProcessing_Adverts::process(array('adverts' => $_adverts));
            // }
            ////////////////////////////
            

            
            
            /////// get html for script ////
            $html = '';
            if($GLOBALS['web_ad_script'] != "included"){
                $swaps = array(
                            'dt' => 'dt'
                         );
                $datas = array(
                            'dt' => $_advert
                         );
                
                $TMPL = new EE_Template();         
                $TMPL->run_template_engine('adverts', 'show');
                $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));
                $GLOBALS['web_ad_script'] = "included";
            }
            ////////////////////////////////
            
            ////////////////////////////////
            $swaps = array(
                        'id' => 'id',
                        'web_ad' => 'web_ad',
                        'web_ad2' => 'web_ad2',
                        'target_action' => 'target_action',
                        'document_name' => 'document_name'
                    );
            $tagdata = $this->EE->TMPL->tagdata;
            
            $return = '';
            foreach($_adverts as $_advert){
                $return .= $this->helper->render_results($swaps, $_advert, $tagdata);
            }
            /////////////////////////////////
            
            $html = $return . " " . $html;
            return $html;
        }
    }
    
}