<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Boards_Create extends BRDProcessing_Boards{
    protected $image_helper;
    function initialize($params = array()){
        $this->EE->load->model("disc_discussion_boards");
        $this->EE->load->model("grp_groups");
        $this->EE->load->model("grp_group_members");
        $this->EE->load->model("article_image");
        self::$utility->fetch_contact(); 
        
        $this->EE->load->helper('image');
        $this->image_helper = new Image_Helper();
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                $this->show($params);
            break;
            case "send":
                return $this->send($params);
            break;    
            case "upcoming_speakers":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/widget/upcoming_speakers.php');
                $processing = new DEProcessing_Dentevents_Widget_UpcomingSpeakers();
                $processing->initialize($params);
                return $processing->process($params);
            break;
        }

    }
    
    function show($params){
        $_contact = self::$contact;
        
        $datas = array();
        
        /// get list of category ///
        $category_opts = $this->helper->make_select_opts('topic_category_0', '');
        $datas['category_opts'] = $category_opts;
        ////////////////////////////
        
        /////////// get groups /////////////////
        $results = self::$utility->get_groups_user($_contact['id']);
        $groups = array();
        foreach($results as $item){
            $groups[$item['id']] = $item['name'];
        }
        $groups_opts = $this->helper->make_select_opts($groups);
        
        $datas['groups_opts'] = $groups_opts;
        /////////////////////////////////////////
        
        $action_id = $this->helper->fetch_action_id("Mboards", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );
               
        $this->EE->TMPL->run_template_engine("boards", "create");
        $this->EE->output->app_output($swaps, $datas);
    }
    
    
    //////////////////////////////////////
    private function process_video($board_id){
        $video_id = $this->EE->input->get_post('video_id');
        if(empty($video_id)){
            return;
        }
        
        $data = array();
        $data['name'] = "Discussion board video posted by {$this->contact_name}";
        $data['image_type'] = 'Video';
        $data['image_format'] = "News";
        $data['portal_show'] = "Public";
        $data['video_source_c'] = "YouTube";
        $data['video_id_c'] = $video_id;
        $data['sequence'] = '1';
        
        $success = $this->EE->article_image->set_record($data);
        if (!$success){
            $this->logger->developer("Failed to article_image video.");
            return false;
        }
        
        $image_id = $success;
        
        /// link video to post ///
        $success = $this->EE->disc_discussion_boards->add_relationship_app($board_id, $image_id, 'article_images');
        if (!$success){
            $this->logger->developer("Failed to link grp_discussion_item to article images video.");
            return false;
        }
    }
    
    private function upload_image($multiple_index){
        $file_id = 'reply_image';
        if(empty($_FILES[$file_id]['name'][$multiple_index]))
            return null;

        $this->EE->load->helper('image');
        $image = new Image_Helper();
       
        /// CONFIGURE the validation image ///
        $size_params = array();
        $size_params['width'] = 600;
        $size_params['accept_width'] = 'any';
        $size_params['multiple'] = $multiple_index;
        
        $result = $image->validation_image($file_id, $size_params);
        //////////////////////////////////////
        $output = array();
        $output['success'] = 0;
        $error_code = '';
        
        if ($result === 0){
            $filename = $image->generate_guid();
            if ($image->upload_to_crm($file_id, $filename, $size_params)){
                $output['success'] = 1;
                $output['filename'] = $filename;
            }else{
                $error_code = "error_fail_upload";
            }
        }else{
            $error_code = $result;
        }
       
        if($output['success'] == 0){
            if(is_string($error_code)){
                $output['error'] = $this->_app_config['error_code'][$error_code];
            }else{
                if($error_code['code'] == "error_small_width" && $error_code['code'] == "error_small_height"){
                    
                }else if($error_code['code'] == "error_small_width"){
                    $output['error'] = "Upload Error: Please select an image at least {$error_code['size']} pixels wide.";
                }else if($error_code['code'] == "error_small_height"){
                    $output['error'] = "Upload Error: Please select an image at least {$error_code['size']} pixels deep.";
                }       
            } 
        }
        
        return $output;
    }
    private function process_image($board_id, $filename){
        if(empty($filename)){
            return;
        }
        $data = array();
        $data['name'] = "Discussion board image posted by {$this->contact_name}";
        $data['image_type'] = 'Photograph';
        $data['image_format'] = "News";
        $data['portal_show'] = "Portal";
        $data['article_image'] = $filename;
        $data['sequence'] = '1';
        
        $success = $this->EE->article_image->set_record($data);
        if (!$success){
            $this->logger->developer("Failed to article_image.");
            return false;
        }
        
        $image_id = $success;
        
        /// link image to post ///
        $success = $this->EE->disc_discussion_boards->add_relationship_app($board_id, $image_id, 'article_images');
        if (!$success){
            $this->logger->developer("Failed to link grp_discussion_item to article images.");
            return false;
        }
    }
    
    function send($sparams = array()){
        $_contact = self::$contact;

        $category = $this->EE->input->get_post("category");
        $topic = $this->EE->input->get_post("topic");
        $description = $this->EE->input->get_post("description");
        $view_group = $this->EE->input->get_post("view_groups");
        $participate_group = $this->EE->input->get_post("participate_groups");
        
        $contact_name = $_contact['salutation'] . ' ' . $_contact['first_name'] . ' ' . $_contact['initial_c'] . ' ' . $_contact['last_name']; 
        if(!empty($_poster['prefname_c'])){
            $contact_name = $_contact['salutation'] . ' ' .  $_contact['prefname_c'] . ' ' . $_contact['last_name']; 
        }
        $this->contact_name = $contact_name;
        
        $now_date = date("Y-m-d");
        
        /// upload image ///
        $uploads_count = $this->image_helper->check_multiple('reply_image');
        $upload_statuses = array();
        $upload_error = false;
        for($i = 0 ; $i < $uploads_count; $i++){
            if(($upload_result = $this->upload_image($i)) != null){
                $upload_statuses[] = $upload_result;
                if($upload_result['success'] === 1){
                }else{
                    $upload_error= true;
                }
            }
        }
        if($upload_error){
            foreach($upload_statuses as $item){
                if($item['success'] == 1 && !empty($item['filename'])){
                    $this->image_helper->remove_old_upload_crm($item['filename']);
                }
            }
            $json = json_encode($upload_statuses);
            //header("Content-Type: application/json"); 
            echo $json;  exit;
        }
        ////////////////////
        
        /// create board ///
            $access = '';
            /// init access ///
            if(empty($view_group) && empty($participate_group)){
                $access = "Open";
            }
            if(empty($view_group) && !empty($participate_group)){
                $access = "GroupUpdateAnyView";
            }
            if(!empty($view_group)){
                $access = "GroupOnly";
            }
            ///////////////////
        $data = array();
        $data['name'] = $topic;
        $data['description'] = $description;
        $data['topic_category'] = $category;
        $data['access_c'] = $access;
        $data['status_c'] = "Active";
        
        $success = $this->EE->disc_discussion_boards->set_record($data);
        if (!$success){
            $this->logger->developer("Failed to create disc_discussion_boards.");
            return false;
        }
        
        $board_id = $success;
            /// link board to group ///
            if(!empty($view_group)){
                $group_id = $view_group;    
            }
            if(!empty($participate_group)){
                $group_id = $participate_group;    
            }
            if(!empty($group_id)){
                $success = $this->EE->disc_discussion_boards->add_relationship_app($board_id, $group_id, 'group_access');
                if (!$success){
                    $this->logger->developer("Failed to link board to group.");
                    return false;
                }
            }
            ///////////////////////////
            
        //////////////////  
         
        /// image ///
        foreach($upload_statuses as $item){
            $filename = $item['filename'];
            $this->process_image($board_id, $filename);
        }
        /////////////
        
        /// video ///
        $this->process_video($board_id);
        /////////////
        
        /// follow topic ///
        $success = $this->EE->disc_discussion_boards->add_relationship_app($board_id, $_contact['id'], "followers");
        if(!$success){
            $this->logger->developer("Failed to link follow topic.");    
        }
        ////////////////////
        
        /// add contacts ///
        $success = $this->EE->disc_discussion_boards->add_relationship_app($board_id, $_contact['id'], "contacts");
        if(!$success){
            $this->logger->developer("Failed to link the contacts.");    
        }
        ////////////////////
        
        /// make member contacts follower to this board ///
        $members_from_board = $this->EE->grp_groups->get_relationship_group_members(
                        array('id' => $group_id, 'selects' => "{#m}.id", 'to_values' => 'id')
                    );
        $contacts_in_members = array();
        foreach($members_from_board as $member_id){
            $contacts_in_member = $this->EE->grp_group_members->get_relationship_contacts(
                        array('id' => $member_id, 'selects' => "{#m}.id", 'to_values' => 'id')
                    );
            $contacts_in_members = array_merge($contacts_in_members, $contacts_in_member);
        }
        $contacts_in_members = array_unique($contacts_in_members);
        $success = $this->EE->disc_discussion_boards->add_relationship_app($board_id, $contacts_in_members, "followers");
        if(!$success){
            $this->logger->developer("Failed to link the followers. " . get_class($this));    
        }
        ///////////////////////////////////////////////////
        
        $json = json_encode(array('result' => 'success', 'id' => $board_id));
        echo $json; exit;
    } 
}