<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Boards_Details extends BRDProcessing_Boards{
    static $board;
    
    function initialize($params = array()){
        $this->EE->load->model("disc_discussion_boards");
        $this->EE->load->model("contacts");
        
        self::$utility->fetch_contact();
        
        $id = $this->EE->input->get_post("id");
        
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.name,{#m}.description,{#m}.date_entered,{#c}.access_c";
        $params['where'] = "{#m}.id='{$id}'";
        $params['single'] = true;
        self::$board = $this->EE->disc_discussion_boards->get_main_data($params);
        
        /// check access ///
        $access = self::$utility->check_access_board(self::$board, true);
        self::$board['board_access'] = $access;

        if($access['view'] == 0){
            self::$router = "noaccess:show";
        }
        ////////////////////
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "posts":
                require_once(PATH_THIRD . 'mboards/models/mboards/details/posts.php');
                $processing = new BRDProcessing_Boards_Details_Posts();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "add_link":
                require_once(PATH_THIRD . 'mboards/models/mboards/details/add_link.php');
                $processing = new BRDProcessing_Boards_Details_AddLink();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "reply":
                require_once(PATH_THIRD . 'mboards/models/mboards/details/reply.php');
                $processing = new BRDProcessing_Boards_Details_Reply();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "quote":
                require_once(PATH_THIRD . 'mboards/models/mboards/details/quote.php');
                $processing = new BRDProcessing_Boards_Details_Quote();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "noaccess":
                require_once(PATH_THIRD . 'mboards/models/mboards/details/noaccess.php');
                $processing = new BRDProcessing_Boards_Details_NoAccess();
                $processing->initialize($params);
                return $processing->process($params);
            break;
        }

    }
    
    function show($params=''){
        $_board = self::$board;
        $image_base_url = $this->_crm_config['main']['upload_url'];
        
        $datas = array();
        /// main ///
        $main = $_board;
        $datas['main'] = &$main;
            /// date entered ///
            $date_entered = new DateTime($main['date_entered'], new DateTimeZone('UTC'));
            $date_entered->setTimezone( new DateTimeZone('Australia/Sydney'));
            $main['date_entered'] = array();
            $main['date_entered']['day'] = $date_entered->format("l");
            $main['date_entered']['date'] = $date_entered->format("d M Y");
            $main['date_entered']['time'] = $date_entered->format("g:i a");
            ////////////////////
        ////////////
        
        /// access informations ///
            $access_infos = array();
            $datas['access_infos'] = &$access_infos;
            /// privacy ///
            $privacy = '';
            switch($_board['access_c']){
                case 'Open':
                    $privacy = 'Open Access';
                break;
                case 'GroupOnly':
                    $privacy = 'Closed Group';
                break;
                case 'GroupUpdateAnyView':
                    $privacy = 'Open Viewing<br/>Group Only Updating';
                break;
            }
            $access_infos['privacy'] = $privacy;
            ///////////////
            
            /// group access ///
            $group_access = '';
            if($_board['access_c'] != 'Open'){
                $_group = $this->EE->disc_discussion_boards->get_relationship_group_access(
                        array('id' => $_board['id'], 'selects' => "{#m}.id,{#m}.name", 'single' => true)
                    );    
                if(!empty($_group)){
                    $group_access = $_group['name'];
                } 
            }
            $access_infos['group_access'] = $group_access;
            ////////////////////
            
            if($_board['access_c'] != 'Open'){
                /// group members total ///
                $access_infos['group_members_total'] = self::$board['board_access']['members']['totals'];
                ///////////////////////////
                
                /// group leader ///
                $group_leader = '';
                if(!empty(self::$board['board_access']['members']['owners'])){
                    $owners = self::$board['board_access']['members']['owners'];    
                    
                    $_owner = self::$utility->fetch_contact_by_id($owners[0]);
                    $group_leader = $_owner['salutation'] . ' ' . $_owner['first_name'] . ' ' . $_owner['initial_c'] . ' ' . $_owner['last_name']; 
                    if(!empty($_owner['prefname_c'])){
                        $group_leader = $_owner['salutation'] . ' ' .  $_owner['prefname_c'] . ' ' . $_owner['last_name']; 
                    }
                }
                $access_infos['group_leader'] = $group_leader;
                ////////////////////
                
                /// group account logo///
                $_group_account = $this->EE->grp_groups->get_relationship_accounts(
                            array('id' => $_group['id'], 'selects' => "{#m}.id,{#c}.logo_c", 'single' => true)
                        );
                if($_group_account != null && !empty($_group_account['logo_c'])){
                    $access_infos['group_account_logo'] = $image_base_url . $_group_account['logo_c'];
                }
                /////////////////////////
            }
            
        ///////////////////////////
        
        /// article images ///
        $article_images = array();
        $datas['article_images'] = &$article_images;
            /// get image ///
            $params = array();
            $params['id'] = $_board['id'];
            $params['selects'] = "{#m}.id,{#m}.article_image,{#m}.description";
            $params['where'] = "{#m}.image_type='Photograph' and {#m}.image_format='News' and {#m}.portal_show <> 'No'";
            $params['orders'] = "{#m}.sequence asc";
            $_images = $this->EE->disc_discussion_boards->get_relationship_article_images($params);
            foreach($_images as $key => $item){
                $_images[$key]['image'] = $image_base_url . $item['article_image']; 
            }
            $_images['totals'] = count($_images);
            $article_images['images'] = $_images;
            /////////////////
            
            /// get video ///
            $params = array();
            $params['id'] = $_board['id'];
            $params['selects'] = "{#m}.id,{#m}.description,{#c}.video_id_c,{#c}.video_source_c";
            $params['where'] = "{#m}.image_type='Video' and {#m}.portal_show <> 'No'";
            $params['orders'] = "{#m}.sequence asc";
            $params['single'] = true;
            $_video = $this->EE->disc_discussion_boards->get_relationship_article_images($params);
            $article_images['video'] = $_video;  
            /////////////////
            
            /// check format ///
            if($_images['totals'] != 0 && $_video != null){
                $article_images['format'] = "both";
            }else if($_images['totals'] == 0 && $_video == null){
                $article_images['format'] = "noboth";
            }else{
                $article_images['format'] = "onlyone";
            }
            ////////////////////
            
        //////////////////////
        
        /// poster ///
        $poster = array();
        $datas['poster'] = &$poster;
        $params = array();
        $params['id'] = $_board['id'];
        $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,
                              {#c}.contact_id_nr_c,{#c}.prefname_c,{#c}.initial_c,{#c}.quals_c,{#c}.rego_domain_c,{#c}.prof_photo_c,
                              {#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c
                             ";
        $params['single'] = true;
        $_poster = $this->EE->disc_discussion_boards->get_relationship_contacts($params);
        if(!empty($_poster['prof_photo_c'])){
            $poster['photo'] = $image_base_url . $_poster['prof_photo_c'];
        }
        
        $poster['name'] = $_poster['salutation'] . ' ' . $_poster['first_name'] . ' ' . $_poster['initial_c'] . ' ' . $_poster['last_name']; 
        if(!empty($_poster['prefname_c'])){
            $poster['name'] = $_poster['salutation'] . ' ' .  $_poster['prefname_c'] . ' ' . $_poster['last_name']; 
        }
        $poster['quals'] = $_poster['quals_c'];
            /// pract type ///
            $practs = '';
            if(strtolower($_poster['rego_domain_c']) == 'australia'){
                 $practs = $_poster['pract_type_c'];
            }else if(strtolower($_poster['rego_domain_c']) == 'new zealand'){
                 $practs = $_poster['pract_type_nz_c'];
            }else{
                 $practs = $_poster['pract_type_other_1_c'];
            }
            $practs = trim($practs, "^");
            $practs = explode("^,^", $practs);
            
            if(count($practs) > 1){
                 $last_pract = array_pop($practs);
                 $practs = implode(", ", $practs) . " and " . $last_pract;
            }else{
                 $practs = implode(", ", $practs);
            }
            $poster['practs'] = $practs;
            /////////////////
        $poster['country'] = $_poster['rego_domain_c'];
        ////////////////
        
        /// posts ///
        $posts = array();
        $datas['posts'] = &$posts;
        self::$router = "posts:show";
        $posts_html = BRDProcessing_Boards_Details::process(array('output' => false, 'current_page' => 1));
        $posts['html'] = $posts_html;
        $posts['totals'] = BRDProcessing_Boards_Details_Posts::$totals;
        $posts['last_post'] = BRDProcessing_Boards_Details_Posts::$last_post;
        /////////////

        $action_id = $this->helper->fetch_action_id("Mboards", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );
               
        $this->EE->TMPL->run_template_engine("boards", "details");
        $this->EE->output->app_output($swaps, $datas);
    }
    
}