<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Boards_Details_Posts extends BRDProcessing_Boards_Details{
    static $list;
    static $last_post;
    static $totals;
    
    protected $current_page;
    
    function initialize($params = array()){
        $this->EE->load->model("grp_discussion_items");
        $this->EE->load->model("contacts");
        
        $board_id = self::$board['id'];
        $now_date = date("Y-m-d");
        
        $current_page = $this->EE->input->get_post('current_page');
        if(!empty($params['current_page'])){
            $current_page = $params['current_page'];
        }
        $this->current_page = $current_page;
        
        $params = array();
        $params['id'] = $board_id;
        $params['selects'] = "{#m}.id,{#m}.name,{#m}.date_entered,{#m}.description";
        $params['where'] = "{#c}.status_c='Active'";
        $params['orders'] = "{#m}.date_entered desc";
        
        self::$list = $this->EE->disc_discussion_boards->get_relationship_posts($params);
        
        /////////////////
        self::$totals = count(self::$list);
        
        $last_post = self::$list[0];
        if(!empty($last_post)){
            $date_entered = new DateTime($last_post['date_entered'], new DateTimeZone('UTC'));
            $date_entered->setTimezone( new DateTimeZone('Australia/Sydney'));
            
            $last_post['date_entered'] = array();
            $last_post['date_entered']['day'] = $date_entered->format("l");
            $last_post['date_entered']['date'] = $date_entered->format("d M Y");
            $last_post['date_entered']['time'] = $date_entered->format("g:i a");
        }
        
        self::$last_post = $last_post;
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "fetch_data":
                return $this->fetch_data($params);
            break;
            case "show":
                return $this->show($params);
            break;
        }

    }
    
    function fetch_data($params=''){
        $_contact = self::$contact;
        
        /// check moderator / owner ///
        $all_can_remove = false;
        if(in_array($_contact['id'], self::$board['board_access']['members']['owners']) ||
            in_array($_contact['id'], self::$board['board_access']['members']['moderators'])){
            $all_can_remove = true;
        }
        ///////////////////////////////
        
        $disable_pagination = $params['disable_pagination'];
        
        /// INITIALIZE the pagination ///
        $current_page = $this->current_page;
        $items_per_page = $this->_app_config['pagination']['boards:posts']['items_per_page'];
        $items_per_navigation = $this->_app_config['pagination']['boards:posts']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        $totals = count(self::$list);
        //////////////////////////////////
        
        $offset = ($current_page - 1) * $items_per_page;
        $list = array_slice(self::$list, $offset, $items_per_page);
        if($disable_pagination === true){
            $list = self::$list;
        }
        
        /// logging events ///
        //self::$router = "logger:record_events";
        //DEProcessing_Dentevents::process(array('events' => $events));
        //////////////////////
        
        $image_base_url = $this->_crm_config['main']['upload_url'];
               
        /// poster ///
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,
                              {#c}.contact_id_nr_c,{#c}.prefname_c,{#c}.initial_c,{#c}.quals_c,{#c}.rego_domain_c,{#c}.prof_photo_c,
                              {#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.pract_type_other_1_c,
                              {#c}.facebook_c,{#c}.twitter_c,{#c}.googleplus_c,{#c}.linkedin_c,{#c}.pinterest_c,
                              {#c}.instagram_c,{#c}.flickr_c,{#c}.xing_c,{#c}.tumblr_c,{#c}.vk_c,{#c}.youtube_c
                             ";
        $params['single'] = true;
        /////////////////////
        
        /// get contacts followed ///
        $contacts_followed = $this->EE->contacts->get_relationship_contacts_followed(
                                array(
                                    'id' => $_contact['id'],
                                    'selects' => "{#m}.id",
                                    'to_values' => 'id'
                                )
                            );
        //////////////////////////////////////////////////
        
        $video_seq = 1;
        foreach($list as $key => $item){
            /// date entered ///
            $date_entered = $item['date_entered'];
            $date_entered = new DateTime($date_entered, new DateTimeZone('UTC'));
            $date_entered->setTimezone(new DateTimeZone('Australia/Sydney'));
            $list[$key]['date_entered'] = $date_entered->format("D M d, Y - g:i a");
            ////////////////////
            
            /// get poster ///
            $params['id'] = $item['id'];
            $_poster = $this->EE->grp_discussion_items->get_relationship_contacts($params);
            if(!empty($_poster)){
                $poster = array();  
                $poster['id'] = $_poster['id'];
                if(!empty($_poster['prof_photo_c'])){
                    $poster['photo'] = $image_base_url . $_poster['prof_photo_c'];
                }
                
                $poster['name'] = $_poster['salutation'] . ' ' . $_poster['first_name'] . ' ' . $_poster['initial_c'] . ' ' . $_poster['last_name']; 
                if(!empty($_poster['prefname_c'])){
                    $poster['name'] = $_poster['salutation'] . ' ' .  $_poster['prefname_c'] . ' ' . $_poster['last_name']; 
                }
                $poster['quals'] = $_poster['quals_c'];
                    /// pract type ///
                    $practs = '';
                    if(strtolower($_poster['rego_domain_c']) == 'australia'){
                         $practs = $_poster['pract_type_c'];
                    }else if(strtolower($_poster['rego_domain_c']) == 'new zealand'){
                         $practs = $_poster['pract_type_nz_c'];
                    }else{
                         $practs = $_poster['pract_type_other_1_c'];
                    }
                    $practs = trim($practs, "^");
                    $practs = explode("^,^", $practs);
                    
                    if(count($practs) > 1){
                         $last_pract = array_pop($practs);
                         $practs = implode(", ", $practs) . " and " . $last_pract;
                    }else{
                         $practs = implode(", ", $practs);
                    }
                    $poster['practs'] = $practs;
                    /////////////////
                $poster['country'] = $_poster['rego_domain_c'];
                ////////////////
                
                /// socials ///
                $poster['socials'] = array('facebook' => $_poster['facebook_c'],
                                    'googleplus' => $_poster['googleplus_c'],
                                    'pinterest' => $_poster['pinterest_c'], 'instagram' => $_poster['instagram_c'],
                                    'flickr' => $_poster['flickr_c'], 'xing' => $_poster['xing_c'],
                                    'tumblr' => $_poster['tumblr_c'], 'vk' => $_poster['vk_c'], 'youtube' => $_poster['youtube_c'],
                                );
                ///////////////
                
                /// get posters ///
                $_posters = $this->EE->contacts->get_relationship_grp_discussion_items(array('id' => $_poster['id'],
                                                                                'selects' => "{#m}.id,{#m}.date_entered",
                                                                                'orders' => "{#m}.date_entered desc"
                                                                        ));
                $poster['total_posts'] = count($_posters);
                $last_post = $_posters[0];
                $date_entered = new DateTime($last_post['date_entered'], new DateTimeZone('UTC'));
                $date_entered->setTimezone( new DateTimeZone('Australia/Sydney'));
                $last_post['date_entered'] = $date_entered->format("d M Y");
                $poster['last_post'] = $last_post;
                ///////////////////
                
                /// group level ///
                $group_level = array();
                if(in_array($_poster['id'], self::$board['board_access']['members']['owners'])){
                    $group_level['text'] = "Group Leader";
                    $group_level['class'] = "owner";
                }
                if(in_array($_poster['id'], self::$board['board_access']['members']['moderators'])){
                    $group_level = "Moderator";
                    $group_level['text'] = "Moderator";
                    $group_level['class'] = "moderator";
                }
                $poster['group_level'] = $group_level;
                ///////////////////
                
                $list[$key]['poster'] = $poster;
            }
            //////////////////
            
            /// check remove ///
            $list[$key]['can_remove'] = $all_can_remove | ($_contact['id'] == $_poster['id']);
            ////////////////////
            
            /// get image ///
            $_images = $this->EE->grp_discussion_items->get_relationship_article_images(
                        array(
                            'id' => $item['id'],
                            'selects' => '{#m}.article_image',
                            'where' => "{#m}.image_type='Photograph' and {#m}.image_format='News' and {#m}.portal_show='Portal'",
                        )
                     );
            $images_html = '';
            foreach($_images as $item1){
                $src = $image_base_url . $item1['article_image'];
                $images_html .= "<img src='{$src}'/>";
            }
            if(!empty($images_html)){
                $list[$key]['images_html'] = $images_html;    
            }
            /////////////////
            
            /// get video ///
            $_video = $this->EE->grp_discussion_items->get_relationship_article_images(
                        array(
                            'id' => $item['id'],
                            'selects' => '{#c}.video_id_c',
                            'where' => "{#m}.image_type='Video' and {#m}.image_format='News' and {#m}.portal_show='Public' and {#c}.video_source_c='YouTube'",
                            'single' => true
                        )
                     );
            if(!empty($_video)){
                $list[$key]['video'] = $_video['video_id_c']; 
                $list[$key]['video_seq'] = $video_seq++;   
            }
            /////////////////
            
            /// check follow user ///
            $follow_user_status = 'plus';
            if(in_array($_poster['id'], $contacts_followed)){
                $follow_user_status = 'minus';
            }
            $list[$key]['follow_user_status'] = $follow_user_status;   
            /////////////////////////
        }
        
        return $list;
    }
    
    private function _prepare_pagination(){
        $totals = count(self::$list);
        /// INITIALIZE the pagination ///
        $current_page = $this->current_page;
        $items_per_page = $this->_app_config['pagination']['boards:posts']['items_per_page'];
        $items_per_navigation = $this->_app_config['pagination']['boards:posts']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        //////////////////////////////////
        
        $totals = ceil($totals / $items_per_page);
        
        $start_page_number =  (int)(($current_page - 1) / $items_per_navigation) * $items_per_navigation + 1;
        $end_page_number = $start_page_number + $items_per_navigation - 1;
        $end_page_number = min($totals, $end_page_number);
        
        /// FETCH datas ///
        $datas = array();
        if($start_page_number == 1){
             $datas['start_class'] = 'disabled';
        }
        if($end_page_number == $totals){
             $datas['end_class'] = 'disabled';
        }
        if ($current_page == 1)
             $datas['prev_class'] = 'disabled';  
        if ($current_page == $totals)
             $datas['next_class'] = 'disabled';       
        
        $datas['links'] = array();
        for ($i = $start_page_number; $i < $end_page_number + 1; $i++){
            $active = '';
            if($i == $current_page){
                $active = "active";    
            }
            $datas['links'][] = array('number' => $i, 'active' => $active); 
        }
         
        $datas['current_page'] = $current_page;
        $datas['total_pages'] = $totals;
        ///////////////////
        
        return $datas;
    }
    
    function show($sparams=''){
        if($sparams['output'] === false && empty(self::$list)){
            return '';
        }
        
        $datas = array();
        $datas['list'] = $this->fetch_data($sparams);
        $datas['totals'] = count(self::$list);
        $pagination = $this->_prepare_pagination();
        
        /// follow topic ///
        $params = array();
        $params['id'] = BRDProcessing_Boards_Details::$board['id'];
        $params['selects'] = "{#m}.id";
        $followers = $this->EE->disc_discussion_boards->get_relationship_followers($params);
        $is_follower_topic = "plus";
        foreach($followers as $item){
            if($item['id'] == self::$contact['id']){
                $is_follower_topic = "minus"; break;
            }
        }
        $datas['is_follower_topic'] = $is_follower_topic;
        $datas['board_access'] = self::$board['board_access'];
        
        ////////////////////
        $datas['board_id'] = self::$board['id'];
        
        $swaps = array(
                    'dt' => 'dt',
                    'pagination' => 'pagination'
                );
        $datas = array(
                    'dt' => $datas,
                    'pagination' => $pagination
                );
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('boards', 'details_discussion_items');
        $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));  
        
        if($sparams['output'] === false){
            return $html;
        }
        
        echo $html;
        exit;
    }
}