<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Boards_Details_Reply extends BRDProcessing_Boards_Details{
    protected $contact_name;
    
    function initialize($params = array()){
        $this->EE->load->model("grp_discussion_items");
        $this->EE->load->model("article_image");
        $this->EE->load->model("contacts");
        
        $this->EE->load->helper('image');
        $this->image_helper = new Image_Helper();
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "send":
                return $this->send($params);
            break;
            case "show":
                return $this->show($params);
            break;
            case "remove":
                return $this->remove($params);
            break;
        }

    }
    
    private function process_video($post_id){
        $video_id = $this->EE->input->get_post('video_id');
        if(empty($video_id)){
            return;
        }
        
        $data = array();
        $data['name'] = "Discussion video posted by {$this->contact_name}";
        $data['image_type'] = 'Video';
        $data['image_format'] = "News";
        $data['portal_show'] = "Public";
        $data['video_source_c'] = "YouTube";
        $data['video_id_c'] = $video_id;
        $data['sequence'] = '1';
        
        $success = $this->EE->article_image->set_record($data);
        if (!$success){
            $this->logger->developer("Failed to article_image video.");
            return false;
        }
        
        $image_id = $success;
        
        /// link video to post ///
        $success = $this->EE->grp_discussion_items->add_relationship_app($post_id, $image_id, 'article_images');
        if (!$success){
            $this->logger->developer("Failed to link grp_discussion_item to article images video.");
            return false;
        }
    }
    
    private function upload_image($multiple_index){
        $file_id = 'reply_image';
        if(empty($_FILES[$file_id]['name'][$multiple_index]))
            return null;

        $this->EE->load->helper('image');
        $image = new Image_Helper();
       
        /// CONFIGURE the validation image ///
        $size_params = array();
        $size_params['width'] = 600;
        $size_params['accept_width'] = 'any';
        $size_params['multiple'] = $multiple_index;
        
        $result = $image->validation_image($file_id, $size_params);
        //////////////////////////////////////
        $output = array();
        $output['success'] = 0;
        $error_code = '';
        
        if ($result === 0){
            $filename = $image->generate_guid();
            if ($image->upload_to_crm($file_id, $filename, $size_params)){
                $output['success'] = 1;
                $output['filename'] = $filename;
            }else{
                $error_code = "error_fail_upload";
            }
        }else{
            $error_code = $result;
        }
       
        if($output['success'] == 0){
            if(is_string($error_code)){
                $output['error'] = $this->_app_config['error_code'][$error_code];
            }else{
                if($error_code['code'] == "error_small_width" && $error_code['code'] == "error_small_height"){
                    
                }else if($error_code['code'] == "error_small_width"){
                    $output['error'] = "Upload Error: Please select an image at least {$error_code['size']} pixels wide.";
                }else if($error_code['code'] == "error_small_height"){
                    $output['error'] = "Upload Error: Please select an image at least {$error_code['size']} pixels deep.";
                }       
            } 
        }
        
        return $output;
    }
    private function process_image($post_id, $filename){
        if(empty($filename)){
            return;
        }
        $data = array();
        $data['name'] = "Discussion image posted by {$this->contact_name}";
        $data['image_type'] = 'Photograph';
        $data['image_format'] = "News";
        $data['portal_show'] = "Portal";
        $data['article_image'] = $filename;
        $data['sequence'] = '1';
        
        $success = $this->EE->article_image->set_record($data);
        if (!$success){
            $this->logger->developer("Failed to article_image.");
            return false;
        }
        
        $image_id = $success;
        
        /// link image to post ///
        $success = $this->EE->grp_discussion_items->add_relationship_app($post_id, $image_id, 'article_images');
        if (!$success){
            $this->logger->developer("Failed to link grp_discussion_item to article images.");
            return false;
        }
    }
    
    function send($sparams = array()){
        $_contact = self::$contact;
        $_board = self::$board;
        
        $reply_text = $this->EE->input->get_post("reply_text");
        
        $contact_name = $_contact['salutation'] . ' ' . $_contact['first_name'] . ' ' . $_contact['initial_c'] . ' ' . $_contact['last_name']; 
        if(!empty($_contact['prefname_c'])){
            $contact_name = $_contact['salutation'] . ' ' .  $_contact['prefname_c'] . ' ' . $_contact['last_name']; 
        }
        $this->contact_name = $contact_name;
        
        $now_date = date("Y-m-d");
        
        /// upload image ///
        $uploads_count = $this->image_helper->check_multiple('reply_image');
        $upload_statuses = array();
        $upload_error = false;
        for($i = 0 ; $i < $uploads_count; $i++){
            if(($upload_result = $this->upload_image($i)) != null){
                $upload_statuses[] = $upload_result;
                if($upload_result['success'] === 1){
                }else{
                    $upload_error= true;
                }
            }
        }
        if($upload_error){
            foreach($upload_statuses as $item){
                if($item['success'] == 1 && !empty($item['filename'])){
                    $this->image_helper->remove_old_upload_crm($item['filename']);
                }
            }
            $json = json_encode($upload_statuses);
            //header("Content-Type: application/json"); 
            echo $json;  exit;
        }
        ////////////////////
        
        /// reply text ///
        $data = array();
        $data['name'] = "Reply from {$contact_name}";
        $data['description'] = $reply_text;
        $data['status_c'] = "Active";
        
        $success = $this->EE->grp_discussion_items->set_record($data);
        if (!$success){
            $this->logger->developer("Failed to create grp_discussion_item.");
            return false;
        }
        
        $post_id = $success;
            /// link post to contacts ///
            $success = $this->EE->contacts->add_relationship_app($_contact['id'], $post_id, 'grp_discussion_items');
            if (!$success){
                $this->logger->developer("Failed to link grp_discussion_item to contacts.");
                return false;
            }
            /////////////////////////////
            
            /// link post to board ///
            $success = $this->EE->disc_discussion_boards->add_relationship_app($_board['id'], $post_id, 'posts');
            if (!$success){
                $this->logger->developer("Failed to link grp_discussion_item to board.");
                return false;
            }
            //////////////////////////
        //////////////////  
        
        /// image ///
        foreach($upload_statuses as $item){
            $filename = $item['filename'];
            $this->process_image($post_id, $filename);
        }
        /////////////
        
        /// video ///
        $this->process_video($post_id);
        /////////////
        
        /// follow topic ///
        $success = $this->EE->disc_discussion_boards->add_relationship_app($_board['id'], $_contact['id'], "followers");
        if(!$success){
            $this->logger->developer("Failed to link follow topic.");    
        }
        ////////////////////
        
        echo 'success'; exit;
    }
    
    function remove($sparams = array()){
        $_contact = self::$contact;
        $_board = self::$board;
        $post_id = $this->EE->input->get_post("post_id");
        
        /// check permission ///
        $all_can_remove = false;
        if(in_array($_contact['id'], self::$board['board_access']['members']['owners']) ||
            in_array($_contact['id'], self::$board['board_access']['members']['moderators'])){
            $all_can_remove = true;
        }
        
        $params = array();
        $params['selects'] = "{#m}.id";
        $params['single'] = true;
        $params['id'] = $post_id;
        $_poster = $this->EE->grp_discussion_items->get_relationship_contacts($params);
        
        $can_remove = $all_can_remove | ($_contact['id'] == $_poster['id']);
        if(!$can_remove){
            self::$router = "details:show";
            return BRDProcessing_Boards::process();
        }
        ////////////////////////
        
        /// heading text ///
            ////////////////////////////////////////
            $contact_name = $_contact['salutation'] . ' ' . $_contact['first_name'] . ' ' . $_contact['initial_c'] . ' ' . $_contact['last_name']; 
            if(!empty($_contact['prefname_c'])){
                $contact_name = $_contact['salutation'] . ' ' .  $_contact['prefname_c'] . ' ' . $_contact['last_name']; 
            }
            $this->contact_name = $contact_name;
            ////////////////////////////////////////
            
            /// date ///
            $now_date = new DateTime('', new DateTimeZone('UTC'));
            $now_date->setTimezone(new DateTimeZone('Australia/Sydney'));
            $date = $now_date->format("j/m/Y");
            $time = $now_date->format("g:i a");
            ////////////
        $heading_text = "Post removed by {$contact_name} {$date} at {$time}";
        $heading_text = "<p>{$heading_text}</p>";
        /////////////////////
        
        /// get post ///
        $_post = $this->EE->grp_discussion_items->get_main_data(
                    array(
                        'selects' => "{#m}.id,{#m}.description",
                        'where' => "{#m}.id='{$post_id}'", 'single' => true
                    )
                );
        ////////////////
        
        $data = array();
        $data['id'] = $post_id;
        $data['status_c'] = "Removed";
        $data['description'] = $heading_text . $_post['description'];
        
        $success = $this->EE->grp_discussion_items->set_record($data);
        if (!$success){
            $this->logger->developer("Failed to remove grp_discussion_item.");
            return false;
        }
        
        self::$router = "details:show";
        return BRDProcessing_Boards::process();
    }
    
    function show($sparams = array()){
        $_contact = self::$contact;
        $_board = self::$board;
        $image_base_url = $this->_crm_config['main']['upload_url'];
        
        $datas = array();
        $datas['board'] = $_board;
        
        /// access informations ///
            $access_infos = array();
            $datas['access_infos'] = &$access_infos;
            /// privacy ///
            $privacy = '';
            switch($_board['access_c']){
                case 'Open':
                    $privacy = 'Open Access';
                break;
                case 'GroupOnly':
                    $privacy = 'Closed Group';
                break;
                case 'GroupUpdateAnyView':
                    $privacy = 'Open Viewing<br/>Group Only Updating';
                break;
            }
            $access_infos['privacy'] = $privacy;
            ///////////////
            
            /// group access ///
            $group_access = '';
            if($_board['access_c'] != 'Open'){
                $_group = $this->EE->disc_discussion_boards->get_relationship_group_access(
                        array('id' => $_board['id'], 'selects' => "{#m}.id,{#m}.name", 'single' => true)
                    );    
                if(!empty($_group)){
                    $group_access = $_group['name'];
                } 
            }
            $access_infos['group_access'] = $group_access;
            ////////////////////
            
            if($_board['access_c'] != 'Open'){
                /// group members total ///
                $access_infos['group_members_total'] = self::$board['board_access']['members']['totals'];
                ///////////////////////////
                
                /// group leader ///
                $group_leader = '';
                if(!empty(self::$board['board_access']['members']['owners'])){
                    $owners = self::$board['board_access']['members']['owners'];    
                    
                    $_owner = self::$utility->fetch_contact_by_id($owners[0]);
                    $group_leader = $_owner['salutation'] . ' ' . $_owner['first_name'] . ' ' . $_owner['initial_c'] . ' ' . $_owner['last_name']; 
                    if(!empty($_owner['prefname_c'])){
                        $group_leader = $_owner['salutation'] . ' ' .  $_owner['prefname_c'] . ' ' . $_owner['last_name']; 
                    }
                }
                $access_infos['group_leader'] = $group_leader;
                ////////////////////
                
                /// group account logo///
                $_group_account = $this->EE->grp_groups->get_relationship_accounts(
                            array('id' => $_group['id'], 'selects' => "{#m}.id,{#c}.logo_c", 'single' => true)
                        );
                if($_group_account != null && !empty($_group_account['logo_c'])){
                    $access_infos['group_account_logo'] = $image_base_url . $_group_account['logo_c'];
                }
                /////////////////////////
            }
            
        ///////////////////////////
        
        $action_id = $this->helper->fetch_action_id("Mboards", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'board_id' => 'board_id',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'board_id' => $_board['id'],
                    'dt' => $datas
                );
               
        $this->EE->TMPL->run_template_engine("boards", "reply");
        $this->EE->output->app_output($swaps, $datas);
    }
}