<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Boards_Discussions extends BRDProcessing_Boards{
    static $list;
    protected $current_page;
    
    function initialize($params = array()){
        $this->EE->load->model("disc_discussion_boards");
        $this->EE->load->model("grp_discussion_items");
        $this->EE->load->model("grp_groups");
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "fetch_data":
                return $this->fetch_data($params);
            break;
            case "show":
                return $this->show($params);
            break;
            case "home":
                require_once(PATH_THIRD . 'mboards/models/mboards/discussions/home.php');
                $processing = new BRDProcessing_Boards_Discussions_Home();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "text":
                require_once(PATH_THIRD . 'mboards/models/mboards/discussions/text.php');
                $processing = new BRDProcessing_Boards_Discussions_Text();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "topics_followed":
                require_once(PATH_THIRD . 'mboards/models/mboards/discussions/topics_followed.php');
                $processing = new BRDProcessing_Boards_Discussions_TopicsFollowed();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "search":
                require_once(PATH_THIRD . 'mboards/models/mboards/discussions/search.php');
                $processing = new BRDProcessing_Boards_Discussions_Search();
                $processing->initialize($params);
                return $processing->process($params);
            break;
        }

    }
    
    function fetch_data($params=''){
        $disable_pagination = $params['disable_pagination'];
        
        /// INITIALIZE the pagination ///
        $current_page = $this->current_page;
        $items_per_page = $this->_app_config['pagination']['boards:discussions']['items_per_page'];
        $items_per_navigation = $this->_app_config['pagination']['boards:discussions']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        $totals = count(self::$list);
        //////////////////////////////////
        
        $offset = ($current_page - 1) * $items_per_page;
        $list = array_slice(self::$list, $offset, $items_per_page);
        if($disable_pagination === true){
            $list = self::$list;
        }
        
        
        $image_base_url = $this->_crm_config['main']['upload_url'];
        

        foreach($list as $key => $item){
            /// board creator ///
            $board_creator = array();
            
            $params = array();
            $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.initial_c,{#c}.prefname_c,{#c}.prof_photo_c,{#c}.photo_thumb_c";
            $params['id'] = $item['id'];
            $params['single'] = true;
            $_board_creator = $this->EE->disc_discussion_boards->get_relationship_contacts($params);
            
                /// date entered ///
                $date_entered = new DateTime($item['date_entered'], new DateTimeZone('UTC'));
                $date_entered->setTimezone( new DateTimeZone('Australia/Sydney'));
                $board_creator['date_entered'] = $date_entered->format("D M d, Y g:i a");
                $board_creator['disp_date'] = array('y' => $date_entered->format("Y"), 'm' => $date_entered->format("M"), 'd' => $date_entered->format("d"));
                $board_creator['disp_time'] = $date_entered->format("g:i a");
                ////////////////////
                
                /// photo ///
                if(!empty($_board_creator['prof_photo_c'])){
                    $board_creator['photo'] = $image_base_url . $_board_creator['prof_photo_c'];
                }else if(!empty($_board_creator['photo_thumb_c'])){
                    $board_creator['photo'] = $image_base_url . $_board_creator['photo_thumb_c'];
                }
                /////////////
                    
                /// name ///
                $name = $_board_creator['salutation'] . ' ' . $_board_creator['first_name'] . ' ' . $_board_creator['initial_c'] . ' ' . $_board_creator['last_name']; 
                if(!empty($_poster['prefname_c'])){
                    $name = $_board_creator['salutation'] . ' ' .  $_board_creator['prefname_c'] . ' ' . $_board_creator['last_name']; 
                }
                $board_creator['name'] = $name;
                ////////////
            
            $list[$key]['board_creator'] = $board_creator;
            /////////////////////
            
            /// check access ///
            if($item['access_c'] == 'GroupOnly'){
                $access = self::$utility->check_access_board($item);
                if($access['view'] == 0){
                    $list[$key]['check_access'] = "private";
                }
            }
            ////////////////////
            
            /// topic category ///
            if(empty($list[$key]['check_access'])){
                $list[$key]['topic_category'] = strtolower($item['topic_category']);
            }
            //////////////////////
            
            /// action ///
            $list[$key]['action'] = $this->seo_helper->get_url(Seo_Helper::BOARDS_DETAIL, array('id' => $item['id']));
            //////////////
            
            /// last post ///
            $params = array();
            $params['id'] = $item['id'];
            $params['selects'] = "{#m}.id,{#m}.date_entered";
            $params['orders'] = "{#m}.date_entered desc";
            $params['where'] = "{#c}.status_c != 'Removed'";
            $_posts = $this->EE->disc_discussion_boards->get_relationship_posts($params);
            $_last_post = $_posts[0];
            /////////////////
            
            /// total posts ///
            $list[$key]['total_posts'] = count($_posts);
            ///////////////////
            
            if(isset($_last_post)){
                ////////get contact/////////
                $params = array();
                $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.initial_c,{#c}.prefname_c,{#c}.prof_photo_c,{#c}.photo_thumb_c";
                $params['id'] = $_last_post['id'];
                $params['single'] = true;
                $_poster = $this->EE->grp_discussion_items->get_relationship_contacts($params);
                
                $poster = array();
                
                    /// date entered ///
                    $date_entered = new DateTime($_last_post['date_entered'], new DateTimeZone('UTC'));
                    $date_entered->setTimezone( new DateTimeZone('Australia/Sydney'));
                    $poster['date_entered'] = $date_entered->format("D M d, Y g:i a");
                    $poster['disp_date'] = array('y' => $date_entered->format("Y"), 'm' => $date_entered->format("M"), 'd' => $date_entered->format("d"));
                    $poster['disp_time'] = $date_entered->format("g:i a");
                    ////////////////////
                    /// photo ///
                    if(!empty($_poster['prof_photo_c'])){
                        $poster['photo'] = $image_base_url . $_poster['prof_photo_c'];
                    }else if(!empty($_poster['photo_thumb_c'])){
                        $poster['photo'] = $image_base_url . $_poster['photo_thumb_c'];
                    }
                    /// name ///
                    $name = $_poster['salutation'] . ' ' . $_poster['first_name'] . ' ' . $_poster['initial_c'] . ' ' . $_poster['last_name']; 
                    if(!empty($_poster['prefname_c'])){
                        $name = $_poster['salutation'] . ' ' .  $_poster['prefname_c'] . ' ' . $_poster['last_name']; 
                    }
                    $poster['name'] = $name;
                ////////////////////////////
                $list[$key]['poster'] = $poster;
            }
            
        }
        
        return $list;
    }
    
    private function _prepare_pagination(){
        $totals = count(self::$list);
        /// INITIALIZE the pagination ///
        $current_page = $this->current_page;
        $items_per_page = $this->_app_config['pagination']['boards:discussions']['items_per_page'];
        $items_per_navigation = $this->_app_config['pagination']['boards:discussions']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        //////////////////////////////////
        
        $totals = ceil($totals / $items_per_page);
        
        $start_page_number =  (int)(($current_page - 1) / $items_per_navigation) * $items_per_navigation + 1;
        $end_page_number = $start_page_number + $items_per_navigation - 1;
        $end_page_number = min($totals, $end_page_number);
        
        /// FETCH datas ///
        $datas = array();
        if($start_page_number == 1){
             $datas['start_class'] = 'disabled';
        }
        if($end_page_number == $totals){
             $datas['end_class'] = 'disabled';
        }
        if ($current_page == 1)
             $datas['prev_class'] = 'disabled';  
        if ($current_page == $totals)
             $datas['next_class'] = 'disabled';       
        
        $datas['links'] = array();
        for ($i = $start_page_number; $i < $end_page_number + 1; $i++){
            $active = '';
            if($i == $current_page){
                $active = "active";    
            }
            $datas['links'][] = array('number' => $i, 'active' => $active); 
        }
         
        $datas['current_page'] = $current_page;
        $datas['total_pages'] = $totals;
        ///////////////////
        
        return $datas;
    }
    
    function show($params=''){
        $heading_title = $params['heading_title'];
        
        $datas = array();
        $datas['list'] = $this->fetch_data($params);
        $datas['totals'] = count(self::$list);
        $datas['heading_title'] = $heading_title;
        $pagination = $this->_prepare_pagination();
        
        $swaps = array(
                    'dt' => 'dt',
                    'pagination' => 'pagination'
                );
        $datas = array(
                    'dt' => $datas,
                    'pagination' => $pagination
                );
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('boards', 'home_discussions');
        $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));  
        
        if($params['output'] === false){
            return $html;
        }
        
        echo $html;
        exit;
    }
    
}