<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Boards_Discussions_Home extends BRDProcessing_Boards_Discussions{

    function initialize($params = array()){
        $category = $this->EE->input->get_post("category");
        $status = $this->EE->input->get_post("status");
        $group = $this->EE->input->get_post("group");
        
        $current_page = $this->EE->input->get_post('current_page');
        if(!empty($params['current_page'])){
            $current_page = $params['current_page'];
        }
        $this->current_page = $current_page;
        
        /// discussion items sql ///
        $params = array();
        $params['selects'] = "{#join_col} as rel_main_id,{#m}.date_entered as rel_date_entered,{#m}.deleted";
        $params['orders'] = "{#m}.date_entered desc";
        $params['execute'] = false;
       
        $discussion_items_sql = $this->EE->disc_discussion_boards->get_relationship_posts($params);
            $params = array();
            $params['selects'] = "{#m}.*";
            $params['custom_main'] = array('sql' => $discussion_items_sql);
            $params['groups'] = "rel_main_id";  
            $params['execute'] = false;
        $discussion_items_sql = $this->EE->grp_discussion_items->get_main_data($params);    
        ////////////////////////////
        
        ////////////////////////////
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.name,{#m}.topic_category,{#m}.date_entered,{#c}.access_c,IF({#ld}.rel_date_entered is null, {#m}.date_entered,{#ld}.rel_date_entered) as sort_date";
        if($status != "all"){
            $params['where'] = "{#c}.status_c='Active'";    
        }
        $params['joins'] = array(
                                '{#ld}' => array(
                                           'sql' => $discussion_items_sql,
                                           'table' => 'linked_discussion_items',
                                           'type' => 'left',
                                           'cond' => "{#m}.id={#ld}.rel_main_id" 
                                        )
                            );
        if(!empty($status) && $status != 'all'){
            $params['where'] = "{#c}.status_c='{$status}'";    
        }
        if(!empty($category)){
            if(!empty($params['where'])){
                $params['where'] .= " and";   
            }
            $params['where'] .= " {#m}.topic_category='{$category}'";    
        }
        if(!empty($group)){
            /// group sql ///
            $group_sql = $this->EE->disc_discussion_boards->get_relationship_group_access(
                        array(
                            'selects' => "{#join_col} as rel_main_id",
                            'where' => "{#m}.id='{$group}'",
                            'groups' => "rel_main_id",
                            'execute' => false,
                        )
                    );
            $params['joins']['{#lg}'] = array(
                                           'sql' => $group_sql,
                                           'table' => 'linked_groups',
                                           'type' => 'inner',
                                           'cond' => "{#m}.id={#lg}.rel_main_id" 
                            );
            /////////////////
        }
        
        $params['orders'] = "sort_date desc";
        self::$list = $this->EE->disc_discussion_boards->get_main_data($params);
    }
    
    private function get_heading_title(){
        $category = $this->EE->input->get_post("category");
        $status = $this->EE->input->get_post("status");
        $group = $this->EE->input->get_post("group");
        
        $title = "Active Discussions - ALL";
        
        /// status ///
        $status_text = "Active";
        if(!empty($status)){
            $status_text = ucfirst($status);
        }
        //////////////
        
        /// category ///
        if(!empty($category)){
            $category_text = $this->helper->get_dropdowns_sugar_labels('topic_category_0', $category, false);
            if(in_array($category, array("ClinicalCase", "QuestionAnswer"))){
                $category_text .= "s";    
            }
        }else if($status != 'all'){
            $category_text = "All";
        }
        ////////////////        
        
        /// get group ///
        if(!empty($group)){
            $_group = $this->EE->grp_groups->get_main_data(
                                                    array('selects' => "{#m}.name", 'where' => "{#m}.id='{$group}'", 'single' => true)
                                                );
            $group_text = $_group['name'];
        }
        /////////////////
        
        /// title ///
        $title = "{$status_text} Discussions";
        if(!empty($category_text)){
            $title .= " - {$category_text}";
        }
        if(!empty($group_text)){
            $title .= " - {$group_text}";
        }
        /////////////
        
        return $title;
    }
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                $params['heading_title'] = $this->get_heading_title();
                return $this->show($params);
            break;
        }

    }
     
}