<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Boards_Groups extends BRDProcessing_Boards{

    function initialize($params = array()){
        $this->EE->load->model("grp_groups");
        $this->EE->load->model('grp_group_members');
        self::$utility->fetch_contact();

        //// fetch contact in the case of saving function /////
        if(empty(self::$contact)){
            $contact_id = $this->EE->input->get_post("contact_id");
            self::$contact = $this->EE->contacts->get_main_data(array(
                'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name",
                'where' => "{#m}.id='$contact_id'",
                'single' => true
            ));
        }
        /// ///////
    }

    function process($params = array()){
        $cmd = self::$utility->fetch_router();

        switch($cmd){
            case "show":
                return $this->show($params);
            break;
            case "add":
                require_once(PATH_THIRD . 'mboards/models/mboards/groups/add.php');
                $processing = new BRDProcessing_Boards_Groups_Add();
                $processing->initialize($params);
                return $processing->process($params);
            break;
            case "member":
                require_once(PATH_THIRD . 'mboards/models/mboards/groups/member.php');
                $processing = new BRDProcessing_Boards_Groups_Member();
                $processing->initialize($params);
                return $processing->process($params);
            break;
        }
    }

    function show($params=''){
        $_contact = self::$contact;

        $data = array();
        $groups = array();
        $showing_groups = array();
        $showing_groups_ids = array();

        ///// GRP Group Members ///
        $grp_members = $this->EE->contacts->get_relationship_grp_group_members(array(
                'id' => $_contact['id'],
                'selects' => "{#m}.id",
                'where' => "{#c}.member_status_c='Active' and ({#c}.access_c like '%^CreateGroups^%' or {#c}.access_c like '%^AdministerGroups^%')",
                //'where' => "{#c}.member_status_c='Active'",
                'to_values' => 'id'
            ));
        ///

        ///// GRP Groups /////
        if(!empty($grp_members)){
            foreach ($grp_members as $key => $member){
                $_groups = $this->EE->grp_group_members->get_relationship_groups(array(
                   'id' => $member,
                    'selects' => '{#m}.id',
                    'where' => "{#c}.group_type_c='Access' and {#c}.group_status_c='Active'",
                    'to_values' => 'id'
                ));
                if(!empty($_groups)){
                    $groups = array_merge($groups, $_groups);
                }
            }
        }
        ///

        //// check if linked to same accounts ////
        $linked_accounts = $this->EE->contacts->get_relationship_accounts(array(
           'id' => $_contact['id'],
            'selects' => "{#m}.id",
            'to_values' => 'id'
        ));
        if(!empty($groups)){
            foreach (array_unique($groups) as $key => $group){
                $group_account = $this->EE->grp_groups->get_relationship_accounts(
                    array('id' => $group, 'selects' => "{#m}.id", 'single' => true)
                );
                if(in_array($group_account['id'], $linked_accounts)){
                    $showing_groups_ids[] = $group;
                }
            }
        }
        ///
        $html = '';
        //// get group data ///
        if(!empty($showing_groups_ids)){
            foreach ($showing_groups_ids as $key => $group){
                $group_data = $this->EE->grp_groups->get_main_data(array(
                   'selects' => "{#m}.id,{#m}.name,{#c}.group_type_c,{#c}.group_status_c",
                    'where' => "{#m}.id='{$group}'",
                    'single'=> true
                ));
                $group_account = $this->EE->grp_groups->get_relationship_accounts(
                    array('id' => $group, 'selects' => "{#m}.id,{#m}.name", 'single' => true)
                );
                $group_data['account_id'] = $group_account['id'];
                $group_data['account_name'] = $group_account['name'];
                /// get group members linked to this group //
                $linked_members = $this->EE->grp_groups->get_relationship_group_members(array(
                    'id' => $group,
                    'selects' => "{#m}.id,{#m}.name,{#c}.access_c"
                ));
                $linked_members = self::$utility->filter_members($linked_members);
                $_swaps = array(
                    'linked_members' => 'linked_members'
                );
                $_datas = array(
                    'linked_members' => $linked_members
                );
                $TMPL = new EE_Template();
                $TMPL->run_template_engine('boards', 'groups_commercial_piece_members');
                $group_data['member_html'] = $this->EE->output->app_output($_swaps, $_datas, array('output' => false));
                ///
                $group_account_id = $group_account['id'];
                $showing_groups[$group_account_id][] = $group_data;
            }

            foreach ($showing_groups as $key => $item){
                $_swaps = array(
                    'groups' => 'groups',
                    'account_id' => 'account_id',
                    'account_name' => 'account_name',
                );
                $_datas = array(
                    'groups' => $item,
                    'account_id' => $item[0]['account_id'],
                    'account_name' => $item[0]['account_name'],
                );
                $TMPL = new EE_Template();
                $TMPL->run_template_engine('boards', 'groups_commercial_piece');
                $html .= $this->EE->output->app_output($_swaps, $_datas, array('output' => false));
            }
        }
        ///
        $data['groups'] = $html;
        $action_id = $this->helper->fetch_action_id("Mboards", "process");
        $swaps = array(
            'AID' => 'AID',
            'dt' => 'dt'
        );
        $data = array(
            'AID' => $action_id,
            'dt' => $data
        );

        $this->EE->TMPL->run_template_engine("boards", "groups");
        $this->EE->output->app_output($swaps, $data);
    }
}