<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Boards_Groups_Add extends BRDProcessing_Boards_Groups {
    static $group_member;

    function initialize($params = array()){

    }

    function process($params = array()){
        $cmd = self::$utility->fetch_router();

        switch($cmd){
            case "show":
                return $this->show($params);
                break;
            case "do_add":
                return $this->do_add($params);
            break;
            case "back":
                return $this->back($params);
            break;
        }
    }

    function show($params =''){
        $account_id = $this->EE->input->get_post("account_id");

        $data = array();
        $data['account_id'] = $account_id;
        $data['contact_id'] = self::$contact['id'];

        $data['group_type_opts'] = $this->helper->make_select_opts(array('Access' => 'Access'), 'Access');
        $data['group_status_opts'] = $this->helper->make_select_opts('group_status_list', 'Active');


        $action_id = $this->helper->fetch_action_id("Mboards", "process");
        $swaps = array(
            'AID' => 'AID',
            'dt' => 'dt'
        );
        $data = array(
            'AID' => $action_id,
            'dt' => $data
        );

        $this->EE->TMPL->run_template_engine("boards", "groups_commercial_add_group");
        $this->EE->output->app_output($swaps, $data);
    }

    function do_add($params = ''){
        $account_id = $this->EE->input->get_post("account_id");
        $group_name = $this->EE->input->get_post("group_name");
        $group_type = $this->EE->input->get_post("group_type");
        $group_status = $this->EE->input->get_post("group_status");

        $data = array();
        $data['name'] = $group_name;
        $data['group_type_c'] = $group_type;
        $data['group_status_c'] = $group_status;
        $data['accounts_grp_groups_1accounts_ida'] = $account_id;

        $success = $this->EE->grp_groups->set_record($data);
        if (!$success){
            $this->logger->developer("Failed to add Group record.");
            return false;
        }

        self::$router = "groups:show";
        return BRDProcessing_Boards::process();
    }

    function back($params){
        self::$router = "groups:show";
        return BRDProcessing_Boards::process();
    }
}