<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Boards_Groups_Member extends BRDProcessing_Boards_Groups {
    static $group_member;

    function initialize($params = array()){
        $this->EE->load->model("accounts");
        $member_id = $this->EE->input->get_post("member_id");
        self::$group_member = $this->EE->grp_group_members->get_main_data(array(
           'selects' => "{#m}.id,{#m}.name,{#c}.member_status_c,{#c}.access_c",
            'where' => "{#m}.id='$member_id'",
            'single' => true
        ));

    }

    function process($params = array()){
        $cmd = self::$utility->fetch_router();

        switch($cmd){
            case "add":
                return $this->add($params);
            break;
            case "add_page":
                return $this->add_page($params);
            break;
            case "edit":
                return $this->edit($params);
            break;
            case "save":
                return $this->save($params);
            break;
            case "back":
                return $this->back($params);
            break;
        }
    }

    function edit($params =''){
        $data = array();
        $data['contact_id'] = self::$contact['id'];
        $_group_member = self::$group_member;

        $data['id'] = $_group_member['id'];
        $data['status_opts'] = $this->helper->make_select_opts('member_status_list', $_group_member['member_status_c']);
        $access = self::$utility->trim_explode($_group_member['access_c']);
        $data['access_checkboxes'] = $this->helper->make_checkboxes('update_access_0', $access, 'member_access_checkbox');

        /// get linked contacts ////
        $contacts = $this->EE->grp_group_members->get_relationship_contacts(array(
            'id' => $_group_member['id'],
            'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name"
        ));
        $contacts = self::$utility->get_full_name($contacts);
        $data['contacts'] = implode("<br>", $contacts);
        ///
        $action_id = $this->helper->fetch_action_id("Mboards", "process");
        $swaps = array(
            'AID' => 'AID',
            'dt' => 'dt'
        );
        $data = array(
            'AID' => $action_id,
            'dt' => $data
        );

        $this->EE->TMPL->run_template_engine("boards", "groups_commercial_edit_member");
        $this->EE->output->app_output($swaps, $data);
    }

    function add_page($params = ''){
        $data = array();
        $data['contact_id'] = self::$contact['id'];

        $group_id = $this->EE->input->get_post("group_id");
        $account_id = $this->EE->input->get_post("account_id");

        $data['group_id'] = $group_id;
        $data['account_id'] = $account_id;
        $data['status_opts'] = $this->helper->make_select_opts('member_status_list', 'Active');
        $data['access_checkboxes'] = $this->helper->make_checkboxes_access('update_access_0', '', 'member_access_checkbox');

        /// get linked contacts to account ////
        $account_id = $this->EE->input->get_post("account_id");

        $contacts = $this->EE->accounts->get_relationship_contacts(array(
            'id' => $account_id,
            'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name"
        ));
        $contacts = self::$utility->get_full_name_by_id($contacts);
        $data['contacts_checkboxes'] = $this->helper->make_checkboxes($contacts, '', 'linking_contact');
        ///
        $action_id = $this->helper->fetch_action_id("Mboards", "process");
        $swaps = array(
            'AID' => 'AID',
            'dt' => 'dt'
        );
        $data = array(
            'AID' => $action_id,
            'dt' => $data
        );

        $this->EE->TMPL->run_template_engine("boards", "groups_commercial_add_member");
        $this->EE->output->app_output($swaps, $data);
    }
    function save($params = ''){
        $id = $this->EE->input->get_post("member_id");
        $group_id = $this->EE->input->get_post("group_id");
        $access = $this->EE->input->get_post("member_access_checkbox");
        $status = $this->EE->input->get_post("status");
        $contact_id = $this->EE->input->get_post("linking_contact");
        $contact_id = $contact_id[0];

        $data = array();
        if(!empty($id)){
            $data['id'] = $id;
        }

        if(empty($status)){
            $status = 'Active';
        }
        $data['member_status_c'] = $status;
        $access = implode("^,^", $access);
        $data['access_c'] = "^{$access}^";
        ///// get contact information ///
        if(!empty($contact_id)){
            $_contact = $this->EE->contacts->get_main_data(array(
                'selects' => "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name",
                'where' => "{#m}.id='$contact_id'",
                'single' => true
            ));
            $data['contacts_grp_group_members_1contacts_ida'] = $contact_id;
            $data['name'] = $_contact['first_name'] . " " . $_contact['last_name'] . " - Access";
            $data['grp_groups_grp_group_members_1grp_groups_ida'] = $group_id;
        }
        ///
        $success = $this->EE->grp_group_members->set_record($data);
        if (!$success){
            $this->logger->developer("Failed to update Group Member record.");
            return false;
        }

        self::$router = "groups:show";
        return BRDProcessing_Boards::process();
    }

    function add($params = ''){

    }
    function back($params){
        self::$router = "groups:show";
        return BRDProcessing_Boards::process();
    }
}