<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Boards_Home extends BRDProcessing_Boards{

    function initialize($params = array()){
        $this->EE->load->model("disc_discussion_boards");
        self::$utility->fetch_contact();
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "show":
                return $this->show($params);
            break;
        }

    }
    
    function show($params=''){
        $_contact = self::$contact;
        
        $datas = array();
        $image_base_url = $this->_crm_config['main']['upload_url'];
        
        /// get list of category ///
        $category_opts = $this->helper->make_select_opts('topic_category_0', '');
        $datas['category_opts'] = $category_opts;
        ////////////////////////////
        
        /// get list of status list ///
        $status_list_opts = $this->helper->make_select_opts('status_list', 'Active');
        $datas['status_list_opts'] = $status_list_opts;
        ////////////////////////////
        
        /////////// get groups /////////////////
        $results = self::$utility->get_groups_user($_contact['id']);
        $groups = array();
        foreach($results as $item){
            $groups[$item['id']] = $item['name'];
        }
        $groups_opts = $this->helper->make_select_opts($groups);
        
        $datas['groups_opts'] = $groups_opts;
        /////////////////////////////////////////
        
        /// discussions html ///
        self::$router = "discussions:home:show";
        $discussions_html = BRDProcessing_Boards::process(array('output' => false, 'current_page' => 1));
        $datas['discussions_html'] = $discussions_html;
        ////////////////////////
        
        /// boards topics followed ///
        self::$router = "discussions:topics_followed:fetch_data";
        $topic_boards = BRDProcessing_Boards::process(array('disable_pagination' => true));
        $datas['topic_boards'] = $topic_boards;
        //////////////////////////////
        
        /// groups ///
            /// fetch group members from contact ///
            $members_from_contact = $this->EE->contacts->get_relationship_grp_group_members(
                            array('id' => $_contact['id'], 'selects' => "{#m}.id", 'to_values' => 'id')
                        );
            $member_ids = implode("','", $members_from_contact);
            $member_ids = "'{$member_ids}'";
            ////////////////////////////////////////
            
            /// member sql ///
            $params = array();
            $params['selects'] = "{#join_col} as rel_main_id";
            $params['where'] = "{#m}.id IN({$member_ids})";
            $params['execute'] = false;
           
            $member_sql = $this->EE->grp_groups->get_relationship_group_members($params);
            //////////////////
            
            /// get groups ///
            $params = array();
            $params['selects'] = "{#m}.id,{#m}.name";
            $params['joins'] = array(
                                '{#lm}' => array(
                                           'sql' => $member_sql,
                                           'table' => 'linked_members',
                                           'type' => 'inner',
                                           'cond' => "{#m}.id={#lm}.rel_main_id" 
                                        )
                            );
            $_groups = $this->EE->grp_groups->get_main_data($params);
            foreach($_groups as $key => $item){
                /// account logo  ///
                $_account = $this->EE->grp_groups->get_relationship_accounts(
                                array(
                                    'id' => $item['id'],
                                    'selects' => "{#m}.id,{#c}.photo_thumb_c,{#c}.logo_c",
                                    'single' => true
                                )
                            );
                if(isset($_account['photo_thumb_c'])){
                    $_groups[$key]['image'] = $image_base_url . $_account['photo_thumb_c'];
                }else if(isset($_account['logo_c'])){
                    $_groups[$key]['image'] = $image_base_url . $_account['logo_c'];
                }
                /////////////////////
                
                /// member totals ///
                $_total = $this->EE->grp_groups->get_relationship_group_members(
                                array(
                                    'id' => $item['id'],
                                    'selects' => "count(*) as total",
                                    'single' => true
                                )
                            );
                $_groups[$key]['member_totals'] = $_total['total'];
                /////////////////////
                
                /// boards totals ///
                $_total = $this->EE->grp_groups->get_relationship_disc_discussion_boards(
                                array(
                                    'id' => $item['id'],
                                    'selects' => "count(*) as total",
                                    'single' => true
                                )
                            );
                $_groups[$key]['boards_totals'] = $_total['total'];
                /////////////////////
            }
            //////////////////
            $datas['groups'] = $_groups;
        //////////////
        
        $action_id = $this->helper->fetch_action_id("Mboards", "process");
        $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
        $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas
                );
               
        $this->EE->TMPL->run_template_engine("boards", "home");
        $this->EE->output->app_output($swaps, $datas);
    }
    
}