<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class MProcessing_Noneuser_Terms extends BRDProcessing_Boards{

    static $events;
    static $selects_events;
    static $contact;
    static $vimeo_connector;
    static $count = 0;

    function init($params = array()){
        $this->EE->load->model("contacts");
       
        $this->EE->load->model('cpd_activity');
        $this->EE->load->model("adverts");

        $this->EE->load->model('general_hits');
    }

    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        switch($cmd){
            
            case "privacy":
                
                return $this->go_page('privacy');
            break;
            case "view":
                
                return $this->go_page('terms');
            break;
        }



        $this->go_page();
    }


    
    public function go_page($type){
        
        $this->init();

        $country = "Australia";
        $website = "DenteventsTV";
        $size = "Leaderboard";
        $limit = 2;
                
        $now_date = new DateTime();
        $now_date = $now_date->format("Y-m-d");
        $country = strtolower($country);
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        /// search adverts ///
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.document_name,{#c}.webad_c,{#c}.webad_url_c,{#c}.webad2_c,{#c}.webad2_url_c,{#c}.link_target_c,{#c}.target_url_c,{#c}.charge_basis_c,{#c}.impressions_c,{#c}.impression_target_c,{#c}.clicks_c,{#c}.click_target_c";
         $params['where'] = "{#c}.target_websites_c like '%^{$website}^%' and {#c}.website_ad_status_c='Active' and {#c}.start_date_c <= '{$now_date}' and {#c}.end_date_c >= '{$now_date}' and {#m}.size='{$size}' and LOWER({#c}.target_country_c) like '%^{$country}^%'";
        $params['orders'] = "rand()";
        $params['limit'] = $limit;
        $_adverts = $this->EE->adverts->get_main_data($params);
        //////////////////////
        if(empty($_adverts)){
            return '';
        }
        
        foreach($_adverts as $key => $_advert){
            if(!empty($_advert['webad_url_c'])){
                $_advert['web_ad'] = $_advert['webad_url_c'];
            }else{
                $_advert['web_ad'] = $img_base_url . $_advert['webad_c'];
            }

            if(!empty($_advert['webad2_url_c'])){
                $_advert['web_ad2'] = $_advert['webad2_url_c'];
            }else{
                $_advert['web_ad2'] = $img_base_url . $_advert['webad2_c'];
            }

            /// fetch target_url ///
            $target_url = '';
            if($_advert['link_target_c'] == 'URL'){
                $target_url = $_advert['target_url_c'];
            }
            if($_advert['link_target_c'] == 'Article'){
                $params = array();
                $params['selects'] = "{#m}.id";
                $params['id'] = $_advert['id'];
                $params['single'] = true;
                $_article = $this->EE->adverts->get_relationship_articles($params);  
                if(!empty($_article)){
                    $target_url = $_article['id'];
                }
            }
            if($_advert['link_target_c'] == 'Product'){
                $params = array();
                $params['selects'] = "{#m}.id";
                $params['id'] = $_advert['id'];
                $params['single'] = true;
                $_product = $this->EE->adverts->get_relationship_products($params);  
                if(!empty($_product)){
                    $target_url = $_product['id'];
                }
            }
            if($_advert['link_target_c'] == 'Event'){
                $params = array();
                $params['selects'] = "{#m}.id,{#c}.sef_url_c";
                $params['id'] = $_advert['id'];
                $params['single'] = true;
                $_cpd_event = $this->EE->adverts->get_relationship_cpd_events($params);  
                if(!empty($_cpd_event)){
                    $target_url = $_cpd_event['sef_url_c'];
                }
            }
            $_advert['target_action'] = $target_url;
            ////////////////////////
            
            $_adverts[$key] = $_advert;
        }
        /////// get html for script ////
        $html = '';
        if($GLOBALS['web_ad_script'] != "included"){
            $swaps = array(
                        'dt' => 'dt'
                     );
            $datas = array(
                        'dt' => $_advert
                     );
            
            $TMPL = new EE_Template();         
            $TMPL->run_template_engine('adverts', 'show');
            $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));
            $GLOBALS['web_ad_script'] = "included";
        }
        ////////////////////////////////
        $remember_flag;
        $username_c = "";
        $password_c = "";
        if(!$this->EE->remember->exists())
            $remember_flag = false;
        else{
            $remember_flag = true;

            $username = $this->EE->session->userdata['username'];
            if (!empty($username)){

                $username_c = $username;
                $selects = "{#c}.id_c as id,{#c}.username_c,{#c}.password_c,{#c}.failed_logins_c,{#c}.email_c,{#c}.locked_c,{#c}.hostile_c,{#c}.first_time_c,{#c}.initial_c,{#c}.gender_c,{#c}.photo_thumb_c,{#c}.prof_photo_c";
                $where = "{#c}.username_c='$username'";
                $params = array();
                $params['selects'] = $selects;
                $params['where'] = $where;
                $cstm = $this->EE->contacts->get_cstm_data($params, false);
                $selects = "{#m}.id,{#m}.first_name,{#m}.last_name,{#m}.salutation,{#c}.password_c";
                $params = array();
                $params['joins'] = array(
                                        "{#c}" => array(
                                            'sql' => $cstm['sql'],
                                            'table' => $cstm['table'],
                                            'type' => 'inner'
                                        )
                                     );
                $params['selects'] = $selects;
                $params['single'] = true;
                $_contact = $this->EE->contacts->get_contacts($params);
                $password_c = $_contact['password_c'];
            }
        }
        if($msg['user_id'])
            $username_c = $msg['user_id'];
        if($msg['password'])
            $password_c = $msg['password'];


        $signout;
        if($this->EE->input->cookie('tsignout'))
            $signout = "true";
        else{

            $signout = "false";
            if($this->EE->session->userdata('member_id') == 0)
                $signout = "true";

        }



        $_terms = $this->get_terms($type);

        ////////////////////////////////
        $swaps = array(
                    'id' => 'id',
                    'web_ad' => 'web_ad',
                    'web_ad2' => 'web_ad2',
                    'target_action' => 'target_action',
                    'document_name' => 'document_name',
                    'AID' => 'AID',
                    'CID' => 'CID',
                    'terms' => 'terms',
                    'type' => 'type',
                    'msg' => 'msg',
                    'remember' => 'remember',
                    'signout' => 'signout',
                    'username' => 'username',
                    'password' => 'password'
                    
                );
        $datas = array(
                    'id' => $_adverts[0]['id'],
                    'web_ad' =>$_adverts[0]['web_ad'],
                    'web_ad2' =>$_adverts[0]['web_ad2'],
                    'target_action' =>$_adverts[0]['target_action'],
                    'document_name' =>$_adverts[0]['document_name'],
                    'AID' => $action_id,
                    'CID' => $contact_id,
                    'terms' => $_terms,
                    'type' => $type,
                    
                    'msg' => $msg['message'],
                    'remember' => $remember_flag,
                    'signout' => $signout,
                    'username' => $username_c,
                    'password' => $password_c
                    
                );
        $this->EE->TMPL->run_template_engine('login', 'none_user_terms');
        $this->EE->output->app_output($swaps, $datas);

    }

    function get_terms($type){
        $data ='';
        $this->EE->load->model('messages');
        $messages = $this->EE->messages;
        
        $selects = "{#c}.effective_date_c,{#m}.description";
        if($type == 'terms')
            $where = "{#m}.area='DVTVterms'";
        else
            $where = "{#m}.area='DVTVprivacy'";
        $orders = "{#c}.effective_date_c desc";
        //$where = "{#m}.area='Welcome'";
        $_term = $messages->get_main_data(array('selects' => $selects, 'where' => $where, 'orders' => $orders, 'single' => 'true'));
        $effective_date_c = $_term['effective_date_c'];
        $term_desc = $_term['description'];
        return $term_desc;
    }

        
   
}

