<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Widget_UpcomingSpeakers extends DEProcessing_Dentevents_Widget{

    function initialize($params = array()){
        $this->EE->load->model("contacts");
    }
    
    function process($params = array()){
        $now_date = date("Y-m-d");
        /// cpd_events sql ///
        $params = array();
        $params['selects'] = "IF({#m}.listing_type = 'Preminum', 1, 0) as type_order, {#join_col} as rel_main_id";
        $params['where'] = "{#m}.event_status='Approved_Online' and {#m}.start_date > '{$now_date}' and ({#c}.rec_type_c NOT IN('Session','Day','Break','Stream') or {#c}.rec_type_c is null)";
        $params['groups'] = "rel_main_id";
        $params['execute'] = false;
       
        $cpd_events_sql = $this->EE->contacts->get_relationship_cpd_events_speakers($params);
        ////////////////////
        
        /////////////////////
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.prof_photo_c,{#c}.contact_id_nr_c,{#c}.initial_c,{#c}.prefname_c";
        $params['where'] = "{#c}.prof_photo_c is not null and {#c}.prof_photo_c != ''";
        $params['joins'] = array(
                                '{#cp}' => array(
                                           'sql' => $cpd_events_sql,
                                           'table' => 'linked_cpd_events',
                                           'type' => 'inner',
                                           'cond' => "{#m}.id={#cp}.rel_main_id" 
                                        )
                            );
        $params['orders'] = "{#cp}.type_order desc";
        $params['limit'] = '6';
   
        $speakers = $this->EE->contacts->get_main_data($params);
        //////////////////////////////////
        
        $img_base_url = $this->_crm_config['main']['upload_url'];
        ////////////////////////////////
        $swaps = array(
                    'id' => 'id',
                    'photo' => 'photo',
                    'last_name' => 'last_name',
                    'action_url' => 'action_url'
                );
        $tagdata = $this->EE->TMPL->tagdata;
        
        $return = '';
        foreach($speakers as $_speaker){
			$name = '';
			if(!empty($_speaker['prefname_c'])){
                $name = $_speaker['salutation'] . " " . $_speaker['prefname_c'] . " " . $_speaker['last_name'];
            }else{
                if(!empty($_speaker['initial_c'])){
                    $name = $_speaker['salutation'] . " " . $_speaker['first_name'] . " " . $_speaker['initial_c'] . " " . $_speaker['last_name'];
                }else{
                    $name = $_speaker['salutation'] . " " . $_speaker['first_name'] . " " . $_speaker['last_name'];
                }
            }
            $_speaker['photo'] = $img_base_url . $_speaker['prof_photo_c'];
            $_speaker['action_url'] = $this->seo_helper->get_seo_url(Seo_Helper::SPEAKER_PROFILE, array('id' => $_speaker['contact_id_nr_c'], 'name' => $name));
            $return .= $this->helper->render_results($swaps, $_speaker, $tagdata);
        }
        /////////////////////////////////
        
        return $return;
    }
     
}