<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class BRDProcessing_Utility extends BRDProcessing{
    
    function __construct(){
        self::$utility = $this;
        parent::__construct();
    }
    
    function fetch_router(){
        $router = self::$router;
        
        $routers = explode(":", $router);
        
        $cmd = $routers[0];
        $routers = array_slice($routers, 1);
        $router = implode(":", $routers);
        
        self::$router = $router;
        
        return $cmd;
    }
    
    function fetch_contact_by_id($contact_id){
        $contacts = $this->EE->contacts;
       
        $selects = "{#c}.id_c as id,{#c}.prefname_c,{#c}.initial_c";
        $where = "{#c}.id_c='$contact_id'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params); 
        
        return $_contact;
    }
    function check_user($email = ''){
        $contacts = $this->EE->contacts;
        $_email = $email;

        $selects = "{#c}.id_c as id,{#c}.prefname_c,{#c}.initial_c,{#c}.email_c,{#c}.username_c,{#c}.first_time_c,{#c}.password_c";
        $where = "{#c}.username_c='$email' or {#c}.email_c='$email'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $_contact = $contacts->get_contacts($params); 
        return $_contact;
    }
    function fetch_contact(){
        if(!empty(self::$contact)){
            return self::$contact;
        }
        $contacts = $this->EE->contacts;
       
        $username = $this->EE->session->userdata('username');
        if (empty($username)){
            return false;
        }
        $selects = "{#c}.id_c as id,{#c}.pract_type_c,{#c}.pract_type_nz_c,{#c}.rego_domain_c,{#c}.email_c,{#c}.prefname_c,{#c}.initial_c";
        $where = "{#c}.username_c='$username'";
        $params = array();
        $params['selects'] = $selects;
        $params['where'] = $where;
        $cstm = $contacts->get_cstm_data($params, false);
        
        $selects = "{#m}.id,{#m}.salutation,{#m}.first_name,{#m}.last_name,{#c}.*";
        $params = array();
        $params['joins'] = array(
                                "{#c}" => array(
                                    'sql' => $cstm['sql'],
                                    'table' => $cstm['table'],
                                    'type' => 'inner'
                                )
                             );
        $params['selects'] = $selects;
        $params['single'] = true;
        $_contact = $contacts->get_contacts($params); 
        
        self::$contact = $_contact;
        
        return $_contact;       
    }
    
    function get_groups_user($contact_id){
        $this->EE->load->model("contacts");
        $this->EE->load->model("grp_groups");
        
        $members = $this->EE->contacts->get_relationship_grp_group_members(
                        array('id' => $contact_id, 'selects' => "{#m}.id", 'to_values' => 'id')
                    );
        if(empty($members)){
            return null;
        }
        $in_sql_members = implode("','", $members);
        $group_members_sql = $this->EE->grp_groups->get_relationship_group_members(
                        array('selects' => "{#join_col} as rel_main_id", 
                        'where' => "{#m}.id IN('{$in_sql_members}')", 
                        'execute' => false,
                        'groups' => 'rel_main_id'
                        )
                    );
                    
        $params = array();
        $params['selects'] = "{#m}.id,{#m}.name";
        $params['joins'] = array(
                                '{#lg}' => array(
                                           'sql' => $group_members_sql,
                                           'table' => 'linked_members',
                                           'type' => 'inner',
                                           'cond' => "{#m}.id={#lg}.rel_main_id" 
                                        )
                            );
        $groups = $this->EE->grp_groups->get_main_data($params);
        
        return $groups;
    }
    function check_access_board($board ,$need_infos = false){    
        $access = array('view' => 1, 'update' => 1);
        
        if($board['access_c'] == 'Open' && !$need_infos){
            return $access;
        }    
                             
        $_contact = $this->fetch_contact();
        $this->EE->load->model("disc_discussion_boards");
        $this->EE->load->model("grp_groups");
        $this->EE->load->model("grp_group_members");
        
        /// fetch group members from board ///
        $_group = $this->EE->disc_discussion_boards->get_relationship_group_access(
                        array('id' => $board['id'], 'selects' => "{#m}.id", 'single' => true)
                    );
        if(empty($_group)){ 
            if($board['access_c'] == 'Open'){
               return $access;     
            }
            return array('view' => 0, 'update' => 0);
        }
        $selects = "{#m}.id";
        if($need_infos){
            $selects .=", {#c}.group_level_c";
        }
        $members_from_board = $this->EE->grp_groups->get_relationship_group_members(
                        array('id' => $_group['id'], 'selects' => $selects)
                    );
        //////////////////////////////////////
        
        /// need infos ///
        if($need_infos){
            $moderators = array();
            $owners = array();
            $commoners = array();
             
            foreach($members_from_board as $item){
                 $_member = $this->EE->grp_group_members->get_relationship_contacts(
                        array('id' => $item['id'], 'selects' => "{#m}.id", 'single' => true)
                    );
                 if(empty($_member)){
                     continue;
                 }
                 switch($item['group_level_c']){
                     case 'Owner':
                        $owners[] = $_member['id'];   
                     break;
                     case 'Moderator':
                        $moderators[] = $_member['id'];
                     break;
                     default:
                        $commoners[] = $_member['id'];
                     break;
                 }
            }
            $access['members'] = array('owners' => $owners, 'moderators' => $moderators, 'commoners' => $commoners, 'totals' => count($members_from_board));
        }
        //////////////////
        
        /// fetch group members from contact ///
        $members_from_contact = $this->EE->contacts->get_relationship_grp_group_members(
                        array('id' => $_contact['id'], 'selects' => "{#m}.id", 'to_values' => 'id')
                    );
        ////////////////////////////////////////
        
        $temp = array();
        foreach($members_from_board as $item){
            $temp[] = $item['id'];
        }
        $members_from_board = $temp;
        
        $intersect = array_intersect($members_from_board, $members_from_contact);
        if(empty($intersect)){
            if($board['access_c'] == 'GroupUpdateAnyView'){
                $access['update'] = 0;
            }
            if($board['access_c'] == 'GroupOnly'){
                $access['view'] = 0;
                $access['update'] = 0;
            }
        }
        
        return $access;
    }

    function get_full_name($contacts = array()){
        $full_names = array();
        foreach ($contacts as $key => $item){
            $full_name = $item['salutation'] . " " . $item['first_name'] . " " . $item['last_name'];
            $full_names[] = $full_name;
        }

        return $full_names;
    }

    function get_full_name_by_id($contacts = array()){
        $full_names = array();
        foreach ($contacts as $key => $item){
            $full_name = $item['salutation'] . " " . $item['first_name'] . " " . $item['last_name'];
            $id = $item['id'];
            $full_names[$id] = $full_name;
        }

        return $full_names;
    }
    
    function filter_members($members = array()){
        foreach($members as $key => $item){
            $access = $item['access_c'];
            $access = trim($access, "^");
            $access = explode("^,^", $access);
            foreach($access as $_key => $_item){
                $access[$_key] = $this->helper->get_dropdowns_sugar_labels('update_access_0', $_item, false);
            }
            $members[$key]['access'] = implode(", ", $access);
            /// get contacts from group member ///
            $contacts = $this->EE->grp_group_members->get_relationship_contacts(array(
               'id' => $item['id'],
                'selects' => "{#m}.salutation,{#m}.first_name,{#m}.last_name"
            ));
            $full_name = '';
            if(!empty($contacts)){
                $full_names = $this->get_full_name($contacts);
                $full_name = implode("<br>", $full_names);
            }
            $members[$key]['linked_contacts'] = $full_name;
            ///
        }

        return $members;
    }

    function trim_explode($str){
        $access = trim($str, "^");
        $access = explode("^,^", $access);

        return $access;
    }
}