<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Account extends DEProcessing_Dentevents{
   static $account;
   static $pagination = true;
   
   function initialize($params = array()){
       $this->EE->load->model("accounts");
       $this->EE->load->model("contacts");
       $this->EE->load->model("postcodes");
       $this->EE->load->model("speciality");
       
       $id = $this->EE->input->get_post("id");

       /// fetch account ///
       $params = array();
       $params['selects'] = "{#m}.id,{#m}.name,{#m}.billing_address_country,{#m}.billing_address_city,{#m}.billing_address_state,{#m}.billing_address_postalcode,{#m}.billing_address_street,
                             {#m}.phone_office,{#m}.phone_fax,{#m}.website,{#m}.description,
                             {#c}.longitude_c,{#c}.lat_c,{#c}.photo1_url_c,{#c}.photo2_url_c,{#c}.logo_url_c,{#c}.account_type_new_c,
                             {#c}.billing_name_c,{#c}.free_phone_c,{#c}.intl_phone_c,{#c}.intl_phone_fax_c,{#c}.disabled_facilities_c,
                             {#c}.ah_emerg_phone_c,{#c}.ah_emerg_proc_c,{#c}.website_stage_c,
                             {#c}.hours_sun_open_c,{#c}.hours_mon_open_c,{#c}.hours_tue_open_c,{#c}.hours_wed_open_c,
                             {#c}.hours_thu_open_c,{#c}.hours_fri_open_c,{#c}.hours_sat_open_c,
                             {#c}.hours_sun_close_c,{#c}.hours_mon_close_c,{#c}.hours_tue_close_c,{#c}.hours_wed_close_c,
                             {#c}.hours_thu_close_c,{#c}.hours_fri_close_c,{#c}.hours_sat_close_c,
                             {#c}.facebook_c,{#c}.twitter_c,{#c}.googleplus_c,{#c}.yelp_c,{#c}.youtube_c,
                             {#c}.flickr_c,{#c}.pinterest_c,{#c}.linkedin_c,{#c}.instagram_c,{#c}.xing_c,
                             {#c}.online_booking_link_c,{#c}.online_booking_engine_c,{#c}.special_offer_c,{#c}.special_offer_expiry_c,
                             {#c}.special_offer_terms_c,{#c}.appt_info_c,{#c}.servicesblob_c,{#c}.exact_location_c,{#c}.display_on_internet_c,
                             {#c}.parking_c,{#c}.finance_policy_c,{#c}.email_on_internet_c,{#c}.contact_id1_c,{#c}.account_id_nr_c,{#c}.tripadvisor_c
                            ";
       $params['where'] = "{#c}.account_id_nr_c='$id'";
       $params['single'] = true;
       
       self::$account = $this->EE->accounts->get_main_data($params);
       
       $city = self::$account['billing_address_city'];
       $city = strtolower($city); $city = ucwords($city);
       self::$account['billing_address_city'] = $city;

       /////////////////////
   }
    
   function process($params = array()){
       $cmd = self::$utility->fetch_router();
        
       switch($cmd){
           case "show":
               return $this->show($params);
           break;
           case "email":
               require_once(PATH_THIRD . 'mdentevents/models/mdentevents/account/email.php');
               $processing = new DEProcessing_Dentevents_Account_Email();
               $processing->initialize($params);
               return $processing->process($params);  
           break;
           
           case "linked_datas":
               require_once(PATH_THIRD . 'mdentevents/models/mdentevents/account/linked_datas.php');
               $processing = new DEProcessing_Dentevents_Account_LinkedDatas();
               $processing->initialize($params);
               return $processing->process($params); 
           break;
           
           case "latest_news":
                require_once(PATH_THIRD . 'mdentevents/models/mdentevents/account/latest_news.php');
               $processing = new DEProcessing_Dentevents_Account_LatestNews();
               $processing->initialize($params);
               return $processing->process($params); 
           break;
       }
   }
   
   function show($params = array()){       
       $id = self::$account['id'];
       $target_type = $this->EE->input->get_post("type");
       self::$pagination = false;
       $_account = self::$account;
       $img_base_url = $this->_crm_config['main']['upload_url'];
       
       /// logging ///
       self::$router = "logger:logger";
       DEProcessing_Dentevents_Account::process(array('logger_field_prefix' => '{#m}', 'logger_field' => 'schclick'));     
       ///////////////
       
       ///////////////////////////////////////////////////////
       $datas = array();
       
       $datas['target_type'] = $target_type;
       $datas['id'] = $_account['account_id_nr_c'];
       $datas['account_id'] = $_account['id'];
       $datas['city'] = $_account['billing_address_city']; 
       $datas['state'] = strtoupper($_account['billing_address_state']);
       $datas['postalcode'] = $_account['billing_address_postalcode'];
       $datas['billing_name'] = $_account['billing_name_c'];
       $datas['appt_info'] = $_account['appt_info_c'];
       $datas['servicesblob'] = $_account['servicesblob_c'];
       $datas['description'] = $_account['description'];
       $datas['online_booking_link'] = $_account['online_booking_link_c'];
       $datas['country'] = $_account['billing_address_country'];
       
       switch($target_type){
           case 'venue':
               $target_type_text = "Venue"; 
           break;
           case 'org':
               $target_type_text = "Organiser";  
           break;
           case 'exhibitor':
               $target_type_text = "Exhibitor";  
           break;
       }    
       $datas['target_type_text'] = $target_type_text;
          
       switch($_account['online_booking_engine_c']){
           case "Tooth_Pick_AU":
               $datas['online_booking_img'] = 'book_btn_tooth_pick_au';  
           break;
           case "1st_Available":
               $datas['online_booking_img'] = 'book_btn_1st_available';   
           break;
           case "Dental_Bookings_AU":
               $datas['online_booking_img'] = 'book_btn_dental_bookings_au';  
           break;
           case "ezybook":
               $datas['online_booking_img'] = 'book_btn_ezybook';  
           break;
           case "Health_Engine_AU":
               $datas['online_booking_img'] = 'book_btn_health_engine_au';  
           break;
           default:
               $datas['online_booking_img'] = 'book_btn_default';  
           break;
       }
       
       $datas['parking'] = $_account['parking_c'];
       $datas['exact_location'] = $_account['exact_location_c'];
       $datas['finance_policy'] = $_account['finance_policy_c'];

       /// check account_type_new_c ///
       if($_account['account_type_new_c'] == "Government Clinic"){
           $datas['notify_government_clinic'] = "NOTE: Treatment at this clinic is subsidised and eligibility criteria applies.";
       }
       $datas['account_type_title'] = "DENTIST";
       if($_account['account_type_new_c'] == "Denture Clinic"){
           $datas['account_type_title'] = "Denture Clinic";
       }
       ////////////////////////////////
       
       /// fetch email1 ///
       if($_account['email_on_internet_c'] == 1){
           $email1 = $this->EE->accounts->get_email_address($_account['id']);
           if(!empty($email1)){
               $datas['email1'] = $email1;
           }
       }
       ////////////////////
       
       /// fetch website ///
       $website = $_account['website'];
       $website = preg_replace('#^https?://#', '', $website);
       $datas['website'] = $website;
       /////////////////////
       
       /// fetch open today box and compare ///
       date_default_timezone_set("Australia/Sydney");

       $now_timestamp = time();
       $now_day = strtolower(date("D"));
       $now_date = date("Y-m-d");
       
       $day_maps = array("sun", "mon", "tue", "wed", "thu", "fri", "sat");
       $days = array();
       foreach($day_maps as $item){
           $days[$item] = array('open' => $this->helper->get_correct_time($_account["hours_{$item}_open_c"]), 'close' => $this->helper->get_correct_time($_account["hours_{$item}_close_c"]));
       }
       
       if(!empty($days[$now_day]['open']) && !empty($days[$now_day]['close'])){
          /// get time stamp for open and close ///
          $timezone = '';
          if(!empty($_account['lat_c']) && !empty($_account['longitude_c'])){
               if(!empty($_account['billing_address_country'])){
                   $timezone = $this->helper->get_nearest_timezone($_account['lat_c'], $_account['longitude_c'], $this->helper->get_countrycode($_account['billing_address_country']));
              }else{
                   $timezone = $this->helper->get_nearest_timezone($_account['lat_c'], $_account['longitude_c']);
              }
          }
          
          if(!empty($timezone)){
              $open_timestamp = new DateTime($now_date . ' ' . $days[$now_day]['open'], new DateTimeZone($timezone));
              $days[$now_day]['open'] = $open_timestamp->format("g:i a");
              $open_timestamp = $open_timestamp->getTimestamp();
              try{
                    $close_timestamp = new DateTime($now_date . ' ' . $days[$now_day]['close'], new DateTimeZone($timezone));
              }catch(Exception $e){
                  
              }
              $days[$now_day]['close'] = $close_timestamp->format("g:i a");
              $close_timestamp = $close_timestamp->getTimestamp();
          }else{
              $open_timestamp = new DateTime($now_date . ' ' . $days[$now_day]['open']);
              $days[$now_day]['open'] = $open_timestamp->format("g:i a");
              $open_timestamp = $open_timestamp->getTimestamp();
              try{
                    $close_timestamp = new DateTime($now_date . ' ' . $days[$now_day]['close']);
              }catch(Exception $e){
                  
              }
              $days[$now_day]['close'] = $close_timestamp->format("g:i a");
              $close_timestamp = $close_timestamp->getTimestamp();
          }
          /////////////////////////////////////////
       }   
       
       if($open_timestamp == null){
           $open_timestamp = 0;
       }
       if($close_timestamp == null){
           $close_timestamp = 0;
       }
       // var_dump($now_day);
       // var_dump($now_timestamp);
       // var_dump($open_timestamp);
       /// compare the now timestamp with open and close timestamp ///
       if($now_timestamp < $open_timestamp){
            $datas['open_day_box'] = "Open Today: " . $days[$now_day]['open'] . " to " . $days[$now_day]['close'];
       }else if($now_timestamp > $close_timestamp){
            for($i = 1; $i < 7; $i++){
               $t_date = new DateTime();
               $t_date = $t_date->add(new DateInterval("P{$i}D"));
               $t_day = strtolower($t_date->format("D"));
               $t_lbl_day = $t_date->format("l");
               if(!empty($days[$t_day]['open']) && !empty($days[$t_day]['close'])){
                   $datas['open_day_box'] = "Open {$t_lbl_day} Call fm " . $days[$t_day]['open'];
                   break;
               }
            }
       }else{
            $datas['open_day_box'] = "Now Open: Call before " . $days[$now_day]['close'];
       }
       ///////////////////////////////////////////////////////////////

       ////////////////////////////    
       
       ///// INITIALIZE open/close hours /////
       $days = array('sun' => 'Sunday', 'mon' => 'Monday', 'tue' => 'Tuesday', 'wed' => 'Wednesday', 'thu' => 'Thursday', 'fri' => 'Friday', 'sat' => 'Saturday');
       
       $datas['hours'] = array();
       // if($_SERVER['REMOTE_ADDR'] == '103.6.219.60'){
       // date_default_timezone_set("Australia/Sydney");
        $cur_date = date("d-m-Y h:i:s a");
        $date_time = new DateTime($cur_date, new DateTimeZone('Australia/Sydney'));
        // $date_time->setTimezone( new DateTimeZone("Australia/Sydney"));

        $cur_date = $date_time->format("N");
        if($_SERVER['REMOTE_ADDR'] == '103.6.219.221'){
          // var_dump($cur_date);
          // var_dump($date_time);
          // $test = new DateTimeZone('Australia/Sydney');
          // $gmt = new DateTimeZone('AEDT');

          // $date = new DateTime('2011-12-25 00:00:00', $test);
          // $date->setTimezone($gmt);
          // echo $date->format('Y-m-d H:i:s');

          // date_default_timezone_set('Australia/Sydney');
          // $_date = date('m/d/Y h:i:s a', time());
          // echo $_date;
          // date_default_timezone_set('Australia/Sydney');

          // $timestamp = time();
          // $date_time = date("d-m-Y (D) H:i:s", $timestamp);
          // echo "Current date and local time on this server is $date_time";
        } 



       // }
       foreach($days as $key => $item){
           $data = array();
           $open_hours = $_account["hours_{$key}_open_c"];
           if(!empty($open_hours)){
               try{
                   $open_hours = new DateTime($open_hours);
                   $data['open'] = $open_hours->format("h:i a");
               } catch (Exception $e) {
               }
               
           }

           $close_hours = $_account["hours_{$key}_close_c"];
           if(!empty($close_hours)){
               try{
                   $close_hours = new DateTime($close_hours);
                   $data['close'] = $close_hours->format("h:i a");
               } catch (Exception $e) {
               }    
           }
           // if(!empty($open_hours) || !empty($close_hours)){
             $data['code'] = $key;
             $data['title'] = $item;
           // }
           
           if(!empty($data['open']) && !empty($data['close'])){
               $datas['hours'][] = $data;     
           }
                   
       }
       if(!empty($datas['hours'])){
          $cur_weekday = intval($cur_date) - 1;
          if ($cur_weekday == 7) {
            $cur_weekday = 0;
          }
          if($_SERVER['REMOTE_ADDR'] == '103.6.219.221'){

            // var_dump($cur_weekday);
            // var_dump($datas['hours'][$cur_weekday]);
          }
          if(!empty($datas['hours'][$cur_weekday]))
            $datas['hours'][$cur_weekday]['class'] = 'red';
       }

      if($_SERVER['REMOTE_ADDR'] == '103.6.219.221'){

        // var_dump("</br>");
        // var_dump($datas['hours']);
      }
       ///////////////////////////////////////  
       
       /// fetch logo ///
       if(!empty($_account['logo_url_c'])){
           $datas['logo'] = $_account['logo_url_c'];
       }
       //////////////////
       
       /// fetch photo1 and photo2 ///
       if(!empty($_account['photo1_url_c'])){
           $datas['photo1'] = $_account['photo1_url_c'];
       }

       if(!empty($_account['photo2_url_c'])){
           $datas['photo2'] = $_account['photo2_url_c'];
       }
       ///////////////////////////////
       
       /// fetch social links ///
       $socials_maps = array('facebook', 'twitter', 'googleplus', 'yelp', 'youtube', 'flickr', 'pinterest', 'linkedin', 'instagram', 'xing', 'tripadvisor');
       $socials = array();
       foreach($socials_maps as $item){
           $link = $_account[$item . '_c'];
           if($item == 'twitter' && !empty($link)){
               $link = "https://x.com/{$link}";
           }
           $socials[] = array('code' => $item, 'link' => $link);
       }
       $datas['socials'] = $socials;
       //////////////////////////
       
       /// check special offer ///
       if(!empty($_account['special_offer_c'])){
            $spec_expiry = new DateTime($_account['special_offer_expiry_c']);
            $spec_expiry = $spec_expiry->format("Y-m-d");
            $now_date = new DateTime();
            $now_date = $now_date->format("Y-m-d"); 
            if($spec_expiry >= $now_date){
                $datas['special_offer'] = $_account['special_offer_c'];
                $datas['special_offer_terms'] = $_account['special_offer_terms_c'];
            }
       }
       $datas['special_offer'] = (empty($datas['special_offer'])) ? '' : $datas['special_offer'];
       ///////////////////////////
       
       /// fetch contact ///
            /// check show country ///
            $country = $this->helper->getRemoteCountry(true);
            $show = "yes";
            if($country != null && strtolower($country->country_name) == strtolower($_account['billing_address_country'])){
                $show = "no";
            }
            $datas['show_country'] = $show;
            //////////////////////////
            /// phone office ///
            $phone_office = $_account['phone_office'];
            if($show == "yes" && !empty($_account['intl_phone_c'])){
                $phone_office = $_account['intl_phone_c'];
            }
            ////////////////////
            /// phone fax ///
            $phone_fax = $_account['phone_fax'];
            if($show == "yes" && !empty($_account['intl_phone_fax_c'])){
                $phone_fax = $_account['intl_phone_fax_c'];
            }
            ////////////////////

       if($show == "yes"){
           $contact_phone = $_account['intl_phone_c'];
       }else{
           $contact_phone = $_account['free_phone_c'];
       }
       if(empty($contact_phone)){
           $contact_phone = $_account['phone_office'];
       }
       $address = nl2br($_account['billing_address_street']);
       $datas['contact'] = array('address' => $address, 'phone' => $phone_office,
                                 'freecall_phone' => $_account['free_phone_c'], 'fax' => $phone_fax, 'contact_phone' => $contact_phone);
       /////////////////////  
       
       
       /// fetch disabled facilities ///
       $list = $this->helper->get_dropdowns_sugar_labels('disabled_facilities_list', $_account['disabled_facilities_c']);
       $datas['disabled_facilities'] = implode(" ", $list);
       /////////////////////////////////
       
       /// fetch After Hours Emergencies  ///
       $datas['ah_emerg_phone'] = $_account['ah_emerg_phone_c'];
       $datas['ah_emerg_proc'] = $_account['ah_emerg_proc_c'];
       //////////////////////////////////////
              
       /// fetch gmap ///
       $datas['gmap'] = array('longitude' => $_account['longitude_c'], 'latitude' => $_account['lat_c']);
       //////////////////
       
       /// fetch linked_datas ///
       self::$router = "linked_datas:fetch_data";
       $linked_datas = DEProcessing_Dentevents_Account::process();
       $datas['linked_datas'] = $linked_datas;
       //////////////////////////
       
       /// upcoming events ///
       self::$router = "events:search:event_account:fetch_data";
       $datas['linked_datas']['upcoming_events'] = DEProcessing_Dentevents::process(array('account_id' => self::$account['id'], 'target' => $target_type,'upcoming_or_past' => 'upcoming', 'pagination' => self::$pagination,'from'=>'accont-page'));
       $datas['linked_datas']['upcoming_events_count'] = count($datas['linked_datas']['upcoming_events']);
       ///////////////////////
       // if($_SERVER['REMOTE_ADDR'] == '103.6.219.60'){
       //   var_dump($datas['linked_datas']['upcoming_events']);
       // }
       
       /// past events ///
       self::$router = "events:search:event_account:fetch_data";
       $datas['linked_datas']['past_events'] = DEProcessing_Dentevents::process(array('account_id' => self::$account['id'], 'target' => $target_type, 'upcoming_or_past' => 'past', 'pagination' => true,'page' => 'speaker_side'));
       $datas['linked_datas']['past_events_count'] = self::$p_events_total;
       ///////////////////
       
       /// email link ///
       $datas['email_link'] = $this->seo_helper->get_seo_url(Seo_Helper::ACCOUNT_DETAIL_EMAIL, array('id' => self::$account['account_id_nr_c']));
       //////////////////
       
       /// latest news ///
       self::$router = "account:latest_news:show";
       $latest_news_html = DEProcessing_Dentevents::process(array('output' => false, 'current_page' => 1, 'account_news' => true, 'account_id' => self::$account['id']));
       $datas['linked_datas']['latest_news'] = $latest_news_html;
       ///////////////////
       
       /// REGISTER META DATAS TO GLOBALS ///
       $GLOBALS['meta']['city'] = $datas['city'];
       $GLOBALS['meta']['state'] = $datas['state'];
       $GLOBALS['meta']['practice_name'] = $_account['name'];  
       $GLOBALS['meta']['country'] = $_account['billing_address_country'];
       $GLOBALS['meta']['name'] = $_account['billing_name_c'];
       $GLOBALS['meta']['id'] = $_account['account_id_nr_c'];
       
       //////////////////////////////////////
       
       ////////pagination ////////////////////////
       self::$router = "events:pagination";
       $pagination = DEProcessing_Dentevents::process(array('account_id' => self::$account['id'], 'target' => $target_type));
       ///////////////////////////////////////
       $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
       $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt',
                    'pagination' => 'pagination'
                );
       $datas = array(
                    'AID' => $action_id,
                    'dt' => $datas,
                    'pagination' => $pagination
               );

       $this->EE->TMPL->run_template_engine("dentevents", "account");
       $this->EE->output->app_output($swaps, $datas);
   }
}