<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Account_Email extends DEProcessing_Dentevents_Account{

   function initialize($params = array()){
       $this->EE->load->model("contacts");
   }
    
   function process($params = array()){
       $cmd = self::$utility->fetch_router();
        
       switch($cmd){
           case "show":
                return $this->show($params);
           break;
           case "send":
                return $this->send($params); 
           break;
       }
   }
   
   function send($params = array()){
       $_account = self::$account;

       $subject = $this->EE->input->get_post("subject"); $subject = (empty($subject)) ? '' : $subject;
       $message = $this->EE->input->get_post("message"); $message = (empty($message)) ? '' : $message;
       $org_message = $message;
       $name = $this->EE->input->get_post("name"); $name = (empty($name)) ? '' : $name;
       $email = $this->EE->input->get_post("email"); $email = (empty($email)) ? '' : $email;
       $phone = $this->EE->input->get_post("phone"); $phone = (empty($phone)) ? '' : $phone;

    
       
       
       $data = array();
       $data['message'] = $message;
       $data['phone'] = $phone;
       $data['name'] = $name;
       $data['email'] = $email;
       
       /// contact email logger ///
       self::$router = "logger:logger";
       DEProcessing_Dentevents_Account::process(array('logger_field_prefix' => '{#c}', 'logger_field' => 'email_count_c'));
       ////////////////////////////
       
       /// fetch time ///
       $time = new DateTime();
       $time = $time->format("d M Y h:i:s");
       $data['time'] = $time;
       //////////////////
       
       /// fetch email1 ///
       $email1 = $this->EE->accounts->get_email_address($_account['id']);
       ////////////////////
       
       /// fetch dentist name ///
       $billing_name = $_account['billing_name_c'];
       $data['billing_name'] = $billing_name;
       //////////////////////////
       
       /// SEND email ///
       $email_template = $this->EE->TMPL->fetch_template('email', 'dentist_account', false);
            
        $swaps = array(
            'dt' => 'dt'
            );
        $datas = array(
            'dt' => $data
            );  
        
        $message = $this->helper->render_results($swaps, $datas, $email_template, true);
            
        $address = $email1;
        $email_tit = $subject;
        $email_msg = $message;
        
        $this->EE->load->library('email');
        $this->EE->email->wordwrap = true;
        $this->EE->email->set_mailtype('html');
        $this->EE->email->from($this->EE->config->item('webmaster_email'), $this->EE->config->item('webmaster_name'));
        $this->EE->email->to($address);
        $this->EE->email->subject($email_tit);
        $this->EE->email->message($email_msg);
        
        $status = '';
        if($this->EE->email->send()){
            $status = "success";
        }else{
            $status = "fail";
        }
       //////////////////
       
       if($status == "success"){
           /// if success, create task and link it to owner_c and account ///
           $owner = $_account['contact_id1_c'];
           $data_task = array(
                   'name' => 'Inquiry from dentist.com.au',
                   'status' => 'In Progress',
                   'message_no_c' => 'MUS2010',
                   'date_entered' => date("F j, Y, g:i a"),
                   'priority' => 'Medium',
                   'message_type_c' => 'External',
                   'email_from_name_c' => $name,
                   'reply_to_email_c' => $email,
                   'email_from_phone_c' => $phone,
                   'description' => $org_message,
                   'parent_type' => "Accounts",
                   'parent_id' => $_account['id'],
                   'contact_id' => $owner
               );
           
           $success = $this->tasks->set_record($data_task);
           if(!$success){
               $this->logger->developer("Failed to create the task for email sent.");
               return false;
           }
           //////////////////////////////////////////////////////////////////     
       }
       
       
       return $this->show(array('status' => $status));
   }
   
   function show($params = array()){
       $_account = self::$account;
       
       $name = $this->EE->input->get_post("name"); $name = (empty($name)) ? '' : $name;
       $email = $this->EE->input->get_post("email"); $email = (empty($email)) ? '' : $email;
       $phone = $this->EE->input->get_post("phone"); $phone = (empty($phone)) ? '' : $phone;
       
       $status = $params['status'];
       $status = (empty($status)) ? '' : $status;

       $tar = $this->EE->input->get_post("tar");
       /// fetch account data ///
       
       /////////////////////
       
       /// fetch billing name ///
       $billing_name = $_account['billing_name_c'];
       //////////////////////////
       
       $data = array('id' => $_account['account_id_nr_c'], 'name' => $name, 'email' => $email, 'phone' => $phone, 'billing_name' => $billing_name, 'status' => $status, 'target' => $tar);
       
       $action_id = $this->helper->fetch_action_id("Mdentevents", "process");
       
       $swaps = array(
                    'AID' => 'AID',
                    'dt' => 'dt'
                );
       $datas = array(
                    'AID' => $action_id,
                    'dt' => $data
                );    
                
       $this->EE->TMPL->run_template_engine("dentevents", "account_email");
       $this->EE->output->app_output($swaps, $datas);
   }
}