<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Account_LatestNews extends DEProcessing_Dentevents_Account{
    static $list;
    protected $current_page;
    
    function initialize($params = array()){
        $this->EE->load->model("cpd_events");
        $this->EE->load->model("articles");
        $this->EE->load->model("accounts");
        
        $account_id = $params['account_id'];
        if(empty($account_id)){
            $account_id = $this->EE->input->get_post('account_id');
        }
        $now_date = date("Y-m-d");
        
        $current_page = $this->EE->input->get_post('current_page');
        if(!empty($params['current_page'])){
            $current_page = $params['current_page'];
        }
        $this->current_page = $current_page;
        
        $params = array();
        $params['id'] = $account_id;
        $params['selects'] = "{#m}.id,{#m}.document_name,{#m}.article_type,{#m}.active_date,{#c}.publication_c";
        $params['where'] = "{#m}.article_type='News' and {#m}.article_search is not null and {#m}.active_date <= '{$now_date}' and ({#m}.exp_date >= '{$now_date}' or {#m}.exp_date is null) and {#m}.status_id='Complete' and {#m}.public_article='Yes'";
        $params['orders'] = "{#m}.active_date desc";
        
        self::$list = $this->EE->accounts->get_relationship_articles($params);
       
    }
    
    function process($params = array()){
        $cmd = self::$utility->fetch_router();
        
        switch($cmd){
            case "fetch_data":
                return $this->fetch_data($params);
            break;
            case "show":
                return $this->show($params);
            break;
        }

    }
    
    function fetch_data($params=''){
        $disable_pagination = $params['disable_pagination'];
        
        /// INITIALIZE the pagination ///
        $current_page = $this->current_page;
        $items_per_page = $this->_app_config['pagination']['events:details:premium:latest_news']['items_per_page'];
        //$items_per_page = 2;
        $items_per_navigation = $this->_app_config['pagination']['events:details:premium:latest_news']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        $totals = count(self::$list);
        //////////////////////////////////
        
        $offset = ($current_page - 1) * $items_per_page;
        $list = array_slice(self::$list, $offset, $items_per_page);
        if($disable_pagination === true){
            $list = self::$list;
        }
        
        /// logging events ///
        //self::$router = "logger:record_events";
        //DEProcessing_Dentevents::process(array('events' => $events));
        //////////////////////
        
        $image_base_url = $this->_crm_config['main']['upload_url'];
        
        $limit_text_length = 50;
        if($this->helper->is_mobile_device()){
            $limit_text_length = 40;    
        }
        
        /// article image ///
        $params = array();
        $params['selects'] = "{#m}.article_image,{#m}.image_url";
        $params['orders'] = "{#m}.sequence asc";
        $params['single'] = true;
        /////////////////////
        
        foreach($list as $key => $item){
            $list[$key]['publication'] = $item['publication_c'];
            /// active date ///
            $active_date = new DateTime($item['active_date']);
            $list[$key]['active_date'] = $active_date->format("d M Y");
            ///////////////////
            
            //// article image ////
            $params['id'] = $item['id'];
            $_image = $this->EE->articles->get_relationship_images($params);
            if(!empty($_image)){
                // $list[$key]['image'] = $image_base_url . $_image['article_image'];
                $list[$key]['image'] = $_image['image_url'];
            }
            ///////////////////////
            
            /// action ///
            $list[$key]['action'] = $this->seo_helper->get_seo_url(Seo_Helper::ARTICLE_DETAIL, array('article' => $item));
            //////////////
            
        }
        
        return $list;
    }
    
    private function _prepare_pagination(){
        $totals = count(self::$list);
        /// INITIALIZE the pagination ///
        $current_page = $this->current_page;
        $items_per_page = $this->_app_config['pagination']['events:details:premium:latest_news']['items_per_page'];
        //$items_per_page = 2;
        $items_per_navigation = $this->_app_config['pagination']['events:details:premium:latest_news']['items_per_navigation'];
        if(empty($current_page)){
             $current_page = 1;
        }
        //////////////////////////////////
        
        $totals = ceil($totals / $items_per_page);
        
        $start_page_number =  (int)(($current_page - 1) / $items_per_navigation) * $items_per_navigation + 1;
        $end_page_number = $start_page_number + $items_per_navigation - 1;
        $end_page_number = min($totals, $end_page_number);
        
        /// FETCH datas ///
        $datas = array();
        if($start_page_number == 1){
             $datas['start_class'] = 'disabled';
        }
        if($end_page_number == $totals){
             $datas['end_class'] = 'disabled';
        }
        if ($current_page == 1)
             $datas['prev_class'] = 'disabled';  
        if ($current_page == $totals)
             $datas['next_class'] = 'disabled';       
        
        $datas['links'] = array();
        for ($i = $start_page_number; $i < $end_page_number + 1; $i++){
            $active = '';
            if($i == $current_page){
                $active = "active";    
            }
            $datas['links'][] = array('number' => $i, 'active' => $active); 
        }
         
        $datas['current_page'] = $current_page;
        $datas['total_pages'] = $totals;
        ///////////////////
        
        return $datas;
    }
    
    function show($params=''){
        if($params['output'] === false && empty(self::$list)){
            return '';
        }
        
        $datas = array();
        $datas['list'] = $this->fetch_data($params);
        $datas['totals'] = count(self::$list);
        $pagination = $this->_prepare_pagination();
        
        $swaps = array(
                    'dt' => 'dt',
                    'pagination' => 'pagination'
                );
        $datas = array(
                    'dt' => $datas,
                    'pagination' => $pagination
                );
        $TMPL = new EE_Template();         
        $TMPL->run_template_engine('dentevents', 'details_premium_latest_news');
        $html = $this->EE->output->app_output($swaps, $datas, array('output' => false));  
        
        if($params['output'] === false){
            return $html;
        }
        
        echo $html;
        exit;
    }
    
}