<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DEProcessing_Dentevents_Account_LinkedDatas extends DEProcessing_Dentevents_Account{

   function initialize($params = array()){
        $this->EE->load->model("documents");
   }
    
   function process($params = array()){
       $cmd = self::$utility->fetch_router();
        
       switch($cmd){
           case "fetch_data":
               return $this->fetch_data($params);
           break;
       }
   }
   
   function fetch_data($params = array()){
       $search_address = $this->EE->input->get_post('address');
       
       $_account = self::$account;
       $img_base_url = $this->_crm_config['main']['upload_url'];
       
       $datas = array();
       
       /// forms and downloads ///  
       $now_date = new DateTime();
       $now_date = $now_date->format("Y-m-d"); 
            
       $params = array();
       $params['id'] = $_account['id'];
       $params['selects'] = "{#m}.id,{#m}.template_type,{#c}.link_to_external_document_c";
       $params['where'] = "{#m}.template_type IN('Referral Form','Brochure','New Patient Form','Newsletter','MedicalHistory') and
                          {#m}.status_id='Complete' and {#c}.show_status_c='Public' and
                          ((exp_date is not null and exp_date > '$now_date') or exp_date is null)
                          and ((active_date is not null and active_date <= '$now_date') or active_date is null)
                          ";
       $docs = $this->EE->accounts->get_relationship_documents($params);
       
       $params = array();
       $params['selects'] = "{#m}.id,{#m}.filename,{#m}.file_ext";
       $params['single'] = true;
       foreach($docs as $key => $item){
           $params['id'] = $item['id'];
           $file = $this->EE->documents->get_relationship_revisions($params);
           if(!empty($file['filename'])){
               $item['file_id'] = $file['id'];
           }else if(!empty($item['link_to_external_document_c'])){
               $item['file_link'] = $item['link_to_external_document_c'];
           }else{
               unset($docs[$key]);
               continue;
           }
           $docs[$key] = $item;     
       }
       
          /// pull template type list ///
          //$types = $this->EE->documents->render_field_dropdown('template_type', '', false, array(), array('dropdown_datas' => 'yes'));
          $types = $this->helper->get_dropdowns_sugar('document_template_type_dom');
          foreach($docs as $key => $item){
              $item['template_type'] = $types[$item['template_type']];
              $docs[$key] = $item;
          }
          ///////////////////////////////
       
       $datas['docs'] = $docs;
       ///////////////////////////
       
       /// image slider ///
       $sliders = array();
       if(!empty($_account['photo1_url_c'])){
           $sliders[] = array( 'image' => $_account['photo1_url_c']);
       }
       $params = array();
       $params['id'] = $_account['id'];
       $params['selects'] = "{#m}.article_image,{#m}.image_url";
       $params['where'] = "{#m}.image_type='Photograph' and {#m}.image_format='News' and {#m}.portal_show='Public'";
       $params['orders'] = "{#m}.sequence asc";
       $_article_images = $this->EE->accounts->get_relationship_articleimage($params);
       
       foreach($_article_images as $item){
           if(!empty($item['article_image'])){
               // $sliders[] = array( 'image' => $img_base_url . $item['article_image']);
                $sliders[] = array( 'image' => $item['image_url']);
               $i++;
           }
       }
       
       $i = 1;
       foreach($sliders as $key => $item){
            $sliders[$key]['alt_prefix_number'] = " $i";    
            $i++;
       }
       if(count($sliders) == 1){
           $sliders[0]['alt_prefix_number'] = '';
       }
       $datas['sliders'] = $sliders;
       ////////////////////
       
       /// treatment options ///
       $params = array();
       $params['id'] = $_account['id'];
       $params['selects'] = "{#m}.name,{#m}.description";
       //$params['where'] = "{#c}.treatment_type_c='Public' and {#c}.country_c='{$_account['billing_address_country']}'";
       $_treatments = $this->EE->accounts->get_relationship_treatments($params);
       
       $datas['treatments'] = $_treatments;
       /////////////////////////
       
       /// linked videos ///
       $params = array();
       $params['id'] = $_account['id'];
       $params['selects'] = "{#c}.video_id_c";
       $params['where'] = "{#m}.image_type='Video' and {#c}.video_id_c != '' and {#m}.portal_show='Public'";
       $params['orders'] = "{#m}.sequence asc";
       $_videos = $this->EE->accounts->get_relationship_articleimage($params);
       
       $datas['videos'] = $_videos;
       /////////////////////
       

       return $datas;
   }
   
}